package bidding.service.service.impl;

import bidding.model.dto.BiddingSupplierOrderManagerModelDto;
import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdMallOrder;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.specification.BiddingProviderSpecification;
import bidding.model.specification.BiddingSupplierOrderManagerSpecification;
import bidding.service.service.query.*;
import cart.api.CartItemApi;
import cart.api.OrderItemApi;
import cart.api.OrderMainApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOrderStatus;
import definition.StatusOperateModule;
import dto.BiddingSupplierOrderMangerDto;
import dto.JcbdBdProviderDto;
import dto.JcbdRoleOperationDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import query.BiddingSupplierOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.List;

import static definition.BiddingRole.BIDDING_SUPPLIER;

/**
 * @author luoxianwei
 * @date 2018/4/14
 * 供应商订单管理
 */
@Slf4j
@Service
public class BiddingSupplierOrderManagerServiceImpl implements BiddingSupplierOrderManagerService {

    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;
    @Autowired
    BiddingMallOrderQueryService biddingMallOrderQueryService;
    @Autowired
    BiddingRoleOperationQueryService biddingRoleOperationQueryService;

    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;

    @Autowired
    MapperFacade mapperFacade;

    /**
     * 查询分页获取供应商订单管理列表
     *
     * @param biddingSupplierOrderManagerListQuery BiddingSupplierOrderManagerListQuery
     * @param pageable Pageable
     * @return Page<BiddingSupplierOrderMangerDto>
     */
    @Override
    public Page<BiddingSupplierOrderMangerDto> getBiddingSupplierOrderMangerList(BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable) {
        log.info("获取订单管理列表-请求参数 {}", JSON.toJSONString(biddingSupplierOrderManagerListQuery));

        BiddingSupplierOrderManagerModelDto supplierOrderManagerModelDto = mapperFacade.map(biddingSupplierOrderManagerListQuery, BiddingSupplierOrderManagerModelDto.class);

        BiddingSupplierOrderManagerSpecification<JcbdMallOrder> specification = new BiddingSupplierOrderManagerSpecification<>(supplierOrderManagerModelDto);
        pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(Sort.Direction.DESC, "dateCreated"));
        Page<JcbdMallOrder> jcbdMallOrders = jcbdMallOrderRepo.findAll(specification, pageable);

        //取出内容，重新封装成满足前台显示的dto
        List<JcbdMallOrder> jcbdMallOrderList = jcbdMallOrders.getContent();
        List<BiddingSupplierOrderMangerDto> biddingSupplierOrderMangerDtoList = new ArrayList<>();
        for (JcbdMallOrder jcbdMallOrder : jcbdMallOrderList) {
            // 页面展示封装 DTO
            BiddingSupplierOrderMangerDto biddingSupplierOrderMangerDto = BeanMapper.map(jcbdMallOrder, BiddingSupplierOrderMangerDto.class);

            // 竞价订单
            if(!Lang.isEmpty(jcbdMallOrder.getJcbdOrder())) {
                //竞价编号
                biddingSupplierOrderMangerDto.setBiddingCode(jcbdMallOrder.getJcbdOrder().getJcbdBidding().getBiddingCode());
                //状态
                BiddingOrderStatus biddingOrderStatus = BiddingOrderStatus.biddingSupplierOrderStatusMap.get(jcbdMallOrder.getSupplierOrderStatus());
                if (!Lang.isEmpty(biddingOrderStatus)) {
                    String statusDescription = biddingOrderStatus.getDescription();
                    biddingSupplierOrderMangerDto.setSupplierOrderStatusDescription(statusDescription);
                    //操作
                    List<JcbdRoleOperationDto> roleOperationDtoList = biddingRoleOperationQueryService.findByRoleCodeAndStatusAndModuleOrderByShowIndex(BIDDING_SUPPLIER, jcbdMallOrder.getSupplierOrderStatus(), StatusOperateModule.BIDDING_MANAGE_SUPPLIER.getCode());
                    biddingSupplierOrderMangerDto.setOperation(roleOperationDtoList);
                } else {
                    log.error("{} 供应商订单状态为空", jcbdMallOrder.getOrderNo());
                }
            } else {
                log.error("{} 竞价订单为空", jcbdMallOrder.getOrderNo());
            }

            biddingSupplierOrderMangerDtoList.add(biddingSupplierOrderMangerDto);
        }
        log.info("biddingSupplierOrderMangerDtoList={}", JSON.toJSONString(biddingSupplierOrderMangerDtoList));
        return new PageImpl<>(biddingSupplierOrderMangerDtoList, new PageRequest(jcbdMallOrders.getNumber(), jcbdMallOrders.getSize(), jcbdMallOrders.getSort()), jcbdMallOrders.getTotalElements());
    }

    @Override
    @Transactional
    public JcbdBdProviderDto findJcbdBdProvider(String id,String providerId) {
        JcbdBdProvider biddingProvider = new JcbdBdProvider();
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setId(id);
        biddingProvider.setJcbdBidding(jcbdBidding);
        biddingProvider.setProviderId(providerId);
        BiddingProviderSpecification specification = new BiddingProviderSpecification(biddingProvider);
        List<JcbdBdProvider> jcbdBdProviders = jcbdBdProviderRepo.findAll(specification);
        return mapperFacade.map(jcbdBdProviders.get(0),JcbdBdProviderDto.class);
    }

}
