package bidding.service.service.impl;

import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.po.VoteDetail;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.VoteDetailRepo;
import bidding.service.service.BiddingVoteService;
import definition.BiddingOperateCode;
import definition.BiddingStatus;
import dto.BiddingChangeStateDto;
import dto.VoteBatchDetailDto;
import dto.VoteDetailDto;
import dto.VoteQueryResultDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

/**
 * 竞价投票业务逻辑层
 *
 * @author Drury
 * @date 2018/3/19
 */
@Slf4j
@Service
public class BiddingVoteServiceImpl implements BiddingVoteService {

    @Autowired
    VoteDetailRepo voteDetailRepo;

    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;

    @Autowired
    BiddingMainServiceImpl biddingMainService;

    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;

    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;




    /**
     * 系统随机确认供应商
     * 竞价小组的商城竞价状态“待提交竞价结果”
     * 未中标的供应商状态更新为“未成交”
     * @param biddingCode 竞价编号
     * @return BaseResponse
     */
    @Override
    @Transactional
    public BaseResponse randomConfirmSupplier(String biddingCode) {

        if(Lang.isEmpty(biddingCode)) {
            return new BaseResponse(false, "参数竞价编号为空");
        }
        try {

            JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
            if(Lang.isEmpty(jcbdBidding)) {
                return new BaseResponse(false, "竞价不存在");
            }
            List<JcbdBdProvider> providers = jcbdBidding.getJcbdBdProviders();

            if(Lang.isEmpty(providers)) {
                return new BaseResponse(false, "供应商不存在");
            }
            Random rand = new Random();
            int randomResult = rand.nextInt(providers.size());
            for (int i = 0; i <providers.size() ; i++) {
                JcbdBdProvider jcbdBdProvider = providers.get(i);
                if(randomResult == i) {
                    //随机命中 供应商状态修改为审查中(可能成交)
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                    jcbdBdProvider.setDealStatus("已成交");
                } else {
                    //供应商状态修改为未成交
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue());
                }
                jcbdBdProviderRepo.save(jcbdBdProvider);
            }

            //竞价状态修改为“待提交竞价结果”
            BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
            biddingChangeStateDto.setBiddingNo(jcbdBidding.getBiddingCode());
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_RESULT_SELECT_WAIT_RANDOM.getValue());
            biddingChangeStateDto.setOpcode(BiddingOperateCode.RANDOM_CONFIRM_SUPPLIER.getCode());
            biddingMainService.changeBiddingState(biddingChangeStateDto);

            return new BaseResponse(true,"操作成功");

        } catch (Exception e) {
            return new BaseResponse(false, "随机确认供应商异常");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse voteSelectionSupplier(VoteDetailDto voteDetailDto) {


        String memberId = voteDetailDto.getVoteMemberId();
        String voteEmail = voteDetailDto.getVoteEmail();
        String biddingCode = voteDetailDto.getBusinessIdentifying();
        JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode,false);
        JcbdBiddingGroupMember groupMembermember = null;
        if (!Lang.isEmpty(memberId)){
            groupMembermember = jcbdBiddingGroupMemberRepo.findByGroupMemberIdAndJcbdBiddingIdAndIsDelete(memberId, jcbdBidding.getId(), false);
        }
        if (Lang.isEmpty(groupMembermember)&&!Lang.isEmpty(voteEmail)){
            groupMembermember = jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(voteEmail, jcbdBidding.getId(), false);
        }
        if (Lang.isEmpty(groupMembermember)){
            log.error("用户memberId：{}，Email：{} 投票操作查无此成员信息", memberId, voteEmail);
            return new BaseResponse("查无此成员信息");
        }
        VoteDetail memberVote = voteDetailRepo.findByVoteNoAndVoteMemberIdAndIsDelete(voteDetailDto.getVoteNo(), groupMembermember.getId(), false);
        if (!Lang.isEmpty(memberVote)){
            return new BaseResponse("抱歉，您已经投过票了");
        }
        VoteDetail voteDetail = BeanMapper.map(voteDetailDto, VoteDetail.class);
        voteDetail.setVoteMemberId(groupMembermember.getId());
        voteDetailRepo.save(voteDetail);
        groupMembermember.setStatus(BiddingStatus.M_VOTED.getValue());
        jcbdBiddingGroupMemberRepo.save(groupMembermember);

        Integer votePeopleNum=0;

        String voteNo = voteDetailDto.getVoteNo();
        List<VoteDetail> voteDetailList = voteDetailRepo.findByVoteNoAndBusinessIdentifyingAndIsDelete(voteNo, biddingCode, false);

        List<JcbdBiddingGroupMember> jcbdBiddingGroupMembers = jcbdBidding.getJcbdBiddingGroupMembers();
        for (JcbdBiddingGroupMember member : jcbdBiddingGroupMembers) {
            for (VoteDetail vote : voteDetailList) {
                if (member.getId().equals(vote.getVoteMemberId())) {
                    votePeopleNum=votePeopleNum+1;
                    break;
                }
            }

        }

        if (votePeopleNum.equals(jcbdBiddingGroupMembers.size())) {
            List<JcbdBdProvider> jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
            //当前最高票数
            Integer bestNum = null;
            //当前最优供应商
            List<JcbdBdProvider> bestProvider = new ArrayList<>();
            for (JcbdBdProvider provider : jcbdBdProviders) {
                Integer voteNum = 0;
                for (VoteDetail vote : voteDetailList) {
                    if (vote.getResult().equals(provider.getProviderId())) {
                        voteNum = voteNum+1;
                    }
                }
                if (bestNum == null) {
                    bestNum = voteNum;
                    bestProvider.add(provider);
                } else {
                    if (voteNum > bestNum) {
                        bestNum = voteNum;
                        bestProvider.clear();
                        bestProvider.add(provider);
                    } else if (voteNum.equals(bestNum)) {
                        bestProvider.add(provider);
                    }
                }
            }

            if (bestProvider.size() == 1) {
                for (JcbdBdProvider provider : jcbdBdProviders) {
                    if (!provider.getId().equals(bestProvider.get(0).getId())) {
                        provider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue());
                        jcbdBdProviderRepo.save(provider);
                    }else {
                        provider.setDealStatus("已成交");
                        jcbdBdProviderRepo.save(provider);
                    }
                }
                BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(jcbdBidding.getBiddingCode());
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_VOTING.getValue());
                biddingChangeStateDto.setOpcode(BiddingOperateCode.VOTE_NO_PLANE_TICKETS.getCode());
                biddingMainService.changeBiddingState(biddingChangeStateDto);
            } else {
                jcbdBdProviders.removeAll(bestProvider);
                for (JcbdBdProvider provider : jcbdBdProviders) {
                    provider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue());
                    jcbdBdProviderRepo.save(provider);
                }
                for(JcbdBdProvider jcbdBdProvider:bestProvider){
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                    jcbdBdProviderRepo.save(jcbdBdProvider);
                }
                BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(jcbdBidding.getBiddingCode());
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_VOTING.getValue());
                biddingChangeStateDto.setOpcode(BiddingOperateCode.VOTE_PLANE_TICKETS.getCode());
                biddingMainService.changeBiddingState(biddingChangeStateDto);
            }
        }
        return new BaseResponse(true, "投票保存成功");
    }

    @Transactional
    @Override
    public List<VoteQueryResultDto> voteDetailsQuery(String biddingNo) {
        JcbdBidding bidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        List<VoteDetail> voteDetailList = voteDetailRepo.findByBusinessIdentifyingAndIsDelete(biddingNo, false);
        HashSet<String> voteNoSet = new HashSet();
        final String alreadyVote="1";
        for (VoteDetail voteDetail : voteDetailList) {
            voteNoSet.add(voteDetail.getVoteNo());
        }
        List<VoteQueryResultDto> voteQueryResultDtoList = new ArrayList<>();
        for (String voteNo : voteNoSet) {
            VoteQueryResultDto voteQueryResultDto = new VoteQueryResultDto();
            voteQueryResultDto.setVoteNo(voteNo);
            List<VoteBatchDetailDto> voteBatchDetailDtos = new ArrayList<>();
            Integer totalVoteNum = 0;
            HashSet<String> providerIds = new HashSet<>();
            List<VoteDetail> voteDetails = voteDetailRepo.findByVoteNoAndBusinessIdentifyingAndIsDelete(voteNo, biddingNo, false);
            for (VoteDetail voteDetail : voteDetails) {
                if (alreadyVote.equals(voteDetail.getStatus())) {
                    totalVoteNum++;
                    providerIds.add(voteDetail.getResult());
                }
            }
            for (String provider : providerIds) {
                VoteBatchDetailDto voteBatchDetailDto = new VoteBatchDetailDto();
                JcbdBdProvider jcbdBdProvider = jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndProviderIdAndIsDelete(biddingNo,provider,false);
                if(!Lang.isEmpty(jcbdBdProvider)){
                    voteBatchDetailDto.setProvideName(jcbdBdProvider.getProviderName());
                    voteBatchDetailDto.setTotalVoteNum(totalVoteNum);
                }
                Integer obtainVoteNum = 0;
                List<String> voters = new ArrayList<>();
                for (VoteDetail voteDetail : voteDetails) {
                    if (provider.equals(voteDetail.getResult())) {
                        obtainVoteNum++;
                        String voteMemberId = voteDetail.getVoteMemberId();
                        JcbdBiddingGroupMember groupMember = jcbdBiddingGroupMemberRepo.findOne(voteMemberId);
                        if(!Lang.isEmpty(groupMember)){
                            voters.add(groupMember.getEmail());
                        }
                    }
                }
                voteBatchDetailDto.setObtainVoteNum(obtainVoteNum);
                voteBatchDetailDto.setVoters(voters);
                voteBatchDetailDto.setTotalVoteNum(totalVoteNum);
                voteBatchDetailDtos.add(voteBatchDetailDto);
            }
            voteQueryResultDto.setVoteBatchDtoList(voteBatchDetailDtos);
            voteQueryResultDtoList.add(voteQueryResultDto);
        }

        Integer votePeopleNum=0;

        for (VoteQueryResultDto voteQueryResultDto : voteQueryResultDtoList) {
            if (voteQueryResultDto.getVoteNo().equals(bidding.getVoteNo())) {
                List<JcbdBiddingGroupMember> jcbdBiddingGroupMembers = bidding.getJcbdBiddingGroupMembers();
                List<VoteDetail> voteDetails = voteDetailRepo.findByVoteNoAndBusinessIdentifyingAndIsDelete(voteQueryResultDto.getVoteNo(), biddingNo, false);
                for (JcbdBiddingGroupMember member : jcbdBiddingGroupMembers) {
                    for (VoteDetail vote : voteDetails) {
                        if (member.getId().equals(vote.getVoteMemberId())) {
                            votePeopleNum=votePeopleNum+1;
                            break;
                        }
                    }
                }
                if (votePeopleNum.equals(jcbdBiddingGroupMembers.size())) {
                    Integer maxVoteNum = null;
                    List<VoteBatchDetailDto> maxVoteBatchList = new ArrayList<>();
                    List<VoteBatchDetailDto> voteBatchDtoList = voteQueryResultDto.getVoteBatchDtoList();
                    for (VoteBatchDetailDto voteBatchDetailDto : voteBatchDtoList) {
                        Integer obtainVoteNum = voteBatchDetailDto.getObtainVoteNum();
                        if (maxVoteNum == null) {
                            maxVoteNum = obtainVoteNum;
                            maxVoteBatchList.add(voteBatchDetailDto);
                        } else {
                            if (obtainVoteNum > maxVoteNum) {
                                maxVoteNum = obtainVoteNum;
                                maxVoteBatchList.clear();
                                maxVoteBatchList.add(voteBatchDetailDto);
                            } else if (obtainVoteNum.equals(maxVoteNum)) {
                                maxVoteNum = obtainVoteNum;
                                maxVoteBatchList.add(voteBatchDetailDto);
                            }
                        }
                    }
                    if (maxVoteBatchList.size() == 1) {
                        for (VoteBatchDetailDto voteBatchDetailDto : voteBatchDtoList) {
                            if (voteBatchDetailDto.getProvideName().equals(maxVoteBatchList.get(0).getProvideName())) {
                                voteBatchDetailDto.setResult("成交");
                            } else {
                                voteBatchDetailDto.setResult("未成交");
                            }
                        }
                    } else {
                        voteBatchDtoList.removeAll(maxVoteBatchList);
                        for (VoteBatchDetailDto voteBatchs : voteBatchDtoList) {
                            voteBatchs.setResult("未成交");
                        }
                        for(VoteBatchDetailDto voteBaths:maxVoteBatchList){
                            voteBaths.setResult("平票");
                        }
                        voteBatchDtoList.addAll(maxVoteBatchList);
                    }

                } else {
                    List<VoteBatchDetailDto> voteBatchDtoList = voteQueryResultDto.getVoteBatchDtoList();
                    for (VoteBatchDetailDto voteBatchDetailDto : voteBatchDtoList) {
                        voteBatchDetailDto.setResult("投票中");
                    }
                }
            }else {
                Integer maxVoteNum = null;
                List<VoteBatchDetailDto> maxVoteBatchList = new ArrayList<>();
                List<VoteBatchDetailDto> voteBatchDtoList = voteQueryResultDto.getVoteBatchDtoList();
                for (VoteBatchDetailDto voteBatchDetailDto : voteBatchDtoList) {
                    Integer obtainVoteNum = voteBatchDetailDto.getObtainVoteNum();
                    if (maxVoteNum == null) {
                        maxVoteNum = obtainVoteNum;
                    } else {
                        if (obtainVoteNum > maxVoteNum) {
                            maxVoteNum = obtainVoteNum;
                            maxVoteBatchList.clear();
                            maxVoteBatchList.add(voteBatchDetailDto);
                        } else if (obtainVoteNum.equals(maxVoteNum)) {
                            maxVoteNum = obtainVoteNum;
                            maxVoteBatchList.add(voteBatchDetailDto);
                        }
                    }
                }
                if (maxVoteBatchList.size() == 1) {
                    for (VoteBatchDetailDto voteBatchDetailDto : voteBatchDtoList) {
                        if (voteBatchDetailDto.getProvideName().equals(maxVoteBatchList.get(0).getProvideName())) {
                            voteBatchDetailDto.setResult("成交");
                        } else {
                            voteBatchDetailDto.setResult("未成交");
                        }
                    }
                } else {
                    voteBatchDtoList.removeAll(maxVoteBatchList);
                    for (VoteBatchDetailDto voteBatchs : voteBatchDtoList) {
                        voteBatchs.setResult("未成交");
                    }
                    for(VoteBatchDetailDto voteBaths:maxVoteBatchList){
                        voteBaths.setResult("平票");
                    }
                    voteBatchDtoList.addAll(maxVoteBatchList);
                }
            }
        }

        return voteQueryResultDtoList;
    }
}
