package bidding.service.service.impl;

import bidding.model.po.MallAttachment;
import bidding.model.repository.MallAttachmentRepo;
import bidding.service.service.MallAttachmentService;
import dto.MallAttachmentDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import java.util.List;

/**
 * @author Jian.
 * @date 2018/4/2
 */
@Slf4j
@Service
public class MallAttachmentServiceImpl implements MallAttachmentService{

    @Autowired
    MallAttachmentRepo mallAttachmentRepo;
    @Autowired
    MapperFacade mapperFacade;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MallAttachmentDto saveOne(MallAttachmentDto mallAttachmentDto) {
        MallAttachment mallAttachment = mapperFacade.map(mallAttachmentDto, MallAttachment.class);
        MallAttachment saved = mallAttachmentRepo.save(mallAttachment);
        return mapperFacade.map(saved, MallAttachmentDto.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<List<MallAttachmentDto>> batchSave(List<MallAttachmentDto> mallAttachmentDtoList) {
        List<MallAttachment> mallAttachments = mapperFacade.mapAsList(mallAttachmentDtoList, MallAttachment.class);
        MallAttachmentDto attachmentDto = mallAttachmentDtoList.get(0);
        if (Lang.isEmpty(attachmentDto.getAttachmentCorrelation())||Lang.isEmpty(attachmentDto.getBusinessCode())){
            throw  new IllegalArgumentException("参数有误，缺少业务附件关联或业务代码");
        }
        List<MallAttachment> attachments = mallAttachmentRepo.findByAttachmentCorrelationAndBusinessCode(attachmentDto.getAttachmentCorrelation(), attachmentDto.getBusinessCode());
        if (!Lang.isEmpty(attachments)){
            mallAttachmentRepo.delete(attachments);
        }
        List<MallAttachment> listSaved = mallAttachmentRepo.save(mallAttachments);
        return new BaseResponse<List<MallAttachmentDto>>(true,"",mapperFacade.mapAsList(listSaved, MallAttachmentDto.class));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse deleteMallAttachments(String attachmentCorrelation, String businessCode) {
        if (Lang.isEmpty(attachmentCorrelation) || Lang.isEmpty(businessCode)){
            throw  new IllegalArgumentException("参数有误，缺少业务附件关联或业务代码");
        }
        List<MallAttachment> attachments = mallAttachmentRepo.findByAttachmentCorrelationAndBusinessCode(attachmentCorrelation, businessCode);
        if (!Lang.isEmpty(attachments)){
            mallAttachmentRepo.delete(attachments);
        }
        return new BaseResponse(true);
    }
}
