package bidding.service.service.impl.query;

import bidding.model.repository.BdDemandCodeRuleRepo;
import bidding.model.repository.BiddingCodeRuleRepo;
import bidding.service.service.query.BdDemandCodeRuleService;
import bidding.service.service.query.BiddingCodeRuleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @program: parent
 * @author: taofeng
 * @create: 2018-04-18
 * <p>
 * 针对demandCode的查询接口
 **/
@Slf4j
@Service
public class BdDemandCodeRuleServiceImpl implements BdDemandCodeRuleService {

    @Autowired
    BdDemandCodeRuleRepo bdDemandCodeRuleRepo;

    /**
     * @author taofeng
     * @date 2018/4/18
     * <p>
     * 查询出最大的demandCode
     */
    @Override
    public String findMaxBemandCode() {
        String maxBemandCode = bdDemandCodeRuleRepo.findMaxDemandCode();
        return maxBemandCode;
    }

    /**
     * @author taofeng
     * @date 2018/4/19
     * <p>
     * 根据biddingId查询demandCode的count
     */
    @Override
    public Integer findDemandCountByBid(String biddingId) {
        Integer demandCount = bdDemandCodeRuleRepo.findDemandCountByBid(biddingId);
        return demandCount;
    }
}
