package bidding.service.service.impl.query;

import bidding.model.repository.BiddingCodeRuleRepo;
import bidding.service.service.query.BiddingCodeRuleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @program: parent
 * @author: taofeng
 * @create: 2018-04-18
 * <p>
 * 针对biddingCode的查询接口
 **/
@Slf4j
@Service
public class BiddingCodeRuleServiceImpl implements BiddingCodeRuleService {

    @Autowired
    BiddingCodeRuleRepo biddingCodeRuleRepo;

    /**
     * @author taofeng
     * @date 2018/4/18
     * <p>
     * 查询出最大的biddingCode
     */
    @Override
    public String findMaxBiddingCode() {
        String maxBiddingCode = biddingCodeRuleRepo.findMaxBiddingCode();
        return maxBiddingCode;
    }
}
