package bidding.service.service.impl.query;

import bidding.model.po.*;
import bidding.model.repository.*;
import bidding.model.specification.*;
import bidding.service.service.query.BiddingConformityReviewQueryService;
import com.alibaba.fastjson.JSON;
import definition.BiddingConformAuditStatus;
import definition.ProviderConformanceRespStatus;
import dto.*;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 符合性审查业务逻辑层
 *
 * @author Drury
 * @date 2018/3/19
 */
@Slf4j
@Service
public class BiddingConformityReviewQueryServiceImpl implements BiddingConformityReviewQueryService {

    /**
     * 获取竞价小组成员信息
     *
     * @param biddingNo 竞价编号
     * @return BaseResponse<List<JcbdBiddingGroupMemberDto>>
     */
    @Override
    public BaseResponse<List<JcbdBiddingGroupMemberDto>> findBiddingGroupMember(String biddingNo) {

        log.info("获取竞价小组成员信息-请求参数竞价编号为 {}", biddingNo);

        // 判断请求参
        if(Lang.isEmpty(biddingNo)) {
            log.error("获取竞价小组成员信息失败-请求参数竞价编号为空");
            return new BaseResponse<>("取竞价小组成员信息失败-请求参数竞价编号为空");
        }

        try {
            // 找到竞价编号对应的竞价ID
            JcbdBidding jcbdBidding = new JcbdBidding();
            jcbdBidding.setBiddingCode(biddingNo);
            List<JcbdBidding> jcbdBiddings = jcbdBiddingRepo.findAll(new BiddingSpecification<>(jcbdBidding));

            // 数据检查
            if(jcbdBiddings.size() != 1) {
                log.error("获取竞价小组成员信息失败-竞价编号为 {} 的数据要求有且只有有 1 条, 实际 {} 条", biddingNo, jcbdBiddings.size());
                return new BaseResponse<>("取竞价小组成员信息失败-数据检查未通过");
            }

            // 根据 竞价ID 找到 竞价小组
            JcbdBiddingGroupMember biddingGroupMember = new JcbdBiddingGroupMember();
            biddingGroupMember.setJcbdBidding(jcbdBiddings.get(0));
            List<JcbdBiddingGroupMember> biddingGroupMembers = jcbdBiddingGroupMemberRepo.findAll(new BiddingGroupMemberSpecification<>(biddingGroupMember));

            // PO 转 DTO
            List<JcbdBiddingGroupMemberDto> biddingGroupMemberDtos = mapperFacade.mapAsList(biddingGroupMembers, JcbdBiddingGroupMemberDto.class);

            log.info("竞价编号为 {} 的竞价成员信息为 {}", biddingNo, JSON.toJSONString(biddingGroupMemberDtos));

            return new BaseResponse<>(true, "操作成功", biddingGroupMemberDtos);
        } catch (Exception e) {
            log.error("获取竞价小组成员信息异常, 竞价编号 {} ", biddingNo, e);
            return new BaseResponse<>("获取竞价小组成员信息异常");
        }
    }

    /**
     * 获取符合性审核列表dto  符合性审核页
     * @param conformityQueryDto
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Page<BiddingConformityListDto> getConformityListByQueryDto(BiddingConformityQueryDto conformityQueryDto) {
        //查询竞价
        JcbdBidding bidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(conformityQueryDto.getBiddingCode(), false);
        JcbdBiddingDemand demand = new JcbdBiddingDemand();
        if(!Lang.isEmpty(conformityQueryDto.getBiddingCode())){
            JcbdBidding jcbdBidding = new JcbdBidding();
            jcbdBidding.setBiddingCode(conformityQueryDto.getBiddingCode());
            demand.setJcbdBidding(jcbdBidding);
        }
        Page<JcbdBiddingDemand> demandPage = jcbdBiddingDemandRepo.findAll(new BiddingDemandSpecification<>(demand), conformityQueryDto.getPageable());

        //取出内容，重新封装成满足前台显示的dto
        List<BiddingConformityListDto> conformityListDtoList = new ArrayList<>();
        if(!Lang.isEmpty(demandPage)){
            List<JcbdBiddingDemand> demandList = demandPage.getContent();
            demandList.forEach( (JcbdBiddingDemand n) ->{
                BiddingConformityListDto conformityListDto = new BiddingConformityListDto();
                conformityListDto.setDemandCode(n.getDemandCode());
                conformityListDto.setGoodsDesription(n.getGoodsDesription());
                conformityListDto.setGoodsBrand(n.getGoodsBrand());
                conformityListDto.setGoodsModel(n.getGoodsModel());
                conformityListDto.setSpecification(n.getSpecification());
                conformityListDto.setMinPurchaseAmount(n.getMinPurchaseAmount());
                conformityListDto.setMaxPurchaseAmount(n.getMaxPurchaseAmount());
//                conformityListDto.setBiddingGroupMemberId(memberId);
                conformityListDto.setDateRequiredDelivery(n.getDateRequiredDelivery());
                //需求地区
                List<JcbdDemandAddressNum> demandAddressNums = n.getJcbdDemandAddressNums();
                List<String> addrList = new ArrayList<>();
                demandAddressNums.forEach(m-> {
                    StringBuffer sb = new StringBuffer();
                    sb.append(m.getProvinceName()).append(m.getCityName())
                            .append(Lang.isEmpty(m.getAreaName())?"":m.getAreaName()).append(Lang.isEmpty(m.getTownName())?"":m.getTownName());
                    addrList.add(sb.toString());

                });
                conformityListDto.setDemandAddrList(addrList);
                //符合性审核个数
                Integer conformityNum = n.getJcbdBiddingConformances().size();
                conformityListDto.setConformityNum(conformityNum);
                //响应供应商数目
                Integer demandRspNUm = n.getJcbdBiddingDemandResponses().size();
                conformityListDto.setDemandResponNum(demandRspNUm);
                //已审查供应商数
                List<JcbdBdProvider> jcbdBdProviders = bidding.getJcbdBdProviders();
                List<JcbdBiddingConformance> conformances = n.getJcbdBiddingConformances();
                final Integer[] count = {0};
                if (!Lang.isEmpty(jcbdBdProviders) && !Lang.isEmpty(conformances)){
                    jcbdBdProviders.forEach(provider->{
                        List<JcbdConformanceCheck> conformanceChecks = new ArrayList<>();
                        conformances.forEach(conformance->{
                            JcbdConformanceCheck jcbdConformanceCheck = new JcbdConformanceCheck();
                            jcbdConformanceCheck.setBiddingConformance(conformance);
                            if(!Lang.isEmpty(conformityQueryDto.getMemberId())){
                                jcbdConformanceCheck.setBiddingGroupMemberId(conformityQueryDto.getMemberId());
                            }else {
                                jcbdConformanceCheck.setEmail(conformityQueryDto.getEmail());
                            }
                            jcbdConformanceCheck.setProviderId(provider.getProviderId());
                            JcbdConformanceCheck conformanceCheck = jcbdConformanCheckRepo.findOne(new BiddingConformanceCheckSpecification<>(jcbdConformanceCheck));
                            if (!Lang.isEmpty(conformanceCheck)){
                                conformanceChecks.add(conformanceCheck);
                            }
                        });
                        if (!Lang.isEmpty(conformanceChecks)){
                            if (conformanceChecks.size() != conformances.size()){
                                count[0] = 0;
                            }else{
                                if(conformanceChecks.contains(null)){
                                    count[0] = 0;
                                }else{
                                    List<String> statusList = conformanceChecks.stream().map(JcbdConformanceCheck::getStatus).collect(Collectors.toList());
                                    if(Lang.isEmpty(statusList) || statusList.contains(null)){
                                        count[0] = 0;
                                    }else{
                                        count[0]++;
                                    }
                                }
                            }

                        }

                    });
                }

//                JcbdConformanceCheck conformanceCheck = new JcbdConformanceCheck();
//                if(!Lang.isEmpty(conformityQueryDto.getMemberId())){
//                    conformanceCheck.setBiddingGroupMemberId(conformityQueryDto.getMemberId());
//                }else {
//                    conformanceCheck.setEmail(conformityQueryDto.getEmail());
//                }
//                //取某一个conformanceId作为约束去查询
//                conformanceCheck.setBiddingConformance(n.getJcbdBiddingConformances().get(0));
//
//                List<JcbdConformanceCheck> checkList = jcbdConformanCheckRepo.findAll(new BiddingConformanceCheckSpecification<>(conformanceCheck));
//                List<String> providerIds = new ArrayList<>();
//                long count = checkList.stream().filter(v -> {
//                    boolean flag = !providerIds.contains(v.getProviderId());
//                    return flag;
//                }).count();
                conformityListDto.setProvidersAudited(count[0]);

                conformityListDtoList.add(conformityListDto);

            });
        }

        return new PageImpl(conformityListDtoList, new PageRequest(demandPage.getNumber(), demandPage.getSize(), demandPage.getSort()), demandPage.getTotalElements());
    }

    /**
     * 获取符合性审核信息-供应商需求响应的具体信息-符合性审核页
     * @param demandCode
     * @return
     */
    @Override
    public List<JcbdBiddingDemandResponseDto> getConformityAuditInfo(String demandCode) {
        JcbdBiddingDemandResponse demandResponse = new JcbdBiddingDemandResponse();
        JcbdBiddingDemand demand = new JcbdBiddingDemand();
        demand.setDemandCode(demandCode);
        demandResponse.setJcbdBiddingDemand(demand);

        List<JcbdBiddingDemandResponse> demandResponList = jcbdBiddingDemandRespRepo.findAll(new BiddingDemandResponseSpecification(demandResponse));
        List<JcbdBiddingDemandResponseDto> demandResponseDtos = mapperFacade.mapAsList(demandResponList, JcbdBiddingDemandResponseDto.class);
        demandResponseDtos.forEach(n -> {
            JcbdBdProvider provider = jcbdBdProviderRepo.findFirstByProviderIdAndIsDelete(n.getResponseProviderId(), false);
            n.setProviderName(provider.getProviderName());

        });
        return demandResponseDtos;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<List<BiddingResponseOutlineDto>> queryConformityOutline(BiddingConformityQueryDto conformityQueryDto) {
        log.info("queryConformityOutline,biddingCode:{},demandCode:{}",conformityQueryDto.getBiddingCode(),conformityQueryDto.getDemandCode());
        if (Lang.isEmpty(conformityQueryDto.getBiddingCode()) || Lang.isEmpty(conformityQueryDto.getDemandCode())){
            return new BaseResponse<>("请求参数有空值！");
        }
        // 获取竞价需求
        JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
        JcbdBidding bidding = new JcbdBidding();
        bidding.setBiddingCode(conformityQueryDto.getBiddingCode());
        biddingDemand.setJcbdBidding(bidding);
        biddingDemand.setDemandCode(conformityQueryDto.getDemandCode());
        JcbdBiddingDemand  jcbdBiddingDemand = jcbdBiddingDemandRepo.findOne(new BiddingDemandSpecification<>(biddingDemand));
        if (Lang.isEmpty(jcbdBiddingDemand)){
            log.info("获取竞价需求数据失败");
            return new BaseResponse<>("获取竞价需求数据失败");
        }

        // 竞价供应商需求响应
        JcbdBiddingDemandResponse biddingDemandResponse = new JcbdBiddingDemandResponse();
        biddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);
        List<JcbdBiddingDemandResponse> demandResponseList = jcbdBiddingDemandRespRepo.findAll(new BiddingDemandResponseSpecification<>(biddingDemandResponse));
        List<BiddingResponseOutlineDto> biddingOutlineDtoList = new ArrayList<>();
        if(!Lang.isEmpty(demandResponseList) &&  demandResponseList.size()>0){
            for (JcbdBiddingDemandResponse n: demandResponseList) {
                BiddingResponseOutlineDto responseOutlineDto = new BiddingResponseOutlineDto();
//                JcbdBdProvider jcbdBdProvider = new JcbdBdProvider();
//                jcbdBdProvider.setId(n.getResponseProviderId());
//                jcbdBdProvider.setJcbdBidding(bidding);
                JcbdBdProvider provider = jcbdBdProviderRepo.findOne(n.getResponseProviderId());
//                List<JcbdBdProvider> jcbdBdProviders = jcbdBdProviderRepo.findAll(new BiddingProviderSpecification<>(jcbdBdProvider));
//                responseOutlineDto.setResponseStatus(jcbdBdProviders.get(0).getResponseStatus());
//                responseOutlineDto.setSupplierId(jcbdBdProviders.get(0).getProviderId());
//                responseOutlineDto.setSupplierName(jcbdBdProviders.get(0).getProviderName());
                List<JcbdBiddingConformance> conformances = jcbdBiddingConformanceRepo.findByJcbdBiddingDemandDemandCodeAndIsDelete(conformityQueryDto.getDemandCode(), false);
                if (Lang.isEmpty(conformances)){
                    log.info("获取竞价需求{}的符合性数据失败",conformityQueryDto.getDemandCode());
                    return new BaseResponse<>("获取竞价需求符合性数据失败");
                }
                JcbdConformanceCheck jcbdConformanceCheck;
                JcbdConformanceCheck conformanceCheck;
                List<JcbdConformanceCheck> conformanceChecks = new ArrayList<>();
                for (JcbdBiddingConformance conformance : conformances) {
                    jcbdConformanceCheck = new JcbdConformanceCheck();
                    jcbdConformanceCheck.setBiddingConformance(conformance);
                    if(!Lang.isEmpty(conformityQueryDto.getMemberId())){
                        jcbdConformanceCheck.setBiddingGroupMemberId(conformityQueryDto.getMemberId());
                    }else {
                        jcbdConformanceCheck.setEmail(conformityQueryDto.getEmail());
                    }
                    jcbdConformanceCheck.setProviderId(provider.getProviderId());
                    conformanceCheck = jcbdConformanCheckRepo.findOne(new BiddingConformanceCheckSpecification<>(jcbdConformanceCheck));
                    conformanceChecks.add(conformanceCheck);
                }
                if (!Lang.isEmpty(conformanceChecks)){
                    if (conformanceChecks.size() != conformances.size()){
                        responseOutlineDto.setResponseStatus(null);
                    }else{
                        if(conformanceChecks.contains(null)){
                            responseOutlineDto.setResponseStatus(null);
                        }else{
                            List<String> statusList = conformanceChecks.stream().map(JcbdConformanceCheck::getStatus).collect(Collectors.toList());
                            if(Lang.isEmpty(statusList) || statusList.contains(null)){
                                responseOutlineDto.setResponseStatus(null);
                            } else if (statusList.contains(BiddingConformAuditStatus.NOT_ACCORD.getValue())){
                                responseOutlineDto.setResponseStatus("("+BiddingConformAuditStatus.NOT_ACCORD.getDescription()+")");
                            }else{
                                responseOutlineDto.setResponseStatus("("+BiddingConformAuditStatus.ACCORD.getDescription()+")");
                            }
                        }
                    }

                }else{
                    // 若没有审查结果，则返回null
                    responseOutlineDto.setResponseStatus(null);
                }
                //符合性审查查看页供应商符合状态
                List<JcbdConformanceCheck> jcbdConformanceChecks = new ArrayList<>();
                JcbdConformanceCheck allConformanceCheck;
                for (JcbdBiddingConformance conformance : conformances) {
                    allConformanceCheck = new JcbdConformanceCheck();
                    allConformanceCheck.setBiddingConformance(conformance);
                    allConformanceCheck.setProviderId(provider.getProviderId());
                    List<JcbdConformanceCheck> conformanceCheckList = jcbdConformanCheckRepo.findByProviderIdAndBiddingConformanceId(provider.getProviderId(), conformance.getId());
                    jcbdConformanceChecks.addAll(conformanceCheckList);
                }
                if (Lang.isEmpty(jcbdConformanceChecks)){
                    responseOutlineDto.setAccordStatus("");
                }else{
                    List<String> statusList = jcbdConformanceChecks.stream().map(JcbdConformanceCheck::getStatus).collect(Collectors.toList());
                    if (statusList.contains(BiddingConformAuditStatus.NOT_ACCORD.getValue())){
                        responseOutlineDto.setAccordStatus("("+BiddingConformAuditStatus.NOT_ACCORD.getDescription()+")");
                    }else{
                        responseOutlineDto.setAccordStatus("("+BiddingConformAuditStatus.ACCORD.getDescription()+")");
                    }
                }
                responseOutlineDto.setSupplierId(provider.getProviderId());
                responseOutlineDto.setSupplierName(provider.getProviderName());
                biddingOutlineDtoList.add(responseOutlineDto);
            }
        }
        log.info("queryConformityOutline查询结果:{}",biddingOutlineDtoList);
        return  new BaseResponse<>(true,"查询成功!",biddingOutlineDtoList);
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<JcbdBiddingDemandResponseDto> getConformityDetail(BiddingConformityQueryDto conformityQueryDto) {
        if (Lang.isEmpty(conformityQueryDto.getBiddingCode()) || Lang.isEmpty(conformityQueryDto.getDemandCode()) || Lang.isEmpty(conformityQueryDto.getProviderId())){
            return new BaseResponse<>("请求参数有空值！");
        }

        JcbdBiddingDemandResponseDto jcbdBiddingDemandResponseDto = new JcbdBiddingDemandResponseDto();
        // 获取竞价需求
        JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
        JcbdBidding bidding = new JcbdBidding();
        bidding.setBiddingCode(conformityQueryDto.getBiddingCode());
        biddingDemand.setJcbdBidding(bidding);
        biddingDemand.setDemandCode(conformityQueryDto.getDemandCode());
        JcbdBiddingDemand  jcbdBiddingDemand = jcbdBiddingDemandRepo.findOne(new BiddingDemandSpecification<>(biddingDemand));
        if (Lang.isEmpty(jcbdBiddingDemand)){
            log.info("获取竞价需求数据失败");
            return new BaseResponse<>("获取竞价需求数据失败");
        }
        JcbdBiddingDemandResponse jcbdBiddingDemandResponse = new JcbdBiddingDemandResponse();
        jcbdBiddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);

        JcbdBdProvider jcbdBdProvider = new JcbdBdProvider();
        jcbdBdProvider.setProviderId(conformityQueryDto.getProviderId());
        jcbdBdProvider.setJcbdBidding(jcbdBiddingDemand.getJcbdBidding());

        JcbdBdProvider provider = jcbdBdProviderRepo.findOne(new BiddingProviderSpecification<>(jcbdBdProvider));
        if(!Lang.isEmpty(provider)){
            // 设置供应商表主键id
            jcbdBiddingDemandResponse.setResponseProviderId(provider.getId());
            // 封装报价有效期数据
            jcbdBiddingDemandResponseDto.setOfferValidity(provider.getOfferValidity());
        }

        //查找某供应商的竞价响应
        List<JcbdBiddingDemandResponse> demandResponseList = jcbdBiddingDemandRespRepo.findAll(new BiddingDemandResponseSpecification<>(jcbdBiddingDemandResponse));
        JcbdBiddingDemandResponse biddingDemandResponse = null;
        if (!Lang.isEmpty(jcbdBiddingDemand)){
            JcbdBiddingDemandDto jcbdBiddingDemandDto = mapperFacade.map(jcbdBiddingDemand, JcbdBiddingDemandDto.class);
            jcbdBiddingDemandDto.setBiddingId(bidding.getId());
            jcbdBiddingDemandResponseDto.setJcbdBiddingDemand(jcbdBiddingDemandDto);
        }
        if(!Lang.isEmpty(demandResponseList)){
            // 获取需求响应数据
            biddingDemandResponse = demandResponseList.get(0);
            if (!Lang.isEmpty(biddingDemandResponse)){
                jcbdBiddingDemandResponseDto = mapperFacade.map(biddingDemandResponse, JcbdBiddingDemandResponseDto.class);
                if(!Lang.isEmpty(biddingDemandResponse.getQouteIndate())){
                    jcbdBiddingDemandResponseDto.setOfferValidity(biddingDemandResponse.getQouteIndate());
                }
            }
            // 封装需求地区及数量列表
            JcbdProviderAddressResponse providerAddressResponse = new JcbdProviderAddressResponse();
            providerAddressResponse.setJcbdBiddingDemandResponse(biddingDemandResponse);
            List<JcbdProviderAddressResponse> providerAddressList = jcbdProviderAddressRespRepo.findAll(new BiddingProviderAddRespSpecification<>(providerAddressResponse));
            if (!Lang.isEmpty(providerAddressList)){
                // 需求地址id
                String demandAddressId;
                // 竞价需求地址表对象
                JcbdDemandAddressNum demandAddress;
                JcbdProviderAddressResponseDto jcbdProviderAddressResponseDto;
                List<JcbdProviderAddressResponseDto> jcbdProviderAddressResponseDtos = new ArrayList<>(providerAddressList.size());
                for (JcbdProviderAddressResponse addressResponse : providerAddressList) {
                    jcbdProviderAddressResponseDto = new JcbdProviderAddressResponseDto();
                    jcbdProviderAddressResponseDto.setDemandAddressId(addressResponse.getDemandAddressId());
                    // 需求数量
                    jcbdProviderAddressResponseDto.setNumberNeed(addressResponse.getNumberNeed());
                    jcbdProviderAddressResponseDto.setContent(addressResponse.getContent());
                    // 备注
                    jcbdProviderAddressResponseDto.setRemark(addressResponse.getRemark());
                    // 状态
                    jcbdProviderAddressResponseDto.setStatus(addressResponse.getStatus());
                    jcbdProviderAddressResponseDtos.add(jcbdProviderAddressResponseDto);
                }
                jcbdBiddingDemandResponseDto.setJcbdProviderAddressResponses(jcbdProviderAddressResponseDtos);
            }
            // 封装供应商符合性审查响应
            JcbdProviderConformanceResp providerConformanceResp = new JcbdProviderConformanceResp();
            providerConformanceResp.setJcbdBiddingDemandResponse(biddingDemandResponse);
            List<JcbdProviderConformanceResp> providerConformanceRespList = jcbdProviderConformanceRespRepo.findAll(new BiddingProviderConformanceRespSpec<>(providerConformanceResp));
            if (!Lang.isEmpty(providerConformanceRespList)) {
                // 供应商符合性响应列表
                List<JcbdProviderConformanceRespDto> jcbdProviderConformanceResDtos = new ArrayList<>(providerConformanceRespList.size());
                JcbdProviderConformanceRespDto jcbdProviderConformanceRespDto;
                JcbdBiddingConformance jcbdBiddingConformance;
                for (JcbdProviderConformanceResp conformanceResp : providerConformanceRespList) {

                    jcbdProviderConformanceRespDto = new JcbdProviderConformanceRespDto();
                    jcbdBiddingConformance = jcbdBiddingConformanceRepo.findOne(conformanceResp.getBiddingConformanceId());
                    //符合性审查表 conformance_check 里不通过的小组成员要返回给前台
                    List<JcbdConformanceCheck> jcbdConformanceChecks = jcbdConformanCheckRepo.findByBiddingConformanceId(jcbdBiddingConformance.getId());
                    StringBuffer noPassStrBuffer = new StringBuffer();
                    for (int i = 0; i < jcbdConformanceChecks.size(); i++) {
                        JcbdConformanceCheck thisConformanceCheck = jcbdConformanceChecks.get(i);
                        if (thisConformanceCheck.getProviderId().equals(conformityQueryDto.getProviderId())){
                            if(JcbdConformanceCheck.CHECK_FLAG_REJECT.equals(thisConformanceCheck.getStatus())){//不符合
                                JcbdBiddingGroupMember groupMember = new JcbdBiddingGroupMember();
                                if(!Lang.isEmpty(thisConformanceCheck.getBiddingGroupMemberId())){
                                    groupMember.setGroupMemberId(thisConformanceCheck.getBiddingGroupMemberId());
                                }else {
                                    groupMember.setEmail(thisConformanceCheck.getEmail());
                                }
                                groupMember.setJcbdBidding(bidding);
                                JcbdBiddingGroupMember biddingGroupMember = jcbdBiddingGroupMemberRepo.findOne(new BiddingGroupMemberSpecification<>(groupMember));
                                if (Lang.isEmpty(biddingGroupMember.getName())){
                                    noPassStrBuffer.append(biddingGroupMember.getEmail());
                                }else{
                                    noPassStrBuffer.append(biddingGroupMember.getName());
                                }
                                if(true){
                                    noPassStrBuffer.append(",");
                                }
                            }
                        }
                    }
                    JcbdConformanceCheck jcbdConformanceCheck = new JcbdConformanceCheck();
                    jcbdConformanceCheck.setBiddingConformance(jcbdBiddingConformance);
                    if(!Lang.isEmpty(conformityQueryDto.getMemberId())){
                        jcbdConformanceCheck.setBiddingGroupMemberId(conformityQueryDto.getMemberId());
                    }else {
                        jcbdConformanceCheck.setEmail(conformityQueryDto.getEmail());
                    }
                    jcbdConformanceCheck.setProviderId(provider.getProviderId());
                    JcbdConformanceCheck conformanceCheck = jcbdConformanCheckRepo.findOne(new BiddingConformanceCheckSpecification<>(jcbdConformanceCheck));
                    if (Lang.isEmpty(conformanceCheck)){
                        jcbdProviderConformanceRespDto.setConformanceStatus(null);
                    }else if(Lang.isEmpty(conformanceCheck.getStatus())){
                        jcbdProviderConformanceRespDto.setConformanceStatus(null);
                    }else{
                        jcbdProviderConformanceRespDto.setConformanceStatus(conformanceCheck.getStatus());
                    }
                    if(!Lang.isEmpty(noPassStrBuffer)){
                        String substring = noPassStrBuffer.substring(0, noPassStrBuffer.length() - 1);
                        jcbdProviderConformanceRespDto.setNotPassMemberStr(substring);
                    }else{
                        jcbdProviderConformanceRespDto.setNotPassMemberStr(noPassStrBuffer.toString());
                    }
                    // 符合性内容
                    jcbdProviderConformanceRespDto.setConformance(jcbdBiddingConformance.getConformance());
                    if (ProviderConformanceRespStatus.ACCORD.getValue().equals(conformanceResp.getStatus())){
                        jcbdProviderConformanceRespDto.setStatus(ProviderConformanceRespStatus.ACCORD.getDescription());
                    }else{
                        jcbdProviderConformanceRespDto.setStatus(ProviderConformanceRespStatus.NOT_ACCORD.getDescription());
                    }
                    jcbdProviderConformanceRespDto.setBiddingConformanceId(jcbdBiddingConformance.getId());
                    jcbdProviderConformanceRespDto.setId(conformanceResp.getId());
                    jcbdProviderConformanceRespDto.setRemark(conformanceResp.getRemark());
                    jcbdProviderConformanceResDtos.add(jcbdProviderConformanceRespDto);
                }
                jcbdBiddingDemandResponseDto.setJcbdProviderConformanceResps(jcbdProviderConformanceResDtos);
            }
        }

        return new BaseResponse<>(true,"查询成功",jcbdBiddingDemandResponseDto);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void deleteComplianceAudit(String biddingNo, String email,String groupMemberId) {
        //查询竞价下的需求
        JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        List<JcbdBiddingDemand> biddingDemands = jcbdBiddingDemandRepo.findByJcbdBiddingIdAndIsDelete(jcbdBidding.getId(), false);
        for(JcbdBiddingDemand biddingDemand:biddingDemands){
            List<JcbdBiddingConformance> conformances = jcbdBiddingConformanceRepo.findByJcbdBiddingDemandDemandCodeAndIsDelete(biddingDemand.getDemandCode(), false);
            for (JcbdBiddingConformance conformance:conformances) {
                List<JcbdConformanceCheck> jcbdConformanceCheck = jcbdConformanCheckRepo.findByBiddingConformanceId(conformance.getId());
                for (JcbdConformanceCheck jc:jcbdConformanceCheck) {
                    if(!Lang.isEmpty(jc.getBiddingGroupMemberId())){
                        if(jc.getBiddingGroupMemberId().equals(groupMemberId)) {
                            jcbdConformanCheckRepo.delete(jc);
                        }
                    }else{
                        if(jc.getEmail().equals(email)){
                            jcbdConformanCheckRepo.delete(jc);
                        }
                    }
                }
            }
        }

    }

    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;
    @Autowired
    JcbdConformanCheckRepo jcbdConformanCheckRepo;
    @Autowired
    JcbdBiddingDemandRespRepo jcbdBiddingDemandRespRepo;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;
    @Autowired
    JcbdDemandAddressNumRepo jcbdDemandAddressNumRepo;
    @Autowired
    JcbdProviderConformanceRespRepo jcbdProviderConformanceRespRepo;
    @Autowired
    JcbdBiddingConformanceRepo jcbdBiddingConformanceRepo;
    @Autowired
    JcbdProviderAddressRespRepo jcbdProviderAddressRespRepo;

}
