package bidding.service.service.impl.query;


import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingDemand;

import bidding.model.repository.JcbdBiddingDemandRepo;

import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.specification.BiddingDemandSpecification;

import bidding.service.service.query.BiddingDemandQueryService;

import dto.JcbdBiddingDemandDto;

import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


import java.util.List;

/**
 * @author Jian.
 * @date 2018/3/20
 */
@Slf4j
@Service
public class BiddingDemandQueryServiceImpl implements BiddingDemandQueryService {

    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    MapperFacade mapperFacade;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<JcbdBiddingDemandDto> findByJcbdBiddingIdAndIsDelete(String biddingCode) {
        JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        List<JcbdBiddingDemand>  jcbdBiddingDemands= jcbdBiddingDemandRepo.findByJcbdBiddingIdAndIsDelete(jcbdBidding.getId(), false);
        return mapperFacade.mapAsList(jcbdBiddingDemands, JcbdBiddingDemandDto.class);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<JcbdBiddingDemandDto> findByJcbdBiddingCodeAndIsDelete(String biddingCode) {
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setBiddingCode(biddingCode);
        JcbdBiddingDemand jcbdBiddingDemand = new JcbdBiddingDemand();
        jcbdBiddingDemand.setJcbdBidding(jcbdBidding);
        List<JcbdBiddingDemand> jcbdBiddingDemandList = jcbdBiddingDemandRepo.findAll(new BiddingDemandSpecification<>(jcbdBiddingDemand));
        return mapperFacade.mapAsList(jcbdBiddingDemandList, JcbdBiddingDemandDto.class);
    }
}
