package bidding.service.service.impl.query;

import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingOperationLog;
import bidding.model.repository.JcbdBiddingOperationLogRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.specification.JcbdBiddingOperationLogSpecification;
import bidding.service.service.query.BiddingLogQueryService;
import com.alibaba.druid.sql.PagerUtils;
import dto.JcbdBiddingOperationLogDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import utils.jpa.JpaPageUtil;

/**
 * 竞价日志查询业务逻辑层
 *
 * @author Drury
 * @date 2018/3/19
 */
@Slf4j
@Service
public class BiddingLogQueryServiceImpl implements BiddingLogQueryService {

    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;

    @Autowired
    JcbdBiddingOperationLogRepo jcbdBiddingOperationLogRepo;

    @Override
    public Page<JcbdBiddingOperationLogDto> findAllByBiddingNo(String biddingNo, Pageable pageable) {
        JcbdBidding jcbidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        JcbdBiddingOperationLog jcbdBiddingOperationLog=new JcbdBiddingOperationLog();
        jcbdBiddingOperationLog.setBiddingId(jcbidding.getId());
        Page<JcbdBiddingOperationLog> jcbdBiddingOperationLogs = jcbdBiddingOperationLogRepo.findAll(new JcbdBiddingOperationLogSpecification<JcbdBiddingOperationLog>(jcbdBiddingOperationLog), pageable);
        return JpaPageUtil.convertPage(jcbdBiddingOperationLogs,JcbdBiddingOperationLog.class,JcbdBiddingOperationLogDto.class);
    }
}
