package bidding.service.service.impl.query;
import bidding.model.po.*;
import bidding.model.repository.JcbdBiddingDemandRespRepo;
import bidding.model.repository.JcbdBiddingPurcahseLogRepo;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.repository.JcbdOrderRepo;
import bidding.model.specification.JcbdBiddingDemandResponseSpecification;
import bidding.model.specification.JcbdMallOrderSpecification;
import bidding.service.service.query.BiddingMallOrderQueryService;
import definition.BiddingOrderStatus;
import dto.BiddingOrderInfoDto;
import dto.JcbdMallOrderDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;

import java.util.Date;
import java.util.List;
/**
* @author luoxianwei
* @date 2018/4/14 
*/
@Slf4j
@Service
public class BiddingMallOrderQueryServiceImpl implements BiddingMallOrderQueryService {

    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;
    @Autowired
    JcbdBiddingPurcahseLogRepo jcbdBiddingPurcahseLogRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdOrderRepo jcbdOrderRepo;
    @Autowired
    JcbdBiddingDemandRespRepo jcbdBiddingDemandRespRepo;

    @Transactional
    @Override
    public List<JcbdMallOrderDto> findByJcbdOrderId(String jcbdOrderId) {
        List<JcbdMallOrder> jcbdMallOrders = jcbdMallOrderRepo.findByJcbdOrderIdAndIsDelete(jcbdOrderId,false);
        return mapperFacade.mapAsList(jcbdMallOrders, JcbdMallOrderDto.class);
    }

    @Transactional
    @Override
    public JcbdMallOrderDto updateStatusByOrderNo(String status, String orderNo) {
        JcbdMallOrder jcbdMallOrder = jcbdMallOrderRepo.findByOrderNo(orderNo);
        jcbdMallOrder.setStatus(BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode());
        jcbdMallOrder.setSupplierOrderStatus(BiddingOrderStatus.SUPPLIER_ORDER_STATUS_CANCELLED.getCode());
        jcbdMallOrder.setLastUpdated(new Date());
        JcbdMallOrder save = jcbdMallOrderRepo.save(jcbdMallOrder);
        return mapperFacade.map(save, JcbdMallOrderDto.class);
    }

    @Override
    @Transactional
    public JcbdMallOrderDto deleteJcbdMallOrderByOrderNo(String orderNo) {
        JcbdMallOrder jcbdMallOrder = jcbdMallOrderRepo.findByOrderNo(orderNo);
        jcbdMallOrder.setIsDelete(true);
        JcbdMallOrder save = jcbdMallOrderRepo.save(jcbdMallOrder);
        return mapperFacade.map(save, JcbdMallOrderDto.class);
    }

    @Override
    public BiddingOrderInfoDto getOrderInfoByOrderNo(String orderNo) {
        JcbdMallOrder jcbdMallOrder = jcbdMallOrderRepo.findByOrderNoAndIsDelete(orderNo, false);
        if(Lang.isEmpty(jcbdMallOrder)){
            return null;
        }
        return new BiddingOrderInfoDto(jcbdMallOrder.getJcbdOrder().getOrderType(),jcbdMallOrder.getJcbdOrder().getSupplierName(),jcbdMallOrder.getJcbdOrder().getCompanyName(),jcbdMallOrder.getJcbdOrder().getBdOrderNo());
    }

    /**
     * 获取订单
     *
     * @param orderNo orderNo
     * @return JcbdMallOrderDto
     */
    @Transactional
    @Override
    public JcbdMallOrderDto findByOrderNo(String orderNo) {
        JcbdMallOrder mallOrderPO = jcbdMallOrderRepo.findByOrderNo(orderNo);
        if(Lang.isEmpty(mallOrderPO)) {
            return null;
        }
        JcbdMallOrderDto mallOrder = mapperFacade.map(mallOrderPO, JcbdMallOrderDto.class);
        if(!Lang.isEmpty(mallOrderPO.getJcbdOrder())) {
            mallOrder.setJdbdOrderId(mallOrderPO.getJcbdOrder().getId());
        }
        return mallOrder;
    }

    /**
     * 更新订单状态
     *
     * @param mallOrderNo                  String
     * @param status              String
     * @param supplierOrderStatus String
     */
    @Override
    public void updateStatusAndSupplierStatus(String mallOrderNo, String status, String supplierOrderStatus) {
        JcbdMallOrder mallOrder = jcbdMallOrderRepo.findByOrderNo(mallOrderNo);
        mallOrder.setStatus(status);
        mallOrder.setSupplierOrderStatus(supplierOrderStatus);
        jcbdMallOrderRepo.save(mallOrder);
    }

    /**
     * 取消购买记录订单
     * @param orderNo
     */
    @Transactional
    @Override
    public void cancelPurchaseLogOrder(String orderNo) {
        JcbdMallOrder mallOrder = jcbdMallOrderRepo.findByOrderNo(orderNo);
        String supplierId = mallOrder.getJcbdOrder().getSupplierId();
        List<JcbdBiddingOrderItem> jcbdBiddingOrderItems = mallOrder.getJcbdBiddingOrderItems();
        for (JcbdBiddingOrderItem jcbdBiddingOrderItem : jcbdBiddingOrderItems) {
            String sku = jcbdBiddingOrderItem.getSku();
            Integer count = jcbdBiddingOrderItem.getCount();
            JcbdBiddingDemandResponseSpecification specification = new JcbdBiddingDemandResponseSpecification(supplierId,sku);
            List<JcbdBiddingDemandResponse> jcbdBiddingDemandResponses = jcbdBiddingDemandRespRepo.findAll(specification);
            if(!Lang.isEmpty(jcbdBiddingDemandResponses)){
                JcbdBiddingDemand jcbdBiddingDemand = jcbdBiddingDemandResponses.get(0).getJcbdBiddingDemand();
                JcbdBiddingPurchaseLog jcbdBiddingPurchaseLog = new JcbdBiddingPurchaseLog();
                jcbdBiddingPurchaseLog.setJcbdBiddingDemand(jcbdBiddingDemand);
                jcbdBiddingPurchaseLog.setSku(sku);
                jcbdBiddingPurchaseLog.setNumberBuy(-count);
                jcbdBiddingPurcahseLogRepo.save(jcbdBiddingPurchaseLog);
            }
        }
    }

}
