package bidding.service.service.impl.query;


import bidding.model.po.*;
import bidding.model.repository.*;
import bidding.model.specification.JcbdPurchaseLogSpecification;
import bidding.service.service.query.BiddingOrderQueryService;
import definition.BiddingOrderStatus;
import dto.*;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.data.BeanMapper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Jian.
 * @date 2018/3/20
 */
@Slf4j
@Service
public class BiddingOrderQueryServiceImpl implements BiddingOrderQueryService {

    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;

    @Autowired
    JcbdOrderRepo jcbdOrderRepo;
    @Autowired
    JcbdBiddingPurchaseLogRepo jcbdBiddingPurchaseLogRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdTempOrderRepo jcbdTempOrderRepo;
    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;

    @Transactional
    @Override
    public List<JcbdOrderDto> findByJcbdBiddingId(String biddingCode) {
        JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        List<JcbdOrder> jcbdOrders = jcbdOrderRepo.findByJcbdBiddingId(jcbdBidding.getId());
        return mapperFacade.mapAsList(jcbdOrders, JcbdOrderDto.class);
    }


    @Transactional
    @Override
    public List<JcbdOrderDto> findAllByBiddingCode(String biddingCode) {
        JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        List<JcbdOrder> jcbdOrderList = jcbdOrderRepo.findByJcbdBiddingId(jcbdBidding.getId());
        return mapperFacade.mapAsList(jcbdOrderList, JcbdOrderDto.class);
    }

    @Override
    @Transactional
    public List<JcbdBiddingPurchaseLogDto> findPurchaseLogs(JcbdBiddingPurchaseLogDto jcbdBiddingPurchaseLogDto) {
        JcbdBiddingPurchaseLog purchaseLog = mapperFacade.map(jcbdBiddingPurchaseLogDto, JcbdBiddingPurchaseLog.class);
        List<JcbdBiddingPurchaseLog> purchaseLogs = jcbdBiddingPurchaseLogRepo.findAll(new JcbdPurchaseLogSpecification<>(purchaseLog));
        return mapperFacade.mapAsList(purchaseLogs, JcbdBiddingPurchaseLogDto.class);
    }

    @Transactional
    @Override
    public BiddingOrderAffiliationDto checkIsBiddingOrder(String parentOrderNo) {
        JcbdOrder jcbdOrder = jcbdOrderRepo.findByBdOrderNo(parentOrderNo);
        BiddingOrderAffiliationDto biddingOrderAffiliationDto = new BiddingOrderAffiliationDto();

        if (jcbdOrder != null) {
            /**
             *订单为竞价订单
             */
            biddingOrderAffiliationDto.setBiddingOrderNo(jcbdOrder.getBdOrderNo());
            biddingOrderAffiliationDto.setIsBiddingOrder(true);
            List<JcbdMallOrder> mallOrders = jcbdOrder.getJcbdMallOrders();
            List<String> orderNos = new ArrayList<>();
            for (JcbdMallOrder mallOrder : mallOrders) {

                if (!StringUtils.equals(BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode(), mallOrder.getStatus()) && mallOrder.getIsDelete()==false) {
                    orderNos.add(mallOrder.getOrderNo());
                }
            }
            biddingOrderAffiliationDto.setOrderNos(orderNos);
        }
        return biddingOrderAffiliationDto;
    }

    @Transactional
    @Override
    public JcbdOrderDto findJcbdOrder(String bdOrderNo) {
        JcbdOrder jcbdOrder = jcbdOrderRepo.findByBdOrderNo(bdOrderNo);
        if (jcbdOrder != null) {
            JcbdOrderDto jcbdOrderDto = BeanMapper.map(jcbdOrder, JcbdOrderDto.class);
            return jcbdOrderDto;
        }
        return null;
    }

    @Transactional
    @Override
    public List<JcbdTempOrderDto> findTempOrderByBiddingCode(String biddingCode) {
        List<JcbdTempOrder> jcbdTempOrders = jcbdTempOrderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(biddingCode, false);
        return BeanMapper.mapList(jcbdTempOrders, JcbdTempOrder.class, JcbdTempOrderDto.class);
    }

    @Override
    public BiddingOrderOutlineInfoDto findOrderOutlineInfo(String orderNo) {
        JcbdOrder jcbdOrder = jcbdOrderRepo.findByBdOrderNo(orderNo);
        BiddingOrderOutlineInfoDto biddingOrderOutlineInfoDto = new BiddingOrderOutlineInfoDto();
        biddingOrderOutlineInfoDto.setOrderNo(jcbdOrder.getBdOrderNo());
        biddingOrderOutlineInfoDto.setCreateTime(new SimpleDateFormat("YYYY-MM-DD HH:mm:ss").format(jcbdOrder.getDateCreated()));
        biddingOrderOutlineInfoDto.setSumPrice(jcbdOrder.getTotalMoney());
        biddingOrderOutlineInfoDto.setFreight(jcbdOrder.getFreight());
        biddingOrderOutlineInfoDto.setOperatorName(jcbdOrder.getJcbdBidding().getOperatorName());
        biddingOrderOutlineInfoDto.setSupplierId(jcbdOrder.getSupplierId());
        biddingOrderOutlineInfoDto.setSupplierName(jcbdOrder.getSupplierName());
        biddingOrderOutlineInfoDto.setStatus(BiddingOrderStatus.biddingOrderStatusMap.get(jcbdOrder.getStatus()).getCode());
        return biddingOrderOutlineInfoDto;
    }

    /**
     * 获取竞价订单
     *
     * @param id
     * @return JcbdOrderDto
     */
    @Transactional(readOnly = true)
    @Override
    public JcbdOrderDto findById(String id) {
        return mapperFacade.map(jcbdOrderRepo.findOne(id), JcbdOrderDto.class);
    }

    @Override
    public BaseResponse queryBiddingOrderNoByMallOrderNo(String mallOrderNo) {
        JcbdMallOrder mallOrder = jcbdMallOrderRepo.findByOrderNo(mallOrderNo);
        if (mallOrder != null) {
            return new BaseResponse(true, "查询成功", mallOrder.getJcbdOrder().getBdOrderNo());
        }
        return new BaseResponse(false, "没找到对应竞价商城订单");
    }

    @Transactional
    @Override
    public JcbdOrderDto updateStatus(String orderNo, String status) {
        JcbdOrder byBdOrderNo = jcbdOrderRepo.findByBdOrderNo(orderNo);
        byBdOrderNo.setStatus(status);
        JcbdOrder order = jcbdOrderRepo.save(byBdOrderNo);
        return mapperFacade.map(order,JcbdOrderDto.class);
    }

}
