package bidding.service.service.impl.query;

import api.query.BiddingOrderQueryApi;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingDemand;
import bidding.model.po.JcbdBiddingPurchaseLog;
import bidding.model.po.JcbdOrder;
import bidding.model.repository.JcbdBiddingDemandRepo;
import bidding.model.repository.JcbdBiddingPurcahseLogRepo;
import bidding.model.repository.JcbdOrderRepo;
import bidding.model.specification.JcbdOrderSpecification;
import bidding.model.specification.JcbdPurchaseLogSpecification;
import bidding.service.service.query.BiddingOrderQueryService;
import bidding.service.service.query.BiddingPurchaseLogQueryService;
import dto.JcbdBiddingPurchaseLogDto;
import dto.JcbdOrderDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Slf4j
@Service
public class BiddingPurchaseLogQueryServiceImpl implements BiddingPurchaseLogQueryService {

    @Autowired
    JcbdBiddingPurcahseLogRepo jcbdBiddingPurcahseLogRepo;
    @Autowired
    MapperFacade mapperFacade;

    @Transactional
    @Override
    public List<JcbdBiddingPurchaseLogDto> findByJcbdBiddingDemandId(String biddingDemandId) {
        List<JcbdBiddingPurchaseLog> jcbdBiddingPurchaseLogs= jcbdBiddingPurcahseLogRepo.findByJcbdBiddingDemandIdAndIsDelete(biddingDemandId,false);
        return mapperFacade.mapAsList(jcbdBiddingPurchaseLogs, JcbdBiddingPurchaseLogDto.class);
    }
}
