package bidding.service.service.impl.query;

import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.specification.BiddingSpecification;
import bidding.service.service.query.BiddingQueryService;
import dto.JcbdBdProviderDto;
import dto.JcbdBiddingDto;
import dto.JcbdBiddingGroupMemberDto;
import dto.JcbdBiddingQueryResultDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.List;
/**
* @author luoxianwei
* @date 2018/4/14 
*/
@Slf4j
@Service
public class BiddingQueryServiceImpl implements BiddingQueryService {

    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public JcbdBiddingDto findByBiddingCodeAndIsDelete(String biddingCode) {
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setBiddingCode(biddingCode);
        JcbdBidding bidding = jcbdBiddingRepo.findOne(new BiddingSpecification<>(jcbdBidding));
        return mapperFacade.map(bidding, JcbdBiddingDto.class);
    }

    /**
     * 根据竞价编号和状态查询报价相同的供应商数
     * @param biddingNo
     * @param status
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<JcbdBdProviderDto> findByBiddingNoAndStatus(String biddingNo, String status) {
        List<JcbdBdProvider> jcbdBdProviderInfos = jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndStatusAndIsDelete(biddingNo, status, false);
        List<JcbdBdProviderDto> jcbdBdProviderDtos = new ArrayList<JcbdBdProviderDto>();
        if(!Lang.isEmpty(jcbdBdProviderInfos)){
            for (JcbdBdProvider jcbdBdProviderInfo:jcbdBdProviderInfos) {
                JcbdBdProviderDto map = BeanMapper.map(jcbdBdProviderInfo, JcbdBdProviderDto.class);
                jcbdBdProviderDtos.add(map);
            }
        }
        return jcbdBdProviderDtos;
    }

    /**
     * 查询竞价小组成员状态
     * @param biddingId
     * @param email
     */
    @Override
    public JcbdBiddingGroupMemberDto findGroupStatus(String email,String biddingId) {
        //获取竞价小组成员信息
        JcbdBiddingGroupMember jcbdBiddingGroupMember = jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete( email, biddingId,false);
        return BeanMapper.map(jcbdBiddingGroupMember, JcbdBiddingGroupMemberDto.class);
    }

    /**
     * 查询所有的竞价信息
     *
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<JcbdBiddingDto> findAllJcbdBidding() {
        List<JcbdBidding> jcbdBiddingList = jcbdBiddingRepo.findAll(new BiddingSpecification<>());
        return mapperFacade.mapAsList(jcbdBiddingList, JcbdBiddingDto.class);
    }

    /**
     * 批量通过竞价编号查找竞价信息
     *
     * @param binddingNos
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<JcbdBiddingDto> findJcbdBiddingByBiddingNo(List<String> binddingNos) {
        List<JcbdBidding> jcbdBiddings = jcbdBiddingRepo.findByBiddingCodeInAndIsDelete(binddingNos, false);
        return mapperFacade.mapAsList(jcbdBiddings, JcbdBiddingDto.class);
    }
}
