package bidding.service.service.impl.query;

import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.po.JcbdRoleOperation;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdRoleOperationRepo;
import bidding.model.specification.BiddingGroupMemberSpecification;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import definition.BiddingRole;
import dto.JcbdRoleOperationDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import query.BiddingOperatorQuery;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

import static java.util.Comparator.comparing;
import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toCollection;

/**
 * 竞价角色操作业务逻辑层
 *
 * @author Drury
 * @date 2018/3/19
 */
@Slf4j
@Service
public class BiddingRoleOperationQueryServiceImpl implements BiddingRoleOperationQueryService {

    @Autowired
    JcbdRoleOperationRepo jcbdRoleOperationRepo;


    @Override
    public List<JcbdRoleOperationDto> findByRoleCodeAndStatus(String roleCode, String status) {
        List<JcbdRoleOperation> jcbdRoleOperationList = jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex(roleCode, status);
        if (!Lang.isEmpty(jcbdRoleOperationList)) {
            return BeanMapper.mapList(jcbdRoleOperationList, JcbdRoleOperation.class, JcbdRoleOperationDto.class);
        }
        return null;
    }

    @Override
    public List<JcbdRoleOperation> getAllStatusByRoles(List<String> roleCodes) {
        List<JcbdRoleOperation> jcbdRoleOperationList = jcbdRoleOperationRepo.findByRoleCodeInOrderByShowIndex(roleCodes);

        ArrayList<JcbdRoleOperation> roleOperations = jcbdRoleOperationList.stream().collect(collectingAndThen(toCollection(() -> new TreeSet<>(comparing(JcbdRoleOperation::getStatus))), ArrayList::new));
        return roleOperations;
    }

    @Override
    public List<JcbdRoleOperationDto> findByRoleCodeAndStatusAndModuleOrderByShowIndex(String roleCode, String status, String module) {
        List<JcbdRoleOperation> jcbdRoleOperationList = jcbdRoleOperationRepo.findByRoleCodeAndStatusAndModuleAndIsDeleteOrderByShowIndex(roleCode, status, module,false);
        if (!Lang.isEmpty(jcbdRoleOperationList)) {
            return BeanMapper.mapList(jcbdRoleOperationList, JcbdRoleOperation.class, JcbdRoleOperationDto.class);
        }
        return null;
    }

    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;

    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;

    @Override
    public List<JcbdRoleOperationDto> getOperatorBiddingOperateByBiddingCode(BiddingOperatorQuery biddingOperatorQuery) {
        JcbdBiddingGroupMember jcbdBiddingGroupMemberQuery = new JcbdBiddingGroupMember();
        jcbdBiddingGroupMemberQuery.setEmail(biddingOperatorQuery.getEmail());
        jcbdBiddingGroupMemberQuery.setGroupMemberId(biddingOperatorQuery.getMemberId());
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setBiddingCode(biddingOperatorQuery.getBiddingNo());
        jcbdBiddingGroupMemberQuery.setJcbdBidding(jcbdBidding);
        List<JcbdBiddingGroupMember> groupMembers = jcbdBiddingGroupMemberRepo.findAll(new BiddingGroupMemberSpecification(jcbdBiddingGroupMemberQuery));
        //查找该用户可以对该记录进行的操作
        List<JcbdRoleOperationDto> jcbdRoleOperationDtoList = new ArrayList<>();
        if (groupMembers != null && !groupMembers.isEmpty()) {
            JcbdBiddingGroupMember groupMember = groupMembers.get(0);
            //如果该用户是这条竞价的经办人则查找两种身份下拥有的操作
            if (groupMember != null && groupMember.getJcbdBidding().getOperatorId().equals(biddingOperatorQuery.getMemberId())) {
                List<JcbdRoleOperation> operationDtoForOperator = jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex(BiddingRole.BIDDING_OPERATOR, groupMember.getStatus());
                List<JcbdRoleOperation> operationDtosForGroupMember = jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex(BiddingRole.BIDDING_GROUP_MEMBER, groupMember.getStatus());
                if (!Lang.isEmpty(operationDtoForOperator)) {
                    jcbdRoleOperationDtoList.addAll(BeanMapper.mapList(operationDtoForOperator, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                }
                if (!Lang.isEmpty(operationDtosForGroupMember)) {
                    jcbdRoleOperationDtoList.addAll(BeanMapper.mapList(operationDtosForGroupMember, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                }
            } else {
                //否则只查找作为竞价小组成员才有的操作
                List<JcbdRoleOperation> operationDtosForGroupMember = jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex(BiddingRole.BIDDING_GROUP_MEMBER, groupMember.getStatus());
                if (!Lang.isEmpty(operationDtosForGroupMember)) {
                    jcbdRoleOperationDtoList.addAll(BeanMapper.mapList(operationDtosForGroupMember, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                }
            }
        }
        //将操作链接拼接一个竞价编号参数
        for (JcbdRoleOperationDto jcbdRoleOperationDto : jcbdRoleOperationDtoList) {
            String url = jcbdRoleOperationDto.getUrl();
            if (url != null && !"".equals(url)) {
                url = url + "?biddingNo=" + biddingOperatorQuery.getBiddingNo();
            }
            jcbdRoleOperationDto.setUrl(url);
        }
        return jcbdRoleOperationDtoList;
    }

    @Override
    public List<String> getBiddingShowTitle(String status, String module) {
        List<JcbdRoleOperation> jcbdRoleOperations = jcbdRoleOperationRepo.findByStatusAndModuleAndIsDelete(status, module, false);
        List<String> result = new ArrayList<>();
        jcbdRoleOperations.forEach(jcbdRoleOperation -> {
            result.add(jcbdRoleOperation.getEvent());
        });
        return result;
    }

    @Override
    public List<JcbdRoleOperationDto> getSupplierBiddingOperateByBiddingCode(String biddingNo, String status) {
        //查找该用户可以对该记录进行的操作
        List<JcbdRoleOperationDto> jcbdRoleOperationDtoList = new ArrayList<>();
        List<JcbdRoleOperation> operationDtos = jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex(BiddingRole.BIDDING_SUPPLIER, status);
        if (!Lang.isEmpty(operationDtos)) {
            jcbdRoleOperationDtoList.addAll(BeanMapper.mapList(operationDtos, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
        }
        //将操作链接拼接一个竞价编号参数
        for (JcbdRoleOperationDto jcbdRoleOperationDto : jcbdRoleOperationDtoList) {
            String url = jcbdRoleOperationDto.getUrl();
            if (url != null && !"".equals(url)) {
                url = url + "?biddingNo=" + biddingNo;
            }
            jcbdRoleOperationDto.setUrl(url);
        }
        return jcbdRoleOperationDtoList;
    }
}
