package bidding.service.service.impl.query;

import bidding.model.po.MallAttachment;
import bidding.model.repository.MallAttachmentRepo;
import bidding.service.service.query.MallAttachmentQueryService;
import dto.MallAttachmentDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.List;

/**
 * @author: taofeng
 * @create: 2018-04-11
 **/
@Slf4j
@Service
public class MallAttachmentQueryServiceImpl implements MallAttachmentQueryService {

    @Autowired
    MallAttachmentRepo mallAttachmentRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<List<MallAttachmentDto>> findAttachmentByBiddingCodeAndBusinessCode(String attachmentCorrelation, String businessCode) {

        if (Lang.isEmpty(Lang.isEmpty(attachmentCorrelation) || Lang.isEmpty(businessCode))) {
            return new BaseResponse(false, "参数为空", null);
        }

        List<MallAttachment> mallAttachmentList = mallAttachmentRepo.findByAttachmentCorrelationAndBusinessCode(attachmentCorrelation, businessCode);
        if (Lang.isEmpty(mallAttachmentList)) {
            return new BaseResponse(false, "数据为空", null);
        }
        List<MallAttachmentDto> mallAttachmentDtos = BeanMapper.mapList(mallAttachmentList, MallAttachment.class, MallAttachmentDto.class);
        if (Lang.isEmpty(mallAttachmentDtos)) {
            return new BaseResponse(false, "结果为空", null);
        }

        return new BaseResponse(true, "操作成功", mallAttachmentDtos);
    }
}
