package bidding.service.service.query;

import dto.*;
import org.springframework.data.domain.Page;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * 符合性审查业务逻辑层接口
 *
 * @author Drury
 * @date 2018/3/19
 */
public interface BiddingConformityReviewQueryService {

    /**
     * 获取竞价小组成员信息
     *
     * @param biddingNo 竞价编号
     * @return BaseResponse<List<JcbdBiddingGroupMemberDto>>
     */
    BaseResponse<List<JcbdBiddingGroupMemberDto>> findBiddingGroupMember(String biddingNo);

    /**
     * 获取符合性审核列表dto  符合性审核页
     * @param conformityQueryDto
     * @return
     */
    Page<BiddingConformityListDto> getConformityListByQueryDto(BiddingConformityQueryDto conformityQueryDto);

    /**
     * 获取符合性审核信息-供应商需求响应的具体信息-符合性审核页
     * @param demandCode
     * @return
     */
    List<JcbdBiddingDemandResponseDto> getConformityAuditInfo(String demandCode);

    /**
     * 获取符合性审核概要-页面上的供应商信息概要
     * @param conformityQueryDto
     * @return
     */
    BaseResponse<List<BiddingResponseOutlineDto>> queryConformityOutline(BiddingConformityQueryDto conformityQueryDto);

    /**
     * 获取具体供应商的符合性信息
     * @param conformityQueryDto
     * @return
     */
    BaseResponse<JcbdBiddingDemandResponseDto> getConformityDetail(BiddingConformityQueryDto conformityQueryDto);

    /**
     * 删除选中的竞价小组成员的符合性审查记录（重新发起符合性审查）
     * @param biddingNo
     * @param groupMemberId
     * @return
     */
    void deleteComplianceAudit(String biddingNo,String email, String groupMemberId);
}
