package bidding.service.service.query;

import dto.*;
import org.springframework.data.domain.Page;
import query.BiddingDemandListQuery;
import sinomall.global.common.response.BaseResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author bande
 * @date 2018/3/19
 */
public interface BiddingMainQueryService {

    /**
     * 获取采购商品集合
     *
     * @param biddingNo 竞价编号
     * @return BaseResponse<List<BiddingPurchaseGoodsDTO>>
     */
    BaseResponse<List<BiddingPurchaseGoodsDTO>> getPurchaseGoods(String biddingNo);

    /**
     * 竞价列表查询接口
     *
     * @param jcbdBiddingQueryDto
     * @return
     */
    Page<JcbdBiddingQueryResultDto> operatorFindJcbdBiddingByParams(JcbdBiddingQueryDto jcbdBiddingQueryDto);

    /**
     * 供应商竞价列表查询
     *
     * @param jcbdBiddingQueryDto
     * @return
     */
    Page<JcbdBiddingQueryResultDto> supplierFindJcbdBiddingByParams(JcbdBiddingQueryDto jcbdBiddingQueryDto);


    /**
     * 竞价需求查询(概要) 通过竞价编号查询竞价需求列表
     *
     * @param biddingDemandListQuery
     * @return
     */
    BaseResponse<Page<BiddingDemandQueryDto>> getBiddingDemandList(BiddingDemandListQuery biddingDemandListQuery);


    /**
     * 竞价需求查询(详细)
     *
     * @param demandCode
     * @return
     */
    BaseResponse<JcbdBiddingDemandDto> getBiddingDemandInfo(String demandCode);

    /**
     * 竞价概要信息查询
     *
     * @param biddingCode
     * @return
     */
    BaseResponse<JcbdBiddingDto> getBiddingByBiddingCode(String biddingCode);

    /**
     * 查找特定一个JcbdBiddingDemandDto
     *
     * @param jcbdBiddingDemandDto
     * @return
     */
    JcbdBiddingDemandDto getBiddingDemandFindOne(JcbdBiddingDemandDto jcbdBiddingDemandDto);

    /**
     * 可采购信息查询接口
     *
     * @param biddingCode
     * @return
     */
    List<ProcureInformationDto> getBiddingDemandSku(String biddingCode);


    /**
     * 查询竞价
     *
     * @param biddingNo
     * @return
     */
    JcbdBiddingDto queryBidding(String biddingNo);

    /**
     * 获取临时订单列表
     *
     * @param biddingNo
     * @return
     */
    List<TempBatchDto> getTempBatchList(String biddingNo);

    /**
     * 根据竞价编号获取已成交的供应商信息
     * @param biddingNo
     * @return
     */
    JcbdBdProviderDto getTransactionSupplier(String biddingNo);

    /**
     * 根据竞价编号及供应商id获取供应商竞价
     * @param biddingNo
     * @param supplierId
     * @return
     */
    JcbdBdProviderDto getProvider(String biddingNo, String supplierId);

    /**
     * 获取竞价全部临时订单
     * @param biddingNo
     * @return
     */
    List<JcbdTempOrderDto> findAllTempOrderByBiddingNo(String biddingNo);


    /**
     * 根据竞价id获取竞价
     * @param biddingId
     * @return
     */
    BaseResponse<JcbdBiddingDto> findOne(String biddingId);

    /**
     * 获取竞价总预算
     * @param biddingNo
     * @return
     */
    BigDecimal getBiddingGeneralBudget(String biddingNo);
}
