package bidding.service.service.query;

import dto.*;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author Jian.
 * @date 2018/3/20
 */
public interface BiddingOrderQueryService {

    /**
     * 通过竞价主表biddingCode查询
     *
     * @param biddingCode
     * @return
     */
    List<JcbdOrderDto> findByJcbdBiddingId(String biddingCode);

    /**
     * 通过竞价主表id查询
     *
     * @param biddingCode
     * @return
     */
    List<JcbdOrderDto> findAllByBiddingCode(String biddingCode);

    /**
     * 查询操作日志
     *
     * @param jcbdBiddingPurchaseLogDto
     * @return
     */
    List<JcbdBiddingPurchaseLogDto> findPurchaseLogs(JcbdBiddingPurchaseLogDto jcbdBiddingPurchaseLogDto);

    /**
     * 查询是否竞价订单
     *
     * @param parentOrderNo
     * @return
     */
    BiddingOrderAffiliationDto checkIsBiddingOrder(String parentOrderNo);

    /**
     * 查询竞价信息
     *
     * @param bdOrderNo
     * @return
     */
    JcbdOrderDto findJcbdOrder(String bdOrderNo);

    /**
     * 查找竞价下的临时订单
     * 默认isDelete 为false
     * @param biddingCode
     * @return
     */
    List<JcbdTempOrderDto> findTempOrderByBiddingCode(String biddingCode);

    /**
     * 竞价订单概要信息
     * @param orderNo
     * @return
     */
    BiddingOrderOutlineInfoDto findOrderOutlineInfo(String orderNo);

    /**
     * 获取竞价订单
     *
     * @param id
     * @return JcbdOrderDto
     */
    JcbdOrderDto findById(String id);

    /**
     * 跟据商城订单号查询竞价订单号
     * @param mallOrderNo
     * @return
     */
    BaseResponse queryBiddingOrderNoByMallOrderNo(String mallOrderNo);

    /**
     * 修改订单状态
     * @param orderNo
     * @param status
     * @return
     */
    JcbdOrderDto updateStatus(String orderNo, String status);
}
