package bidding.service.service.query;

import dto.JcbdBdProviderDto;
import dto.JcbdBiddingDto;
import dto.JcbdBiddingGroupMemberDto;
import dto.JcbdBiddingQueryResultDto;

import java.util.List;

/**
* @author luoxianwei
* @date 2018/4/14 
*/
public interface BiddingQueryService {

    /**
     * 通过竞价编号查找竞价信息
     * @param biddingCode
     * @return
     */
    JcbdBiddingDto findByBiddingCodeAndIsDelete(String biddingCode);

    /**
     * 查询所有的竞价信息
     * @return
     */
    List<JcbdBiddingDto> findAllJcbdBidding();


    /**
     * 批量通过竞价编号查找竞价信息
     * @param binddingNo
     * @return
     */
    List<JcbdBiddingDto> findJcbdBiddingByBiddingNo(List<String> binddingNo);

    /**
     * 根据竞价编号和状态查询报价相同的供应商数
     * @param biddingNo
     * @param status
     * @return
     */
    List<JcbdBdProviderDto> findByBiddingNoAndStatus(String biddingNo, String status);

    /**
     * 查询小组成员状态
     * @param biddingNo
     * @param email
     */
    JcbdBiddingGroupMemberDto findGroupStatus(String biddingNo, String email);
}
