package bidding.service.service.query;
import dto.BiddingSupplierOrderMangerDto;
import dto.JcbdBdProviderDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import query.BiddingSupplierOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;

import java.util.List;
/**
* @author luoxianwei
* @date 2018/4/14
 * 供应商订单管理业务逻辑层接口
*/
public interface BiddingSupplierOrderManagerService {

    /**
     * 查询分页获取供应商订单管理列表
     *
     * @param biddingSupplierOrderManagerListQuery
     * @param pageable
     * @return BaseResponse<Page<BiddingOrderResultDto>>
     */
    Page<BiddingSupplierOrderMangerDto> getBiddingSupplierOrderMangerList(BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable);

    /**
     * 根据供应商id查询供应商信息
     * @param providerId
     * @return
     */
    JcbdBdProviderDto findJcbdBdProvider(String id,String providerId);
}
