/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingConformance;
import bidding.model.po.JcbdBiddingDemand;
import bidding.model.po.JcbdBiddingDemandResponse;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.po.JcbdConformanceCheck;
import bidding.model.po.JcbdDemandAddressNum;
import bidding.model.po.JcbdProviderAddressResponse;
import bidding.model.po.JcbdProviderConformanceResp;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingConformanceRepo;
import bidding.model.repository.JcbdBiddingDemandRepo;
import bidding.model.repository.JcbdBiddingDemandRespRepo;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdConformanCheckRepo;
import bidding.model.repository.JcbdDemandAddressNumRepo;
import bidding.model.repository.JcbdProviderAddressRespRepo;
import bidding.model.repository.JcbdProviderConformanceRespRepo;
import bidding.model.specification.BiddingConformanceCheckSpecification;
import bidding.model.specification.BiddingConformanceSpecification;
import bidding.model.specification.BiddingDemandAddressSpecification;
import bidding.model.specification.BiddingDemandResponseSpecification;
import bidding.model.specification.BiddingDemandSpecification;
import bidding.model.specification.BiddingProviderAddRespSpecification;
import bidding.model.specification.BiddingProviderConformanceRespSpec;
import bidding.model.specification.BiddingProviderSpecification;
import bidding.model.specification.BiddingSpecification;
import bidding.service.service.BiddingConformityReviewService;
import bidding.service.service.BiddingConformityReviewTransactionalService;
import com.alibaba.fastjson.JSON;
import definition.BiddingConformAuditStatus;
import definition.BiddingProviderAddRespStatus;
import definition.BiddingStatus;
import definition.ProviderConformanceRespStatus;
import dto.BiddingConformReviewAuditListDTO;
import dto.BiddingConformityAuditDTO;
import dto.BiddingConformityReviewDTO;
import dto.BiddingConformityReviewDemandAddDTO;
import dto.BiddingConformityReviewInfoDTO;
import dto.JcbdBiddingQueryDto;
import dto.JcbdBiddingQueryResultDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import query.BiddingConformityReviewAuditListQuery;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class BiddingConformityReviewServiceImpl
implements BiddingConformityReviewService {
    private static final Logger log = LoggerFactory.getLogger(BiddingConformityReviewServiceImpl.class);
    @Autowired
    JcbdConformanCheckRepo jcbdConformanCheckRepo;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    private MapperFacade mapperFacade;
    @Autowired
    private JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;
    private JcbdBiddingRepo biddingRepo;
    private JcbdBiddingDemandRepo biddingDemandRepo;
    private JcbdBiddingConformanceRepo biddingConformanceRepo;
    private JcbdBiddingDemandRespRepo biddingDemandRespRepo;
    private JcbdConformanCheckRepo biddingConformanCheckRepo;
    private JcbdBdProviderRepo biddingProviderRepo;
    private JcbdDemandAddressNumRepo biddingDemandAddressRepo;
    private JcbdProviderAddressRespRepo providerAddressRespRepo;
    private JcbdProviderConformanceRespRepo providerConformanceRespRepo;
    private BiddingConformityReviewTransactionalService biddingConformityReviewTransactionalService;

    public BaseResponse<Page<BiddingConformReviewAuditListDTO>> getBiddingConformityReviewAuditList(BiddingConformityReviewAuditListQuery biddingConformityReviewAuditListQuery) {
        log.info("\u83b7\u53d6\u7b26\u5408\u6027\u5ba1\u67e5\u5217\u8868-\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)biddingConformityReviewAuditListQuery));
        if (Lang.isEmpty((Object)biddingConformityReviewAuditListQuery)) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7b26\u5408\u6027\u5ba1\u67e5\u5217\u8868\u5931\u8d25-\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)biddingConformityReviewAuditListQuery.getAuditorId())) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7b26\u5408\u6027\u5ba1\u67e5\u5217\u8868\u5931\u8d25-\u5ba1\u6838\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)biddingConformityReviewAuditListQuery.getBiddingCode())) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7b26\u5408\u6027\u5ba1\u67e5\u5217\u8868\u5931\u8d25-\u7ade\u4ef7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)biddingConformityReviewAuditListQuery.getPageable())) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7b26\u5408\u6027\u5ba1\u67e5\u5217\u8868\u5931\u8d25-\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        try {
            BaseResponse biddingResponse = this.findAndCheckBidding(biddingConformityReviewAuditListQuery.getBiddingCode());
            if (!biddingResponse.isSuccess()) {
                return new BaseResponse(biddingResponse.getResultMessage());
            }
            JcbdBidding bidding = (JcbdBidding)biddingResponse.getResult();
            JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
            biddingDemand.setJcbdBidding(bidding);
            Page biddingDemandPage = this.biddingDemandRepo.findAll((Specification)new BiddingDemandSpecification(biddingDemand), biddingConformityReviewAuditListQuery.getPageable());
            List biddingDemands = biddingDemandPage.getContent();
            List biddingConformReviewAuditList = this.mapperFacade.mapAsList((Iterable)biddingDemands, BiddingConformReviewAuditListDTO.class);
            for (int i = 0; i < biddingDemands.size(); ++i) {
                JcbdBiddingConformance biddingConformance = new JcbdBiddingConformance();
                biddingConformance.setJcbdBiddingDemand((JcbdBiddingDemand)biddingDemands.get(i));
                Long checkItemCount = this.biddingConformanceRepo.count((Specification)new BiddingConformanceSpecification(biddingConformance));
                ((BiddingConformReviewAuditListDTO)biddingConformReviewAuditList.get(i)).setCheckItemCount(Integer.valueOf(checkItemCount.intValue()));
                JcbdBiddingDemandResponse biddingDemandResponse = new JcbdBiddingDemandResponse();
                biddingDemandResponse.setJcbdBiddingDemand((JcbdBiddingDemand)biddingDemands.get(i));
                Long demandResponseCount = this.biddingDemandRespRepo.count((Specification)new BiddingDemandResponseSpecification(biddingDemandResponse));
                ((BiddingConformReviewAuditListDTO)biddingConformReviewAuditList.get(i)).setDemandResponseCount(Integer.valueOf(demandResponseCount.intValue()));
                HashMap<String, Integer> map = new HashMap<String, Integer>(demandResponseCount.intValue());
                List biddingConformances = this.biddingConformanceRepo.findAll((Specification)new BiddingConformanceSpecification(biddingConformance));
                for (JcbdBiddingConformance biddingConformanceTemp : biddingConformances) {
                    JcbdConformanceCheck conformanceCheck = new JcbdConformanceCheck();
                    conformanceCheck.setBiddingConformance(biddingConformanceTemp);
                    conformanceCheck.setBiddingGroupMemberId(biddingConformityReviewAuditListQuery.getAuditorId());
                    List conformanceChecks = this.biddingConformanCheckRepo.findAll((Specification)new BiddingConformanceCheckSpecification(conformanceCheck));
                    for (JcbdConformanceCheck conformanceCheckTemp : conformanceChecks) {
                        String key = conformanceCheckTemp.getProviderId();
                        if (map.containsKey(key)) {
                            map.put(key, (Integer)map.get(key) + 1);
                            continue;
                        }
                        map.put(key, 1);
                    }
                }
                int auditSupplierCount = 0;
                for (String key : map.keySet()) {
                    if (((Integer)map.get(key)).intValue() != biddingConformances.size()) continue;
                    ++auditSupplierCount;
                }
                ((BiddingConformReviewAuditListDTO)biddingConformReviewAuditList.get(i)).setAuditSupplierCount(Integer.valueOf(auditSupplierCount));
            }
            PageImpl biddingConformReviewAuditListDTOPage = new PageImpl(biddingConformReviewAuditList, biddingConformityReviewAuditListQuery.getPageable(), (long)biddingConformReviewAuditList.size());
            log.info("\u83b7\u53d6\u7b26\u5408\u6027\u5ba1\u67e5\u5217\u8868 DATA : {}", (Object)JSON.toJSONString((Object)biddingConformReviewAuditListDTOPage));
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)biddingConformReviewAuditListDTOPage);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b26\u5408\u6027\u5ba1\u67e5\u5217\u8868\u5f02\u5e38, \u7ade\u4ef7\u7f16\u53f7 {} ", (Object)biddingConformityReviewAuditListQuery.getBiddingCode(), (Object)e);
            return new BaseResponse("\u83b7\u53d6\u7b26\u5408\u6027\u5ba1\u67e5\u5217\u8868\u5f02\u5e38");
        }
    }

    public BaseResponse<List<BiddingConformityReviewInfoDTO>> getBiddingConformityReviewInfo(String demandCode, String auditorId) {
        log.info("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e-\u8bf7\u6c42\u53c2\u6570\u7ade\u4ef7\u9700\u6c42\u7f16\u53f7 {}", (Object)demandCode);
        if (Lang.isEmpty((Object)demandCode)) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e\u5931\u8d25-\u8bf7\u6c42\u53c2\u6570\u7ade\u4ef7\u9700\u6c42\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        try {
            JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
            biddingDemand.setDemandCode(demandCode);
            List biddingDemands = this.biddingDemandRepo.findAll((Specification)new BiddingDemandSpecification(biddingDemand));
            if (biddingDemands.size() != 1) {
                log.error("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e\u5931\u8d25-\u7ade\u4ef7\u9700\u6c42\u7f16\u53f7\u4e3a {} \u7684\u6570\u636e\u8981\u6c42\u6709\u4e14\u53ea\u6709\u6709 1 \u6761, \u5b9e\u9645 {} \u6761", (Object)biddingDemand, (Object)biddingDemands.size());
                return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e\u5931\u8d25-\u6570\u636e\u68c0\u67e5\u672a\u901a\u8fc7");
            }
            biddingDemand = (JcbdBiddingDemand)biddingDemands.get(0);
            JcbdDemandAddressNum biddingDemandAdd = new JcbdDemandAddressNum();
            biddingDemandAdd.setJcbdBiddingDemand(biddingDemand);
            List biddingDemandAdds = this.biddingDemandAddressRepo.findAll((Specification)new BiddingDemandAddressSpecification(biddingDemandAdd));
            JcbdBiddingConformance biddingConformance = new JcbdBiddingConformance();
            biddingConformance.setJcbdBiddingDemand(biddingDemand);
            List biddingConformances = this.biddingConformanceRepo.findAll((Specification)new BiddingConformanceSpecification(biddingConformance));
            JcbdBidding bidding = new JcbdBidding();
            bidding.setId(biddingDemand.getJcbdBidding().getId());
            JcbdBdProvider biddingProvider = new JcbdBdProvider();
            biddingProvider.setJcbdBidding(bidding);
            List biddingProviders = this.biddingProviderRepo.findAll((Specification)new BiddingProviderSpecification(biddingProvider));
            biddingProviders = biddingProviders.stream().filter(provider -> !provider.getStatus().equals(BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue())).collect(Collectors.toList());
            biddingProviders = biddingProviders.stream().filter(provider -> !provider.getStatus().equals(BiddingStatus.SUPPLIER_RESPONSE_GIVEUP.getValue())).collect(Collectors.toList());
            JcbdBiddingDemandResponse biddingDemandResponse = new JcbdBiddingDemandResponse();
            biddingDemandResponse.setJcbdBiddingDemand(biddingDemand);
            List biddingDemandResponses = this.biddingDemandRespRepo.findAll((Specification)new BiddingDemandResponseSpecification(biddingDemandResponse));
            ArrayList<BiddingConformityReviewInfoDTO> biddingConformityReviewInfos = new ArrayList<BiddingConformityReviewInfoDTO>();
            for (JcbdBdProvider biddingProviderTemp : biddingProviders) {
                BiddingConformityReviewInfoDTO biddingConformityReviewInfo = new BiddingConformityReviewInfoDTO();
                biddingConformityReviewInfo.setSupplierId(biddingProviderTemp.getId());
                biddingConformityReviewInfo.setSupplierName(biddingProviderTemp.getProviderName());
                biddingConformityReviewInfo.setGoodsDescription(biddingDemand.getGoodsDesription());
                biddingConformityReviewInfo.setSpecification(biddingDemand.getSpecification());
                biddingConformityReviewInfo.setServiceRequirement(biddingDemand.getServiceRequirement());
                biddingConformityReviewInfo.setDateRequiredDelivery(biddingDemand.getDateRequiredDelivery());
                for (JcbdBiddingDemandResponse biddingDemandResponseTemp : biddingDemandResponses) {
                    if (!biddingDemandResponseTemp.getResponseProviderId().equals(biddingProviderTemp.getId())) continue;
                    biddingConformityReviewInfo.setGoodsTitle(biddingDemandResponseTemp.getGoodsTitle());
                    biddingConformityReviewInfo.setGoodsParams(biddingDemandResponseTemp.getGoodsParams());
                    biddingConformityReviewInfo.setServerPromise(biddingDemandResponseTemp.getServicePromise());
                    biddingConformityReviewInfo.setSku(biddingDemandResponseTemp.getSku());
                    biddingConformityReviewInfo.setGoodsLink(biddingDemandResponseTemp.getGoodsLink());
                    biddingConformityReviewInfo.setPricePeriodOfValidity(biddingDemandResponseTemp.getQouteIndate());
                    biddingConformityReviewInfo.setSupplyPeriod(biddingDemandResponseTemp.getSupplyPeriod());
                    biddingConformityReviewInfo.setRemark(biddingDemandResponseTemp.getRemark());
                    JcbdProviderAddressResponse providerAddressResponse = new JcbdProviderAddressResponse();
                    providerAddressResponse.setJcbdBiddingDemandResponse(biddingDemandResponseTemp);
                    List providerAddressResponses = this.providerAddressRespRepo.findAll((Specification)new BiddingProviderAddRespSpecification(providerAddressResponse));
                    ArrayList<BiddingConformityReviewDemandAddDTO> demandAdds = new ArrayList<BiddingConformityReviewDemandAddDTO>();
                    for (JcbdProviderAddressResponse providerAddressResponseTemp : providerAddressResponses) {
                        for (JcbdDemandAddressNum biddingDemandAddress : biddingDemandAdds) {
                            if (!providerAddressResponseTemp.getDemandAddressId().equals(biddingDemandAddress.getId())) continue;
                            String address = biddingDemandAddress.getProvinceName();
                            address = address + biddingDemandAddress.getCityName();
                            address = address + biddingDemandAddress.getAreaName();
                            address = address + biddingDemandAddress.getTownName();
                            BiddingConformityReviewDemandAddDTO biddingConformityReviewDemandAdd = new BiddingConformityReviewDemandAddDTO();
                            biddingConformityReviewDemandAdd.setAddress(address);
                            biddingConformityReviewDemandAdd.setNumberNeed(biddingDemandAddress.getNumberNeed());
                            biddingConformityReviewDemandAdd.setRemark(providerAddressResponseTemp.getRemark());
                            biddingConformityReviewDemandAdd.setStatus(((BiddingProviderAddRespStatus)BiddingProviderAddRespStatus.bddingProviderAddRespStatusMap.get(providerAddressResponseTemp.getStatus())).getDescription());
                            demandAdds.add(biddingConformityReviewDemandAdd);
                        }
                    }
                    biddingConformityReviewInfo.setDemandAdds(demandAdds);
                    ArrayList<BiddingConformityReviewDTO> conformityReviews = new ArrayList<BiddingConformityReviewDTO>();
                    JcbdProviderConformanceResp providerConformanceResp = new JcbdProviderConformanceResp();
                    providerConformanceResp.setJcbdBiddingDemandResponse(biddingDemandResponseTemp);
                    List providerConformanceResps = this.providerConformanceRespRepo.findAll((Specification)new BiddingProviderConformanceRespSpec(providerConformanceResp));
                    int accordCount = 0;
                    int notAccordCount = 0;
                    for (JcbdProviderConformanceResp providerConformanceRespTemp : providerConformanceResps) {
                        for (JcbdBiddingConformance biddingConformanceTemp : biddingConformances) {
                            if (!providerConformanceRespTemp.getBiddingConformanceId().equals(biddingConformanceTemp.getId())) continue;
                            BiddingConformityReviewDTO biddingConformityReview = new BiddingConformityReviewDTO();
                            biddingConformityReview.setConformance(biddingConformanceTemp.getConformance());
                            biddingConformityReview.setStatus(((ProviderConformanceRespStatus)ProviderConformanceRespStatus.providerConformanceRespStatusMap.get(providerConformanceRespTemp.getStatus())).getDescription());
                            biddingConformityReview.setRemark(providerConformanceRespTemp.getRemark());
                            JcbdConformanceCheck biddingConformanceCheck = new JcbdConformanceCheck();
                            biddingConformanceCheck.setBiddingGroupMemberId(auditorId);
                            biddingConformanceCheck.setJcbdProviderConformanceResp(providerConformanceRespTemp);
                            biddingConformanceCheck.setProviderId(biddingDemandResponseTemp.getResponseProviderId());
                            biddingConformanceCheck.setBiddingConformance(biddingConformanceTemp);
                            List biddingConformanceChecks = this.biddingConformanCheckRepo.findAll((Specification)new BiddingConformanceCheckSpecification(biddingConformanceCheck));
                            if (biddingConformanceChecks.size() > 1) {
                                log.error("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e\u5931\u8d25-\u540c\u4e00\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u540c\u4e00\u7b26\u5408\u6027\u5ba1\u67e5\u9879\u4f9b\u5e94\u5546\u54cd\u5e94\u5ba1\u6838\u7684\u6570\u636e\u8981\u6c42\u6700\u591a\u53ea\u6709 1 \u6761, \u5b9e\u9645 {} \u6761", (Object)biddingDemands.size());
                                return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e\u5931\u8d25-\u6570\u636e\u68c0\u67e5\u672a\u901a\u8fc7");
                            }
                            if (biddingConformanceChecks.size() == 1) {
                                JcbdConformanceCheck conformanceCheck = (JcbdConformanceCheck)biddingConformanceChecks.get(0);
                                if (BiddingConformAuditStatus.ACCORD.equals(BiddingConformAuditStatus.biddingConformAuditStatusMap.get(conformanceCheck.getStatus()))) {
                                    ++accordCount;
                                } else if (BiddingConformAuditStatus.NOT_ACCORD.equals(BiddingConformAuditStatus.biddingConformAuditStatusMap.get(conformanceCheck.getStatus()))) {
                                    ++notAccordCount;
                                }
                                biddingConformityReview.setAuditStatus(conformanceCheck.getStatus());
                            }
                            conformityReviews.add(biddingConformityReview);
                        }
                    }
                    if (accordCount == biddingConformances.size()) {
                        biddingConformityReviewInfo.setSupplierResponseAuditStatus(BiddingConformAuditStatus.ACCORD.getDescription());
                    } else if (notAccordCount == biddingConformances.size()) {
                        biddingConformityReviewInfo.setSupplierResponseAuditStatus(BiddingConformAuditStatus.NOT_ACCORD.getDescription());
                    }
                    biddingConformityReviewInfo.setConformityReviews(conformityReviews);
                }
                biddingConformityReviewInfos.add(biddingConformityReviewInfo);
            }
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", biddingConformityReviewInfos);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e\u5f02\u5e38, \u7ade\u4ef7\u9700\u6c42\u7f16\u53f7 {} ", (Object)demandCode, (Object)e);
            return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e\u5f02\u5e38");
        }
    }

    public BaseResponse saveBiddingConformityReviewAuditData(BiddingConformityAuditDTO conformityAudit) {
        log.info("\u4fdd\u5b58\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u6570\u636e-\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)conformityAudit));
        try {
            this.biddingConformityReviewTransactionalService.saveBiddingConformityReviewAuditData(conformityAudit);
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u5ba1\u67e5\u6570\u636e\u5f02\u5e38, \u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)conformityAudit), (Object)e);
            return new BaseResponse("\u4fdd\u5b58\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u6570\u636e\u5f02\u5e38");
        }
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BaseResponse<Boolean> isBiddingConformityReviewAuditComplished(String biddingCode, String auditorId, String email) {
        log.info("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u662f\u5426\u5b8c\u6210-\u8bf7\u6c42\u53c2\u6570 : \u7ade\u4ef7\u7f16\u53f7 {}, \u5ba1\u6838\u4ebaID {},\u5ba1\u6838\u4eba\u90ae\u7bb1", new Object[]{biddingCode, auditorId, email});
        if (Lang.isEmpty((Object)biddingCode)) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u662f\u5426\u5b8c\u6210\u5931\u8d25-\u7ade\u4ef7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)auditorId) && Lang.isEmpty((Object)email)) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u662f\u5426\u5b8c\u6210\u5931\u8d25-\u5ba1\u6838\u4ebaID\u6216\u8005\u90ae\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        try {
            BaseResponse biddingResponse = this.findAndCheckBidding(biddingCode);
            if (!biddingResponse.isSuccess()) {
                return new BaseResponse(biddingResponse.getResultMessage());
            }
            JcbdBidding bidding = (JcbdBidding)biddingResponse.getResult();
            boolean auditComplished = this.isBiddingConformityReviewAuditComplished(bidding, auditorId, email);
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)auditComplished);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u662f\u5426\u5b8c\u6210\u5f02\u5e38-\u8bf7\u6c42\u53c2\u6570 : \u7ade\u4ef7\u7f16\u53f7 {}, \u5ba1\u6838\u4ebaID {},\u5ba1\u6838\u4eba\u90ae\u7bb1 {}", new Object[]{biddingCode, auditorId, email, e});
            return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u662f\u5426\u5b8c\u6210\u5f02\u5e38");
        }
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BaseResponse<Boolean> isLastBiddingConformityReviewSubmit(String biddingCode) {
        log.info("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u63d0\u4ea4\u662f\u5426\u6700\u540e\u4e00\u4e2a-\u8bf7\u6c42\u53c2\u6570 \u7ade\u4ef7\u7f16\u53f7 : {}", (Object)biddingCode);
        if (Lang.isEmpty((Object)biddingCode)) {
            BaseResponse baseResponse = new BaseResponse("\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u63d0\u4ea4\u662f\u5426\u6700\u540e\u4e00\u4e2a-\u7ade\u4ef7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        try {
            BaseResponse biddingResponse = this.findAndCheckBidding(biddingCode);
            if (!biddingResponse.isSuccess()) {
                return new BaseResponse(biddingResponse.getResultMessage());
            }
            JcbdBidding bidding = (JcbdBidding)biddingResponse.getResult();
            List biddingGroupMembers = bidding.getJcbdBiddingGroupMembers().stream().filter(biddingGroupMember -> biddingGroupMember.getIsDelete() == false).collect(Collectors.toList());
            int auditComplishedCount = 0;
            for (JcbdBiddingGroupMember biddingGroupMember2 : biddingGroupMembers) {
                boolean auditComplished = this.isBiddingConformityReviewAuditComplished(bidding, biddingGroupMember2.getGroupMemberId(), biddingGroupMember2.getEmail());
                if (!auditComplished) continue;
                ++auditComplishedCount;
            }
            log.info("\u5168\u90e8\u6570\u91cf {}, \u5b8c\u6210\u5ba1\u6838\u6570\u91cf {}", (Object)biddingGroupMembers.size(), (Object)auditComplishedCount);
            if (auditComplishedCount == biddingGroupMembers.size()) {
                return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)true);
            }
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)false);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u63d0\u4ea4\u662f\u5426\u6700\u540e\u4e00\u4e2a\u5f02\u5e38", (Throwable)e);
            return new BaseResponse(false, "\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u63d0\u4ea4\u662f\u5426\u6700\u540e\u4e00\u4e2a\u5f02\u5e38");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Integer> getBiddingComformanceAuditAvailableCount(String biddingCode) {
        log.info("\u83b7\u53d6\u7b26\u5408\u7ade\u4ef7\u9700\u6c42\u7684\u4f9b\u5e94\u5546\u6570\u91cf-\u8bf7\u6c42\u53c2\u6570 \u7ade\u4ef7\u7f16\u53f7 : {}", (Object)biddingCode);
        if (Lang.isEmpty((Object)biddingCode)) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7b26\u5408\u7ade\u4ef7\u9700\u6c42\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5931\u8d25-\u7ade\u4ef7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        try {
            BaseResponse biddingResponse = this.findAndCheckBidding(biddingCode);
            if (!biddingResponse.isSuccess()) {
                return new BaseResponse(biddingResponse.getResultMessage());
            }
            JcbdBidding bidding = (JcbdBidding)biddingResponse.getResult();
            List biddingGroupMembers = bidding.getJcbdBiddingGroupMembers().stream().filter(biddingGroupMember -> biddingGroupMember.getIsDelete() == false).collect(Collectors.toList());
            int auditComplishedCount = 0;
            for (JcbdBiddingGroupMember biddingGroupMember2 : biddingGroupMembers) {
                boolean auditComplished = this.isBiddingConformityReviewAuditComplished(bidding, biddingGroupMember2.getGroupMemberId(), biddingGroupMember2.getEmail());
                if (!auditComplished) continue;
                ++auditComplishedCount;
            }
            if (auditComplishedCount != biddingGroupMembers.size()) {
                BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u7b26\u5408\u7ade\u4ef7\u9700\u6c42\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5931\u8d25-\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u5c1a\u672a\u5b8c\u6210\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838");
                log.error(baseResponse.getResultMessage());
                return baseResponse;
            }
            int auditYesCount = this.getBiddingComformanceAuditYesSuppliersCount(bidding);
            log.info("\u7b26\u5408\u7ade\u4ef7\u9700\u6c42\u7684\u4f9b\u5e94\u5546\u6570\u91cf {}", (Object)auditYesCount);
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)auditYesCount);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b26\u5408\u7ade\u4ef7\u9700\u6c42\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5f02\u5e38", (Throwable)e);
            return new BaseResponse(false, "\u83b7\u53d6\u7b26\u5408\u7ade\u4ef7\u9700\u6c42\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5f02\u5e38");
        }
    }

    public Page<JcbdBiddingQueryResultDto> supplierFindJcbdBiddingByParams(JcbdBiddingQueryDto jcbdBiddingQueryDto) {
        return null;
    }

    private BaseResponse<JcbdBidding> findAndCheckBidding(String biddingCode) {
        JcbdBidding bidding = new JcbdBidding();
        bidding.setBiddingCode(biddingCode);
        List biddings = this.biddingRepo.findAll((Specification)new BiddingSpecification(bidding));
        if (biddings.size() != 1) {
            log.error("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u662f\u5426\u5b8c\u6210-\u7ade\u4ef7\u7f16\u53f7\u4e3a {} \u7684\u6570\u636e\u8981\u6c42\u6709\u4e14\u53ea\u6709\u6709 1 \u6761, \u5b9e\u9645 {} \u6761", (Object)biddingCode, (Object)biddings.size());
            return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u662f\u5426\u5b8c\u6210\u5931\u8d25-\u6570\u636e\u68c0\u67e5\u672a\u901a\u8fc7");
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", biddings.get(0));
    }

    public boolean isBiddingConformityReviewAuditComplished(JcbdBidding bidding, String auditorId, String email) {
        List biddingDemands = bidding.getJcbdBiddingDemands().stream().filter(biddingDemand -> biddingDemand.getIsDelete() == false).collect(Collectors.toList());
        List biddingProviders = bidding.getJcbdBdProviders().stream().filter(biddingProvider -> biddingProvider.getIsDelete() == false).collect(Collectors.toList());
        biddingProviders = biddingProviders.stream().filter(biddingProvider -> !BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue().equals(biddingProvider.getStatus())).collect(Collectors.toList());
        biddingProviders = biddingProviders.stream().filter(biddingProvider -> !BiddingStatus.SUPPLIER_RESPONSE_GIVEUP.getValue().equals(biddingProvider.getStatus())).collect(Collectors.toList());
        for (JcbdBdProvider biddingProvider2 : biddingProviders) {
            for (JcbdBiddingDemand biddingDemand2 : biddingDemands) {
                List biddingConformances = biddingDemand2.getJcbdBiddingConformances().stream().filter(biddingConformance -> biddingConformance.getIsDelete() == false).collect(Collectors.toList());
                int conformanceAuditCount = 0;
                for (JcbdBiddingConformance biddingConformance2 : biddingConformances) {
                    List biddingConformanceChecks = this.jcbdConformanCheckRepo.findByBiddingConformanceId(biddingConformance2.getId()).stream().filter(biddingConformanceCheck -> biddingConformanceCheck.getIsDelete() == false).collect(Collectors.toList());
                    for (JcbdConformanceCheck biddingConformanceCheck2 : biddingConformanceChecks) {
                        JcbdBiddingGroupMember jcbdMember;
                        if (!Lang.isEmpty((Object)biddingConformanceCheck2.getBiddingGroupMemberId())) {
                            if (!biddingProvider2.getProviderId().equals(biddingConformanceCheck2.getProviderId()) || !biddingConformanceCheck2.getBiddingGroupMemberId().equals(auditorId) || Lang.isEmpty((Object)(jcbdMember = this.jcbdBiddingGroupMemberRepo.findByGroupMemberIdAndJcbdBiddingIdAndIsDelete(auditorId, bidding.getId(), false)).getConfomanceCheck())) continue;
                            ++conformanceAuditCount;
                            continue;
                        }
                        if (!biddingProvider2.getProviderId().equals(biddingConformanceCheck2.getProviderId()) || !biddingConformanceCheck2.getEmail().equals(email) || Lang.isEmpty((Object)(jcbdMember = this.jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(email, bidding.getId(), false)).getConfomanceCheck())) continue;
                        ++conformanceAuditCount;
                    }
                }
                if (conformanceAuditCount == biddingConformances.size()) continue;
                return false;
            }
        }
        return true;
    }

    @Transactional
    public int getBiddingComformanceAuditYesSuppliersCount(JcbdBidding bidding) {
        List biddingProviders = bidding.getJcbdBdProviders().stream().filter(biddingProvider -> biddingProvider.getIsDelete() == false).collect(Collectors.toList());
        ArrayList<String> auditYesBiddingProviderIds = new ArrayList<String>();
        for (Object biddingProvider2 : biddingProviders) {
            auditYesBiddingProviderIds.add(biddingProvider2.getProviderId());
        }
        List biddingDemands = bidding.getJcbdBiddingDemands().stream().filter(biddingDemand -> biddingDemand.getIsDelete() == false).collect(Collectors.toList());
        for (JcbdBiddingDemand biddingDemand2 : biddingDemands) {
            List biddingConformances = biddingDemand2.getJcbdBiddingConformances().stream().filter(biddingConformance -> biddingConformance.getIsDelete() == false).collect(Collectors.toList());
            for (JcbdBiddingConformance biddingConformance2 : biddingConformances) {
                List biddingConformanceChecks = this.jcbdConformanCheckRepo.findByBiddingConformanceId(biddingConformance2.getId()).stream().filter(biddingConformanceCheck -> biddingConformanceCheck.getIsDelete() == false).collect(Collectors.toList());
                for (JcbdConformanceCheck biddingConformanceCheck2 : biddingConformanceChecks) {
                    if (!auditYesBiddingProviderIds.contains(biddingConformanceCheck2.getProviderId()) || !BiddingConformAuditStatus.NOT_ACCORD.getValue().equals(biddingConformanceCheck2.getStatus())) continue;
                    auditYesBiddingProviderIds.remove(biddingConformanceCheck2.getProviderId());
                }
            }
        }
        ArrayList<JcbdBdProvider> jcbdBdProviders = new ArrayList<JcbdBdProvider>();
        for (String providerId : auditYesBiddingProviderIds) {
            JcbdBdProvider provider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(bidding.getId(), providerId, Boolean.valueOf(false));
            provider.setConformanceCheckStatus(BiddingConformAuditStatus.ACCORD.getValue());
            jcbdBdProviders.add(provider);
        }
        this.jcbdBdProviderRepo.save(jcbdBdProviders);
        return auditYesBiddingProviderIds.size();
    }

    @Autowired
    private void setMapperFacade(MapperFacade mapperFacade) {
        this.mapperFacade = mapperFacade;
    }

    @Autowired
    private void setBiddingRepo(JcbdBiddingRepo biddingRepo) {
        this.biddingRepo = biddingRepo;
    }

    @Autowired
    private void setBiddingDemandRepo(JcbdBiddingDemandRepo biddingDemandRepo) {
        this.biddingDemandRepo = biddingDemandRepo;
    }

    @Autowired
    private void setBiddingConformanceRepo(JcbdBiddingConformanceRepo biddingConformanceRepo) {
        this.biddingConformanceRepo = biddingConformanceRepo;
    }

    @Autowired
    private void setBiddingDemandRespRepo(JcbdBiddingDemandRespRepo biddingDemandRespRepo) {
        this.biddingDemandRespRepo = biddingDemandRespRepo;
    }

    @Autowired
    private void setBiddingConformanCheckRepo(JcbdConformanCheckRepo biddingConformanCheckRepo) {
        this.biddingConformanCheckRepo = biddingConformanCheckRepo;
    }

    @Autowired
    private void setBiddingProviderRepo(JcbdBdProviderRepo biddingProviderRepo) {
        this.biddingProviderRepo = biddingProviderRepo;
    }

    @Autowired
    private void setBiddingDemandAddressRepo(JcbdDemandAddressNumRepo biddingDemandAddressRepo) {
        this.biddingDemandAddressRepo = biddingDemandAddressRepo;
    }

    @Autowired
    private void setProviderAddressRespRepo(JcbdProviderAddressRespRepo providerAddressRespRepo) {
        this.providerAddressRespRepo = providerAddressRespRepo;
    }

    @Autowired
    private void setProviderConformanceRespRepo(JcbdProviderConformanceRespRepo providerConformanceRespRepo) {
        this.providerConformanceRespRepo = providerConformanceRespRepo;
    }

    @Autowired
    public void setBiddingConformityReviewTransactionalService(BiddingConformityReviewTransactionalService biddingConformityReviewTransactionalService) {
        this.biddingConformityReviewTransactionalService = biddingConformityReviewTransactionalService;
    }
}

