/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.po.JcbdBiddingConformance;
import bidding.model.po.JcbdConformanceCheck;
import bidding.model.po.JcbdProviderConformanceResp;
import bidding.model.repository.JcbdBiddingConformanceRepo;
import bidding.model.repository.JcbdConformanCheckRepo;
import bidding.model.repository.JcbdProviderConformanceRespRepo;
import bidding.model.specification.BiddingConformanceCheckSpecification;
import bidding.service.service.BiddingConformityReviewTransactionalService;
import dto.BiddingConformAuditInfoDTO;
import dto.BiddingConformAuditSupplierDTO;
import dto.BiddingConformityAuditDTO;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;

@Service
public class BiddingConformityReviewTransactionalServiceImpl
implements BiddingConformityReviewTransactionalService {
    private static final Logger log = LoggerFactory.getLogger(BiddingConformityReviewTransactionalServiceImpl.class);
    @Autowired
    JcbdProviderConformanceRespRepo jcbdProviderConformanceRespRepo;
    @Autowired
    JcbdBiddingConformanceRepo jcbdBiddingConformanceRepo;
    private JcbdProviderConformanceRespRepo providerConformanceRespRepo;
    private JcbdConformanCheckRepo biddingConformanCheckRepo;

    @Transactional(rollbackFor={Exception.class})
    public void saveBiddingConformityReviewAuditData(BiddingConformityAuditDTO conformityAudit) {
        for (BiddingConformAuditSupplierDTO biddingConformAuditSupplier : conformityAudit.getSuppliers()) {
            for (BiddingConformAuditInfoDTO biddingConformAuditInfo : biddingConformAuditSupplier.getAuditInfos()) {
                JcbdConformanceCheck conformanceCheck = new JcbdConformanceCheck();
                JcbdBiddingConformance conformance = (JcbdBiddingConformance)this.jcbdBiddingConformanceRepo.findOne((Serializable)((Object)biddingConformAuditInfo.getComplianceId()));
                conformanceCheck.setBiddingConformance(conformance);
                conformanceCheck.setProviderId(biddingConformAuditSupplier.getSupplierId());
                JcbdProviderConformanceResp jcbdProviderConformanceResp = (JcbdProviderConformanceResp)this.jcbdProviderConformanceRespRepo.findOne((Serializable)((Object)biddingConformAuditInfo.getComplianceIdSupplierResponse()));
                conformanceCheck.setJcbdProviderConformanceResp(jcbdProviderConformanceResp);
                conformanceCheck.setBiddingGroupMemberId(conformityAudit.getAuditorId());
                conformanceCheck.setEmail(conformityAudit.getEmail());
                List conformanceChecks = this.biddingConformanCheckRepo.findAll((Specification)new BiddingConformanceCheckSpecification(conformanceCheck));
                if (Lang.isEmpty((Object)conformanceChecks)) {
                    conformanceCheck.setConformanceNo(UUID.randomUUID().toString());
                    JcbdProviderConformanceResp providerConformanceResp = (JcbdProviderConformanceResp)this.providerConformanceRespRepo.findOne((Serializable)((Object)biddingConformAuditInfo.getComplianceIdSupplierResponse()));
                    conformanceCheck.setJcbdProviderConformanceResp(providerConformanceResp);
                } else {
                    if (conformanceChecks.size() != 1) {
                        log.error("\u4fdd\u5b58\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u6570\u636e\u5931\u8d25 : \u627e\u5230\u591a\u6761\u540c\u4e00\u5ba1\u6838\u4eba\u540c\u4e00\u4f9b\u5e94\u5546\u540c\u4e00\u7b26\u5408\u6027\u5ba1\u67e5\u9879\u7684\u5ba1\u6838\u8bb0\u5f55");
                        throw new RuntimeException("\u4fdd\u5b58\u7b26\u5408\u6027\u5ba1\u67e5\u5ba1\u6838\u6570\u636e\u5931\u8d25 : \u627e\u5230\u591a\u6761\u540c\u4e00\u5ba1\u6838\u4eba\u540c\u4e00\u4f9b\u5e94\u5546\u540c\u4e00\u7b26\u5408\u6027\u5ba1\u67e5\u9879\u7684\u5ba1\u6838\u8bb0\u5f55");
                    }
                    conformanceCheck = (JcbdConformanceCheck)conformanceChecks.get(0);
                }
                conformanceCheck.setStatus(biddingConformAuditInfo.getAuditStatus());
                this.biddingConformanCheckRepo.saveAndFlush((Object)conformanceCheck);
            }
        }
    }

    @Autowired
    private void setBiddingConformanCheckRepo(JcbdConformanCheckRepo biddingConformanCheckRepo) {
        this.biddingConformanCheckRepo = biddingConformanCheckRepo;
    }

    @Autowired
    private void setProviderConformanceRespRepo(JcbdProviderConformanceRespRepo providerConformanceRespRepo) {
        this.providerConformanceRespRepo = providerConformanceRespRepo;
    }
}

