/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.po.JcbdBiddingOperationLog;
import bidding.model.po.JcbdBiddingPurchaseLog;
import bidding.model.repository.JcbdBiddingOperationLogRepo;
import bidding.model.repository.JcbdBiddingPurchaseLogRepo;
import bidding.service.service.BiddingLogService;
import dto.JcbdBiddingOperationLogDto;
import dto.JcbdBiddingPurchaseLogDto;
import java.util.Date;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BiddingLogServiceImpl
implements BiddingLogService {
    private static final Logger log = LoggerFactory.getLogger(BiddingLogServiceImpl.class);
    @Autowired
    JcbdBiddingOperationLogRepo jcbdBiddingOperationLogRepo;
    @Autowired
    JcbdBiddingPurchaseLogRepo jcbdBiddingPurchaseLogRepo;
    @Autowired
    MapperFacade mapperFacade;

    @Transactional(rollbackFor={Exception.class})
    public void saveBiddingOperationLog(JcbdBiddingOperationLogDto biddingOperationLog) {
        JcbdBiddingOperationLog operationLog = (JcbdBiddingOperationLog)this.mapperFacade.map((Object)biddingOperationLog, JcbdBiddingOperationLog.class);
        operationLog.setOperationTime(new Date());
        this.jcbdBiddingOperationLogRepo.save((Object)operationLog);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBiddingOperationLogs(List<JcbdBiddingOperationLogDto> biddingOperationLogDtoList) {
        List jcbdBiddingOperationLogs = this.mapperFacade.mapAsList(biddingOperationLogDtoList, JcbdBiddingOperationLog.class);
        this.jcbdBiddingOperationLogRepo.save((Iterable)jcbdBiddingOperationLogs);
    }

    @Transactional
    public void savePurchaseLog(List<JcbdBiddingPurchaseLogDto> purchaseLogDtos) {
        List jcbdBiddingPurchaseLogs = this.mapperFacade.mapAsList(purchaseLogDtos, JcbdBiddingPurchaseLog.class);
        this.jcbdBiddingPurchaseLogRepo.save((Iterable)jcbdBiddingPurchaseLogs);
    }
}

