/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.po.BiddingStatusCategory;
import bidding.model.po.BiddingStatusTransform;
import bidding.model.po.JcbdBdGroupCheck;
import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBdSkuCheck;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingConformance;
import bidding.model.po.JcbdBiddingDemand;
import bidding.model.po.JcbdBiddingDemandResponse;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.po.JcbdDemandAddressNum;
import bidding.model.po.JcbdMallOrder;
import bidding.model.po.JcbdOrder;
import bidding.model.po.JcbdTempGoods;
import bidding.model.po.JcbdTempOrder;
import bidding.model.repository.BiddingStatusCategoryRepo;
import bidding.model.repository.BiddingStatusTransformRepo;
import bidding.model.repository.JcbdBdGroupCheckRepo;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBdSkuCheckRepo;
import bidding.model.repository.JcbdBiddingDemandRepo;
import bidding.model.repository.JcbdBiddingDemandRespRepo;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingOperationLogRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.repository.JcbdOrderRepo;
import bidding.model.repository.JcbdStoreContactsRepo;
import bidding.model.repository.JcbdTempGoodsRepo;
import bidding.model.repository.JcbdTempOrderRepo;
import bidding.model.repository.VoteDetailRepo;
import bidding.model.specification.BiddingSpecification;
import bidding.model.specification.BiddingStatusTransformSpecification;
import bidding.service.service.BiddingMainService;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingConformAuditStatus;
import definition.BiddingOperateCode;
import definition.BiddingOrderStatus;
import definition.BiddingStatus;
import definition.WayforConfirmBiddingResult;
import dto.BiddingAuditDTO;
import dto.BiddingChangeStateDto;
import dto.BiddingOrderConfirmNotifyDto;
import dto.BiddingResultNotifyDto;
import dto.BiddingStateResponseDto;
import dto.ChooseBiddingMemberAgainDto;
import dto.JcbdBiddingDemandDto;
import dto.JcbdBiddingDto;
import dto.JcbdBiddingGroupMemberDto;
import dto.JcbdOrderDto;
import dto.JcbdTempOrderDto;
import dto.NotifyProvider;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import uninogift.api.protocol.SupplierLoginApi;
import utils.Lang;
import utils.data.BeanMapper;
import utils.lock.RedisLockUtil;

@Service
public class BiddingMainServiceImpl
implements BiddingMainService {
    private static final Logger log = LoggerFactory.getLogger(BiddingMainServiceImpl.class);
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    JcbdBdGroupCheckRepo jcbdBdGroupCheckRepo;
    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;
    @Autowired
    BiddingStatusTransformRepo biddingStatusTransformRepo;
    @Autowired
    BiddingStatusCategoryRepo biddingStatusCategoryRepo;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;
    @Autowired
    JcbdBdSkuCheckRepo jcbdBdSkuCheckRepo;
    @Autowired
    JcbdOrderRepo jcbdOrderRepo;
    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;
    @Autowired
    JcbdTempOrderRepo jcbdTempOrderRepo;
    @Autowired
    JcbdTempGoodsRepo jcbdTempGoodsRepo;
    @Autowired
    RedisLockUtil redisLockUtil;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    VoteDetailRepo voteDetailRepo;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    JcbdBiddingOperationLogRepo jcbdBiddingOperationLogRepo;
    @MotanReferer
    SupplierLoginApi supplierLoginApi;
    @Autowired
    JcbdBiddingDemandRespRepo jcbdBiddingDemandRespRepo;
    public String VOTENO_CODE_REDIS_KEY = "BIDDING:VOTENO_CODE_REDIS_KEY:";
    public String GROUPCHECKNO_CODE_REDIS_KEY = "BIDDING:GROUPCHECKNO_CODE_REDIS_KEY:";
    @Autowired
    BiddingMainService biddingMainService;
    @Autowired
    JcbdStoreContactsRepo jcbdStoreContactsRepo;

    @Transactional
    public BaseResponse<JcbdBiddingDto> saveOrUpdateBiddingBaseInfo(JcbdBiddingDto biddingDto) {
        JcbdBiddingDto jbdDto = null;
        if (Lang.isEmpty((Object)biddingDto) || Lang.isEmpty((Object)biddingDto.getBiddingCode())) {
            return new BaseResponse(false, "\u7ade\u4ef7\u6570\u636e\u4e3a\u7a7a", null);
        }
        JcbdBidding jb = null;
        try {
            List jcbdBdProviders;
            List jcbdBiddingGroupMembers;
            List operationLogs = new ArrayList();
            if (!Lang.isEmpty((Object)biddingDto.getId())) {
                jb = this.jcbdBiddingRepo.findByIdAndIsDelete(biddingDto.getId(), false);
                if (!jb.getBiddingCode().equals(biddingDto.getBiddingCode())) {
                    return new BaseResponse(false, "\u7ade\u4ef7\u7f16\u53f7\u4e0d\u5141\u8bb8\u4fee\u6539", null);
                }
                operationLogs = this.jcbdBiddingOperationLogRepo.findByBiddingId(jb.getId());
                this.jcbdBiddingRepo.delete((Object)jb);
                this.jcbdBiddingRepo.flush();
            }
            JcbdBidding jcbdBidding = (JcbdBidding)this.mapperFacade.map((Object)biddingDto, JcbdBidding.class);
            if (jb != null) {
                List jcbdBiddingDemands = jb.getJcbdBiddingDemands();
                jcbdBidding.setJcbdBiddingDemands(jcbdBiddingDemands);
                jcbdBiddingDemands.forEach(demand -> demand.setJcbdBidding(jcbdBidding));
            }
            if (!Lang.isEmpty((Object)(jcbdBiddingGroupMembers = jcbdBidding.getJcbdBiddingGroupMembers()))) {
                for (int i = 0; i < jcbdBiddingGroupMembers.size(); ++i) {
                    JcbdBiddingGroupMember jbgm = (JcbdBiddingGroupMember)jcbdBiddingGroupMembers.get(i);
                    jbgm.setJcbdBidding(jcbdBidding);
                    jbgm.setStatus(BiddingStatus.OM_SUBMIT_WAIT.getValue());
                }
            }
            if (!Lang.isEmpty((Object)(jcbdBdProviders = jcbdBidding.getJcbdBdProviders()))) {
                for (int i = 0; i < jcbdBdProviders.size(); ++i) {
                    JcbdBdProvider jbp = (JcbdBdProvider)jcbdBdProviders.get(i);
                    jbp.setJcbdBidding(jcbdBidding);
                }
            }
            jcbdBidding.setStatus(BiddingStatus.OM_SUBMIT_WAIT.getValue());
            JcbdBidding jbd = (JcbdBidding)this.jcbdBiddingRepo.saveAndFlush((Object)jcbdBidding);
            if (!Lang.isEmpty(operationLogs)) {
                operationLogs.forEach(operationLog -> operationLog.setBiddingId(jbd.getId()));
                this.jcbdBiddingOperationLogRepo.save(operationLogs);
            }
            jbdDto = (JcbdBiddingDto)this.mapperFacade.map((Object)jbd, JcbdBiddingDto.class);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)jbdDto);
    }

    public BaseResponse saveOrUpdateBiddingDemand(JcbdBiddingDemandDto biddingDemandDto) {
        List jcbdBiddingConformances;
        List jcbdDemandAddressNums;
        if (Lang.isEmpty((Object)biddingDemandDto)) {
            return new BaseResponse(false, "\u7ade\u4ef7\u9700\u6c42\u6570\u636e\u4e3a\u7a7a");
        }
        if (Lang.isEmpty((Object)biddingDemandDto.getBiddingId())) {
            return new BaseResponse(false, "\u7ade\u4ef7id\u4e3a\u7a7a");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByIdAndIsDelete(biddingDemandDto.getBiddingId(), false);
        if (Lang.isEmpty((Object)jcbdBidding)) {
            return new BaseResponse(false, "\u7ade\u4ef7\u4e0d\u5b58\u5728");
        }
        JcbdBiddingDemand jcbdBiddingDemand = null;
        if (!Lang.isEmpty((Object)biddingDemandDto.getId())) {
            jcbdBiddingDemand = this.jcbdBiddingDemandRepo.findByIdAndIsDelete(biddingDemandDto.getId(), false);
        }
        if (!Lang.isEmpty(jcbdBiddingDemand)) {
            if (!jcbdBiddingDemand.getDemandCode().equals(biddingDemandDto.getDemandCode())) {
                return new BaseResponse(false, "\u7ade\u4ef7\u9700\u6c42\u7f16\u53f7\u4e0d\u5141\u8bb8\u4fee\u6539");
            }
            this.jcbdBiddingDemandRepo.delete((Serializable)((Object)jcbdBiddingDemand.getId()));
        }
        if (!Lang.isEmpty((Object)(jcbdDemandAddressNums = (jcbdBiddingDemand = (JcbdBiddingDemand)this.mapperFacade.map((Object)biddingDemandDto, JcbdBiddingDemand.class)).getJcbdDemandAddressNums()))) {
            for (int i = 0; i < jcbdDemandAddressNums.size(); ++i) {
                JcbdDemandAddressNum jdan = (JcbdDemandAddressNum)jcbdDemandAddressNums.get(i);
                jdan.setJcbdBiddingDemand(jcbdBiddingDemand);
            }
        }
        if (!Lang.isEmpty((Object)(jcbdBiddingConformances = jcbdBiddingDemand.getJcbdBiddingConformances()))) {
            for (int i = 0; i < jcbdBiddingConformances.size(); ++i) {
                JcbdBiddingConformance jbc = (JcbdBiddingConformance)jcbdBiddingConformances.get(i);
                jbc.setJcbdBiddingDemand(jcbdBiddingDemand);
            }
        }
        jcbdBiddingDemand.setJcbdBidding(jcbdBidding);
        this.jcbdBiddingDemandRepo.save((Object)jcbdBiddingDemand);
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @Transactional
    public BaseResponse deleteBidding(String biddingNo) {
        if (Lang.isEmpty((Object)biddingNo)) {
            return new BaseResponse(false, "\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty((Object)jcbdBidding)) {
            return new BaseResponse(false, "\u7ade\u4ef7\u6570\u636e\u5f02\u5e38");
        }
        List jcbdBiddingGroupMembers = jcbdBidding.getJcbdBiddingGroupMembers();
        jcbdBiddingGroupMembers.forEach(member -> member.setIsDelete(Boolean.valueOf(true)));
        this.jcbdBiddingGroupMemberRepo.save((Iterable)jcbdBiddingGroupMembers);
        List jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
        jcbdBdProviders.forEach(jcbdBdProvider -> jcbdBdProvider.setIsDelete(Boolean.valueOf(true)));
        this.jcbdBdProviderRepo.save((Iterable)jcbdBdProviders);
        jcbdBidding.setIsDelete(Boolean.valueOf(true));
        try {
            this.jcbdBiddingRepo.saveAndFlush((Object)jcbdBidding);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return new BaseResponse(false, "\u7ade\u4ef7\u5220\u9664\u5931\u8d25");
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public BaseResponse deleteBiddingDemand(String biddingDemandNo) {
        if (Lang.isEmpty((Object)biddingDemandNo)) {
            return new BaseResponse(false, "\u7ade\u4ef7\u9700\u6c42\u7f16\u53f7\u4e3a\u7a7a");
        }
        JcbdBiddingDemand jcbdBiddingDemand = this.jcbdBiddingDemandRepo.findByDemandCodeAndIsDelete(biddingDemandNo, false);
        if (Lang.isEmpty((Object)jcbdBiddingDemand)) {
            return new BaseResponse(false, "\u7ade\u4ef7\u9700\u6c42\u6570\u636e\u4e0d\u5b58\u5728");
        }
        jcbdBiddingDemand.setIsDelete(Boolean.valueOf(true));
        try {
            this.jcbdBiddingDemandRepo.saveAndFlush((Object)jcbdBiddingDemand);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return new BaseResponse(false, "\u7ade\u4ef7\u5220\u9664\u5931\u8d25");
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @Transactional
    public BiddingStateResponseDto changeBiddingState(BiddingChangeStateDto changeStateDto) {
        JcbdBidding bidding = null;
        BiddingStatusTransform biddingStatusTransform = null;
        String statusCategoryCode = "BIDDING_STATUS";
        BiddingStatusCategory biddingStatusCategory = this.biddingStatusCategoryRepo.findByBiddingCategoryCode(statusCategoryCode);
        try {
            if (StringUtils.isEmpty((String)changeStateDto.getBiddingNo()) || StringUtils.isEmpty((String)changeStateDto.getCurrentState()) || StringUtils.isEmpty((String)changeStateDto.getOpcode())) {
                throw new IllegalArgumentException("\u66f4\u65b0\u7ade\u4ef7\u72b6\u6001\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(changeStateDto.getBiddingNo(), false);
            if (bidding == null) {
                throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u8be5\u7ade\u4ef7");
            }
            if (!StringUtils.equals((String)bidding.getStatus(), (String)changeStateDto.getCurrentState())) {
                throw new IllegalArgumentException("\u5f53\u524d\u7ade\u4ef7\u72b6\u6001\u6709\u8bef");
            }
            biddingStatusTransform = this.getBiddingStatusTransform(changeStateDto, biddingStatusCategory);
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7\u72b6\u6001\u8f6c\u6362\u53c2\u6570\u9519\u8bef,changeStateDto={}", (Object)JSON.toJSONString((Object)changeStateDto), (Object)e);
            return new BiddingStateResponseDto(false, e.getMessage());
        }
        bidding.setStatus(biddingStatusTransform.getNextStatus());
        this.jcbdBiddingRepo.saveAndFlush((Object)bidding);
        log.info("\u7ade\u4ef7\u72b6\u6001\u4fee\u6539\u6210\u529f\uff0c\u540c\u6b65\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u72b6\u6001 changeStateDto={}", (Object)JSON.toJSONString((Object)changeStateDto));
        List jcbdBiddingGroupMembers = bidding.getJcbdBiddingGroupMembers();
        for (JcbdBiddingGroupMember jcbdBiddingGroupMember : jcbdBiddingGroupMembers) {
            jcbdBiddingGroupMember.setStatus(bidding.getStatus());
        }
        this.jcbdBiddingGroupMemberRepo.save((Iterable)jcbdBiddingGroupMembers);
        return new BiddingStateResponseDto(true, "\u64cd\u4f5c\u6210\u529f", bidding.getStatus(), bidding.getId());
    }

    public BiddingStatusTransform getBiddingStatusTransform(BiddingChangeStateDto changeStateDto, BiddingStatusCategory biddingStatusCategory) {
        BiddingStatusTransform biddingStatusTransform = new BiddingStatusTransform();
        biddingStatusTransform.setBiddingStatusCategoryId(biddingStatusCategory.getId());
        biddingStatusTransform.setCurrentStatus(changeStateDto.getCurrentState());
        biddingStatusTransform.setOperationCode(changeStateDto.getOpcode());
        List biddingStatusTransforms = this.biddingStatusTransformRepo.findAll((Specification)new BiddingStatusTransformSpecification(biddingStatusTransform));
        if (biddingStatusTransforms == null || biddingStatusTransforms.isEmpty()) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u7801\u6709\u8bef\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u8f6c\u6362\u72b6\u6001");
        }
        biddingStatusTransform = (BiddingStatusTransform)biddingStatusTransforms.get(0);
        return biddingStatusTransform;
    }

    public BaseResponse updateBiddingTime(String biddingNo, Date timeStartResponse, Date timeEndResponse) {
        if (Lang.isEmpty((Object)biddingNo) || Lang.isEmpty((Object)timeStartResponse) || Lang.isEmpty((Object)timeEndResponse)) {
            return new BaseResponse(false, "\u66f4\u65b0\u7ade\u4ef7\u54cd\u5e94\u65f6\u95f4\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (bidding == null) {
            return new BaseResponse(false, "\u4e0d\u5b58\u5728\u8be5\u7ade\u4ef7");
        }
        bidding.setTimeStartResponse(timeStartResponse);
        bidding.setTimeEndResponse(timeEndResponse);
        try {
            this.jcbdBiddingRepo.saveAndFlush((Object)bidding);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return new BaseResponse(false, "\u66f4\u65b0\u7ade\u4ef7\u54cd\u5e94\u65f6\u95f4\u5931\u8d25");
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public BaseResponse chooseBiddingGroupMemberAgain(List<ChooseBiddingMemberAgainDto> chooseBiddingMemberAgainDtoList) {
        try {
            if (!Lang.isEmpty(chooseBiddingMemberAgainDtoList)) {
                for (ChooseBiddingMemberAgainDto cbmad : chooseBiddingMemberAgainDtoList) {
                    if (Lang.isEmpty((Object)cbmad.getId())) continue;
                    JcbdBiddingGroupMember member = (JcbdBiddingGroupMember)this.jcbdBiddingGroupMemberRepo.findOne((Serializable)((Object)cbmad.getId()));
                    if (!Lang.isEmpty((Object)cbmad.getEffective())) {
                        member.setEffective(cbmad.getEffective());
                    }
                    if (!Lang.isEmpty((Object)cbmad.getEmail())) {
                        member.setEmail(cbmad.getEmail());
                    }
                    this.jcbdBiddingGroupMemberRepo.save((Object)member);
                }
            }
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return new BaseResponse(false, "\u91cd\u9009\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458");
        }
    }

    @Transactional
    public BaseResponse auditBiddingDemand(BiddingAuditDTO biddingAudit) {
        List checks;
        String noPass = "0";
        String biddingNo = biddingAudit.getBiddingNo();
        if (Lang.isEmpty((Object)biddingNo)) {
            return new BaseResponse(false, "biddingNo\u4e0d\u4e3a\u7a7a");
        }
        if (Lang.isEmpty((Object)biddingAudit.getStatus())) {
            return new BaseResponse(false, "Status\u4e0d\u4e3a\u7a7a");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        JcbdBiddingGroupMember groupMember = null;
        if (!Lang.isEmpty((Object)biddingAudit.getAuditorId())) {
            groupMember = this.jcbdBiddingGroupMemberRepo.findByGroupMemberIdAndJcbdBiddingIdAndIsDelete(biddingAudit.getAuditorId(), jcbdBidding.getId(), false);
        } else if (!Lang.isEmpty((Object)biddingAudit.getEmail())) {
            groupMember = this.jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(biddingAudit.getEmail(), jcbdBidding.getId(), false);
        }
        if (Lang.isEmpty(groupMember)) {
            return new BaseResponse("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        JcbdBdGroupCheck groupCheck = this.jcbdBdGroupCheckRepo.findByGroupMemberIdAndJcbdBiddingBiddingCode(groupMember.getId(), biddingNo);
        if (!Lang.isEmpty((Object)groupCheck)) {
            return new BaseResponse("\u5df2\u5ba1\u6838\uff0c\u4e0d\u80fd\u91cd\u590d\u5ba1\u6838");
        }
        JcbdBdGroupCheck jcbdBdGroupCheck = new JcbdBdGroupCheck();
        jcbdBdGroupCheck.setStatus(biddingAudit.getStatus());
        jcbdBdGroupCheck.setContent(biddingAudit.getContent());
        jcbdBdGroupCheck.setGroupCheckNo(jcbdBidding.getGroupCheckNo());
        jcbdBdGroupCheck.setGroupMemberId(groupMember.getId());
        jcbdBdGroupCheck.setJcbdBidding(jcbdBidding);
        this.jcbdBdGroupCheckRepo.save((Object)jcbdBdGroupCheck);
        if (jcbdBdGroupCheck.getStatus().equals("0")) {
            BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
            biddingChangeStateDto.setOpcode(BiddingOperateCode.AUDIT_BIDDING_NOPASS.getCode());
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_AUDIT_WAIT.getValue());
            biddingChangeStateDto.setBiddingNo(biddingNo);
            this.biddingMainService.changeBiddingState(biddingChangeStateDto);
            return new BaseResponse(true, "\u5ba1\u6838\u610f\u89c1\u4fdd\u5b58\u6210\u529f");
        }
        Integer memberSize = jcbdBidding.getJcbdBiddingGroupMembers().size();
        if (memberSize.equals((checks = this.jcbdBdGroupCheckRepo.findByJcbdBiddingBiddingCodeAndGroupCheckNo(biddingNo, jcbdBidding.getGroupCheckNo())).size())) {
            for (JcbdBdGroupCheck check : checks) {
                if (!"0".equals(check.getStatus())) continue;
                BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setOpcode(BiddingOperateCode.AUDIT_BIDDING_NOPASS.getCode());
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_AUDIT_WAIT.getValue());
                biddingChangeStateDto.setBiddingNo(biddingNo);
                this.biddingMainService.changeBiddingState(biddingChangeStateDto);
                return new BaseResponse(true, "\u5ba1\u6838\u610f\u89c1\u4fdd\u5b58\u6210\u529f");
            }
            BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
            biddingChangeStateDto.setOpcode(BiddingOperateCode.AUDIT_BIDDING_PASS.getCode());
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_AUDIT_WAIT.getValue());
            biddingChangeStateDto.setBiddingNo(biddingNo);
            this.biddingMainService.changeBiddingState(biddingChangeStateDto);
        } else {
            groupMember.setStatus(BiddingStatus.M_Bidding_AUDIT_OK.getValue());
            this.jcbdBiddingGroupMemberRepo.save((Object)groupMember);
        }
        return new BaseResponse(true, "\u5ba1\u6838\u610f\u89c1\u4fdd\u5b58\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse openPrice(String biddingNo) {
        block17: {
            BiddingChangeStateDto biddingChangeStateDto;
            List jcbdBdProviderList = this.jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(biddingNo, false);
            jcbdBdProviderList = jcbdBdProviderList.stream().filter(provider -> provider.getStatus().equals(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue())).collect(Collectors.toList());
            JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
            List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
            BigDecimal minPrice = null;
            ArrayList<JcbdBdProvider> bidProviders = new ArrayList<JcbdBdProvider>();
            String accord = "1";
            for (JcbdBdProvider provider2 : jcbdBdProviderList) {
                BigDecimal totalPrice = new BigDecimal(0);
                Boolean isAccord = true;
                for (JcbdBiddingDemand demand : jcbdBiddingDemands) {
                    Long minPurchaseAmount = demand.getMinPurchaseAmount();
                    if (minPurchaseAmount == null) {
                        minPurchaseAmount = Long.parseLong("1");
                    }
                    List jcbdBiddingDemandResponses = demand.getJcbdBiddingDemandResponses();
                    for (JcbdBiddingDemandResponse demandResponse : jcbdBiddingDemandResponses) {
                        if (!provider2.getId().equals(demandResponse.getResponseProviderId())) continue;
                        if (!"1".equals(demandResponse.getIsAllAccord())) {
                            isAccord = false;
                        }
                        BigDecimal price = demandResponse.getPrice();
                        totalPrice = totalPrice.add(price.multiply(new BigDecimal(minPurchaseAmount)).setScale(2, 0));
                    }
                }
                if (!isAccord.booleanValue()) continue;
                if (minPrice == null) {
                    minPrice = totalPrice;
                    bidProviders.add(provider2);
                    continue;
                }
                if (totalPrice.compareTo(minPrice) < 0) {
                    bidProviders.clear();
                    minPrice = totalPrice;
                    bidProviders.add(provider2);
                    continue;
                }
                if (totalPrice.compareTo(minPrice) != 0) continue;
                bidProviders.add(provider2);
            }
            if (Lang.isEmpty(bidProviders)) break block17;
            if (bidProviders.size() == 1) {
                biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(biddingNo);
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_YES.getValue());
                biddingChangeStateDto.setOpcode(BiddingOperateCode.START_QUOTED_PRICE_EQUALS_ONE.getCode());
                this.changeBiddingState(biddingChangeStateDto);
                for (JcbdBdProvider jcbdBdProvider : jcbdBdProviderList) {
                    if (!jcbdBdProvider.getId().equals(((JcbdBdProvider)bidProviders.get(0)).getId())) {
                        jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue());
                        this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
                        continue;
                    }
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                    jcbdBdProvider.setDealStatus("\u5df2\u6210\u4ea4");
                    this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
                }
            } else {
                biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(biddingNo);
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_YES.getValue());
                if (WayforConfirmBiddingResult.BIDDING_RADIO_VOTE.getValue().equals(jcbdBidding.getWayForConfirmBiddingResult())) {
                    biddingChangeStateDto.setOpcode(BiddingOperateCode.START_QUOTED_PRICE_OVER_ONE_RANDOM.getCode());
                } else if (WayforConfirmBiddingResult.BIDDING_RADIO_RANDOM.getValue().equals(jcbdBidding.getWayForConfirmBiddingResult())) {
                    biddingChangeStateDto.setOpcode(BiddingOperateCode.START_QUOTED_PRICE_OVER_ONE_VOTE.getCode());
                } else {
                    throw new RuntimeException("\u6ca1\u6709\u5df2\u7ecf\u9009\u62e9\u7684\u786e\u8ba4\u65b9\u5f0f");
                }
                this.changeBiddingState(biddingChangeStateDto);
                for (JcbdBdProvider best : bidProviders) {
                    best.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                    this.jcbdBdProviderRepo.save((Object)best);
                }
                jcbdBdProviderList.removeAll(bidProviders);
                for (JcbdBdProvider other : jcbdBdProviderList) {
                    other.setStatus(BiddingStatus.AUDITOR_RESULT_AUDIT_NOT.getValue());
                    this.jcbdBdProviderRepo.save((Object)other);
                }
            }
        }
        return new BaseResponse(true, "\u5f00\u542f\u62a5\u4ef7\u64cd\u4f5c\u6210\u529f");
    }

    @Transactional
    public BaseResponse<List<JcbdBiddingDto>> biddingResponseFinishValidateAll() {
        Integer[] providerResponseNum = new Integer[]{0};
        Date currentTime = Calendar.getInstance().getTime();
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setStatus(BiddingStatus.OM_RESPONSE_WAIT.getValue());
        BiddingSpecification biddingSpecification = new BiddingSpecification();
        biddingSpecification.setCurrentTime(currentTime);
        biddingSpecification.setBidding(jcbdBidding);
        biddingSpecification.setBiddingEndFlag(true);
        List jcbdBiddingList = this.jcbdBiddingRepo.findAll((Specification)biddingSpecification);
        if (Lang.isEmpty((Object)jcbdBiddingList)) {
            log.info("BiddingMainServiceImpl.biddingResponseFinishValidateAll:\u672a\u626b\u63cf\u5230\u7ade\u4ef7\u6570\u636e!");
            return new BaseResponse(true, "\u8be5\u65f6\u95f4\u6bb5\u65e0\u8fc7\u671f\u7ade\u4ef7!");
        }
        log.info("\u672c\u6b21\u626b\u63cf\u5171\u6709{}\u6761\u7ade\u4ef7\u622a\u6b62", (Object)jcbdBiddingList.size());
        jcbdBiddingList.forEach(bidding -> {
            BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
            List jcbdBdProviderList = this.jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(bidding.getBiddingCode(), false);
            biddingChangeStateDto.setBiddingNo(bidding.getBiddingCode());
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_RESPONSE_WAIT.getValue());
            ArrayList<JcbdBdProvider> providers = new ArrayList<JcbdBdProvider>();
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviderList) {
                if (!jcbdBdProvider.getStatus().equals(BiddingStatus.SUPPLIER_RESPONSE_YES.getValue())) continue;
                providers.add(jcbdBdProvider);
            }
            boolean isEnd = false;
            if (providers.size() < 2) {
                biddingChangeStateDto.setOpcode(BiddingOperateCode.ABANDON_RESPONSE.getCode());
                isEnd = true;
            } else {
                biddingChangeStateDto.setOpcode(BiddingOperateCode.RESPOND_BIDDING.getCode());
            }
            this.changeBiddingState(biddingChangeStateDto);
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviderList) {
                if (isEnd) {
                    if (BiddingStatus.SUPPLIER_RESPONSE_YES.getValue().equals(jcbdBdProvider.getStatus())) {
                        providerResponseNum[0] = providerResponseNum[0] + 1;
                    }
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_BIDDING_END.getValue());
                } else if (BiddingStatus.SUPPLIER_RESPONSE_YES.getValue().equals(jcbdBdProvider.getStatus())) {
                    providerResponseNum[0] = providerResponseNum[0] + 1;
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                } else if (BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue().equals(jcbdBdProvider.getStatus()) || BiddingStatus.SUPPLIER_RESPONSE_YES_GIVEUP.getValue().equals(jcbdBdProvider.getStatus())) {
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_RESPONSE_GIVEUP.getValue());
                }
                this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
            }
            bidding.setProviderResponseNum(providerResponseNum[0]);
            this.jcbdBiddingRepo.save(bidding);
            log.info("\u7ade\u4ef7\u7f16\u53f7--{}--\u5df2\u5904\u7406", (Object)bidding.getBiddingCode());
        });
        return new BaseResponse(true, "\u5df2\u5904\u7406\u76f8\u5173\u8fc7\u671f\u6570\u636e!");
    }

    @Transactional
    public BaseResponse biddingResponseFinishValidate(String biddingNo) {
        Integer providerResponseNum = 0;
        if (Lang.isEmpty((Object)biddingNo)) {
            log.info("BiddingMainServiceImpl.biddingResponseFinishValidate() parm is empty!");
            return new BaseResponse(false, "\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a!");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty((Object)jcbdBidding)) {
            log.info("BiddingMainServiceImpl.biddingResponseFinishValidate():\u672a\u626b\u63cf\u5230\u8fc7\u671f\u7ade\u4ef7!");
            return new BaseResponse(false, "\u672a\u626b\u63cf\u5230\u8fc7\u671f\u7ade\u4ef7");
        }
        Date currentTime = Calendar.getInstance().getTime();
        Date timeEndResponse = jcbdBidding.getTimeEndResponse();
        if (!Lang.isEmpty((Object)timeEndResponse)) {
            BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
            List jcbdBdProviderList = this.jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(jcbdBidding.getBiddingCode(), false);
            biddingChangeStateDto.setBiddingNo(jcbdBidding.getBiddingCode());
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_RESPONSE_WAIT.getValue());
            ArrayList<JcbdBdProvider> providers = new ArrayList<JcbdBdProvider>();
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviderList) {
                if (!jcbdBdProvider.getStatus().equals(BiddingStatus.SUPPLIER_RESPONSE_YES.getValue())) continue;
                providers.add(jcbdBdProvider);
            }
            boolean isEnd = false;
            if (providers.size() < 2) {
                biddingChangeStateDto.setOpcode(BiddingOperateCode.ABANDON_RESPONSE.getCode());
                isEnd = true;
            } else {
                biddingChangeStateDto.setOpcode(BiddingOperateCode.RESPOND_BIDDING.getCode());
            }
            this.changeBiddingState(biddingChangeStateDto);
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviderList) {
                if (isEnd) {
                    if (BiddingStatus.SUPPLIER_RESPONSE_YES.getValue().equals(jcbdBdProvider.getStatus())) {
                        providerResponseNum = providerResponseNum + 1;
                    }
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_BIDDING_END.getValue());
                } else if (BiddingStatus.SUPPLIER_RESPONSE_YES.getValue().equals(jcbdBdProvider.getStatus())) {
                    providerResponseNum = providerResponseNum + 1;
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                } else if (BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue().equals(jcbdBdProvider.getStatus()) || BiddingStatus.SUPPLIER_RESPONSE_YES_GIVEUP.getValue().equals(jcbdBdProvider.getStatus())) {
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_RESPONSE_GIVEUP.getValue());
                    jcbdBdProvider.setConformanceCheckStatus(BiddingConformAuditStatus.NOT_ACCORD.getValue());
                }
                this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
            }
            jcbdBidding.setProviderResponseNum(providerResponseNum);
            this.jcbdBiddingRepo.save((Object)jcbdBidding);
            return new BaseResponse("001", "\u7ade\u4ef7\u5df2\u8fc7\u671f!");
        }
        return new BaseResponse(false, "\u672a\u627e\u5230\u76f8\u5173\u6570\u636e!");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse auditBiddingSku(BiddingAuditDTO biddingAuditDTO) {
        List jcbdBdProviders;
        BiddingChangeStateDto biddingChangeStateDto;
        String pass = "1";
        String biddingNo = biddingAuditDTO.getBiddingNo();
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        JcbdBdSkuCheck jcbdBdSkuCheck = (JcbdBdSkuCheck)BeanMapper.map((Object)biddingAuditDTO, JcbdBdSkuCheck.class);
        jcbdBdSkuCheck.setJcbdBidding(jcbdBidding);
        this.jcbdBdSkuCheckRepo.save((Object)jcbdBdSkuCheck);
        String providerId = "";
        if ("1".equals(biddingAuditDTO.getStatus())) {
            biddingChangeStateDto = new BiddingChangeStateDto();
            biddingChangeStateDto.setBiddingNo(biddingNo);
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_SKU_AUDIT_WAIT.getValue());
            biddingChangeStateDto.setOpcode(BiddingOperateCode.AUDIT_BIDDING_SKU_PASS.getCode());
            this.changeBiddingState(biddingChangeStateDto);
            jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
                if (!BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue().equals(jcbdBdProvider.getStatus())) continue;
                jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue());
                this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
                providerId = jcbdBdProvider.getId();
            }
        } else {
            biddingChangeStateDto = new BiddingChangeStateDto();
            biddingChangeStateDto.setBiddingNo(biddingNo);
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_SKU_AUDIT_WAIT.getValue());
            biddingChangeStateDto.setOpcode(BiddingOperateCode.AUDIT_BIDDING_SKU_NO_PASS.getCode());
            this.changeBiddingState(biddingChangeStateDto);
            jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
                if (!BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue().equals(jcbdBdProvider.getStatus())) continue;
                jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_SKU_AUDIT_NOT.getValue());
                this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
                providerId = jcbdBdProvider.getId();
            }
        }
        List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        for (JcbdBiddingDemand jcbdBiddingDemand : jcbdBiddingDemands) {
            JcbdBiddingDemandResponse jcbdBiddingDemandResponse = this.jcbdBiddingDemandRespRepo.findByJcbdBiddingDemandIdAndResponseProviderIdAndIsDelete(jcbdBiddingDemand.getId(), providerId, Boolean.valueOf(false));
            jcbdBiddingDemandResponse.setSkuIsModify(Boolean.valueOf(false));
            this.jcbdBiddingDemandRespRepo.save((Object)jcbdBiddingDemandResponse);
        }
        return new BaseResponse(true, "\u5ba1\u6838SKU\u901a\u8fc7");
    }

    @Transactional
    public BaseResponse biddingResultNoPass(String biddingNo) {
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (bidding == null) {
            log.error("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u67e5\u4e0d\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u7ade\u4ef7\u4e0d\u5b58\u5728biddingNo={}", (Object)biddingNo);
        }
        BiddingChangeStateDto changeStateDto = new BiddingChangeStateDto();
        changeStateDto.setBiddingNo(biddingNo);
        changeStateDto.setCurrentState(BiddingStatus.AUDITOR_RESULT_AUDIT_WAIT.getValue());
        changeStateDto.setOpcode(BiddingOperateCode.AUDIT_BIDDING_RESULT_NO_PASS.getCode());
        BiddingStateResponseDto biddingState = this.changeBiddingState(changeStateDto);
        if (!biddingState.isSuccess()) {
            log.error("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u67e5\u4e0d\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u66f4\u65b0\u7ade\u4ef7\u5931\u8d25\uff0cbiddingNo={}\uff0cbiddingState={}", (Object)biddingNo, (Object)JSON.toJSONString((Object)biddingState));
        }
        for (JcbdBdProvider jcbdBdProvider : bidding.getJcbdBdProviders()) {
            jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_BIDDING_NOT.getValue());
            String dealStatus = "\u672a\u6210\u4ea4";
            jcbdBdProvider.setDealStatus(dealStatus);
        }
        return new BaseResponse(true, "\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6838\u4e0d\u901a\u8fc7\u56de\u8c03\u6210\u529f");
    }

    @Transactional
    public BaseResponse<BiddingResultNotifyDto> finishBiddingResultAudit(String biddingNo) {
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (bidding == null) {
            log.error("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u67e5\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u7ade\u4ef7\u4e0d\u5b58\u5728biddingNo={}", (Object)biddingNo);
        }
        BiddingChangeStateDto changeStateDto = new BiddingChangeStateDto();
        changeStateDto.setBiddingNo(biddingNo);
        changeStateDto.setCurrentState(BiddingStatus.OM_RESULT_AUDIT_WAIT.getValue());
        changeStateDto.setOpcode(BiddingOperateCode.AUDIT_BIDDING_RESULT_PASS.getCode());
        changeStateDto.setOperationTime(new Date());
        changeStateDto.setOperationContent(BiddingOperateCode.AUDIT_BIDDING_RESULT_PASS.getCodeName());
        BiddingStateResponseDto biddingState = this.changeBiddingState(changeStateDto);
        if (!biddingState.isSuccess()) {
            log.error("\u7ade\u4ef7\u7ed3\u679c\u5ba1\u67e5\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u66f4\u65b0\u7ade\u4ef7\u5931\u8d25\uff0cbiddingNo={}\uff0cbiddingState={}", (Object)biddingNo, (Object)JSON.toJSONString((Object)biddingState));
            new BaseResponse(false, "\u66f4\u65b0\u7ade\u4ef7\u5931\u8d25");
        }
        BiddingResultNotifyDto biddingResultNotifyDto = new BiddingResultNotifyDto();
        ArrayList<NotifyProvider> notDealProviders = new ArrayList<NotifyProvider>();
        for (JcbdBdProvider jcbdBdProvider : bidding.getJcbdBdProviders()) {
            NotifyProvider notifyProvider;
            String dealStatus;
            if (BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue().equals(jcbdBdProvider.getStatus())) {
                jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_BIDDING_YES.getValue());
                dealStatus = "\u5df2\u6210\u4ea4";
                jcbdBdProvider.setDealStatus(dealStatus);
                notifyProvider = new NotifyProvider();
                notifyProvider.setProviderId(jcbdBdProvider.getProviderId());
                notifyProvider.setName(jcbdBdProvider.getProviderName());
                biddingResultNotifyDto.setDealProvider(notifyProvider);
                continue;
            }
            jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_BIDDING_NOT.getValue());
            dealStatus = "\u672a\u6210\u4ea4";
            jcbdBdProvider.setDealStatus(dealStatus);
            notifyProvider = new NotifyProvider();
            notifyProvider.setProviderId(jcbdBdProvider.getProviderId());
            notifyProvider.setName(jcbdBdProvider.getProviderName());
            notDealProviders.add(notifyProvider);
        }
        biddingResultNotifyDto.setOperatorName(bidding.getOperatorName());
        biddingResultNotifyDto.setOperatorPhone(bidding.getOperatorPhone());
        biddingResultNotifyDto.setNotDealProviders(notDealProviders);
        this.jcbdBdProviderRepo.save((Iterable)bidding.getJcbdBdProviders());
        return new BaseResponse(true, "\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6838\u901a\u8fc7\u56de\u8c03\u6210\u529f", (Object)biddingResultNotifyDto);
    }

    @Transactional
    public BaseResponse finishBiddingOrderAudit(String biddingOrderNo) {
        JcbdOrder jcbdOrder = this.jcbdOrderRepo.findByBdOrderNo(biddingOrderNo);
        if (jcbdOrder == null) {
            log.error("\u5ba1\u6838\u901a\u8fc7\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ade\u4ef7\u8ba2\u5355\uff0cbiddingOrderNo={}", (Object)biddingOrderNo);
            return new BaseResponse(true, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ade\u4ef7\u8ba2\u5355");
        }
        jcbdOrder.setStatus(BiddingOrderStatus.ORDER_STATUS_TOBECONFIRMED.getCode());
        List mallOrders = jcbdOrder.getJcbdMallOrders();
        if (mallOrders != null && !mallOrders.isEmpty()) {
            for (JcbdMallOrder mallOrder : mallOrders) {
                mallOrder.setStatus(BiddingOrderStatus.ORDER_STATUS_TOBECONFIRMED.getCode());
                mallOrder.setSupplierOrderStatus(BiddingOrderStatus.SUPPLIER_ORDER_STATUS_TOBECONFIRMED.getCode());
                log.info("\u5ba1\u6838\u5b8c\u6210\uff0c\u66f4\u65b0\u7ade\u4ef7\u5546\u57ce\u8ba2\u5355\u72b6\u6001\u6210\u529f,mallOrderNo={}", (Object)mallOrder.getOrderNo());
            }
        }
        JcbdBdProvider jcbdBdProvider = (JcbdBdProvider)this.jcbdBdProviderRepo.findOne((Serializable)((Object)jcbdOrder.getSupplierId()));
        BiddingOrderConfirmNotifyDto biddingOrderConfirmNotifyDto = new BiddingOrderConfirmNotifyDto();
        biddingOrderConfirmNotifyDto.setOperatorName(jcbdOrder.getJcbdBidding().getOperatorName());
        biddingOrderConfirmNotifyDto.setOperatorPhone(jcbdOrder.getJcbdBidding().getOperatorPhone());
        biddingOrderConfirmNotifyDto.setBiddingNo(jcbdOrder.getJcbdBidding().getBiddingCode());
        NotifyProvider notifyProvider = new NotifyProvider();
        notifyProvider.setProviderId(jcbdBdProvider.getProviderId());
        notifyProvider.setName(jcbdOrder.getSupplierName());
        biddingOrderConfirmNotifyDto.setNotifyProvider(notifyProvider);
        return new BaseResponse(true, "\u66f4\u65b0\u6210\u529f", (Object)biddingOrderConfirmNotifyDto);
    }

    @Transactional
    public BaseResponse biddingOrderAuditNoPass(String biddingOrderNo) {
        JcbdOrder jcbdOrder = this.jcbdOrderRepo.findByBdOrderNo(biddingOrderNo);
        if (jcbdOrder == null) {
            log.error("\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ade\u4ef7\u8ba2\u5355\uff0cbiddingOrderNo={}", (Object)biddingOrderNo);
            return new BaseResponse(true, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ade\u4ef7\u8ba2\u5355");
        }
        jcbdOrder.setStatus(BiddingOrderStatus.ORDER_STATUS_AUDITFAILURE.getCode());
        List mallOrders = jcbdOrder.getJcbdMallOrders();
        if (mallOrders != null && !mallOrders.isEmpty()) {
            for (JcbdMallOrder mallOrder : mallOrders) {
                mallOrder.setStatus(BiddingOrderStatus.ORDER_STATUS_AUDITFAILURE.getCode());
                log.info("\u8ba2\u5355\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u66f4\u65b0\u7ade\u4ef7\u5546\u57ce\u8ba2\u5355\u72b6\u6001\u6210\u529f,mallOrderNo={}", (Object)mallOrder.getOrderNo());
            }
        }
        return new BaseResponse(true, "\u66f4\u65b0\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse saveBiddingTempOrderInfo(JcbdTempOrderDto jcbdTempOrderDto) {
        JcbdTempOrder jcbdTempOrderOlder;
        if (!Lang.isEmpty((Object)jcbdTempOrderDto.getId()) && !Lang.isEmpty((Object)(jcbdTempOrderOlder = (JcbdTempOrder)this.jcbdTempOrderRepo.findOne((Serializable)((Object)jcbdTempOrderDto.getId()))))) {
            this.jcbdTempOrderRepo.delete((Object)jcbdTempOrderOlder);
        }
        String biddingNo = jcbdTempOrderDto.getBiddingNo();
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        List jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
        String storeId = "";
        for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
            if (!jcbdBdProvider.getStatus().equals(BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue())) continue;
            storeId = jcbdBdProvider.getProviderId();
        }
        JcbdTempOrder jcbdTempOrder = (JcbdTempOrder)BeanMapper.map((Object)jcbdTempOrderDto, JcbdTempOrder.class);
        List tempGoodses = jcbdTempOrder.getJcbdTempGoodses();
        for (JcbdTempGoods goods : tempGoodses) {
            goods.setJcbdTempOrder(jcbdTempOrder);
        }
        jcbdTempOrder.setJcbdTempGoodses(tempGoodses);
        jcbdTempOrder.setJcbdBidding(jcbdBidding);
        jcbdTempOrder.setStoreId(storeId);
        this.jcbdTempOrderRepo.save((Object)jcbdTempOrder);
        return new BaseResponse(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public JcbdOrderDto saveJcbdOrder(JcbdOrderDto jcbdOrderDto) {
        JcbdOrder jcbdOrder = (JcbdOrder)this.mapperFacade.map((Object)jcbdOrderDto, JcbdOrder.class);
        for (JcbdMallOrder jcbdMallOrder : jcbdOrder.getJcbdMallOrders()) {
            jcbdMallOrder.setJcbdOrder(jcbdOrder);
        }
        JcbdOrder order = (JcbdOrder)this.jcbdOrderRepo.save((Object)jcbdOrder);
        return (JcbdOrderDto)this.mapperFacade.map((Object)order, JcbdOrderDto.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse deleteTempOrderById(List<String> tempOrderId) {
        for (String orderId : tempOrderId) {
            this.jcbdTempOrderRepo.delete((Serializable)((Object)orderId));
        }
        return new BaseResponse(true, "\u5220\u9664\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTempOrderByBiddingCode(String biddingCode) {
        List jcbdTempOrders = this.jcbdTempOrderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(biddingCode, Boolean.valueOf(false));
        this.jcbdTempOrderRepo.delete((Iterable)jcbdTempOrders);
    }

    @Transactional
    public JcbdTempOrderDto modifyTempOrderById(String tempOrderId) {
        JcbdTempOrder jcbdTempOrder = (JcbdTempOrder)this.jcbdTempOrderRepo.findOne((Serializable)((Object)tempOrderId));
        if (jcbdTempOrder != null) {
            return (JcbdTempOrderDto)BeanMapper.map((Object)jcbdTempOrder, JcbdTempOrderDto.class);
        }
        return null;
    }

    @Transactional
    public BaseResponse finishBidding(String biddingNo) {
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (bidding == null) {
            return new BaseResponse(false, "\u7ade\u4ef7\u4e0d\u5b58\u5728");
        }
        bidding.setStatus(BiddingStatus.OM_BIDDING_END.getValue());
        List providers = bidding.getJcbdBdProviders();
        List jcbdBiddingGroupMembers = bidding.getJcbdBiddingGroupMembers();
        for (JcbdBiddingGroupMember jcbdBiddingGroupMember : jcbdBiddingGroupMembers) {
            jcbdBiddingGroupMember.setStatus(BiddingStatus.OM_BIDDING_END.getValue());
        }
        for (JcbdBdProvider provider : providers) {
            provider.setStatus(BiddingStatus.SUPPLIER_BIDDING_END.getValue());
        }
        try {
            this.jcbdBiddingRepo.save((Object)bidding);
            this.jcbdBdProviderRepo.save((Iterable)providers);
            this.jcbdBiddingGroupMemberRepo.save((Iterable)jcbdBiddingGroupMembers);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return new BaseResponse(false, "\u66f4\u65b0\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public String updateBiddingVoteNo(String biddingNo) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        String voteNo = jcbdBidding.getVoteNo();
        if (Lang.isEmpty((Object)voteNo)) {
            SimpleDateFormat format = new SimpleDateFormat("YYYYMMdd");
            String dateTime = format.format(new Date());
            BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)this.VOTENO_CODE_REDIS_KEY);
            Long sequenceNo = boundValueOperations.increment(1L);
            if (sequenceNo >= 1000L) {
                boundValueOperations.set((Object)0);
            }
            voteNo = "V" + dateTime + (sequenceNo + 1000L + "").substring(1);
        } else {
            voteNo = voteNo.substring(0, 1) + String.valueOf(Long.parseLong(voteNo.substring(1)) + 1L);
        }
        jcbdBidding.setVoteNo(voteNo);
        this.jcbdBiddingRepo.saveAndFlush((Object)jcbdBidding);
        return voteNo;
    }

    public String updateBiddingGroupCheckNo(String biddingNo) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        String groupCheckNo = jcbdBidding.getGroupCheckNo();
        if (Lang.isEmpty((Object)groupCheckNo)) {
            SimpleDateFormat format = new SimpleDateFormat("YYYYMMdd");
            String dateTime = format.format(new Date());
            BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)this.GROUPCHECKNO_CODE_REDIS_KEY);
            Long sequenceNo = boundValueOperations.increment(1L);
            if (sequenceNo >= 1000L) {
                boundValueOperations.set((Object)0);
            }
            groupCheckNo = "C" + dateTime + (sequenceNo + 1000L + "").substring(1);
        } else {
            groupCheckNo = groupCheckNo.substring(0, 1) + String.valueOf(Long.parseLong(groupCheckNo.substring(1)) + 1L);
        }
        jcbdBidding.setGroupCheckNo(groupCheckNo);
        this.jcbdBiddingRepo.saveAndFlush((Object)jcbdBidding);
        return groupCheckNo;
    }

    public BaseResponse updateBiddingResultResult(String biddingNo, String remark) {
        if (Lang.isEmpty((Object)biddingNo)) {
            return new BaseResponse(false, "\u63d0\u4ea4\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6838\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (bidding == null) {
            return new BaseResponse(false, "\u4e0d\u5b58\u5728\u8be5\u7ade\u4ef7");
        }
        if (Lang.isEmpty((Object)remark)) {
            remark = " ";
        }
        bidding.setBdCommitContent(remark);
        try {
            this.jcbdBiddingRepo.saveAndFlush((Object)bidding);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return new BaseResponse(false, "\u63d0\u4ea4\u7ade\u4ef7\u7ed3\u679c\u5ba1\u6838\u5931\u8d25");
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public void changeBiddingGroupMemberStatus(String biddingNo, String auditorId, String status, String email) {
        JcbdBiddingGroupMember member;
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (!Lang.isEmpty((Object)auditorId)) {
            member = this.jcbdBiddingGroupMemberRepo.findByGroupMemberIdAndJcbdBiddingIdAndIsDelete(auditorId, jcbdBidding.getId(), false);
            member.setStatus(status);
        } else {
            member = this.jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(email, jcbdBidding.getId(), false);
            member.setStatus(status);
        }
        this.jcbdBiddingGroupMemberRepo.save((Object)member);
    }

    @Transactional
    public BaseResponse<Boolean> getVoteStatus(String biddingNo, String memberId) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (jcbdBidding == null) {
            return new BaseResponse(true, "\u7ade\u4ef7\u4e0d\u5b58\u5728", (Object)false);
        }
        if (StringUtils.equals((String)WayforConfirmBiddingResult.BIDDING_RADIO_VOTE.getValue(), (String)jcbdBidding.getWayForConfirmBiddingResult())) {
            return new BaseResponse(true, "\u7ade\u4ef7\u662f\u968f\u673a\u786e\u5b9a\u4f9b\u5e94\u5546", (Object)false);
        }
        if (StringUtils.equals((String)BiddingStatus.OM_VOTING.getValue(), (String)jcbdBidding.getStatus())) {
            return new BaseResponse(true, "\u6295\u7968\u4e2d", (Object)true);
        }
        JcbdBiddingGroupMember groupMember = this.jcbdBiddingGroupMemberRepo.findByGroupMemberIdAndJcbdBiddingIdAndIsDelete(memberId, jcbdBidding.getId(), false);
        if (groupMember == null) {
            groupMember = this.jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(memberId, jcbdBidding.getId(), false);
        }
        if (groupMember == null) {
            return new BaseResponse(true, "\u672a\u627e\u5230\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f", (Object)false);
        }
        if (groupMember == null) {
            return new BaseResponse(true, "\u672a\u627e\u5230\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f", (Object)false);
        }
        List voteDetails = this.voteDetailRepo.findByBusinessIdentifyingAndVoteMemberIdAndIsDelete(biddingNo, groupMember.getId(), false);
        if (voteDetails != null && !voteDetails.isEmpty()) {
            return new BaseResponse(true, "\u5df2\u5b58\u5728\u6295\u7968\u8bb0\u5f55", (Object)true);
        }
        return new BaseResponse(true, "\u7ade\u4ef7\u7ed3\u679c\u51b3\u5b9a\u65b9\u5f0f\u4e3a\u6295\u7968\uff0c\u4e0d\u9700\u8981\u6295\u7968", (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResponse<String> getBiddingNo() {
        String biddingNoRedisKey = "bidding-service:biddingNo:key";
        String biddingNoRedisTimeKey = "bidding-service:biddingNo:timeKey";
        String createBiddingNoSequenceSql = "create sequence mall_bidding_seq_newsId increment by 1 start with 1";
        String dropBiddingNoSequenceSql = "drop sequence mall_bidding_seq_newsId";
        String queryBiddingNoSql = "select mall_bidding_seq_newsId.nextval from dual";
        String monthSequence = null;
        this.redisLockUtil.lock(biddingNoRedisKey);
        try {
            Calendar calendar = Calendar.getInstance();
            BoundValueOperations biddingTimeBoundValueOperations = this.redisTemplate.boundValueOps((Object)biddingNoRedisTimeKey);
            Object month = biddingTimeBoundValueOperations.get();
            if (month != null) {
                if (calendar.get(2) != ((Integer)month).intValue()) {
                    try {
                        this.jdbcTemplate.execute(dropBiddingNoSequenceSql);
                        this.jdbcTemplate.execute(createBiddingNoSequenceSql);
                    }
                    catch (Exception e) {
                        log.error("\u91cd\u7f6e\u7ade\u4ef7\u5e8f\u5217\u53f7\u51fa\u9519", (Throwable)e);
                    }
                }
                biddingTimeBoundValueOperations.set((Object)calendar.get(2));
            }
            try {
                monthSequence = (String)this.jdbcTemplate.queryForObject(queryBiddingNoSql, String.class);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u7ade\u4ef7\u5e8f\u5217\u51fa\u9519", (Throwable)e);
                log.info("\u521b\u5efa\u7ade\u4ef7\u5e8f\u5217");
                this.jdbcTemplate.execute(createBiddingNoSequenceSql);
                monthSequence = (String)this.jdbcTemplate.queryForObject(queryBiddingNoSql, String.class);
            }
            StringBuilder biddingBuilder = new StringBuilder("B").append(new SimpleDateFormat("YYYYMM").format(calendar.getTime()));
            if (monthSequence.length() < 4) {
                for (int t = 0; t < 4 - monthSequence.length(); ++t) {
                    biddingBuilder.append("0");
                }
            }
            biddingBuilder.append(monthSequence);
            BaseResponse baseResponse = new BaseResponse(true, "\u83b7\u53d6\u7ade\u4ef7\u7f16\u53f7\u6210\u529f", (Object)biddingBuilder.toString());
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u7ade\u4ef7\u7f16\u53f7\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.redisLockUtil.unlock(biddingNoRedisKey);
        }
        return null;
    }

    public Boolean findTempOrderBySkus(List<String> skus) {
        List jcbdTempGoods = this.jcbdTempGoodsRepo.findBySkuIn(skus);
        if (jcbdTempGoods.size() > 0) {
            return true;
        }
        return false;
    }

    public BaseResponse changeGroupMemberConfomanceCheck(String biddingNo, String auditorId, String email) {
        JcbdBiddingGroupMember member;
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (!Lang.isEmpty((Object)auditorId)) {
            member = this.jcbdBiddingGroupMemberRepo.findByGroupMemberIdAndJcbdBiddingIdAndIsDelete(auditorId, jcbdBidding.getId(), false);
            member.setConfomanceCheck(Boolean.valueOf(true));
        } else {
            member = this.jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(email, jcbdBidding.getId(), false);
            member.setConfomanceCheck(Boolean.valueOf(true));
        }
        try {
            this.jcbdBiddingGroupMemberRepo.save((Object)member);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
            return new BaseResponse("\u66f4\u6539\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
        }
        return new BaseResponse(true);
    }

    public BaseResponse cancelGroupMemberConfomanceCheck(String biddingNo, String auditorId, String email) {
        JcbdBiddingGroupMember member;
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (!Lang.isEmpty((Object)auditorId)) {
            member = this.jcbdBiddingGroupMemberRepo.findByGroupMemberIdAndJcbdBiddingIdAndIsDelete(auditorId, jcbdBidding.getId(), false);
            member.setConfomanceCheck(Boolean.valueOf(false));
        } else {
            member = this.jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(email, jcbdBidding.getId(), false);
            member.setConfomanceCheck(Boolean.valueOf(false));
        }
        try {
            this.jcbdBiddingGroupMemberRepo.save((Object)member);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
            return new BaseResponse("\u66f4\u6539\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
        }
        return new BaseResponse(true);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse changeBiddingOrderState(List<String> orderNos, String state) {
        log.info("\u66f4\u6539\u7ade\u4ef7\u8ba2\u5355\u72b6\u6001-orderNo:{},status:{}", (Object)JSON.toJSONString(orderNos), (Object)state);
        orderNos.parallelStream().forEach(orderNo -> this.jcbdMallOrderRepo.updateOrderStatus(orderNo, state));
        return new BaseResponse(true, "\u66f4\u6539\u7ade\u4ef7\u8ba2\u5355\u72b6\u6001\u6210\u529f");
    }

    public JcbdBiddingGroupMemberDto findByMemberId(String operatorId) {
        JcbdBiddingGroupMember jcbdBiddingGroupMember = this.jcbdBiddingGroupMemberRepo.findFirstByGroupMemberIdAndIsDelete(operatorId, Boolean.valueOf(false));
        JcbdBiddingGroupMemberDto jcbdBiddingGroupMemberDto = null;
        if (!Lang.isEmpty((Object)jcbdBiddingGroupMember)) {
            jcbdBiddingGroupMemberDto = (JcbdBiddingGroupMemberDto)BeanMapper.map((Object)jcbdBiddingGroupMember, JcbdBiddingGroupMemberDto.class);
        }
        return jcbdBiddingGroupMemberDto;
    }
}

