/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.dto.BiddingOrderMangerModelDto;
import bidding.model.po.JcbdMallOrder;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.specification.BiddingOrderManagerSpecification;
import bidding.service.service.query.BiddingOrderManagerService;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import com.alibaba.fastjson.JSON;
import definition.BiddingOrderStatus;
import definition.StatusOperateModule;
import dto.BiddingOrderMangerDto;
import java.util.ArrayList;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import query.BiddingOrderManagerListQuery;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingOrderManagerServiceImpl
implements BiddingOrderManagerService {
    private static final Logger log = LoggerFactory.getLogger(BiddingOrderManagerServiceImpl.class);
    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;
    @Autowired
    BiddingRoleOperationQueryService biddingRoleOperationQueryService;
    @Autowired
    MapperFacade mapperFacade;

    public Page<BiddingOrderMangerDto> getBiddingOrderMangerList(BiddingOrderManagerListQuery biddingOrderManagerListQuery, Pageable pageable) {
        log.info("\u83b7\u53d6\u8ba2\u5355\u7ba1\u7406\u5217\u8868-\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)biddingOrderManagerListQuery));
        BiddingOrderMangerModelDto biddingOrderMangerModelDto = (BiddingOrderMangerModelDto)this.mapperFacade.map((Object)biddingOrderManagerListQuery, BiddingOrderMangerModelDto.class);
        BiddingOrderManagerSpecification specification = new BiddingOrderManagerSpecification(biddingOrderMangerModelDto);
        Page jcbdMallOrders = this.jcbdMallOrderRepo.findAll((Specification)specification, pageable);
        List jcbdMallOrderList = jcbdMallOrders.getContent();
        ArrayList<BiddingOrderMangerDto> biddingOrderMangerDtoList = new ArrayList<BiddingOrderMangerDto>();
        for (JcbdMallOrder jcbdMallOrder : jcbdMallOrderList) {
            BiddingOrderMangerDto biddingOrderMangerDto = (BiddingOrderMangerDto)BeanMapper.map((Object)jcbdMallOrder, BiddingOrderMangerDto.class);
            biddingOrderMangerDto.setBiddingCode(jcbdMallOrder.getJcbdOrder().getJcbdBidding().getBiddingCode());
            BiddingOrderStatus biddingOrderStatus = (BiddingOrderStatus)BiddingOrderStatus.biddingOrderStatusMap.get(jcbdMallOrder.getStatus());
            if (!Lang.isEmpty((Object)biddingOrderStatus)) {
                String statusDescription = biddingOrderStatus.getDescription();
                biddingOrderMangerDto.setStatusDescription(statusDescription);
                List roleOperationDtoList = this.biddingRoleOperationQueryService.findByRoleCodeAndStatusAndModuleOrderByShowIndex("BIDDING_OPERATOR", jcbdMallOrder.getStatus(), StatusOperateModule.BIDDING_ORDER_MANAGE.getCode());
                biddingOrderMangerDto.setOperation(roleOperationDtoList);
            } else {
                log.error("\u8ba2\u5355\u72b6\u6001\u4e3a\u7a7a");
            }
            biddingOrderMangerDtoList.add(biddingOrderMangerDto);
        }
        return new PageImpl(biddingOrderMangerDtoList, (Pageable)new PageRequest(jcbdMallOrders.getNumber(), jcbdMallOrders.getSize(), jcbdMallOrders.getSort()), jcbdMallOrders.getTotalElements());
    }

    public List<BiddingOrderMangerDto> getCancelOrders(BiddingOrderManagerListQuery biddingOrderManagerListQuery) {
        BiddingOrderMangerModelDto biddingOrderMangerModelDto = (BiddingOrderMangerModelDto)this.mapperFacade.map((Object)biddingOrderManagerListQuery, BiddingOrderMangerModelDto.class);
        BiddingOrderManagerSpecification specification = new BiddingOrderManagerSpecification(biddingOrderMangerModelDto);
        List jcbdMallOrderList = this.jcbdMallOrderRepo.findAll((Specification)specification);
        return this.mapperFacade.mapAsList((Iterable)jcbdMallOrderList, BiddingOrderMangerDto.class);
    }
}

