/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.dto.BiddingOrderResultModelDto;
import bidding.model.po.JcbdMallOrder;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.specification.BiddingOrderResultSpecification;
import bidding.service.service.BiddingOrderResultService;
import bidding.service.service.query.BiddingMallOrderQueryService;
import bidding.service.service.query.BiddingOrderQueryService;
import bidding.service.service.query.BiddingQueryService;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import com.alibaba.fastjson.JSON;
import definition.BiddingOrderStatus;
import definition.StatusOperateModule;
import dto.BiddingOrderResultDto;
import java.util.ArrayList;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import query.BiddingOrderResultListQuery;
import utils.Lang;

@Service
public class BiddingOrderResultServiceImpl
implements BiddingOrderResultService {
    private static final Logger log = LoggerFactory.getLogger(BiddingOrderResultServiceImpl.class);
    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;
    @Autowired
    BiddingOrderQueryService biddingOrderQueryService;
    @Autowired
    BiddingMallOrderQueryService biddingMallOrderQueryService;
    @Autowired
    BiddingQueryService biddingQueryService;
    @Autowired
    BiddingRoleOperationQueryService biddingRoleOperationQueryService;
    private MapperFacade mapperFacade;

    public Page<BiddingOrderResultDto> getBiddingOrderResultList(BiddingOrderResultListQuery biddingOrderResultListQuery, Pageable pageable) {
        log.info("\u83b7\u53d6\u6267\u884c\u7ed3\u679c\u5217\u8868-\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)biddingOrderResultListQuery));
        BiddingOrderResultModelDto biddingOrderResultModelDto = (BiddingOrderResultModelDto)this.mapperFacade.map((Object)biddingOrderResultListQuery, BiddingOrderResultModelDto.class);
        BiddingOrderResultSpecification specification = new BiddingOrderResultSpecification(biddingOrderResultModelDto);
        Page jcbdMallOrders = this.jcbdMallOrderRepo.findAll((Specification)specification, pageable);
        List jcbdMallOrderList = jcbdMallOrders.getContent();
        ArrayList<BiddingOrderResultDto> biddingOrderResultDtoList = new ArrayList<BiddingOrderResultDto>();
        for (JcbdMallOrder jcbdMallOrder : jcbdMallOrderList) {
            BiddingOrderResultDto biddingOrderResultDto = (BiddingOrderResultDto)this.mapperFacade.map((Object)jcbdMallOrder, BiddingOrderResultDto.class);
            biddingOrderResultDto.setPurchaseNo(jcbdMallOrder.getJcbdOrder().getPurchaseNo());
            biddingOrderResultDto.setBiddingCode(jcbdMallOrder.getJcbdOrder().getJcbdBidding().getBiddingCode());
            BiddingOrderStatus biddingOrderStatus = (BiddingOrderStatus)BiddingOrderStatus.biddingOrderStatusMap.get(jcbdMallOrder.getStatus());
            if (!Lang.isEmpty((Object)biddingOrderStatus)) {
                String statusDescription = biddingOrderStatus.getDescription();
                biddingOrderResultDto.setStatusDescription(statusDescription);
            }
            biddingOrderResultDto.setStatus(jcbdMallOrder.getStatus());
            List roleOperationDtoList = this.biddingRoleOperationQueryService.findByRoleCodeAndStatusAndModuleOrderByShowIndex("BIDDING_OPERATOR", jcbdMallOrder.getStatus(), StatusOperateModule.BIDDING_ORDER_MANAGE.getCode());
            biddingOrderResultDto.setOperation(roleOperationDtoList);
            biddingOrderResultDtoList.add(biddingOrderResultDto);
        }
        return new PageImpl(biddingOrderResultDtoList, (Pageable)new PageRequest(jcbdMallOrders.getNumber(), jcbdMallOrders.getSize(), jcbdMallOrders.getSort()), jcbdMallOrders.getTotalElements());
    }

    @Autowired
    private void setMapperFacade(MapperFacade mapperFacade) {
        this.mapperFacade = mapperFacade;
    }
}

