/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.po.BiddingStatusCategory;
import bidding.model.po.BiddingStatusTransform;
import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingDemand;
import bidding.model.po.JcbdBiddingDemandResponse;
import bidding.model.po.JcbdBiddingOperationLog;
import bidding.model.po.MallAttachment;
import bidding.model.repository.BiddingStatusCategoryRepo;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingDemandRepo;
import bidding.model.repository.JcbdBiddingDemandRespRepo;
import bidding.model.repository.JcbdBiddingOperationLogRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdStoreContactsRepo;
import bidding.model.repository.MallAttachmentRepo;
import bidding.service.service.BiddingMainService;
import bidding.service.service.BiddingResponseService;
import com.alibaba.fastjson.JSON;
import definition.BiddingOperateCode;
import definition.BiddingStatus;
import definition.ProviderConformanceRespStatus;
import dto.BiddingChangeStateDto;
import dto.BiddingStateResponseDto;
import dto.BiddingSupplierChangeStateDto;
import dto.JcbdBiddingDemandResponseDto;
import dto.MallAttachmentDto;
import dto.SupplierBiddingResponseDto;
import dto.UpdateSkuDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingResponseServiceImpl
implements BiddingResponseService {
    private static final Logger log = LoggerFactory.getLogger(BiddingResponseServiceImpl.class);
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;
    @Autowired
    JcbdBiddingDemandRespRepo jcbdBiddingDemandRespRepo;
    @Autowired
    MallAttachmentRepo mallAttachmentRepo;
    @Autowired
    JcbdStoreContactsRepo jcbdStoreContactsRepo;
    @Autowired
    BiddingMainService biddingMainService;
    @Autowired
    BiddingStatusCategoryRepo biddingStatusCategoryRepo;
    @Autowired
    JcbdBiddingOperationLogRepo jcbdBiddingOperationLogRepo;
    private static final String FUHE = "1";
    private static final String UNFUHE = "0";

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse supplierBiddingResponse(SupplierBiddingResponseDto supplierBiddingResponseDto) {
        String biddingNo = supplierBiddingResponseDto.getJcbdBiddingNo();
        boolean isAllAccored = true;
        log.info("\u7ade\u4ef7\u7f16\u53f7\uff1a{}", (Object)biddingNo);
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(supplierBiddingResponseDto.getJcbdBiddingNo(), false);
        if (jcbdBidding != null) {
            List jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
                if (!jcbdBdProvider.getProviderId().equals(supplierBiddingResponseDto.getProviderId())) continue;
                List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
                for (JcbdBiddingDemand demand : jcbdBiddingDemands) {
                    List jcbdBiddingDemandResponses = demand.getJcbdBiddingDemandResponses();
                    for (JcbdBiddingDemandResponse response : jcbdBiddingDemandResponses) {
                        if (!response.getResponseProviderId().equals(jcbdBdProvider.getId())) continue;
                        if (!ProviderConformanceRespStatus.ACCORD.getValue().equals(response.getIsAllAccord())) {
                            isAllAccored = false;
                        }
                        if (!response.getResponseProviderId().equals(jcbdBdProvider.getId())) continue;
                        response.setQouteIndate(supplierBiddingResponseDto.getOfferValidity());
                        this.jcbdBiddingDemandRespRepo.save((Object)response);
                    }
                }
                if (isAllAccored) {
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_RESPONSE_YES.getValue());
                    jcbdBdProvider.setOfferValidity(supplierBiddingResponseDto.getOfferValidity());
                    jcbdBdProvider.setResponseStatus(ProviderConformanceRespStatus.ACCORD.getValue());
                    this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
                    continue;
                }
                jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_RESPONSE_YES_GIVEUP.getValue());
                jcbdBdProvider.setOfferValidity(supplierBiddingResponseDto.getOfferValidity());
                jcbdBdProvider.setResponseStatus(ProviderConformanceRespStatus.ACCORD.getValue());
                this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
            }
            return new BaseResponse(true, "\u63d0\u4ea4\u6210\u529f");
        }
        return new BaseResponse("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ade\u4ef7");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse updateBiddingDemandResponse(JcbdBiddingDemandResponseDto jcbdBiddingDemandResponseDto) {
        List attachmentDtos;
        String storeId;
        String biddingId = jcbdBiddingDemandResponseDto.getJcbdBiddingDemand().getBiddingId();
        JcbdBdProvider jcbdBdProvider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(biddingId, storeId = jcbdBiddingDemandResponseDto.getStoreId(), Boolean.valueOf(false));
        if (jcbdBdProvider != null) {
            jcbdBiddingDemandResponseDto.setResponseProviderId(jcbdBdProvider.getId());
        }
        String demandCode = jcbdBiddingDemandResponseDto.getJcbdBiddingDemand().getDemandCode();
        JcbdBiddingDemand jcbdBiddingDemand = this.jcbdBiddingDemandRepo.findByDemandCodeAndJcbdBiddingIdAndIsDelete(demandCode, biddingId, false);
        String id = jcbdBiddingDemandResponseDto.getId();
        if (!Lang.isEmpty((Object)id)) {
            JcbdBiddingDemandResponse demandResponse = (JcbdBiddingDemandResponse)this.jcbdBiddingDemandRespRepo.findOne((Serializable)((Object)id));
            this.jcbdBiddingDemandRespRepo.delete((Object)demandResponse);
        }
        JcbdBiddingDemandResponse jcbdBiddingDemandResponse = (JcbdBiddingDemandResponse)BeanMapper.map((Object)jcbdBiddingDemandResponseDto, JcbdBiddingDemandResponse.class);
        jcbdBiddingDemandResponse.setId(null);
        List providerConformanceResps = jcbdBiddingDemandResponse.getJcbdProviderConformanceResps();
        for (Object jcbdProviderConformanceResp : providerConformanceResps) {
            jcbdProviderConformanceResp.setJcbdBiddingDemandResponse(jcbdBiddingDemandResponse);
        }
        jcbdBiddingDemandResponse.setJcbdProviderConformanceResps(providerConformanceResps);
        List providerAddressResponses = jcbdBiddingDemandResponse.getJcbdProviderAddressResponses();
        for (Object jcbdProviderAddressResponse : providerAddressResponses) {
            jcbdProviderAddressResponse.setJcbdBiddingDemandResponse(jcbdBiddingDemandResponse);
        }
        jcbdBiddingDemandResponse.setJcbdProviderAddressResponses(providerAddressResponses);
        List jcbdProviderAddressResponses = jcbdBiddingDemandResponse.getJcbdProviderAddressResponses();
        for (Object jcbdProviderAddressResponse : jcbdProviderAddressResponses) {
            if (FUHE.equals(jcbdProviderAddressResponse.getStatus())) {
                jcbdBiddingDemandResponse.setIsAllAccord(FUHE);
                continue;
            }
            jcbdBiddingDemandResponse.setIsAllAccord(UNFUHE);
            break;
        }
        if (FUHE.equals(jcbdBiddingDemandResponse.getIsAllAccord())) {
            List jcbdProviderConformanceResps = jcbdBiddingDemandResponse.getJcbdProviderConformanceResps();
            for (Object jcbdProviderConformanceResp : jcbdProviderConformanceResps) {
                if (FUHE.equals(jcbdProviderConformanceResp.getStatus())) {
                    jcbdBiddingDemandResponse.setIsAllAccord(FUHE);
                    continue;
                }
                jcbdBiddingDemandResponse.setIsAllAccord(UNFUHE);
                break;
            }
        }
        jcbdBiddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);
        JcbdBiddingDemandResponse demandResponse = (JcbdBiddingDemandResponse)this.jcbdBiddingDemandRespRepo.saveAndFlush((Object)jcbdBiddingDemandResponse);
        List mallAttachmentList = this.mallAttachmentRepo.findByAttachmentCorrelationAndIsDelete(demandResponse.getId(), false);
        if (!Lang.isEmpty((Object)mallAttachmentList)) {
            for (MallAttachment mallAttachment : mallAttachmentList) {
                this.mallAttachmentRepo.delete((Object)mallAttachment);
            }
        }
        if (!Lang.isEmpty((Object)(attachmentDtos = jcbdBiddingDemandResponseDto.getAttachment()))) {
            for (MallAttachmentDto mallAttachmentDto : attachmentDtos) {
                MallAttachment mallAttachment = (MallAttachment)BeanMapper.map((Object)mallAttachmentDto, MallAttachment.class);
                mallAttachment.setAttachmentCorrelation(jcbdBiddingDemandResponse.getId());
                this.mallAttachmentRepo.save((Object)mallAttachment);
            }
        }
        return new BaseResponse(true, "\u4fdd\u5b58\u6210\u529f");
    }

    public BiddingStateResponseDto supplierBiddingStatusChange(BiddingSupplierChangeStateDto changeStateDto) {
        JcbdBdProvider provider = null;
        try {
            if (StringUtils.isEmpty((String)changeStateDto.getBiddingNo()) || StringUtils.isEmpty((String)changeStateDto.getOpcode()) || StringUtils.isEmpty((String)changeStateDto.getSupplierId())) {
                throw new IllegalArgumentException("\u66f4\u65b0\u4f9b\u5e94\u5546\u7ade\u4ef7\u72b6\u6001\u53c2\u6570\u4e0d\u6b63\u786e");
            }
            String biddingNo = changeStateDto.getBiddingNo();
            JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
            provider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), changeStateDto.getSupplierId(), Boolean.valueOf(false));
            if (provider == null) {
                throw new IllegalArgumentException("\u6ca1\u6709\u8be5\u4f9b\u5e94\u5546");
            }
            if (!StringUtils.equals((String)changeStateDto.getCurrentState(), (String)provider.getStatus())) {
                throw new IllegalArgumentException("\u4f9b\u5e94\u5546\u5f53\u524d\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            BiddingStatusTransform biddingStatusTransform = null;
            String statusCategoryCode = "SUPPLIER_BIDDING_STATUS";
            BiddingStatusCategory biddingStatusCategory = this.biddingStatusCategoryRepo.findByBiddingCategoryCode(statusCategoryCode);
            biddingStatusTransform = this.biddingMainService.getBiddingStatusTransform((BiddingChangeStateDto)changeStateDto, biddingStatusCategory);
            provider.setStatus(biddingStatusTransform.getNextStatus());
            this.jcbdBdProviderRepo.saveAndFlush((Object)provider);
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7\u72b6\u6001\u8f6c\u6362\u53c2\u6570\u9519\u8bef,changeStateDto={}", (Object)JSON.toJSONString((Object)changeStateDto), (Object)e);
            return new BiddingStateResponseDto(false, e.getMessage());
        }
        return new BiddingStateResponseDto(true, "\u64cd\u4f5c\u6210\u529f", provider.getStatus());
    }

    public BaseResponse updateBiddingDemandResponseSku(UpdateSkuDto updateSkuDto) {
        String demandNo = updateSkuDto.getDemandNo();
        String biddingNo = updateSkuDto.getBiddingNo();
        String providerId = updateSkuDto.getProviderId();
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        JcbdBdProvider jcbdBdProvider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(bidding.getId(), providerId, Boolean.valueOf(false));
        JcbdBiddingDemand demand = this.jcbdBiddingDemandRepo.findByDemandCodeAndJcbdBiddingIdAndIsDelete(demandNo, bidding.getId(), false);
        JcbdBiddingDemandResponse jcbdBiddingDemandResponse = this.jcbdBiddingDemandRespRepo.findByJcbdBiddingDemandIdAndResponseProviderIdAndIsDelete(demand.getId(), jcbdBdProvider.getId(), Boolean.valueOf(false));
        if (!(!Lang.isEmpty((Object)jcbdBiddingDemandResponse.getSkuModify()) && jcbdBiddingDemandResponse.getSkuModify().booleanValue() || updateSkuDto.getSku().equals(jcbdBiddingDemandResponse.getSku()))) {
            jcbdBiddingDemandResponse.setSkuModify(Boolean.valueOf(true));
            jcbdBiddingDemandResponse.setSkuIsModify(Boolean.valueOf(true));
        }
        JcbdBiddingOperationLog jcbdBiddingOperationLog = new JcbdBiddingOperationLog();
        if (jcbdBiddingDemandResponse.getSku() == null) {
            jcbdBiddingOperationLog.setOperationContent("\u65b0\u589e\u5546\u54c1\u7f16\u7801");
            jcbdBiddingOperationLog.setRemark("\u9700\u6c42" + demandNo + "\u8865\u5f55\u5546\u54c1\u7f16\u7801\u4e3a" + updateSkuDto.getSku());
        } else {
            jcbdBiddingOperationLog.setOperationContent("\u4fee\u6539\u5546\u54c1\u7f16\u7801");
            jcbdBiddingOperationLog.setRemark("\u9700\u6c42" + demandNo + "\u5c06\u65e7\u7684\u5546\u54c1\u7f16\u7801" + jcbdBiddingDemandResponse.getSku() + "\u4fee\u6539\u4e3a\u65b0\u7684\u5546\u54c1\u7f16\u7801" + updateSkuDto.getSku());
        }
        jcbdBiddingDemandResponse.setSku(updateSkuDto.getSku());
        jcbdBiddingDemandResponse.setGoodsLink(updateSkuDto.getUrl());
        this.jcbdBiddingDemandRespRepo.save((Object)jcbdBiddingDemandResponse);
        jcbdBiddingOperationLog.setOperatorName(updateSkuDto.getOperatorName());
        jcbdBiddingOperationLog.setOperationTime(new Date());
        jcbdBiddingOperationLog.setBiddingId(bidding.getId());
        this.jcbdBiddingOperationLogRepo.save((Object)jcbdBiddingOperationLog);
        return new BaseResponse(true, "\u66f4\u65b0sku\u6210\u529f");
    }

    @Transactional
    public BaseResponse supplierInitStatus(String biddingNo) {
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (bidding == null) {
            return new BaseResponse(false, "\u7ade\u4ef7\u4e0d\u5b58\u5728");
        }
        List providers = bidding.getJcbdBdProviders();
        for (JcbdBdProvider provider : providers) {
            BiddingSupplierChangeStateDto biddingChangeStateDto = new BiddingSupplierChangeStateDto();
            biddingChangeStateDto.setOpcode(BiddingOperateCode.SUPPLIER_INIT.getCode());
            biddingChangeStateDto.setBiddingNo(biddingNo);
            biddingChangeStateDto.setSupplierId(provider.getProviderId());
            BiddingStateResponseDto biddingStateResponseDto = this.supplierBiddingStatusChange(biddingChangeStateDto);
            if (!biddingStateResponseDto.isSuccess() || !StringUtils.equals((String)BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue(), (String)biddingStateResponseDto.getBiddingState())) {
                log.error("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u7ade\u4ef7\u9519\u8bef,biddingNo={},biddingStateResponseDto={}", (Object)biddingNo, (Object)JSON.toJSONString((Object)biddingStateResponseDto));
                throw new RuntimeException("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u7ade\u4ef7\u9519\u8bef");
            }
            provider.setPublish(Boolean.valueOf(true));
        }
        try {
            this.jcbdBdProviderRepo.save((Iterable)providers);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u7ade\u4ef7\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef,biddingNo={},biddingStateResponseDto={}", (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u7ade\u4ef7\u9519\u8bef");
        }
        return new BaseResponse(true, "\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u72b6\u6001\u6210\u529f");
    }

    @Transactional
    public BaseResponse supplierInitModifySku(String biddingNo, String supplierId) {
        if (Lang.isEmpty((Object)biddingNo) || Lang.isEmpty((Object)supplierId)) {
            log.error("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u662f\u5426\u4fee\u6539sku\u53c2\u6570\u4f20\u5165\u9519\u8bef");
            return new BaseResponse("\u53c2\u6570\u4f20\u5165\u9519\u8bef");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty((Object)jcbdBidding)) {
            log.error("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u662f\u5426\u4fee\u6539sku  \u65e0\u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7", (Object)biddingNo);
            return new BaseResponse("\u65e0\u6b64\u7ade\u4ef7");
        }
        JcbdBdProvider provider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), supplierId, Boolean.valueOf(false));
        if (Lang.isEmpty((Object)provider)) {
            log.error("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u662f\u5426\u4fee\u6539sku  \u65e0\u4f9b\u5e94\u5546id\u4e3a{}\u7684\u4f9b\u5e94\u5546", (Object)supplierId);
            return new BaseResponse("\u65e0\u6b64\u4f9b\u5e94\u5546");
        }
        List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        if (Lang.isEmpty((Object)jcbdBiddingDemands)) {
            log.error("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u662f\u5426\u4fee\u6539sku  \u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7\u4e0b\u65e0\u9700\u6c42", (Object)biddingNo);
            return new BaseResponse("\u8be5\u7ade\u4ef7\u4e0b\u65e0\u9700\u6c42");
        }
        ArrayList responses = new ArrayList();
        jcbdBiddingDemands.forEach(demand -> demand.getJcbdBiddingDemandResponses().forEach(response -> {
            if (response.getResponseProviderId().equals(provider.getId())) {
                response.setSkuModify(Boolean.valueOf(false));
                responses.add(response);
            }
        }));
        try {
            this.jcbdBiddingDemandRespRepo.save(responses);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u662f\u5426\u4fee\u6539sku \u7f16\u53f7\u4e3a{}\u4f9b\u5e94\u5546id\u4e3a{}\u6570\u636e\u5e93\u64cd\u4f5c\u6709\u8bef", new Object[]{biddingNo, supplierId, e});
            return new BaseResponse("\u6570\u636e\u5e93\u64cd\u4f5c\u6709\u8bef");
        }
        return new BaseResponse(true);
    }

    public BaseResponse responseGiveUp(String biddingNo, String supplierId) {
        if (Lang.isEmpty((Object)biddingNo) || Lang.isEmpty((Object)supplierId)) {
            log.error("\u653e\u5f03\u54cd\u5e94\u53c2\u6570\u4f20\u5165\u9519\u8bef");
            return new BaseResponse("\u53c2\u6570\u4f20\u5165\u9519\u8bef");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty((Object)jcbdBidding)) {
            log.error("\u653e\u5f03\u54cd\u5e94  \u65e0\u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7", (Object)biddingNo);
            return new BaseResponse("\u65e0\u6b64\u7ade\u4ef7");
        }
        JcbdBdProvider provider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), supplierId, Boolean.valueOf(false));
        if (Lang.isEmpty((Object)provider)) {
            log.error("\u653e\u5f03\u54cd\u5e94  \u65e0\u4f9b\u5e94\u5546id\u4e3a{}\u7684\u4f9b\u5e94\u5546", (Object)supplierId);
            return new BaseResponse("\u65e0\u6b64\u4f9b\u5e94\u5546");
        }
        provider.setStatus(BiddingStatus.SUPPLIER_RESPONSE_GIVEUP.getValue());
        provider.setResponseStatus(ProviderConformanceRespStatus.NOT_ACCORD.getValue());
        try {
            this.jcbdBdProviderRepo.save((Object)provider);
        }
        catch (Exception e) {
            log.error("\u653e\u5f03\u54cd\u5e94 \u7f16\u53f7\u4e3a{}\u4f9b\u5e94\u5546id\u4e3a{}\u6570\u636e\u5e93\u64cd\u4f5c\u6709\u8bef", new Object[]{biddingNo, supplierId, e});
            return new BaseResponse("\u6570\u636e\u5e93\u64cd\u4f5c\u6709\u8bef");
        }
        return new BaseResponse(true);
    }
}

