/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.dto.BiddingSupplierOrderManagerModelDto;
import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdMallOrder;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.specification.BiddingProviderSpecification;
import bidding.model.specification.BiddingSupplierOrderManagerSpecification;
import bidding.service.service.query.BiddingMallOrderQueryService;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import bidding.service.service.query.BiddingSupplierOrderManagerService;
import com.alibaba.fastjson.JSON;
import definition.BiddingOrderStatus;
import definition.StatusOperateModule;
import dto.BiddingSupplierOrderMangerDto;
import dto.JcbdBdProviderDto;
import java.util.ArrayList;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import query.BiddingSupplierOrderManagerListQuery;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingSupplierOrderManagerServiceImpl
implements BiddingSupplierOrderManagerService {
    private static final Logger log = LoggerFactory.getLogger(BiddingSupplierOrderManagerServiceImpl.class);
    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;
    @Autowired
    BiddingMallOrderQueryService biddingMallOrderQueryService;
    @Autowired
    BiddingRoleOperationQueryService biddingRoleOperationQueryService;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    MapperFacade mapperFacade;

    public Page<BiddingSupplierOrderMangerDto> getBiddingSupplierOrderMangerList(BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable) {
        log.info("\u83b7\u53d6\u8ba2\u5355\u7ba1\u7406\u5217\u8868-\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)biddingSupplierOrderManagerListQuery));
        BiddingSupplierOrderManagerModelDto supplierOrderManagerModelDto = (BiddingSupplierOrderManagerModelDto)this.mapperFacade.map((Object)biddingSupplierOrderManagerListQuery, BiddingSupplierOrderManagerModelDto.class);
        BiddingSupplierOrderManagerSpecification specification = new BiddingSupplierOrderManagerSpecification(supplierOrderManagerModelDto);
        pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(Sort.Direction.DESC, new String[]{"dateCreated"}));
        Page jcbdMallOrders = this.jcbdMallOrderRepo.findAll((Specification)specification, pageable);
        List jcbdMallOrderList = jcbdMallOrders.getContent();
        ArrayList<BiddingSupplierOrderMangerDto> biddingSupplierOrderMangerDtoList = new ArrayList<BiddingSupplierOrderMangerDto>();
        for (JcbdMallOrder jcbdMallOrder : jcbdMallOrderList) {
            BiddingSupplierOrderMangerDto biddingSupplierOrderMangerDto = (BiddingSupplierOrderMangerDto)BeanMapper.map((Object)jcbdMallOrder, BiddingSupplierOrderMangerDto.class);
            if (!Lang.isEmpty((Object)jcbdMallOrder.getJcbdOrder())) {
                biddingSupplierOrderMangerDto.setBiddingCode(jcbdMallOrder.getJcbdOrder().getJcbdBidding().getBiddingCode());
                BiddingOrderStatus biddingOrderStatus = (BiddingOrderStatus)BiddingOrderStatus.biddingSupplierOrderStatusMap.get(jcbdMallOrder.getSupplierOrderStatus());
                if (!Lang.isEmpty((Object)biddingOrderStatus)) {
                    String statusDescription = biddingOrderStatus.getDescription();
                    biddingSupplierOrderMangerDto.setSupplierOrderStatusDescription(statusDescription);
                    List roleOperationDtoList = this.biddingRoleOperationQueryService.findByRoleCodeAndStatusAndModuleOrderByShowIndex("BIDDING_SUPPLIER", jcbdMallOrder.getSupplierOrderStatus(), StatusOperateModule.BIDDING_MANAGE_SUPPLIER.getCode());
                    biddingSupplierOrderMangerDto.setOperation(roleOperationDtoList);
                } else {
                    log.error("{} \u4f9b\u5e94\u5546\u8ba2\u5355\u72b6\u6001\u4e3a\u7a7a", (Object)jcbdMallOrder.getOrderNo());
                }
            } else {
                log.error("{} \u7ade\u4ef7\u8ba2\u5355\u4e3a\u7a7a", (Object)jcbdMallOrder.getOrderNo());
            }
            biddingSupplierOrderMangerDtoList.add(biddingSupplierOrderMangerDto);
        }
        log.info("biddingSupplierOrderMangerDtoList={}", (Object)JSON.toJSONString(biddingSupplierOrderMangerDtoList));
        return new PageImpl(biddingSupplierOrderMangerDtoList, (Pageable)new PageRequest(jcbdMallOrders.getNumber(), jcbdMallOrders.getSize(), jcbdMallOrders.getSort()), jcbdMallOrders.getTotalElements());
    }

    @Transactional
    public JcbdBdProviderDto findJcbdBdProvider(String id, String providerId) {
        JcbdBdProvider biddingProvider = new JcbdBdProvider();
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setId(id);
        biddingProvider.setJcbdBidding(jcbdBidding);
        biddingProvider.setProviderId(providerId);
        BiddingProviderSpecification specification = new BiddingProviderSpecification(biddingProvider);
        List jcbdBdProviders = this.jcbdBdProviderRepo.findAll((Specification)specification);
        return (JcbdBdProviderDto)this.mapperFacade.map(jcbdBdProviders.get(0), JcbdBdProviderDto.class);
    }
}

