/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.po.VoteDetail;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.VoteDetailRepo;
import bidding.service.service.BiddingVoteService;
import bidding.service.service.impl.BiddingMainServiceImpl;
import definition.BiddingOperateCode;
import definition.BiddingStatus;
import dto.BiddingChangeStateDto;
import dto.VoteBatchDetailDto;
import dto.VoteDetailDto;
import dto.VoteQueryResultDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingVoteServiceImpl
implements BiddingVoteService {
    private static final Logger log = LoggerFactory.getLogger(BiddingVoteServiceImpl.class);
    @Autowired
    VoteDetailRepo voteDetailRepo;
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    BiddingMainServiceImpl biddingMainService;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;

    @Transactional
    public BaseResponse randomConfirmSupplier(String biddingCode) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return new BaseResponse(false, "\u53c2\u6570\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
        }
        try {
            JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
            if (Lang.isEmpty((Object)jcbdBidding)) {
                return new BaseResponse(false, "\u7ade\u4ef7\u4e0d\u5b58\u5728");
            }
            List providers = jcbdBidding.getJcbdBdProviders();
            if (Lang.isEmpty((Object)providers)) {
                return new BaseResponse(false, "\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
            }
            Random rand = new Random();
            int randomResult = rand.nextInt(providers.size());
            for (int i = 0; i < providers.size(); ++i) {
                JcbdBdProvider jcbdBdProvider = (JcbdBdProvider)providers.get(i);
                if (randomResult == i) {
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                    jcbdBdProvider.setDealStatus("\u5df2\u6210\u4ea4");
                } else {
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue());
                }
                this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
            }
            BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
            biddingChangeStateDto.setBiddingNo(jcbdBidding.getBiddingCode());
            biddingChangeStateDto.setCurrentState(BiddingStatus.OM_RESULT_SELECT_WAIT_RANDOM.getValue());
            biddingChangeStateDto.setOpcode(BiddingOperateCode.RANDOM_CONFIRM_SUPPLIER.getCode());
            this.biddingMainService.changeBiddingState(biddingChangeStateDto);
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            return new BaseResponse(false, "\u968f\u673a\u786e\u8ba4\u4f9b\u5e94\u5546\u5f02\u5e38");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse voteSelectionSupplier(VoteDetailDto voteDetailDto) {
        String memberId = voteDetailDto.getVoteMemberId();
        String voteEmail = voteDetailDto.getVoteEmail();
        String biddingCode = voteDetailDto.getBusinessIdentifying();
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        JcbdBiddingGroupMember groupMembermember = null;
        if (!Lang.isEmpty((Object)memberId)) {
            groupMembermember = this.jcbdBiddingGroupMemberRepo.findByGroupMemberIdAndJcbdBiddingIdAndIsDelete(memberId, jcbdBidding.getId(), false);
        }
        if (Lang.isEmpty(groupMembermember) && !Lang.isEmpty((Object)voteEmail)) {
            groupMembermember = this.jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(voteEmail, jcbdBidding.getId(), false);
        }
        if (Lang.isEmpty(groupMembermember)) {
            log.error("\u7528\u6237memberId\uff1a{}\uff0cEmail\uff1a{} \u6295\u7968\u64cd\u4f5c\u67e5\u65e0\u6b64\u6210\u5458\u4fe1\u606f", (Object)memberId, (Object)voteEmail);
            return new BaseResponse("\u67e5\u65e0\u6b64\u6210\u5458\u4fe1\u606f");
        }
        VoteDetail memberVote = this.voteDetailRepo.findByVoteNoAndVoteMemberIdAndIsDelete(voteDetailDto.getVoteNo(), groupMembermember.getId(), Boolean.valueOf(false));
        if (!Lang.isEmpty((Object)memberVote)) {
            return new BaseResponse("\u62b1\u6b49\uff0c\u60a8\u5df2\u7ecf\u6295\u8fc7\u7968\u4e86");
        }
        VoteDetail voteDetail = (VoteDetail)BeanMapper.map((Object)voteDetailDto, VoteDetail.class);
        voteDetail.setVoteMemberId(groupMembermember.getId());
        this.voteDetailRepo.save((Object)voteDetail);
        groupMembermember.setStatus(BiddingStatus.M_VOTED.getValue());
        this.jcbdBiddingGroupMemberRepo.save((Object)groupMembermember);
        Integer votePeopleNum = 0;
        String voteNo = voteDetailDto.getVoteNo();
        List voteDetailList = this.voteDetailRepo.findByVoteNoAndBusinessIdentifyingAndIsDelete(voteNo, biddingCode, false);
        List jcbdBiddingGroupMembers = jcbdBidding.getJcbdBiddingGroupMembers();
        block0: for (JcbdBiddingGroupMember member : jcbdBiddingGroupMembers) {
            for (Object vote : voteDetailList) {
                if (!member.getId().equals(vote.getVoteMemberId())) continue;
                votePeopleNum = votePeopleNum + 1;
                continue block0;
            }
        }
        if (votePeopleNum.equals(jcbdBiddingGroupMembers.size())) {
            Object biddingChangeStateDto;
            List jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
            Integer bestNum = null;
            ArrayList<JcbdBdProvider> bestProvider = new ArrayList<JcbdBdProvider>();
            for (JcbdBdProvider provider : jcbdBdProviders) {
                Integer voteNum = 0;
                for (VoteDetail vote : voteDetailList) {
                    if (!vote.getResult().equals(provider.getProviderId())) continue;
                    voteNum = voteNum + 1;
                }
                if (bestNum == null) {
                    bestNum = voteNum;
                    bestProvider.add(provider);
                    continue;
                }
                if (voteNum > bestNum) {
                    bestNum = voteNum;
                    bestProvider.clear();
                    bestProvider.add(provider);
                    continue;
                }
                if (!voteNum.equals(bestNum)) continue;
                bestProvider.add(provider);
            }
            if (bestProvider.size() == 1) {
                for (JcbdBdProvider provider : jcbdBdProviders) {
                    if (!provider.getId().equals(((JcbdBdProvider)bestProvider.get(0)).getId())) {
                        provider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue());
                        this.jcbdBdProviderRepo.save((Object)provider);
                        continue;
                    }
                    provider.setDealStatus("\u5df2\u6210\u4ea4");
                    this.jcbdBdProviderRepo.save((Object)provider);
                }
                biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(jcbdBidding.getBiddingCode());
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_VOTING.getValue());
                biddingChangeStateDto.setOpcode(BiddingOperateCode.VOTE_NO_PLANE_TICKETS.getCode());
                this.biddingMainService.changeBiddingState((BiddingChangeStateDto)biddingChangeStateDto);
            } else {
                jcbdBdProviders.removeAll(bestProvider);
                for (JcbdBdProvider provider : jcbdBdProviders) {
                    provider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue());
                    this.jcbdBdProviderRepo.save((Object)provider);
                }
                for (JcbdBdProvider jcbdBdProvider : bestProvider) {
                    jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                    this.jcbdBdProviderRepo.save((Object)jcbdBdProvider);
                }
                biddingChangeStateDto = new BiddingChangeStateDto();
                biddingChangeStateDto.setBiddingNo(jcbdBidding.getBiddingCode());
                biddingChangeStateDto.setCurrentState(BiddingStatus.OM_VOTING.getValue());
                biddingChangeStateDto.setOpcode(BiddingOperateCode.VOTE_PLANE_TICKETS.getCode());
                this.biddingMainService.changeBiddingState((BiddingChangeStateDto)biddingChangeStateDto);
            }
        }
        return new BaseResponse(true, "\u6295\u7968\u4fdd\u5b58\u6210\u529f");
    }

    @Transactional
    public List<VoteQueryResultDto> voteDetailsQuery(String biddingNo) {
        VoteBatchDetailDto voteBatchDetailDto2;
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        List voteDetailList = this.voteDetailRepo.findByBusinessIdentifyingAndIsDelete(biddingNo, false);
        HashSet<String> voteNoSet = new HashSet<String>();
        String alreadyVote = "1";
        for (Object voteDetail : voteDetailList) {
            voteNoSet.add(voteDetail.getVoteNo());
        }
        ArrayList<VoteQueryResultDto> voteQueryResultDtoList = new ArrayList<VoteQueryResultDto>();
        for (String voteNo : voteNoSet) {
            VoteQueryResultDto voteQueryResultDto = new VoteQueryResultDto();
            voteQueryResultDto.setVoteNo(voteNo);
            ArrayList<VoteBatchDetailDto> voteBatchDetailDtos = new ArrayList<VoteBatchDetailDto>();
            Integer totalVoteNum = 0;
            HashSet providerIds = new HashSet();
            List voteDetails = this.voteDetailRepo.findByVoteNoAndBusinessIdentifyingAndIsDelete(voteNo, biddingNo, false);
            for (VoteDetail voteDetail : voteDetails) {
                if (!"1".equals(voteDetail.getStatus())) continue;
                Integer n = totalVoteNum;
                Integer n2 = totalVoteNum = Integer.valueOf(totalVoteNum + 1);
                providerIds.add(voteDetail.getResult());
            }
            Iterator iterator = providerIds.iterator();
            while (iterator.hasNext()) {
                String provider = (String)iterator.next();
                voteBatchDetailDto2 = new VoteBatchDetailDto();
                JcbdBdProvider jcbdBdProvider = this.jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndProviderIdAndIsDelete(biddingNo, provider, false);
                if (!Lang.isEmpty((Object)jcbdBdProvider)) {
                    voteBatchDetailDto2.setProvideName(jcbdBdProvider.getProviderName());
                    voteBatchDetailDto2.setTotalVoteNum(totalVoteNum);
                }
                Integer obtainVoteNum = 0;
                ArrayList<String> voters = new ArrayList<String>();
                for (VoteDetail voteDetail : voteDetails) {
                    if (!provider.equals(voteDetail.getResult())) continue;
                    Integer n = obtainVoteNum;
                    Integer n3 = obtainVoteNum = Integer.valueOf(obtainVoteNum + 1);
                    String voteMemberId = voteDetail.getVoteMemberId();
                    JcbdBiddingGroupMember groupMember = (JcbdBiddingGroupMember)this.jcbdBiddingGroupMemberRepo.findOne((Serializable)((Object)voteMemberId));
                    if (Lang.isEmpty((Object)groupMember)) continue;
                    voters.add(groupMember.getEmail());
                }
                voteBatchDetailDto2.setObtainVoteNum(obtainVoteNum);
                voteBatchDetailDto2.setVoters(voters);
                voteBatchDetailDto2.setTotalVoteNum(totalVoteNum);
                voteBatchDetailDtos.add(voteBatchDetailDto2);
            }
            voteQueryResultDto.setVoteBatchDtoList(voteBatchDetailDtos);
            voteQueryResultDtoList.add(voteQueryResultDto);
        }
        Integer votePeopleNum = 0;
        for (VoteQueryResultDto voteQueryResultDto : voteQueryResultDtoList) {
            List voteBatchDtoList;
            if (voteQueryResultDto.getVoteNo().equals(bidding.getVoteNo())) {
                List jcbdBiddingGroupMembers = bidding.getJcbdBiddingGroupMembers();
                List voteDetails = this.voteDetailRepo.findByVoteNoAndBusinessIdentifyingAndIsDelete(voteQueryResultDto.getVoteNo(), biddingNo, false);
                block6: for (JcbdBiddingGroupMember member : jcbdBiddingGroupMembers) {
                    for (Object vote : voteDetails) {
                        if (!member.getId().equals(vote.getVoteMemberId())) continue;
                        votePeopleNum = votePeopleNum + 1;
                        continue block6;
                    }
                }
                if (votePeopleNum.equals(jcbdBiddingGroupMembers.size())) {
                    Object vote;
                    Integer maxVoteNum = null;
                    ArrayList<VoteBatchDetailDto> maxVoteBatchList = new ArrayList<VoteBatchDetailDto>();
                    List voteBatchDtoList2 = voteQueryResultDto.getVoteBatchDtoList();
                    for (VoteBatchDetailDto voteBatchDetailDto2 : voteBatchDtoList2) {
                        Integer obtainVoteNum = voteBatchDetailDto2.getObtainVoteNum();
                        if (maxVoteNum == null) {
                            maxVoteNum = obtainVoteNum;
                            maxVoteBatchList.add(voteBatchDetailDto2);
                            continue;
                        }
                        if (obtainVoteNum > maxVoteNum) {
                            maxVoteNum = obtainVoteNum;
                            maxVoteBatchList.clear();
                            maxVoteBatchList.add(voteBatchDetailDto2);
                            continue;
                        }
                        if (!obtainVoteNum.equals(maxVoteNum)) continue;
                        maxVoteNum = obtainVoteNum;
                        maxVoteBatchList.add(voteBatchDetailDto2);
                    }
                    if (maxVoteBatchList.size() == 1) {
                        vote = voteBatchDtoList2.iterator();
                        while (vote.hasNext()) {
                            voteBatchDetailDto2 = (VoteBatchDetailDto)vote.next();
                            if (voteBatchDetailDto2.getProvideName().equals(((VoteBatchDetailDto)maxVoteBatchList.get(0)).getProvideName())) {
                                voteBatchDetailDto2.setResult("\u6210\u4ea4");
                                continue;
                            }
                            voteBatchDetailDto2.setResult("\u672a\u6210\u4ea4");
                        }
                        continue;
                    }
                    voteBatchDtoList2.removeAll(maxVoteBatchList);
                    for (VoteBatchDetailDto voteBatchs : voteBatchDtoList2) {
                        voteBatchs.setResult("\u672a\u6210\u4ea4");
                    }
                    vote = maxVoteBatchList.iterator();
                    while (vote.hasNext()) {
                        VoteBatchDetailDto voteBaths = (VoteBatchDetailDto)vote.next();
                        voteBaths.setResult("\u5e73\u7968");
                    }
                    voteBatchDtoList2.addAll(maxVoteBatchList);
                    continue;
                }
                voteBatchDtoList = voteQueryResultDto.getVoteBatchDtoList();
                for (VoteBatchDetailDto voteBatchDetailDto3 : voteBatchDtoList) {
                    voteBatchDetailDto3.setResult("\u6295\u7968\u4e2d");
                }
                continue;
            }
            Integer maxVoteNum = null;
            ArrayList<VoteBatchDetailDto> maxVoteBatchList = new ArrayList<VoteBatchDetailDto>();
            voteBatchDtoList = voteQueryResultDto.getVoteBatchDtoList();
            for (VoteBatchDetailDto voteBatchDetailDto3 : voteBatchDtoList) {
                Integer obtainVoteNum = voteBatchDetailDto3.getObtainVoteNum();
                if (maxVoteNum == null) {
                    maxVoteNum = obtainVoteNum;
                    continue;
                }
                if (obtainVoteNum > maxVoteNum) {
                    maxVoteNum = obtainVoteNum;
                    maxVoteBatchList.clear();
                    maxVoteBatchList.add(voteBatchDetailDto3);
                    continue;
                }
                if (!obtainVoteNum.equals(maxVoteNum)) continue;
                maxVoteNum = obtainVoteNum;
                maxVoteBatchList.add(voteBatchDetailDto3);
            }
            if (maxVoteBatchList.size() == 1) {
                for (VoteBatchDetailDto voteBatchDetailDto3 : voteBatchDtoList) {
                    if (voteBatchDetailDto3.getProvideName().equals(((VoteBatchDetailDto)maxVoteBatchList.get(0)).getProvideName())) {
                        voteBatchDetailDto3.setResult("\u6210\u4ea4");
                        continue;
                    }
                    voteBatchDetailDto3.setResult("\u672a\u6210\u4ea4");
                }
                continue;
            }
            voteBatchDtoList.removeAll(maxVoteBatchList);
            for (VoteBatchDetailDto voteBatchs : voteBatchDtoList) {
                voteBatchs.setResult("\u672a\u6210\u4ea4");
            }
            for (VoteBatchDetailDto voteBaths : maxVoteBatchList) {
                voteBaths.setResult("\u5e73\u7968");
            }
            voteBatchDtoList.addAll(maxVoteBatchList);
        }
        return voteQueryResultDtoList;
    }
}

