/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl;

import bidding.model.po.MallAttachment;
import bidding.model.repository.MallAttachmentRepo;
import bidding.service.service.MallAttachmentService;
import dto.MallAttachmentDto;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class MallAttachmentServiceImpl
implements MallAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(MallAttachmentServiceImpl.class);
    @Autowired
    MallAttachmentRepo mallAttachmentRepo;
    @Autowired
    MapperFacade mapperFacade;

    @Transactional(rollbackFor={Exception.class})
    public MallAttachmentDto saveOne(MallAttachmentDto mallAttachmentDto) {
        MallAttachment mallAttachment = (MallAttachment)this.mapperFacade.map((Object)mallAttachmentDto, MallAttachment.class);
        MallAttachment saved = (MallAttachment)this.mallAttachmentRepo.save((Object)mallAttachment);
        return (MallAttachmentDto)this.mapperFacade.map((Object)saved, MallAttachmentDto.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<List<MallAttachmentDto>> batchSave(List<MallAttachmentDto> mallAttachmentDtoList) {
        List mallAttachments = this.mapperFacade.mapAsList(mallAttachmentDtoList, MallAttachment.class);
        MallAttachmentDto attachmentDto = mallAttachmentDtoList.get(0);
        if (Lang.isEmpty((Object)attachmentDto.getAttachmentCorrelation()) || Lang.isEmpty((Object)attachmentDto.getBusinessCode())) {
            throw new IllegalArgumentException("\u53c2\u6570\u6709\u8bef\uff0c\u7f3a\u5c11\u4e1a\u52a1\u9644\u4ef6\u5173\u8054\u6216\u4e1a\u52a1\u4ee3\u7801");
        }
        List attachments = this.mallAttachmentRepo.findByAttachmentCorrelationAndBusinessCode(attachmentDto.getAttachmentCorrelation(), attachmentDto.getBusinessCode());
        if (!Lang.isEmpty((Object)attachments)) {
            this.mallAttachmentRepo.delete((Iterable)attachments);
        }
        List listSaved = this.mallAttachmentRepo.save((Iterable)mallAttachments);
        return new BaseResponse(true, "", (Object)this.mapperFacade.mapAsList((Iterable)listSaved, MallAttachmentDto.class));
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse deleteMallAttachments(String attachmentCorrelation, String businessCode) {
        if (Lang.isEmpty((Object)attachmentCorrelation) || Lang.isEmpty((Object)businessCode)) {
            throw new IllegalArgumentException("\u53c2\u6570\u6709\u8bef\uff0c\u7f3a\u5c11\u4e1a\u52a1\u9644\u4ef6\u5173\u8054\u6216\u4e1a\u52a1\u4ee3\u7801");
        }
        List attachments = this.mallAttachmentRepo.findByAttachmentCorrelationAndBusinessCode(attachmentCorrelation, businessCode);
        if (!Lang.isEmpty((Object)attachments)) {
            this.mallAttachmentRepo.delete((Iterable)attachments);
        }
        return new BaseResponse(true);
    }
}

