/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl.query;

import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingConformance;
import bidding.model.po.JcbdBiddingDemand;
import bidding.model.po.JcbdBiddingDemandResponse;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.po.JcbdConformanceCheck;
import bidding.model.po.JcbdProviderAddressResponse;
import bidding.model.po.JcbdProviderConformanceResp;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingConformanceRepo;
import bidding.model.repository.JcbdBiddingDemandRepo;
import bidding.model.repository.JcbdBiddingDemandRespRepo;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdConformanCheckRepo;
import bidding.model.repository.JcbdDemandAddressNumRepo;
import bidding.model.repository.JcbdProviderAddressRespRepo;
import bidding.model.repository.JcbdProviderConformanceRespRepo;
import bidding.model.specification.BiddingConformanceCheckSpecification;
import bidding.model.specification.BiddingDemandResponseSpecification;
import bidding.model.specification.BiddingDemandSpecification;
import bidding.model.specification.BiddingGroupMemberSpecification;
import bidding.model.specification.BiddingProviderAddRespSpecification;
import bidding.model.specification.BiddingProviderConformanceRespSpec;
import bidding.model.specification.BiddingProviderSpecification;
import bidding.model.specification.BiddingSpecification;
import bidding.service.service.query.BiddingConformityReviewQueryService;
import com.alibaba.fastjson.JSON;
import definition.BiddingConformAuditStatus;
import definition.ProviderConformanceRespStatus;
import dto.BiddingConformityListDto;
import dto.BiddingConformityQueryDto;
import dto.BiddingResponseOutlineDto;
import dto.JcbdBiddingDemandDto;
import dto.JcbdBiddingDemandResponseDto;
import dto.JcbdBiddingGroupMemberDto;
import dto.JcbdProviderAddressResponseDto;
import dto.JcbdProviderConformanceRespDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class BiddingConformityReviewQueryServiceImpl
implements BiddingConformityReviewQueryService {
    private static final Logger log = LoggerFactory.getLogger(BiddingConformityReviewQueryServiceImpl.class);
    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;
    @Autowired
    JcbdConformanCheckRepo jcbdConformanCheckRepo;
    @Autowired
    JcbdBiddingDemandRespRepo jcbdBiddingDemandRespRepo;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;
    @Autowired
    JcbdDemandAddressNumRepo jcbdDemandAddressNumRepo;
    @Autowired
    JcbdProviderConformanceRespRepo jcbdProviderConformanceRespRepo;
    @Autowired
    JcbdBiddingConformanceRepo jcbdBiddingConformanceRepo;
    @Autowired
    JcbdProviderAddressRespRepo jcbdProviderAddressRespRepo;

    public BaseResponse<List<JcbdBiddingGroupMemberDto>> findBiddingGroupMember(String biddingNo) {
        log.info("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f-\u8bf7\u6c42\u53c2\u6570\u7ade\u4ef7\u7f16\u53f7\u4e3a {}", (Object)biddingNo);
        if (Lang.isEmpty((Object)biddingNo)) {
            log.error("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u5931\u8d25-\u8bf7\u6c42\u53c2\u6570\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
            return new BaseResponse("\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u5931\u8d25-\u8bf7\u6c42\u53c2\u6570\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a");
        }
        try {
            JcbdBidding jcbdBidding = new JcbdBidding();
            jcbdBidding.setBiddingCode(biddingNo);
            List jcbdBiddings = this.jcbdBiddingRepo.findAll((Specification)new BiddingSpecification(jcbdBidding));
            if (jcbdBiddings.size() != 1) {
                log.error("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u5931\u8d25-\u7ade\u4ef7\u7f16\u53f7\u4e3a {} \u7684\u6570\u636e\u8981\u6c42\u6709\u4e14\u53ea\u6709\u6709 1 \u6761, \u5b9e\u9645 {} \u6761", (Object)biddingNo, (Object)jcbdBiddings.size());
                return new BaseResponse("\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u5931\u8d25-\u6570\u636e\u68c0\u67e5\u672a\u901a\u8fc7");
            }
            JcbdBiddingGroupMember biddingGroupMember = new JcbdBiddingGroupMember();
            biddingGroupMember.setJcbdBidding((JcbdBidding)jcbdBiddings.get(0));
            List biddingGroupMembers = this.jcbdBiddingGroupMemberRepo.findAll((Specification)new BiddingGroupMemberSpecification(biddingGroupMember));
            List biddingGroupMemberDtos = this.mapperFacade.mapAsList((Iterable)biddingGroupMembers, JcbdBiddingGroupMemberDto.class);
            log.info("\u7ade\u4ef7\u7f16\u53f7\u4e3a {} \u7684\u7ade\u4ef7\u6210\u5458\u4fe1\u606f\u4e3a {}", (Object)biddingNo, (Object)JSON.toJSONString((Object)biddingGroupMemberDtos));
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)biddingGroupMemberDtos);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u5f02\u5e38, \u7ade\u4ef7\u7f16\u53f7 {} ", (Object)biddingNo, (Object)e);
            return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Page<BiddingConformityListDto> getConformityListByQueryDto(BiddingConformityQueryDto conformityQueryDto) {
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(conformityQueryDto.getBiddingCode(), false);
        JcbdBiddingDemand demand = new JcbdBiddingDemand();
        if (!Lang.isEmpty((Object)conformityQueryDto.getBiddingCode())) {
            JcbdBidding jcbdBidding = new JcbdBidding();
            jcbdBidding.setBiddingCode(conformityQueryDto.getBiddingCode());
            demand.setJcbdBidding(jcbdBidding);
        }
        Page demandPage = this.jcbdBiddingDemandRepo.findAll((Specification)new BiddingDemandSpecification(demand), conformityQueryDto.getPageable());
        ArrayList conformityListDtoList = new ArrayList();
        if (!Lang.isEmpty((Object)demandPage)) {
            List demandList = demandPage.getContent();
            demandList.forEach(n -> {
                BiddingConformityListDto conformityListDto = new BiddingConformityListDto();
                conformityListDto.setDemandCode(n.getDemandCode());
                conformityListDto.setGoodsDesription(n.getGoodsDesription());
                conformityListDto.setGoodsBrand(n.getGoodsBrand());
                conformityListDto.setGoodsModel(n.getGoodsModel());
                conformityListDto.setSpecification(n.getSpecification());
                conformityListDto.setMinPurchaseAmount(n.getMinPurchaseAmount());
                conformityListDto.setMaxPurchaseAmount(n.getMaxPurchaseAmount());
                conformityListDto.setDateRequiredDelivery(n.getDateRequiredDelivery());
                List demandAddressNums = n.getJcbdDemandAddressNums();
                ArrayList addrList = new ArrayList();
                demandAddressNums.forEach(m -> {
                    StringBuffer sb = new StringBuffer();
                    sb.append(m.getProvinceName()).append(m.getCityName()).append(Lang.isEmpty((Object)m.getAreaName()) ? "" : m.getAreaName()).append(Lang.isEmpty((Object)m.getTownName()) ? "" : m.getTownName());
                    addrList.add(sb.toString());
                });
                conformityListDto.setDemandAddrList(addrList);
                Integer conformityNum = n.getJcbdBiddingConformances().size();
                conformityListDto.setConformityNum(conformityNum);
                Integer demandRspNUm = n.getJcbdBiddingDemandResponses().size();
                conformityListDto.setDemandResponNum(demandRspNUm);
                List jcbdBdProviders = bidding.getJcbdBdProviders();
                List conformances = n.getJcbdBiddingConformances();
                Integer[] count = new Integer[]{0};
                if (!Lang.isEmpty((Object)jcbdBdProviders) && !Lang.isEmpty((Object)conformances)) {
                    jcbdBdProviders.forEach(provider -> {
                        ArrayList conformanceChecks = new ArrayList();
                        conformances.forEach(conformance -> {
                            JcbdConformanceCheck jcbdConformanceCheck = new JcbdConformanceCheck();
                            jcbdConformanceCheck.setBiddingConformance(conformance);
                            if (!Lang.isEmpty((Object)conformityQueryDto.getMemberId())) {
                                jcbdConformanceCheck.setBiddingGroupMemberId(conformityQueryDto.getMemberId());
                            } else {
                                jcbdConformanceCheck.setEmail(conformityQueryDto.getEmail());
                            }
                            jcbdConformanceCheck.setProviderId(provider.getProviderId());
                            JcbdConformanceCheck conformanceCheck = (JcbdConformanceCheck)this.jcbdConformanCheckRepo.findOne((Specification)new BiddingConformanceCheckSpecification(jcbdConformanceCheck));
                            if (!Lang.isEmpty((Object)conformanceCheck)) {
                                conformanceChecks.add(conformanceCheck);
                            }
                        });
                        if (!Lang.isEmpty(conformanceChecks)) {
                            if (conformanceChecks.size() != conformances.size()) {
                                count[0] = 0;
                            } else if (conformanceChecks.contains(null)) {
                                count[0] = 0;
                            } else {
                                List statusList = conformanceChecks.stream().map(JcbdConformanceCheck::getStatus).collect(Collectors.toList());
                                if (Lang.isEmpty(statusList) || statusList.contains(null)) {
                                    count[0] = 0;
                                } else {
                                    Integer n = count[0];
                                    Integer n2 = count[0] = Integer.valueOf(count[0] + 1);
                                }
                            }
                        }
                    });
                }
                conformityListDto.setProvidersAudited(count[0]);
                conformityListDtoList.add(conformityListDto);
            });
        }
        return new PageImpl(conformityListDtoList, (Pageable)new PageRequest(demandPage.getNumber(), demandPage.getSize(), demandPage.getSort()), demandPage.getTotalElements());
    }

    public List<JcbdBiddingDemandResponseDto> getConformityAuditInfo(String demandCode) {
        JcbdBiddingDemandResponse demandResponse = new JcbdBiddingDemandResponse();
        JcbdBiddingDemand demand = new JcbdBiddingDemand();
        demand.setDemandCode(demandCode);
        demandResponse.setJcbdBiddingDemand(demand);
        List demandResponList = this.jcbdBiddingDemandRespRepo.findAll((Specification)new BiddingDemandResponseSpecification(demandResponse));
        List demandResponseDtos = this.mapperFacade.mapAsList((Iterable)demandResponList, JcbdBiddingDemandResponseDto.class);
        demandResponseDtos.forEach(n -> {
            JcbdBdProvider provider = this.jcbdBdProviderRepo.findFirstByProviderIdAndIsDelete(n.getResponseProviderId(), false);
            n.setProviderName(provider.getProviderName());
        });
        return demandResponseDtos;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<List<BiddingResponseOutlineDto>> queryConformityOutline(BiddingConformityQueryDto conformityQueryDto) {
        log.info("queryConformityOutline,biddingCode:{},demandCode:{}", (Object)conformityQueryDto.getBiddingCode(), (Object)conformityQueryDto.getDemandCode());
        if (Lang.isEmpty((Object)conformityQueryDto.getBiddingCode()) || Lang.isEmpty((Object)conformityQueryDto.getDemandCode())) {
            return new BaseResponse("\u8bf7\u6c42\u53c2\u6570\u6709\u7a7a\u503c\uff01");
        }
        JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
        JcbdBidding bidding = new JcbdBidding();
        bidding.setBiddingCode(conformityQueryDto.getBiddingCode());
        biddingDemand.setJcbdBidding(bidding);
        biddingDemand.setDemandCode(conformityQueryDto.getDemandCode());
        JcbdBiddingDemand jcbdBiddingDemand = (JcbdBiddingDemand)this.jcbdBiddingDemandRepo.findOne((Specification)new BiddingDemandSpecification(biddingDemand));
        if (Lang.isEmpty((Object)jcbdBiddingDemand)) {
            log.info("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u6570\u636e\u5931\u8d25");
            return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u6570\u636e\u5931\u8d25");
        }
        JcbdBiddingDemandResponse biddingDemandResponse = new JcbdBiddingDemandResponse();
        biddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);
        List demandResponseList = this.jcbdBiddingDemandRespRepo.findAll((Specification)new BiddingDemandResponseSpecification(biddingDemandResponse));
        ArrayList<BiddingResponseOutlineDto> biddingOutlineDtoList = new ArrayList<BiddingResponseOutlineDto>();
        if (!Lang.isEmpty((Object)demandResponseList) && demandResponseList.size() > 0) {
            for (JcbdBiddingDemandResponse n : demandResponseList) {
                BiddingResponseOutlineDto responseOutlineDto = new BiddingResponseOutlineDto();
                JcbdBdProvider provider = (JcbdBdProvider)this.jcbdBdProviderRepo.findOne((Serializable)((Object)n.getResponseProviderId()));
                List conformances = this.jcbdBiddingConformanceRepo.findByJcbdBiddingDemandDemandCodeAndIsDelete(conformityQueryDto.getDemandCode(), false);
                if (Lang.isEmpty((Object)conformances)) {
                    log.info("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42{}\u7684\u7b26\u5408\u6027\u6570\u636e\u5931\u8d25", (Object)conformityQueryDto.getDemandCode());
                    return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u7b26\u5408\u6027\u6570\u636e\u5931\u8d25");
                }
                ArrayList<JcbdConformanceCheck> conformanceChecks = new ArrayList<JcbdConformanceCheck>();
                for (JcbdBiddingConformance conformance : conformances) {
                    JcbdConformanceCheck jcbdConformanceCheck = new JcbdConformanceCheck();
                    jcbdConformanceCheck.setBiddingConformance(conformance);
                    if (!Lang.isEmpty((Object)conformityQueryDto.getMemberId())) {
                        jcbdConformanceCheck.setBiddingGroupMemberId(conformityQueryDto.getMemberId());
                    } else {
                        jcbdConformanceCheck.setEmail(conformityQueryDto.getEmail());
                    }
                    jcbdConformanceCheck.setProviderId(provider.getProviderId());
                    JcbdConformanceCheck conformanceCheck = (JcbdConformanceCheck)this.jcbdConformanCheckRepo.findOne((Specification)new BiddingConformanceCheckSpecification(jcbdConformanceCheck));
                    conformanceChecks.add(conformanceCheck);
                }
                if (!Lang.isEmpty(conformanceChecks)) {
                    if (conformanceChecks.size() != conformances.size()) {
                        responseOutlineDto.setResponseStatus(null);
                    } else if (conformanceChecks.contains(null)) {
                        responseOutlineDto.setResponseStatus(null);
                    } else {
                        List statusList = conformanceChecks.stream().map(JcbdConformanceCheck::getStatus).collect(Collectors.toList());
                        if (Lang.isEmpty(statusList) || statusList.contains(null)) {
                            responseOutlineDto.setResponseStatus(null);
                        } else if (statusList.contains(BiddingConformAuditStatus.NOT_ACCORD.getValue())) {
                            responseOutlineDto.setResponseStatus("(" + BiddingConformAuditStatus.NOT_ACCORD.getDescription() + ")");
                        } else {
                            responseOutlineDto.setResponseStatus("(" + BiddingConformAuditStatus.ACCORD.getDescription() + ")");
                        }
                    }
                } else {
                    responseOutlineDto.setResponseStatus(null);
                }
                ArrayList jcbdConformanceChecks = new ArrayList();
                for (JcbdBiddingConformance conformance : conformances) {
                    JcbdConformanceCheck allConformanceCheck = new JcbdConformanceCheck();
                    allConformanceCheck.setBiddingConformance(conformance);
                    allConformanceCheck.setProviderId(provider.getProviderId());
                    List conformanceCheckList = this.jcbdConformanCheckRepo.findByProviderIdAndBiddingConformanceId(provider.getProviderId(), conformance.getId());
                    jcbdConformanceChecks.addAll(conformanceCheckList);
                }
                if (Lang.isEmpty(jcbdConformanceChecks)) {
                    responseOutlineDto.setAccordStatus("");
                } else {
                    List statusList = jcbdConformanceChecks.stream().map(JcbdConformanceCheck::getStatus).collect(Collectors.toList());
                    if (statusList.contains(BiddingConformAuditStatus.NOT_ACCORD.getValue())) {
                        responseOutlineDto.setAccordStatus("(" + BiddingConformAuditStatus.NOT_ACCORD.getDescription() + ")");
                    } else {
                        responseOutlineDto.setAccordStatus("(" + BiddingConformAuditStatus.ACCORD.getDescription() + ")");
                    }
                }
                responseOutlineDto.setSupplierId(provider.getProviderId());
                responseOutlineDto.setSupplierName(provider.getProviderName());
                biddingOutlineDtoList.add(responseOutlineDto);
            }
        }
        log.info("queryConformityOutline\u67e5\u8be2\u7ed3\u679c:{}", biddingOutlineDtoList);
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f!", biddingOutlineDtoList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<JcbdBiddingDemandResponseDto> getConformityDetail(BiddingConformityQueryDto conformityQueryDto) {
        if (Lang.isEmpty((Object)conformityQueryDto.getBiddingCode()) || Lang.isEmpty((Object)conformityQueryDto.getDemandCode()) || Lang.isEmpty((Object)conformityQueryDto.getProviderId())) {
            return new BaseResponse("\u8bf7\u6c42\u53c2\u6570\u6709\u7a7a\u503c\uff01");
        }
        JcbdBiddingDemandResponseDto jcbdBiddingDemandResponseDto = new JcbdBiddingDemandResponseDto();
        JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
        JcbdBidding bidding = new JcbdBidding();
        bidding.setBiddingCode(conformityQueryDto.getBiddingCode());
        biddingDemand.setJcbdBidding(bidding);
        biddingDemand.setDemandCode(conformityQueryDto.getDemandCode());
        JcbdBiddingDemand jcbdBiddingDemand = (JcbdBiddingDemand)this.jcbdBiddingDemandRepo.findOne((Specification)new BiddingDemandSpecification(biddingDemand));
        if (Lang.isEmpty((Object)jcbdBiddingDemand)) {
            log.info("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u6570\u636e\u5931\u8d25");
            return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u6570\u636e\u5931\u8d25");
        }
        JcbdBiddingDemandResponse jcbdBiddingDemandResponse = new JcbdBiddingDemandResponse();
        jcbdBiddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);
        JcbdBdProvider jcbdBdProvider = new JcbdBdProvider();
        jcbdBdProvider.setProviderId(conformityQueryDto.getProviderId());
        jcbdBdProvider.setJcbdBidding(jcbdBiddingDemand.getJcbdBidding());
        JcbdBdProvider provider = (JcbdBdProvider)this.jcbdBdProviderRepo.findOne((Specification)new BiddingProviderSpecification(jcbdBdProvider));
        if (!Lang.isEmpty((Object)provider)) {
            jcbdBiddingDemandResponse.setResponseProviderId(provider.getId());
            jcbdBiddingDemandResponseDto.setOfferValidity(provider.getOfferValidity());
        }
        List demandResponseList = this.jcbdBiddingDemandRespRepo.findAll((Specification)new BiddingDemandResponseSpecification(jcbdBiddingDemandResponse));
        JcbdBiddingDemandResponse biddingDemandResponse = null;
        if (!Lang.isEmpty((Object)jcbdBiddingDemand)) {
            JcbdBiddingDemandDto jcbdBiddingDemandDto = (JcbdBiddingDemandDto)this.mapperFacade.map((Object)jcbdBiddingDemand, JcbdBiddingDemandDto.class);
            jcbdBiddingDemandDto.setBiddingId(bidding.getId());
            jcbdBiddingDemandResponseDto.setJcbdBiddingDemand(jcbdBiddingDemandDto);
        }
        if (!Lang.isEmpty((Object)demandResponseList)) {
            biddingDemandResponse = (JcbdBiddingDemandResponse)demandResponseList.get(0);
            if (!Lang.isEmpty((Object)biddingDemandResponse)) {
                jcbdBiddingDemandResponseDto = (JcbdBiddingDemandResponseDto)this.mapperFacade.map((Object)biddingDemandResponse, JcbdBiddingDemandResponseDto.class);
                if (!Lang.isEmpty((Object)biddingDemandResponse.getQouteIndate())) {
                    jcbdBiddingDemandResponseDto.setOfferValidity(biddingDemandResponse.getQouteIndate());
                }
            }
            JcbdProviderAddressResponse providerAddressResponse = new JcbdProviderAddressResponse();
            providerAddressResponse.setJcbdBiddingDemandResponse(biddingDemandResponse);
            List providerAddressList = this.jcbdProviderAddressRespRepo.findAll((Specification)new BiddingProviderAddRespSpecification(providerAddressResponse));
            if (!Lang.isEmpty((Object)providerAddressList)) {
                ArrayList<JcbdProviderAddressResponseDto> jcbdProviderAddressResponseDtos = new ArrayList<JcbdProviderAddressResponseDto>(providerAddressList.size());
                for (JcbdProviderAddressResponse addressResponse : providerAddressList) {
                    JcbdProviderAddressResponseDto jcbdProviderAddressResponseDto = new JcbdProviderAddressResponseDto();
                    jcbdProviderAddressResponseDto.setDemandAddressId(addressResponse.getDemandAddressId());
                    jcbdProviderAddressResponseDto.setNumberNeed(addressResponse.getNumberNeed());
                    jcbdProviderAddressResponseDto.setContent(addressResponse.getContent());
                    jcbdProviderAddressResponseDto.setRemark(addressResponse.getRemark());
                    jcbdProviderAddressResponseDto.setStatus(addressResponse.getStatus());
                    jcbdProviderAddressResponseDtos.add(jcbdProviderAddressResponseDto);
                }
                jcbdBiddingDemandResponseDto.setJcbdProviderAddressResponses(jcbdProviderAddressResponseDtos);
            }
            JcbdProviderConformanceResp providerConformanceResp = new JcbdProviderConformanceResp();
            providerConformanceResp.setJcbdBiddingDemandResponse(biddingDemandResponse);
            List providerConformanceRespList = this.jcbdProviderConformanceRespRepo.findAll((Specification)new BiddingProviderConformanceRespSpec(providerConformanceResp));
            if (!Lang.isEmpty((Object)providerConformanceRespList)) {
                ArrayList<JcbdProviderConformanceRespDto> jcbdProviderConformanceResDtos = new ArrayList<JcbdProviderConformanceRespDto>(providerConformanceRespList.size());
                for (JcbdProviderConformanceResp conformanceResp : providerConformanceRespList) {
                    JcbdProviderConformanceRespDto jcbdProviderConformanceRespDto = new JcbdProviderConformanceRespDto();
                    JcbdBiddingConformance jcbdBiddingConformance = (JcbdBiddingConformance)this.jcbdBiddingConformanceRepo.findOne((Serializable)((Object)conformanceResp.getBiddingConformanceId()));
                    List jcbdConformanceChecks = this.jcbdConformanCheckRepo.findByBiddingConformanceId(jcbdBiddingConformance.getId());
                    StringBuffer noPassStrBuffer = new StringBuffer();
                    for (int i = 0; i < jcbdConformanceChecks.size(); ++i) {
                        JcbdConformanceCheck thisConformanceCheck = (JcbdConformanceCheck)jcbdConformanceChecks.get(i);
                        if (!thisConformanceCheck.getProviderId().equals(conformityQueryDto.getProviderId()) || !"0".equals(thisConformanceCheck.getStatus())) continue;
                        JcbdBiddingGroupMember groupMember = new JcbdBiddingGroupMember();
                        if (!Lang.isEmpty((Object)thisConformanceCheck.getBiddingGroupMemberId())) {
                            groupMember.setGroupMemberId(thisConformanceCheck.getBiddingGroupMemberId());
                        } else {
                            groupMember.setEmail(thisConformanceCheck.getEmail());
                        }
                        groupMember.setJcbdBidding(bidding);
                        JcbdBiddingGroupMember biddingGroupMember = (JcbdBiddingGroupMember)this.jcbdBiddingGroupMemberRepo.findOne((Specification)new BiddingGroupMemberSpecification(groupMember));
                        if (Lang.isEmpty((Object)biddingGroupMember.getName())) {
                            noPassStrBuffer.append(biddingGroupMember.getEmail());
                        } else {
                            noPassStrBuffer.append(biddingGroupMember.getName());
                        }
                        noPassStrBuffer.append(",");
                    }
                    JcbdConformanceCheck jcbdConformanceCheck = new JcbdConformanceCheck();
                    jcbdConformanceCheck.setBiddingConformance(jcbdBiddingConformance);
                    if (!Lang.isEmpty((Object)conformityQueryDto.getMemberId())) {
                        jcbdConformanceCheck.setBiddingGroupMemberId(conformityQueryDto.getMemberId());
                    } else {
                        jcbdConformanceCheck.setEmail(conformityQueryDto.getEmail());
                    }
                    jcbdConformanceCheck.setProviderId(provider.getProviderId());
                    JcbdConformanceCheck conformanceCheck = (JcbdConformanceCheck)this.jcbdConformanCheckRepo.findOne((Specification)new BiddingConformanceCheckSpecification(jcbdConformanceCheck));
                    if (Lang.isEmpty((Object)conformanceCheck)) {
                        jcbdProviderConformanceRespDto.setConformanceStatus(null);
                    } else if (Lang.isEmpty((Object)conformanceCheck.getStatus())) {
                        jcbdProviderConformanceRespDto.setConformanceStatus(null);
                    } else {
                        jcbdProviderConformanceRespDto.setConformanceStatus(conformanceCheck.getStatus());
                    }
                    if (!Lang.isEmpty((Object)noPassStrBuffer)) {
                        String substring = noPassStrBuffer.substring(0, noPassStrBuffer.length() - 1);
                        jcbdProviderConformanceRespDto.setNotPassMemberStr(substring);
                    } else {
                        jcbdProviderConformanceRespDto.setNotPassMemberStr(noPassStrBuffer.toString());
                    }
                    jcbdProviderConformanceRespDto.setConformance(jcbdBiddingConformance.getConformance());
                    if (ProviderConformanceRespStatus.ACCORD.getValue().equals(conformanceResp.getStatus())) {
                        jcbdProviderConformanceRespDto.setStatus(ProviderConformanceRespStatus.ACCORD.getDescription());
                    } else {
                        jcbdProviderConformanceRespDto.setStatus(ProviderConformanceRespStatus.NOT_ACCORD.getDescription());
                    }
                    jcbdProviderConformanceRespDto.setBiddingConformanceId(jcbdBiddingConformance.getId());
                    jcbdProviderConformanceRespDto.setId(conformanceResp.getId());
                    jcbdProviderConformanceRespDto.setRemark(conformanceResp.getRemark());
                    jcbdProviderConformanceResDtos.add(jcbdProviderConformanceRespDto);
                }
                jcbdBiddingDemandResponseDto.setJcbdProviderConformanceResps(jcbdProviderConformanceResDtos);
            }
        }
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)jcbdBiddingDemandResponseDto);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteComplianceAudit(String biddingNo, String email, String groupMemberId) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        List biddingDemands = this.jcbdBiddingDemandRepo.findByJcbdBiddingIdAndIsDelete(jcbdBidding.getId(), false);
        for (JcbdBiddingDemand biddingDemand : biddingDemands) {
            List conformances = this.jcbdBiddingConformanceRepo.findByJcbdBiddingDemandDemandCodeAndIsDelete(biddingDemand.getDemandCode(), false);
            for (JcbdBiddingConformance conformance : conformances) {
                List jcbdConformanceCheck = this.jcbdConformanCheckRepo.findByBiddingConformanceId(conformance.getId());
                for (JcbdConformanceCheck jc : jcbdConformanceCheck) {
                    if (!Lang.isEmpty((Object)jc.getBiddingGroupMemberId())) {
                        if (!jc.getBiddingGroupMemberId().equals(groupMemberId)) continue;
                        this.jcbdConformanCheckRepo.delete((Object)jc);
                        continue;
                    }
                    if (!jc.getEmail().equals(email)) continue;
                    this.jcbdConformanCheckRepo.delete((Object)jc);
                }
            }
        }
    }
}

