/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl.query;

import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingDemand;
import bidding.model.repository.JcbdBiddingDemandRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.specification.BiddingDemandSpecification;
import bidding.service.service.query.BiddingDemandQueryService;
import dto.JcbdBiddingDemandDto;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BiddingDemandQueryServiceImpl
implements BiddingDemandQueryService {
    private static final Logger log = LoggerFactory.getLogger(BiddingDemandQueryServiceImpl.class);
    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    MapperFacade mapperFacade;

    @Transactional(rollbackFor={Exception.class})
    public List<JcbdBiddingDemandDto> findByJcbdBiddingIdAndIsDelete(String biddingCode) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        List jcbdBiddingDemands = this.jcbdBiddingDemandRepo.findByJcbdBiddingIdAndIsDelete(jcbdBidding.getId(), false);
        return this.mapperFacade.mapAsList((Iterable)jcbdBiddingDemands, JcbdBiddingDemandDto.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<JcbdBiddingDemandDto> findByJcbdBiddingCodeAndIsDelete(String biddingCode) {
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setBiddingCode(biddingCode);
        JcbdBiddingDemand jcbdBiddingDemand = new JcbdBiddingDemand();
        jcbdBiddingDemand.setJcbdBidding(jcbdBidding);
        List jcbdBiddingDemandList = this.jcbdBiddingDemandRepo.findAll((Specification)new BiddingDemandSpecification(jcbdBiddingDemand));
        return this.mapperFacade.mapAsList((Iterable)jcbdBiddingDemandList, JcbdBiddingDemandDto.class);
    }
}

