/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl.query;

import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingDemand;
import bidding.model.po.JcbdBiddingDemandResponse;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.po.JcbdDemandAddressNum;
import bidding.model.po.JcbdRoleOperation;
import bidding.model.po.JcbdTempGoods;
import bidding.model.po.JcbdTempOrder;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingDemandRepo;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdRoleOperationRepo;
import bidding.model.repository.JcbdTempOrderRepo;
import bidding.model.specification.BiddingDemandSpecification;
import bidding.model.specification.BiddingProviderSpecification;
import bidding.service.service.query.BiddingMainQueryService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import definition.BiddingStatus;
import dto.BiddingDemandQueryDto;
import dto.BiddingPurchaseGoodsDTO;
import dto.JcbdBdProviderDto;
import dto.JcbdBiddingDemandDto;
import dto.JcbdBiddingDto;
import dto.JcbdBiddingQueryDto;
import dto.JcbdBiddingQueryResultDto;
import dto.JcbdRoleOperationDto;
import dto.JcbdTempOrderDto;
import dto.ProcureInformationDto;
import dto.TempBatchDto;
import dto.TempBatchListDto;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import query.BiddingDemandListQuery;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingMainQueryServiceImpl
implements BiddingMainQueryService {
    private static final Logger log = LoggerFactory.getLogger(BiddingMainQueryServiceImpl.class);
    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;
    @Autowired
    JcbdRoleOperationRepo jcbdRoleOperationRepo;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdTempOrderRepo jcbdTempOrderRepo;
    public static final String IS_CHECKED = "1";
    public static final String IS_CHECKEING = "0";

    public BaseResponse<List<BiddingPurchaseGoodsDTO>> getPurchaseGoods(String biddingNo) {
        return null;
    }

    public Page<JcbdBiddingQueryResultDto> operatorFindJcbdBiddingByParams(JcbdBiddingQueryDto jcbdBiddingQueryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)jcbdBiddingQueryDto));
        Specification specification = this.getSpecificationForOperator(jcbdBiddingQueryDto);
        Page biddingGroupMembers = this.jcbdBiddingGroupMemberRepo.findAll(specification, jcbdBiddingQueryDto.getPageable());
        List jcbdBiddingGroupMemberList = biddingGroupMembers.getContent();
        ArrayList<JcbdBiddingQueryResultDto> jcbdBiddingQueryResultDtoList = new ArrayList<JcbdBiddingQueryResultDto>();
        if (!Lang.isEmpty((Object)jcbdBiddingGroupMemberList)) {
            for (JcbdBiddingGroupMember groupMember : jcbdBiddingGroupMemberList) {
                JcbdBiddingQueryResultDto jcbdBiddingQueryResultDto = new JcbdBiddingQueryResultDto();
                jcbdBiddingQueryResultDto.setJcbdBiddingNo(groupMember.getJcbdBidding().getBiddingCode());
                jcbdBiddingQueryResultDto.setDescribe(groupMember.getJcbdBidding().getBiddingDescription());
                jcbdBiddingQueryResultDto.setStartTime(groupMember.getJcbdBidding().getTimeStartResponse());
                jcbdBiddingQueryResultDto.setEndTime(groupMember.getJcbdBidding().getTimeEndResponse());
                jcbdBiddingQueryResultDto.setInvitationSupplierNum(groupMember.getJcbdBidding().getProviderInviteNum());
                jcbdBiddingQueryResultDto.setResponseSupplierNum(groupMember.getJcbdBidding().getProviderResponseNum());
                jcbdBiddingQueryResultDto.setState(groupMember.getJcbdBidding().getStatus());
                BiddingStatus biddingStatus = (BiddingStatus)BiddingStatus.biddingStatusMap.get(groupMember.getJcbdBidding().getStatus());
                jcbdBiddingQueryResultDto.setStateName(biddingStatus.getDescription());
                ArrayList jcbdRoleOperationDtoList = new ArrayList();
                if (groupMember.getJcbdBidding().getOperatorId().equals(jcbdBiddingQueryDto.getUserId())) {
                    List operationDtoForOperator = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex("BIDDING_OPERATOR", groupMember.getStatus());
                    List operationDtosForGroupMember = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex("BIDDING_GROUP_MEMBER", groupMember.getStatus());
                    if (!Lang.isEmpty((Object)operationDtoForOperator)) {
                        jcbdRoleOperationDtoList.addAll(BeanMapper.mapList((Iterable)operationDtoForOperator, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                    }
                    if (!Lang.isEmpty((Object)operationDtosForGroupMember)) {
                        jcbdRoleOperationDtoList.addAll(BeanMapper.mapList((Iterable)operationDtosForGroupMember, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                    }
                } else {
                    List operationDtosForGroupMember = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex("BIDDING_GROUP_MEMBER", groupMember.getStatus());
                    if (!Lang.isEmpty((Object)operationDtosForGroupMember)) {
                        jcbdRoleOperationDtoList.addAll(BeanMapper.mapList((Iterable)operationDtosForGroupMember, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                    }
                }
                for (JcbdRoleOperationDto jcbdRoleOperationDto : jcbdRoleOperationDtoList) {
                    String url = jcbdRoleOperationDto.getUrl();
                    if (url != null && !"".equals(url)) {
                        url = url + "?biddingNo=" + jcbdBiddingQueryResultDto.getJcbdBiddingNo();
                    }
                    jcbdRoleOperationDto.setUrl(url);
                }
                jcbdBiddingQueryResultDto.setOperations(jcbdRoleOperationDtoList);
                jcbdBiddingQueryResultDtoList.add(jcbdBiddingQueryResultDto);
            }
        }
        return new PageImpl(jcbdBiddingQueryResultDtoList, (Pageable)new PageRequest(biddingGroupMembers.getNumber(), biddingGroupMembers.getSize(), biddingGroupMembers.getSort()), biddingGroupMembers.getTotalElements());
    }

    public Page<JcbdBiddingQueryResultDto> supplierFindJcbdBiddingByParams(JcbdBiddingQueryDto jcbdBiddingQueryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)jcbdBiddingQueryDto));
        Specification specification = this.getSpecificationForSupplier(jcbdBiddingQueryDto);
        Page jcbdBdProviders = this.jcbdBdProviderRepo.findAll(specification, jcbdBiddingQueryDto.getPageable());
        List jcbdBdProviderList = jcbdBdProviders.getContent();
        ArrayList<JcbdBiddingQueryResultDto> jcbdBiddingQueryResultDtoList = new ArrayList<JcbdBiddingQueryResultDto>();
        if (!Lang.isEmpty((Object)jcbdBdProviderList)) {
            for (JcbdBdProvider bdProvider : jcbdBdProviderList) {
                JcbdBiddingQueryResultDto jcbdBiddingQueryResultDto = new JcbdBiddingQueryResultDto();
                jcbdBiddingQueryResultDto.setJcbdBiddingNo(bdProvider.getJcbdBidding().getBiddingCode());
                jcbdBiddingQueryResultDto.setDescribe(bdProvider.getJcbdBidding().getBiddingDescription());
                jcbdBiddingQueryResultDto.setStartTime(bdProvider.getJcbdBidding().getTimeStartResponse());
                jcbdBiddingQueryResultDto.setEndTime(bdProvider.getJcbdBidding().getTimeEndResponse());
                List jcbdBiddingDemands = this.jcbdBiddingDemandRepo.findByJcbdBiddingIdAndIsDelete(bdProvider.getJcbdBidding().getId(), false);
                if (!Lang.isEmpty((Object)jcbdBiddingDemands)) {
                    jcbdBiddingQueryResultDto.setNeedNum(Integer.valueOf(jcbdBiddingDemands.size()));
                } else {
                    jcbdBiddingQueryResultDto.setNeedNum(Integer.valueOf(0));
                }
                jcbdBiddingQueryResultDto.setState(bdProvider.getStatus());
                BiddingStatus biddingStatus = (BiddingStatus)BiddingStatus.biddingStatusMap.get(bdProvider.getStatus());
                if (biddingStatus != null) {
                    jcbdBiddingQueryResultDto.setStateName(biddingStatus.getDescription());
                }
                ArrayList jcbdRoleOperationDtoList = new ArrayList();
                List operationDtos = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex("BIDDING_SUPPLIER", bdProvider.getStatus());
                if (!Lang.isEmpty((Object)operationDtos)) {
                    jcbdRoleOperationDtoList.addAll(BeanMapper.mapList((Iterable)operationDtos, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                }
                for (JcbdRoleOperationDto jcbdRoleOperationDto : jcbdRoleOperationDtoList) {
                    String url = jcbdRoleOperationDto.getUrl();
                    if (url != null && !"".equals(url)) {
                        url = url + "?biddingNo=" + jcbdBiddingQueryResultDto.getJcbdBiddingNo();
                    }
                    jcbdRoleOperationDto.setUrl(url);
                }
                jcbdBiddingQueryResultDto.setOperations(jcbdRoleOperationDtoList);
                jcbdBiddingQueryResultDtoList.add(jcbdBiddingQueryResultDto);
            }
        }
        return new PageImpl(jcbdBiddingQueryResultDtoList, (Pageable)new PageRequest(jcbdBdProviders.getNumber(), jcbdBdProviders.getSize(), jcbdBdProviders.getSort()), jcbdBdProviders.getTotalElements());
    }

    @Transactional(readOnly=true)
    public BaseResponse<Page<BiddingDemandQueryDto>> getBiddingDemandList(BiddingDemandListQuery biddingDemandListQuery) {
        log.info("\u7ecf\u529e\u4eba\u7f16\u8f91\u5ba1\u6838-\u7ade\u4ef7\u9700\u6c42\u67e5\u8be2-\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)biddingDemandListQuery));
        if (Lang.isEmpty((Object)biddingDemandListQuery)) {
            BaseResponse baseResponse = new BaseResponse(false, "\u7ecf\u529e\u4eba\u7f16\u8f91\u5ba1\u6838-\u7ade\u4ef7\u9700\u6c42\u67e5\u8be2-\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)biddingDemandListQuery.getBiddingCode())) {
            BaseResponse baseResponse = new BaseResponse(false, "\u7ecf\u529e\u4eba\u7f16\u8f91\u5ba1\u6838-\u7ade\u4ef7\u9700\u6c42\u67e5\u8be2-\u7ade\u4ef7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)biddingDemandListQuery.getPageable())) {
            BaseResponse baseResponse = new BaseResponse(false, "\u7ecf\u529e\u4eba\u7f16\u8f91\u5ba1\u6838-\u7ade\u4ef7\u9700\u6c42\u67e5\u8be2-\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        try {
            JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingDemandListQuery.getBiddingCode(), false);
            if (Lang.isEmpty((Object)jcbdBidding)) {
                BaseResponse baseResponse = new BaseResponse(false, "\u7ade\u4ef7\u4e0d\u5b58\u5728");
                log.error("\u7ade\u4ef7{}\u4e0d\u5b58\u5728", (Object)biddingDemandListQuery.getBiddingCode());
                return baseResponse;
            }
            JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
            biddingDemand.setJcbdBidding(jcbdBidding);
            Page biddingDemandPage = this.jcbdBiddingDemandRepo.findAll((Specification)new BiddingDemandSpecification(biddingDemand), biddingDemandListQuery.getPageable());
            List biddingDemands = biddingDemandPage.getContent();
            ArrayList<BiddingDemandQueryDto> list = new ArrayList<BiddingDemandQueryDto>();
            if (Lang.isEmpty((Object)biddingDemands)) {
                BaseResponse baseResponse = new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)new PageImpl(list, biddingDemandListQuery.getPageable(), (long)list.size()));
                return baseResponse;
            }
            for (JcbdBiddingDemand demand : biddingDemands) {
                BiddingDemandQueryDto bdqd = (BiddingDemandQueryDto)this.mapperFacade.map((Object)demand, BiddingDemandQueryDto.class);
                if (!Lang.isEmpty((Object)demand.getJcbdBiddingConformances())) {
                    bdqd.setComplianceAuditNum(Integer.valueOf(demand.getJcbdBiddingConformances().size()));
                }
                if (!Lang.isEmpty((Object)demand.getJcbdDemandAddressNums())) {
                    String addr = "";
                    for (int i = 0; i < demand.getJcbdDemandAddressNums().size(); ++i) {
                        addr = i != demand.getJcbdDemandAddressNums().size() - 1 ? addr + ((JcbdDemandAddressNum)demand.getJcbdDemandAddressNums().get(i)).getProvinceName() + ((JcbdDemandAddressNum)demand.getJcbdDemandAddressNums().get(i)).getCityName() + "," : addr + ((JcbdDemandAddressNum)demand.getJcbdDemandAddressNums().get(i)).getProvinceName() + ((JcbdDemandAddressNum)demand.getJcbdDemandAddressNums().get(i)).getCityName();
                    }
                    bdqd.setDemandAddress(addr);
                }
                list.add(bdqd);
            }
            PageImpl BiddingDemandQueryDtoPage = new PageImpl(list, biddingDemandListQuery.getPageable(), (long)list.size());
            log.info("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u5217\u8868 DATA : {}", (Object)JSON.toJSONString((Object)BiddingDemandQueryDtoPage));
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", (Object)BiddingDemandQueryDtoPage);
        }
        catch (Exception e) {
            log.error("\u7ecf\u529e\u4eba\u7f16\u8f91\u5ba1\u6838-\u7ade\u4ef7\u9700\u6c42\u67e5\u8be2\u5f02\u5e38, \u7ade\u4ef7\u7f16\u53f7 {} ", (Object)biddingDemandListQuery.getBiddingCode(), (Object)e);
            return new BaseResponse(false, "\u7ade\u4ef7\u9700\u6c42\u5217\u8868\u67e5\u8be2\u5f02\u5e38", null);
        }
    }

    @Transactional(readOnly=true)
    public BaseResponse<JcbdBiddingDemandDto> getBiddingDemandInfo(String demandCode) {
        if (Lang.isEmpty((Object)demandCode)) {
            return new BaseResponse(false, "\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        }
        JcbdBiddingDemand jcbdBiddingDemand = this.jcbdBiddingDemandRepo.findByDemandCodeAndIsDelete(demandCode, false);
        JcbdBiddingDemandDto jcbdBiddingDemandDto = null;
        if (!Lang.isEmpty((Object)jcbdBiddingDemand)) {
            jcbdBiddingDemandDto = (JcbdBiddingDemandDto)this.mapperFacade.map((Object)jcbdBiddingDemand, JcbdBiddingDemandDto.class);
        }
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", jcbdBiddingDemandDto);
    }

    @Transactional(readOnly=true)
    public BaseResponse<JcbdBiddingDto> getBiddingByBiddingCode(String biddingCode) {
        if (Lang.isEmpty((Object)biddingCode)) {
            return new BaseResponse(false, "\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        JcbdBiddingDto jcbdBiddingDto = null;
        if (!Lang.isEmpty((Object)jcbdBidding)) {
            jcbdBiddingDto = (JcbdBiddingDto)this.mapperFacade.map((Object)jcbdBidding, JcbdBiddingDto.class);
        }
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", jcbdBiddingDto);
    }

    private Specification getSpecificationForOperator(JcbdBiddingQueryDto jcbdBiddingQueryDto) {
        return (root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(criteriaBuilder.equal((Expression)root.get("isDelete"), (Object)false));
            if (jcbdBiddingQueryDto.getDescribe() != null) {
                predicates.add(criteriaBuilder.like((Expression)root.get("jcbdBidding").get("biddingDescription"), "%" + jcbdBiddingQueryDto.getDescribe() + "%"));
            }
            if (jcbdBiddingQueryDto.getStartTime() != null) {
                predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("jcbdBidding").get("timeStartResponse"), (Comparable)jcbdBiddingQueryDto.getStartTime()));
            }
            if (jcbdBiddingQueryDto.getEndTime() != null) {
                predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("jcbdBidding").get("timeEndResponse"), (Comparable)jcbdBiddingQueryDto.getEndTime()));
            }
            if (jcbdBiddingQueryDto.getJcbdBiddingNo() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("jcbdBidding").get("biddingCode"), (Object)jcbdBiddingQueryDto.getJcbdBiddingNo()));
            }
            if (!Lang.isEmpty((Object)jcbdBiddingQueryDto.getStates())) {
                predicates.add(root.get("status").in((Collection)jcbdBiddingQueryDto.getStates()));
            }
            if (jcbdBiddingQueryDto.getUserId() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("groupMemberId"), (Object)jcbdBiddingQueryDto.getUserId()));
            }
            if (jcbdBiddingQueryDto.getEmail() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("email"), (Object)jcbdBiddingQueryDto.getEmail()));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }

    private Specification getSpecificationForSupplier(JcbdBiddingQueryDto jcbdBiddingQueryDto) {
        return (root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(criteriaBuilder.equal((Expression)root.get("isDelete"), (Object)false));
            predicates.add(criteriaBuilder.isNotNull((Expression)root.get("status")));
            predicates.add(criteriaBuilder.equal((Expression)root.get("publish"), (Object)true));
            if (jcbdBiddingQueryDto.getDescribe() != null) {
                predicates.add(criteriaBuilder.like((Expression)root.get("jcbdBidding").get("biddingDescription"), "%" + jcbdBiddingQueryDto.getDescribe() + "%"));
            }
            if (jcbdBiddingQueryDto.getStartTime() != null) {
                predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("jcbdBidding").get("timeStartResponse"), (Comparable)jcbdBiddingQueryDto.getStartTime()));
            }
            if (jcbdBiddingQueryDto.getStartTime2() != null) {
                predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("jcbdBidding").get("timeStartResponse"), (Comparable)jcbdBiddingQueryDto.getStartTime2()));
            }
            if (jcbdBiddingQueryDto.getEndTime() != null) {
                predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("jcbdBidding").get("timeEndResponse"), (Comparable)jcbdBiddingQueryDto.getEndTime()));
            }
            if (jcbdBiddingQueryDto.getEndTime2() != null) {
                predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("jcbdBidding").get("timeEndResponse"), (Comparable)jcbdBiddingQueryDto.getStartTime2()));
            }
            if (jcbdBiddingQueryDto.getJcbdBiddingNo() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("jcbdBidding").get("biddingCode"), (Object)jcbdBiddingQueryDto.getJcbdBiddingNo()));
            }
            if (!Lang.isEmpty((Object)jcbdBiddingQueryDto.getStates())) {
                predicates.add(root.get("status").in((Collection)jcbdBiddingQueryDto.getStates()));
            }
            if (jcbdBiddingQueryDto.getProviderId() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("providerId"), (Object)jcbdBiddingQueryDto.getProviderId()));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }

    @Transactional
    public JcbdBiddingDemandDto getBiddingDemandFindOne(JcbdBiddingDemandDto jcbdBiddingDemandDto) {
        JcbdBiddingDemand jcbdBiddingDemand = this.jcbdBiddingDemandRepo.findByIdAndIsDelete(jcbdBiddingDemandDto.getId(), false);
        return (JcbdBiddingDemandDto)this.mapperFacade.map((Object)jcbdBiddingDemand, JcbdBiddingDemandDto.class);
    }

    @Transactional
    public List<ProcureInformationDto> getBiddingDemandSku(String biddingCode) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        List jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
        String dealProviderId = "";
        if (!Lang.isEmpty((Object)jcbdBdProviders)) {
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
                if (!jcbdBdProvider.getStatus().equals(BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue())) continue;
                dealProviderId = jcbdBdProvider.getId();
            }
        }
        ArrayList<ProcureInformationDto> procureInformationDtos = new ArrayList<ProcureInformationDto>();
        List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        for (JcbdBiddingDemand jcbdBiddingDemand : jcbdBiddingDemands) {
            List jcbdBiddingDemandResponses = jcbdBiddingDemand.getJcbdBiddingDemandResponses();
            for (JcbdBiddingDemandResponse jcbdBiddingDemandResponse : jcbdBiddingDemandResponses) {
                if (!jcbdBiddingDemandResponse.getResponseProviderId().equals(dealProviderId)) continue;
                ProcureInformationDto procureInformationDto = new ProcureInformationDto();
                procureInformationDto.setDemandId(jcbdBiddingDemand.getId());
                procureInformationDto.setDemandCode(jcbdBiddingDemand.getDemandCode());
                procureInformationDto.setSku(jcbdBiddingDemandResponse.getSku());
                procureInformationDto.setPrice(jcbdBiddingDemandResponse.getPrice());
                procureInformationDto.setMaxPurchaseAmount(jcbdBiddingDemand.getMaxPurchaseAmount());
                procureInformationDtos.add(procureInformationDto);
            }
        }
        return procureInformationDtos;
    }

    @Transactional
    public JcbdBiddingDto queryBidding(String biddingNo) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        return (JcbdBiddingDto)BeanMapper.map((Object)jcbdBidding, JcbdBiddingDto.class);
    }

    @Transactional(readOnly=true)
    public List<TempBatchDto> getTempBatchList(String biddingNo) {
        List jcbdTempOrders = this.jcbdTempOrderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(biddingNo, Boolean.valueOf(false));
        ArrayList<TempBatchDto> tempBatchDtos = new ArrayList<TempBatchDto>();
        DecimalFormat df = new DecimalFormat("#0.00");
        for (JcbdTempOrder jcbdTempOrder : jcbdTempOrders) {
            TempBatchDto tempBatchDto = new TempBatchDto();
            tempBatchDto.setTempOrderId(jcbdTempOrder.getId());
            List jcbdTempGoodses = jcbdTempOrder.getJcbdTempGoodses();
            ArrayList<TempBatchListDto> tempBatchListDtos = new ArrayList<TempBatchListDto>();
            for (JcbdTempGoods jcbdTempGoods : jcbdTempGoodses) {
                TempBatchListDto tempBatchListDto = new TempBatchListDto();
                tempBatchListDto.setSku(jcbdTempGoods.getSku());
                tempBatchListDto.setNum(jcbdTempGoods.getNum());
                tempBatchListDto.setPrice(jcbdTempGoods.getPrice());
                if (!Lang.isEmpty((Object)jcbdTempGoods.getNum()) && !Lang.isEmpty((Object)jcbdTempGoods.getPrice())) {
                    String totalPrice = df.format(new BigDecimal(jcbdTempGoods.getNum()).multiply(jcbdTempGoods.getPrice()).setScale(2, 0));
                    tempBatchListDto.setTotalPrice(new BigDecimal(totalPrice));
                }
                tempBatchListDto.setAddressId(jcbdTempOrder.getMemberAddressId());
                tempBatchListDtos.add(tempBatchListDto);
            }
            tempBatchDto.setTempBatchLists(tempBatchListDtos);
            tempBatchDtos.add(tempBatchDto);
        }
        return tempBatchDtos;
    }

    @Transactional(readOnly=true)
    public JcbdBdProviderDto getTransactionSupplier(String biddingNo) {
        if (Lang.isEmpty((Object)biddingNo)) {
            log.error("\u67e5\u8be2\u7ade\u4ef7\u5df2\u6210\u4ea4\u7684\u4f9b\u5e94\u5546\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        try {
            JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
            if (Lang.isEmpty((Object)jcbdBidding)) {
                log.error("\u7ade\u4ef7{}\u4e0d\u5b58\u5728", (Object)biddingNo);
                return null;
            }
            JcbdBdProvider provider = new JcbdBdProvider();
            provider.setJcbdBidding(jcbdBidding);
            provider.setStatus(BiddingStatus.SUPPLIER_BIDDING_YES.getValue());
            List providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_SKU_MAKEUP_WAIT.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_SKU_AUDIT_NOT.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                return null;
            }
            return (JcbdBdProviderDto)BeanMapper.map(providers.get(0), JcbdBdProviderDto.class);
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7\u7f16\u53f7\u4e3a{}\u67e5\u8be2\u6700\u7ec8\u6210\u4ea4\u4f9b\u5e94\u5546\u5931\u8d25", (Object)biddingNo, (Object)e);
            return null;
        }
    }

    @Transactional(readOnly=true)
    public JcbdBdProviderDto getProvider(String biddingNo, String supplierId) {
        if (Lang.isEmpty((Object)biddingNo)) {
            log.error("\u67e5\u8be2\u7ade\u4ef7\u5df2\u6210\u4ea4\u7684\u4f9b\u5e94\u5546\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        try {
            JcbdBdProvider provider = this.jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndProviderIdAndIsDelete(biddingNo, supplierId, false);
            if (Lang.isEmpty((Object)provider)) {
                log.error("\u4f9b\u5e94\u5546{}\u4e0b\u7684\u7ade\u4ef7{}\u4e0d\u5b58\u5728", (Object)supplierId, (Object)biddingNo);
                return null;
            }
            return (JcbdBdProviderDto)BeanMapper.map((Object)provider, JcbdBdProviderDto.class);
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546{}\u4e0b\u7684\u7ade\u4ef7{}\u67e5\u8be2\u5931\u8d25", new Object[]{supplierId, biddingNo, e});
            return null;
        }
    }

    @Transactional
    public List<JcbdTempOrderDto> findAllTempOrderByBiddingNo(String biddingNo) {
        List jcbdTempOrderList = this.jcbdTempOrderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(biddingNo, Boolean.valueOf(false));
        if (!Lang.isEmpty((Object)jcbdTempOrderList)) {
            return BeanMapper.mapList((Iterable)jcbdTempOrderList, JcbdTempOrder.class, JcbdTempOrderDto.class);
        }
        return null;
    }

    @Transactional(readOnly=true)
    public BaseResponse<JcbdBiddingDto> findOne(String biddingId) {
        if (Lang.isEmpty((Object)biddingId)) {
            return new BaseResponse("\u53c2\u6570\u9519\u8bef");
        }
        JcbdBidding bidding = this.jcbdBiddingRepo.findByIdAndIsDelete(biddingId, false);
        if (Lang.isEmpty((Object)bidding)) {
            return new BaseResponse("\u65e0\u6b64\u7ade\u4ef7");
        }
        return new BaseResponse(true, "", this.mapperFacade.map((Object)bidding, JcbdBiddingDto.class));
    }

    @Transactional
    public BigDecimal getBiddingGeneralBudget(String biddingNo) {
        if (StringUtils.isEmpty((CharSequence)biddingNo)) {
            return null;
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        List jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
        BigDecimal generalBudget = new BigDecimal(IS_CHECKEING);
        for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
            if (!jcbdBdProvider.getStatus().equals(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue())) continue;
            for (JcbdBiddingDemand jcbdBiddingDemand : jcbdBiddingDemands) {
                Long maxPurchaseAmount = jcbdBiddingDemand.getMaxPurchaseAmount();
                BigDecimal price = new BigDecimal(IS_CHECKEING);
                List jcbdBiddingDemandResponses = jcbdBiddingDemand.getJcbdBiddingDemandResponses();
                for (JcbdBiddingDemandResponse response : jcbdBiddingDemandResponses) {
                    if (!response.getResponseProviderId().equals(jcbdBdProvider.getId())) continue;
                    price = response.getPrice();
                }
                BigDecimal budget = price.multiply(new BigDecimal(maxPurchaseAmount));
                generalBudget = generalBudget.add(budget);
            }
        }
        return generalBudget;
    }
}

