/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl.query;

import bidding.model.po.JcbdBiddingDemand;
import bidding.model.po.JcbdBiddingDemandResponse;
import bidding.model.po.JcbdBiddingOrderItem;
import bidding.model.po.JcbdBiddingPurchaseLog;
import bidding.model.po.JcbdMallOrder;
import bidding.model.repository.JcbdBiddingDemandRespRepo;
import bidding.model.repository.JcbdBiddingPurcahseLogRepo;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.repository.JcbdOrderRepo;
import bidding.model.specification.JcbdBiddingDemandResponseSpecification;
import bidding.service.service.query.BiddingMallOrderQueryService;
import definition.BiddingOrderStatus;
import dto.BiddingOrderInfoDto;
import dto.JcbdMallOrderDto;
import java.util.Date;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;

@Service
public class BiddingMallOrderQueryServiceImpl
implements BiddingMallOrderQueryService {
    private static final Logger log = LoggerFactory.getLogger(BiddingMallOrderQueryServiceImpl.class);
    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;
    @Autowired
    JcbdBiddingPurcahseLogRepo jcbdBiddingPurcahseLogRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdOrderRepo jcbdOrderRepo;
    @Autowired
    JcbdBiddingDemandRespRepo jcbdBiddingDemandRespRepo;

    @Transactional
    public List<JcbdMallOrderDto> findByJcbdOrderId(String jcbdOrderId) {
        List jcbdMallOrders = this.jcbdMallOrderRepo.findByJcbdOrderIdAndIsDelete(jcbdOrderId, Boolean.valueOf(false));
        return this.mapperFacade.mapAsList((Iterable)jcbdMallOrders, JcbdMallOrderDto.class);
    }

    @Transactional
    public JcbdMallOrderDto updateStatusByOrderNo(String status, String orderNo) {
        JcbdMallOrder jcbdMallOrder = this.jcbdMallOrderRepo.findByOrderNo(orderNo);
        jcbdMallOrder.setStatus(BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode());
        jcbdMallOrder.setSupplierOrderStatus(BiddingOrderStatus.SUPPLIER_ORDER_STATUS_CANCELLED.getCode());
        jcbdMallOrder.setLastUpdated(new Date());
        JcbdMallOrder save = (JcbdMallOrder)this.jcbdMallOrderRepo.save((Object)jcbdMallOrder);
        return (JcbdMallOrderDto)this.mapperFacade.map((Object)save, JcbdMallOrderDto.class);
    }

    @Transactional
    public JcbdMallOrderDto deleteJcbdMallOrderByOrderNo(String orderNo) {
        JcbdMallOrder jcbdMallOrder = this.jcbdMallOrderRepo.findByOrderNo(orderNo);
        jcbdMallOrder.setIsDelete(Boolean.valueOf(true));
        JcbdMallOrder save = (JcbdMallOrder)this.jcbdMallOrderRepo.save((Object)jcbdMallOrder);
        return (JcbdMallOrderDto)this.mapperFacade.map((Object)save, JcbdMallOrderDto.class);
    }

    public BiddingOrderInfoDto getOrderInfoByOrderNo(String orderNo) {
        JcbdMallOrder jcbdMallOrder = this.jcbdMallOrderRepo.findByOrderNoAndIsDelete(orderNo, false);
        if (Lang.isEmpty((Object)jcbdMallOrder)) {
            return null;
        }
        return new BiddingOrderInfoDto(jcbdMallOrder.getJcbdOrder().getOrderType(), jcbdMallOrder.getJcbdOrder().getSupplierName(), jcbdMallOrder.getJcbdOrder().getCompanyName(), jcbdMallOrder.getJcbdOrder().getBdOrderNo());
    }

    @Transactional
    public JcbdMallOrderDto findByOrderNo(String orderNo) {
        JcbdMallOrder mallOrderPO = this.jcbdMallOrderRepo.findByOrderNo(orderNo);
        if (Lang.isEmpty((Object)mallOrderPO)) {
            return null;
        }
        JcbdMallOrderDto mallOrder = (JcbdMallOrderDto)this.mapperFacade.map((Object)mallOrderPO, JcbdMallOrderDto.class);
        if (!Lang.isEmpty((Object)mallOrderPO.getJcbdOrder())) {
            mallOrder.setJdbdOrderId(mallOrderPO.getJcbdOrder().getId());
        }
        return mallOrder;
    }

    public void updateStatusAndSupplierStatus(String mallOrderNo, String status, String supplierOrderStatus) {
        JcbdMallOrder mallOrder = this.jcbdMallOrderRepo.findByOrderNo(mallOrderNo);
        mallOrder.setStatus(status);
        mallOrder.setSupplierOrderStatus(supplierOrderStatus);
        this.jcbdMallOrderRepo.save((Object)mallOrder);
    }

    @Transactional
    public void cancelPurchaseLogOrder(String orderNo) {
        JcbdMallOrder mallOrder = this.jcbdMallOrderRepo.findByOrderNo(orderNo);
        String supplierId = mallOrder.getJcbdOrder().getSupplierId();
        List jcbdBiddingOrderItems = mallOrder.getJcbdBiddingOrderItems();
        for (JcbdBiddingOrderItem jcbdBiddingOrderItem : jcbdBiddingOrderItems) {
            String sku = jcbdBiddingOrderItem.getSku();
            Integer count = jcbdBiddingOrderItem.getCount();
            JcbdBiddingDemandResponseSpecification specification = new JcbdBiddingDemandResponseSpecification(supplierId, sku);
            List jcbdBiddingDemandResponses = this.jcbdBiddingDemandRespRepo.findAll((Specification)specification);
            if (Lang.isEmpty((Object)jcbdBiddingDemandResponses)) continue;
            JcbdBiddingDemand jcbdBiddingDemand = ((JcbdBiddingDemandResponse)jcbdBiddingDemandResponses.get(0)).getJcbdBiddingDemand();
            JcbdBiddingPurchaseLog jcbdBiddingPurchaseLog = new JcbdBiddingPurchaseLog();
            jcbdBiddingPurchaseLog.setJcbdBiddingDemand(jcbdBiddingDemand);
            jcbdBiddingPurchaseLog.setSku(sku);
            jcbdBiddingPurchaseLog.setNumberBuy(Integer.valueOf(-count.intValue()));
            this.jcbdBiddingPurcahseLogRepo.save((Object)jcbdBiddingPurchaseLog);
        }
    }
}

