/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl.query;

import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingPurchaseLog;
import bidding.model.po.JcbdMallOrder;
import bidding.model.po.JcbdOrder;
import bidding.model.po.JcbdTempOrder;
import bidding.model.repository.JcbdBiddingPurchaseLogRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.repository.JcbdOrderRepo;
import bidding.model.repository.JcbdTempOrderRepo;
import bidding.model.specification.JcbdPurchaseLogSpecification;
import bidding.service.service.query.BiddingOrderQueryService;
import definition.BiddingOrderStatus;
import dto.BiddingOrderAffiliationDto;
import dto.BiddingOrderOutlineInfoDto;
import dto.JcbdBiddingPurchaseLogDto;
import dto.JcbdOrderDto;
import dto.JcbdTempOrderDto;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.data.BeanMapper;

@Service
public class BiddingOrderQueryServiceImpl
implements BiddingOrderQueryService {
    private static final Logger log = LoggerFactory.getLogger(BiddingOrderQueryServiceImpl.class);
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    JcbdOrderRepo jcbdOrderRepo;
    @Autowired
    JcbdBiddingPurchaseLogRepo jcbdBiddingPurchaseLogRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdTempOrderRepo jcbdTempOrderRepo;
    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;

    @Transactional
    public List<JcbdOrderDto> findByJcbdBiddingId(String biddingCode) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        List jcbdOrders = this.jcbdOrderRepo.findByJcbdBiddingId(jcbdBidding.getId());
        return this.mapperFacade.mapAsList((Iterable)jcbdOrders, JcbdOrderDto.class);
    }

    @Transactional
    public List<JcbdOrderDto> findAllByBiddingCode(String biddingCode) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingCode, false);
        List jcbdOrderList = this.jcbdOrderRepo.findByJcbdBiddingId(jcbdBidding.getId());
        return this.mapperFacade.mapAsList((Iterable)jcbdOrderList, JcbdOrderDto.class);
    }

    @Transactional
    public List<JcbdBiddingPurchaseLogDto> findPurchaseLogs(JcbdBiddingPurchaseLogDto jcbdBiddingPurchaseLogDto) {
        JcbdBiddingPurchaseLog purchaseLog = (JcbdBiddingPurchaseLog)this.mapperFacade.map((Object)jcbdBiddingPurchaseLogDto, JcbdBiddingPurchaseLog.class);
        List purchaseLogs = this.jcbdBiddingPurchaseLogRepo.findAll((Specification)new JcbdPurchaseLogSpecification(purchaseLog));
        return this.mapperFacade.mapAsList((Iterable)purchaseLogs, JcbdBiddingPurchaseLogDto.class);
    }

    @Transactional
    public BiddingOrderAffiliationDto checkIsBiddingOrder(String parentOrderNo) {
        JcbdOrder jcbdOrder = this.jcbdOrderRepo.findByBdOrderNo(parentOrderNo);
        BiddingOrderAffiliationDto biddingOrderAffiliationDto = new BiddingOrderAffiliationDto();
        if (jcbdOrder != null) {
            biddingOrderAffiliationDto.setBiddingOrderNo(jcbdOrder.getBdOrderNo());
            biddingOrderAffiliationDto.setIsBiddingOrder(Boolean.valueOf(true));
            List mallOrders = jcbdOrder.getJcbdMallOrders();
            ArrayList<String> orderNos = new ArrayList<String>();
            for (JcbdMallOrder mallOrder : mallOrders) {
                if (StringUtils.equals((CharSequence)BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode(), (CharSequence)mallOrder.getStatus()) || mallOrder.getIsDelete().booleanValue()) continue;
                orderNos.add(mallOrder.getOrderNo());
            }
            biddingOrderAffiliationDto.setOrderNos(orderNos);
        }
        return biddingOrderAffiliationDto;
    }

    @Transactional
    public JcbdOrderDto findJcbdOrder(String bdOrderNo) {
        JcbdOrder jcbdOrder = this.jcbdOrderRepo.findByBdOrderNo(bdOrderNo);
        if (jcbdOrder != null) {
            JcbdOrderDto jcbdOrderDto = (JcbdOrderDto)BeanMapper.map((Object)jcbdOrder, JcbdOrderDto.class);
            return jcbdOrderDto;
        }
        return null;
    }

    @Transactional
    public List<JcbdTempOrderDto> findTempOrderByBiddingCode(String biddingCode) {
        List jcbdTempOrders = this.jcbdTempOrderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(biddingCode, Boolean.valueOf(false));
        return BeanMapper.mapList((Iterable)jcbdTempOrders, JcbdTempOrder.class, JcbdTempOrderDto.class);
    }

    public BiddingOrderOutlineInfoDto findOrderOutlineInfo(String orderNo) {
        JcbdOrder jcbdOrder = this.jcbdOrderRepo.findByBdOrderNo(orderNo);
        BiddingOrderOutlineInfoDto biddingOrderOutlineInfoDto = new BiddingOrderOutlineInfoDto();
        biddingOrderOutlineInfoDto.setOrderNo(jcbdOrder.getBdOrderNo());
        biddingOrderOutlineInfoDto.setCreateTime(new SimpleDateFormat("YYYY-MM-DD HH:mm:ss").format(jcbdOrder.getDateCreated()));
        biddingOrderOutlineInfoDto.setSumPrice(jcbdOrder.getTotalMoney());
        biddingOrderOutlineInfoDto.setFreight(jcbdOrder.getFreight());
        biddingOrderOutlineInfoDto.setOperatorName(jcbdOrder.getJcbdBidding().getOperatorName());
        biddingOrderOutlineInfoDto.setSupplierId(jcbdOrder.getSupplierId());
        biddingOrderOutlineInfoDto.setSupplierName(jcbdOrder.getSupplierName());
        biddingOrderOutlineInfoDto.setStatus(((BiddingOrderStatus)BiddingOrderStatus.biddingOrderStatusMap.get(jcbdOrder.getStatus())).getCode());
        return biddingOrderOutlineInfoDto;
    }

    @Transactional(readOnly=true)
    public JcbdOrderDto findById(String id) {
        return (JcbdOrderDto)this.mapperFacade.map(this.jcbdOrderRepo.findOne((Serializable)((Object)id)), JcbdOrderDto.class);
    }

    public BaseResponse queryBiddingOrderNoByMallOrderNo(String mallOrderNo) {
        JcbdMallOrder mallOrder = this.jcbdMallOrderRepo.findByOrderNo(mallOrderNo);
        if (mallOrder != null) {
            return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)mallOrder.getJcbdOrder().getBdOrderNo());
        }
        return new BaseResponse(false, "\u6ca1\u627e\u5230\u5bf9\u5e94\u7ade\u4ef7\u5546\u57ce\u8ba2\u5355");
    }

    @Transactional
    public JcbdOrderDto updateStatus(String orderNo, String status) {
        JcbdOrder byBdOrderNo = this.jcbdOrderRepo.findByBdOrderNo(orderNo);
        byBdOrderNo.setStatus(status);
        JcbdOrder order = (JcbdOrder)this.jcbdOrderRepo.save((Object)byBdOrderNo);
        return (JcbdOrderDto)this.mapperFacade.map((Object)order, JcbdOrderDto.class);
    }
}

