/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl.query;

import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.specification.BiddingSpecification;
import bidding.service.service.query.BiddingQueryService;
import dto.JcbdBdProviderDto;
import dto.JcbdBiddingDto;
import dto.JcbdBiddingGroupMemberDto;
import java.util.ArrayList;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingQueryServiceImpl
implements BiddingQueryService {
    private static final Logger log = LoggerFactory.getLogger(BiddingQueryServiceImpl.class);
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;

    @Transactional(rollbackFor={Exception.class})
    public JcbdBiddingDto findByBiddingCodeAndIsDelete(String biddingCode) {
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setBiddingCode(biddingCode);
        JcbdBidding bidding = (JcbdBidding)this.jcbdBiddingRepo.findOne((Specification)new BiddingSpecification(jcbdBidding));
        return (JcbdBiddingDto)this.mapperFacade.map((Object)bidding, JcbdBiddingDto.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<JcbdBdProviderDto> findByBiddingNoAndStatus(String biddingNo, String status) {
        List jcbdBdProviderInfos = this.jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndStatusAndIsDelete(biddingNo, status, false);
        ArrayList<JcbdBdProviderDto> jcbdBdProviderDtos = new ArrayList<JcbdBdProviderDto>();
        if (!Lang.isEmpty((Object)jcbdBdProviderInfos)) {
            for (JcbdBdProvider jcbdBdProviderInfo : jcbdBdProviderInfos) {
                JcbdBdProviderDto map = (JcbdBdProviderDto)BeanMapper.map((Object)jcbdBdProviderInfo, JcbdBdProviderDto.class);
                jcbdBdProviderDtos.add(map);
            }
        }
        return jcbdBdProviderDtos;
    }

    public JcbdBiddingGroupMemberDto findGroupStatus(String email, String biddingId) {
        JcbdBiddingGroupMember jcbdBiddingGroupMember = this.jcbdBiddingGroupMemberRepo.findByEmailAndJcbdBiddingIdAndIsDelete(email, biddingId, false);
        return (JcbdBiddingGroupMemberDto)BeanMapper.map((Object)jcbdBiddingGroupMember, JcbdBiddingGroupMemberDto.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<JcbdBiddingDto> findAllJcbdBidding() {
        List jcbdBiddingList = this.jcbdBiddingRepo.findAll((Specification)new BiddingSpecification());
        return this.mapperFacade.mapAsList((Iterable)jcbdBiddingList, JcbdBiddingDto.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<JcbdBiddingDto> findJcbdBiddingByBiddingNo(List<String> binddingNos) {
        List jcbdBiddings = this.jcbdBiddingRepo.findByBiddingCodeInAndIsDelete(binddingNos, false);
        return this.mapperFacade.mapAsList((Iterable)jcbdBiddings, JcbdBiddingDto.class);
    }
}

