/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl.query;

import bidding.model.po.JcbdBdProvider;
import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingConformance;
import bidding.model.po.JcbdBiddingDemand;
import bidding.model.po.JcbdBiddingDemandResponse;
import bidding.model.po.JcbdDemandAddressNum;
import bidding.model.po.JcbdProviderAddressResponse;
import bidding.model.po.JcbdProviderConformanceResp;
import bidding.model.po.JcbdStoreContacts;
import bidding.model.repository.JcbdBdProviderRepo;
import bidding.model.repository.JcbdBiddingConformanceRepo;
import bidding.model.repository.JcbdBiddingDemandRepo;
import bidding.model.repository.JcbdBiddingDemandRespRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdDemandAddressNumRepo;
import bidding.model.repository.JcbdProviderAddressRespRepo;
import bidding.model.repository.JcbdProviderConformanceRespRepo;
import bidding.model.repository.JcbdStoreContactsRepo;
import bidding.model.specification.BiddingConformanceSpecification;
import bidding.model.specification.BiddingDemandAddressSpecification;
import bidding.model.specification.BiddingDemandResponseSpecification;
import bidding.model.specification.BiddingDemandSpecification;
import bidding.model.specification.BiddingProviderAddRespSpecification;
import bidding.model.specification.BiddingProviderConformanceRespSpec;
import bidding.model.specification.BiddingProviderSpecification;
import bidding.service.service.query.BiddingResponseQueryService;
import com.alibaba.fastjson.JSON;
import definition.BiddingDemandResStatus;
import definition.BiddingStatus;
import definition.ProviderConformanceRespStatus;
import dto.BiddingPriceParityDto;
import dto.BiddingResponseDemandOutlineDto;
import dto.BiddingResponseOutlineDto;
import dto.BiddingResponseResultDto;
import dto.BiddingResultDemandQueryDto;
import dto.BiddingResultSupplierInfoQueryDto;
import dto.BiddingSupplierContactDTO;
import dto.BiddingSupplierDTO;
import dto.DemanResponseParmDto;
import dto.DemandResponseQueryDto;
import dto.JcbdBdProviderDto;
import dto.JcbdBiddingDemandDto;
import dto.JcbdBiddingDemandResponseDto;
import dto.JcbdProviderAddressResponseDto;
import dto.JcbdProviderConformanceRespDto;
import dto.PriceParityInfoDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import query.BiddingDemandListQuery;
import query.BiddingDemandRespQuery;
import query.SupplierBiddingDamandQuery;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingResponseQueryServiceImpl
implements BiddingResponseQueryService {
    private static final Logger log = LoggerFactory.getLogger(BiddingResponseQueryServiceImpl.class);
    public static final String ACCORD_DEMAND = "\u6ee1\u8db3\u9700\u6c42";
    public static final String NOT_ACCORD_DEMAND = "\u4e0d\u6ee1\u8db3\u9700\u6c42";
    private static final String MAX_PURCHASE_AMOUNT_DESC = "\u6700\u9ad8\u91c7\u8d2d\u6570\u91cf";
    private static final String MIN_PURCHASE_AMOUNT_DESC = "\u6700\u4f4e\u91c7\u8d2d\u6570\u91cf";
    private static final String SUPPLIER_QUOTEDPRICE_OK = "\u5df2\u62a5\u4ef7";
    private static final String SUPPLIER_QUOTEDPRICE_NO = "\u672a\u62a5\u4ef7";
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;
    @Autowired
    JcbdBiddingDemandRespRepo jcbdBiddingDemandRespRepo;
    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;
    @Autowired
    JcbdBiddingConformanceRepo jcbdBiddingConformanceRepo;
    @Autowired
    JcbdDemandAddressNumRepo jcbdDemandAddressNumRepo;
    @Autowired
    JcbdProviderAddressRespRepo jcbdProviderAddressRespRepo;
    @Autowired
    JcbdProviderConformanceRespRepo jcbdProviderConformanceRespRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    JcbdStoreContactsRepo jcbdStoreContactsRepo;

    @Transactional(readOnly=true)
    public BaseResponse<BiddingResultSupplierInfoQueryDto> getBiddingResultSupplierInfo(String demandCode) {
        if (Lang.isEmpty((Object)demandCode)) {
            return new BaseResponse(false, "\u9700\u6c42\u7f16\u53f7\u4e3a\u7a7a", null);
        }
        JcbdBiddingDemand jbd = this.jcbdBiddingDemandRepo.findByDemandCodeAndIsDelete(demandCode, false);
        JcbdBidding jcbdBidding = jbd.getJcbdBidding();
        List jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
        ArrayList<JcbdBdProvider> noJcBdProviders = new ArrayList<JcbdBdProvider>();
        for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
            if (!jcbdBdProvider.getStatus().equals(BiddingStatus.SUPPLIER_BIDDING_NOT.getValue()) && !jcbdBdProvider.getStatus().equals(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue())) continue;
            noJcBdProviders.add(jcbdBdProvider);
        }
        jcbdBdProviders.removeAll(noJcBdProviders);
        JcbdBdProvider provider = null;
        if (!Lang.isEmpty((Object)jcbdBdProviders)) {
            provider = (JcbdBdProvider)jcbdBdProviders.get(0);
        }
        BiddingResultSupplierInfoQueryDto brsi = new BiddingResultSupplierInfoQueryDto();
        brsi.setDemandCode(demandCode);
        brsi.setSupplierId(provider.getProviderId());
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)brsi);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BaseResponse<List<BiddingResponseOutlineDto>> queryBiddingResponseOutline(String biddingNo, String demandCode) {
        log.info("BiddingResponseQueryServiceImpl.queryBiddingResponseOutline\u8bf7\u6c42\u53c2\u6570biddingCode:{},demandCode:{}", (Object)biddingNo, (Object)demandCode);
        if (Lang.isEmpty((Object)biddingNo) || Lang.isEmpty((Object)demandCode)) {
            return new BaseResponse("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty((Object)bidding)) {
            return new BaseResponse("\u7ade\u4ef7\u6570\u636e\u4e3a\u7a7a!");
        }
        JcbdBiddingDemand jcbdBiddingDemand = this.jcbdBiddingDemandRepo.findByDemandCodeAndIsDelete(demandCode, false);
        JcbdBiddingDemandResponse biddingDemandResponse = new JcbdBiddingDemandResponse();
        biddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);
        List demandResponseList = this.jcbdBiddingDemandRespRepo.findAll((Specification)new BiddingDemandResponseSpecification(biddingDemandResponse));
        ArrayList<BiddingResponseOutlineDto> biddingOutlineDtoList = null;
        if (!Lang.isEmpty((Object)demandResponseList)) {
            biddingOutlineDtoList = new ArrayList<BiddingResponseOutlineDto>(demandResponseList.size());
            for (JcbdBiddingDemandResponse demandResponse : demandResponseList) {
                BiddingResponseOutlineDto biddingResponseOutlineDto = new BiddingResponseOutlineDto();
                String responseProviderId = demandResponse.getResponseProviderId();
                JcbdBdProvider provider = this.jcbdBdProviderRepo.findByIdAndIsDelete(responseProviderId, false);
                JcbdBdProviderDto jcbdBdProviderDto = (JcbdBdProviderDto)this.mapperFacade.map((Object)provider, JcbdBdProviderDto.class);
                biddingResponseOutlineDto.setSupplierId(jcbdBdProviderDto.getProviderId());
                String status = jcbdBdProviderDto.getStatus();
                if (Lang.isEmpty((Object)status) || BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue().equals(status)) {
                    biddingResponseOutlineDto.setResponseStatus(BiddingStatus.SUPPLIER_RESPONSE_NOT.getDescription());
                } else if (this.demandResponseIsAllAccord(biddingNo, responseProviderId).isSuccess()) {
                    biddingResponseOutlineDto.setResponseStatus(ACCORD_DEMAND);
                } else {
                    biddingResponseOutlineDto.setResponseStatus(NOT_ACCORD_DEMAND);
                }
                biddingResponseOutlineDto.setSupplierName(jcbdBdProviderDto.getProviderName());
                biddingOutlineDtoList.add(biddingResponseOutlineDto);
            }
        }
        log.info("BiddingResponseQueryServiceImpl.queryBiddingResponseOutline \u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString(biddingOutlineDtoList));
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f!", biddingOutlineDtoList);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BaseResponse<Page<BiddingResponseDemandOutlineDto>> supplierBiddingResponseDemandOutline(SupplierBiddingDamandQuery supplierBiddingDamandQuery) {
        log.info("BiddingResponseServiceImpl.findSupplierBiddingResponse\u8bf7\u6c42\u53c2\u6570 {}", (Object)supplierBiddingDamandQuery);
        if (Lang.isEmpty((Object)supplierBiddingDamandQuery)) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u4f9b\u5e94\u5546\u7ade\u4ef7\u54cd\u5e94\u5217\u8868\u5931\u8d25:\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
            log.info("BiddingResponseServiceImpl.findSupplierBiddingResponse:" + baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)supplierBiddingDamandQuery.getBiddingCode())) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u4f9b\u5e94\u5546\u7ade\u4ef7\u54cd\u5e94\u5217\u8868\u5931\u8d25:\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a!");
            log.info("BiddingResponseServiceImpl.findSupplierBiddingResponse:" + baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)supplierBiddingDamandQuery.getPageable())) {
            BaseResponse baseResponse = new BaseResponse("\u83b7\u53d6\u4f9b\u5e94\u5546\u7ade\u4ef7\u54cd\u5e94\u5217\u8868\u5931\u8d25:\u5206\u9875\u53c2\u6570\u4e3a\u7a7a!");
            log.info("BiddingResponseServiceImpl.findSupplierBiddingResponse:" + baseResponse.getResultMessage());
            return baseResponse;
        }
        try {
            JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(supplierBiddingDamandQuery.getBiddingCode(), false);
            if (Lang.isEmpty((Object)bidding)) {
                return new BaseResponse("\u7ade\u4ef7\u6570\u636e\u4e3a\u7a7a!");
            }
            JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
            biddingDemand.setJcbdBidding(bidding);
            Page biddingDemandPage = this.jcbdBiddingDemandRepo.findAll((Specification)new BiddingDemandSpecification(biddingDemand), supplierBiddingDamandQuery.getPageable());
            List jcbdBiddingDemandList = biddingDemandPage.getContent();
            if (Lang.isEmpty((Object)jcbdBiddingDemandList)) {
                log.info("BiddingResponseServiceImpl.findSupplierBiddingResponse:\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u5217\u8868\u4e3a\u7a7a!");
                return new BaseResponse("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u5217\u8868\u4e3a\u7a7a!");
            }
            JcbdBdProvider jcbdBdProvider = null;
            if (!Lang.isEmpty((Object)supplierBiddingDamandQuery.getSupplierId())) {
                jcbdBdProvider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(bidding.getId(), supplierBiddingDamandQuery.getSupplierId(), Boolean.valueOf(false));
            }
            ArrayList<BiddingResponseDemandOutlineDto> biddingResponseDemandOutlineDtos = new ArrayList<BiddingResponseDemandOutlineDto>();
            for (JcbdBiddingDemand jcbdBiddingDemand : jcbdBiddingDemandList) {
                BiddingResponseDemandOutlineDto biddingResponseDemandOutlineDto = new BiddingResponseDemandOutlineDto();
                biddingResponseDemandOutlineDto.setDemandId(jcbdBiddingDemand.getId());
                biddingResponseDemandOutlineDto.setDemandNo(jcbdBiddingDemand.getDemandCode());
                biddingResponseDemandOutlineDto.setGoodsModel(jcbdBiddingDemand.getGoodsModel());
                biddingResponseDemandOutlineDto.setGoodsBrand(jcbdBiddingDemand.getGoodsBrand());
                biddingResponseDemandOutlineDto.setSpecification(jcbdBiddingDemand.getSpecification());
                biddingResponseDemandOutlineDto.setGoodsDesription(jcbdBiddingDemand.getGoodsDesription());
                biddingResponseDemandOutlineDto.setHighestPurchaseNumber(jcbdBiddingDemand.getMaxPurchaseAmount());
                biddingResponseDemandOutlineDto.setLowestPurchaseNumber(jcbdBiddingDemand.getMinPurchaseAmount());
                biddingResponseDemandOutlineDto.setRequiredDeliveryDate(jcbdBiddingDemand.getDateRequiredDelivery());
                JcbdBiddingConformance jcbdBiddingConformance = new JcbdBiddingConformance();
                jcbdBiddingConformance.setJcbdBiddingDemand(jcbdBiddingDemand);
                Long accordCheckCount = this.jcbdBiddingConformanceRepo.count((Specification)new BiddingConformanceSpecification(jcbdBiddingConformance));
                biddingResponseDemandOutlineDto.setConformanceNumber(Integer.valueOf(accordCheckCount.intValue()));
                JcbdDemandAddressNum jcbdDemandAddressNum = new JcbdDemandAddressNum();
                jcbdDemandAddressNum.setJcbdBiddingDemand(jcbdBiddingDemand);
                List jcbdDemandAddressNums = this.jcbdDemandAddressNumRepo.findAll((Specification)new BiddingDemandAddressSpecification(jcbdDemandAddressNum));
                StringBuffer stringBuffer = new StringBuffer();
                if (!Lang.isEmpty((Object)jcbdDemandAddressNums)) {
                    for (JcbdDemandAddressNum demandAddressNum : jcbdDemandAddressNums) {
                        stringBuffer.append(demandAddressNum.getProvinceName()).append(demandAddressNum.getCityName()).append(",");
                    }
                    biddingResponseDemandOutlineDto.setDemandAddress(stringBuffer.substring(0, stringBuffer.length() - 1));
                }
                if (!Lang.isEmpty((Object)jcbdBdProvider)) {
                    JcbdBiddingDemandResponse jcbdBiddingDemandResponse = new JcbdBiddingDemandResponse();
                    jcbdBiddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);
                    jcbdBiddingDemandResponse.setResponseProviderId(jcbdBdProvider.getId());
                    List jcbdBiddingDemandResponses = this.jcbdBiddingDemandRespRepo.findAll((Specification)new BiddingDemandResponseSpecification(jcbdBiddingDemandResponse));
                    if (jcbdBiddingDemandResponses.size() > 0) {
                        biddingResponseDemandOutlineDto.setDemandResponseStatus(BiddingDemandResStatus.DEMAND_RESPONSE_STATUS.getDescription());
                        biddingResponseDemandOutlineDto.setPrice(((JcbdBiddingDemandResponse)jcbdBiddingDemandResponses.get(0)).getPrice());
                    } else {
                        biddingResponseDemandOutlineDto.setDemandResponseStatus(BiddingDemandResStatus.NOT_DEMAND_RESPONSE_STATUS.getDescription());
                    }
                } else {
                    biddingResponseDemandOutlineDto.setResponseSupplierNumber(bidding.getProviderResponseNum());
                }
                biddingResponseDemandOutlineDtos.add(biddingResponseDemandOutlineDto);
            }
            PageImpl suppBiddingResponseDtoPage = new PageImpl(biddingResponseDemandOutlineDtos, supplierBiddingDamandQuery.getPageable(), (long)biddingResponseDemandOutlineDtos.size());
            log.info("BiddingResponseServiceImpl.findSupplierBiddingResponse \u83b7\u53d6\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)suppBiddingResponseDtoPage));
            return new BaseResponse(true, "\u83b7\u53d6\u6210\u529f", (Object)suppBiddingResponseDtoPage);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u4f9b\u5e94\u5546\u7ade\u4ef7\u54cd\u5e94\u5217\u8868\u5f02\u5e38\uff0c\u7ade\u4ef7\u7f16\u53f7 {}", (Object)supplierBiddingDamandQuery.getBiddingCode(), (Object)e);
            return new BaseResponse("\u83b7\u53d6\u4f9b\u5e94\u5546\u7ade\u4ef7\u54cd\u5e94\u5217\u8868\u5f02\u5e38!");
        }
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BaseResponse<JcbdBiddingDemandResponseDto> queryBiddingDemandResponse(BiddingDemandRespQuery biddingDemandRespQuery) {
        log.info("BiddingResponseQueryServiceImpl.queryBiddingDemandResponse\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)biddingDemandRespQuery));
        if (Lang.isEmpty((Object)biddingDemandRespQuery) || Lang.isEmpty((Object)biddingDemandRespQuery.getSupplierId()) || Lang.isEmpty((Object)biddingDemandRespQuery.getDemandCode()) || Lang.isEmpty((Object)biddingDemandRespQuery.getBiddingNo())) {
            return new BaseResponse("\u67e5\u8be2\u7ade\u4ef7\u4f9b\u5e94\u5546\u9700\u6c42\u54cd\u5e94\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        JcbdBiddingDemandResponseDto jcbdBiddingDemandResponseDto = new JcbdBiddingDemandResponseDto();
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingDemandRespQuery.getBiddingNo(), false);
        if (Lang.isEmpty((Object)bidding)) {
            return new BaseResponse("\u7ade\u4ef7\u6570\u636e\u4e3a\u7a7a!");
        }
        JcbdBiddingDemand jcbdBiddingDemand = this.jcbdBiddingDemandRepo.findByDemandCodeAndIsDelete(biddingDemandRespQuery.getDemandCode(), false);
        JcbdBiddingDemandResponse jcbdBiddingDemandResponse = new JcbdBiddingDemandResponse();
        jcbdBiddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);
        JcbdBdProvider jcbdBdProvider = new JcbdBdProvider();
        jcbdBdProvider.setProviderId(biddingDemandRespQuery.getSupplierId());
        jcbdBdProvider.setJcbdBidding(bidding);
        JcbdBdProvider provider = (JcbdBdProvider)this.jcbdBdProviderRepo.findOne((Specification)new BiddingProviderSpecification(jcbdBdProvider));
        if (!Lang.isEmpty((Object)provider)) {
            jcbdBiddingDemandResponse.setResponseProviderId(provider.getId());
            jcbdBiddingDemandResponseDto.setOfferValidity(provider.getOfferValidity());
        }
        JcbdBiddingDemandResponse biddingDemandResponse = (JcbdBiddingDemandResponse)this.jcbdBiddingDemandRespRepo.findOne((Specification)new BiddingDemandResponseSpecification(jcbdBiddingDemandResponse));
        JcbdBiddingDemandDto jcbdBiddingDemandDto = new JcbdBiddingDemandDto();
        if (!Lang.isEmpty((Object)jcbdBiddingDemand)) {
            jcbdBiddingDemandDto = (JcbdBiddingDemandDto)this.mapperFacade.map((Object)jcbdBiddingDemand, JcbdBiddingDemandDto.class);
            jcbdBiddingDemandDto.setBiddingId(bidding.getId());
            jcbdBiddingDemandDto.setBiddingCode(bidding.getBiddingCode());
        }
        if (Lang.isEmpty((Object)biddingDemandResponse)) {
            JcbdDemandAddressNum jcbdDemandAddressNum = new JcbdDemandAddressNum();
            jcbdDemandAddressNum.setJcbdBiddingDemand(jcbdBiddingDemand);
            List addressNums = this.jcbdDemandAddressNumRepo.findAll((Specification)new BiddingDemandAddressSpecification(jcbdDemandAddressNum));
            ArrayList<JcbdProviderAddressResponseDto> jcbdProviderAddressResponseDtos = new ArrayList<JcbdProviderAddressResponseDto>(addressNums.size());
            if (!Lang.isEmpty((Object)addressNums)) {
                for (JcbdDemandAddressNum addressNum : addressNums) {
                    JcbdProviderAddressResponseDto jcbdProviderAddressResponseDto = new JcbdProviderAddressResponseDto();
                    jcbdProviderAddressResponseDto.setDemandAddressId(addressNum.getId());
                    jcbdProviderAddressResponseDto.setContent(addressNum.getProvinceName() + addressNum.getCityName());
                    jcbdProviderAddressResponseDto.setNumberNeed(addressNum.getNumberNeed());
                    jcbdProviderAddressResponseDtos.add(jcbdProviderAddressResponseDto);
                }
            }
            JcbdProviderAddressResponseDto minPurchaseAmount = new JcbdProviderAddressResponseDto();
            minPurchaseAmount.setContent(MIN_PURCHASE_AMOUNT_DESC);
            minPurchaseAmount.setNumberNeed(jcbdBiddingDemand.getMinPurchaseAmount());
            JcbdProviderAddressResponseDto maxPurchaseAmount = new JcbdProviderAddressResponseDto();
            maxPurchaseAmount.setNumberNeed(jcbdBiddingDemand.getMaxPurchaseAmount());
            maxPurchaseAmount.setContent(MAX_PURCHASE_AMOUNT_DESC);
            jcbdProviderAddressResponseDtos.add(minPurchaseAmount);
            jcbdProviderAddressResponseDtos.add(maxPurchaseAmount);
            jcbdBiddingDemandResponseDto.setJcbdProviderAddressResponses(jcbdProviderAddressResponseDtos);
            JcbdBiddingConformance jcbdBiddingConformance = new JcbdBiddingConformance();
            jcbdBiddingConformance.setJcbdBiddingDemand(jcbdBiddingDemand);
            List jcbdBiddingConformances = this.jcbdBiddingConformanceRepo.findAll((Specification)new BiddingConformanceSpecification(jcbdBiddingConformance));
            if (!Lang.isEmpty((Object)jcbdBiddingConformances)) {
                ArrayList<JcbdProviderConformanceRespDto> jcbdProviderConformanceResDtos = new ArrayList<JcbdProviderConformanceRespDto>(jcbdBiddingConformances.size());
                for (JcbdBiddingConformance biddingConformance : jcbdBiddingConformances) {
                    JcbdProviderConformanceRespDto jcbdProviderConformanceRespDto = new JcbdProviderConformanceRespDto();
                    jcbdProviderConformanceRespDto.setBiddingConformanceId(biddingConformance.getId());
                    jcbdProviderConformanceRespDto.setConformance(biddingConformance.getConformance());
                    jcbdProviderConformanceResDtos.add(jcbdProviderConformanceRespDto);
                }
                jcbdBiddingDemandResponseDto.setJcbdProviderConformanceResps(jcbdProviderConformanceResDtos);
            }
        } else {
            if (!Lang.isEmpty((Object)biddingDemandResponse)) {
                jcbdBiddingDemandResponseDto = (JcbdBiddingDemandResponseDto)this.mapperFacade.map((Object)biddingDemandResponse, JcbdBiddingDemandResponseDto.class);
                if (!Lang.isEmpty((Object)biddingDemandResponse.getQouteIndate())) {
                    jcbdBiddingDemandResponseDto.setOfferValidity(biddingDemandResponse.getQouteIndate());
                }
                jcbdBiddingDemandDto.setBiddingId(bidding.getId());
                jcbdBiddingDemandDto.setBiddingCode(bidding.getBiddingCode());
            }
            JcbdProviderAddressResponse providerAddressResponse = new JcbdProviderAddressResponse();
            providerAddressResponse.setJcbdBiddingDemandResponse(biddingDemandResponse);
            List providerAddressList = this.jcbdProviderAddressRespRepo.findAll((Specification)new BiddingProviderAddRespSpecification(providerAddressResponse));
            if (!Lang.isEmpty((Object)providerAddressList)) {
                ArrayList<JcbdProviderAddressResponseDto> jcbdProviderAddressResponseDtos = new ArrayList<JcbdProviderAddressResponseDto>(providerAddressList.size());
                for (JcbdProviderAddressResponse addressResponse : providerAddressList) {
                    JcbdProviderAddressResponseDto jcbdProviderAddressResponseDto = new JcbdProviderAddressResponseDto();
                    jcbdProviderAddressResponseDto.setDemandAddressId(addressResponse.getDemandAddressId());
                    jcbdProviderAddressResponseDto.setNumberNeed(addressResponse.getNumberNeed());
                    jcbdProviderAddressResponseDto.setContent(addressResponse.getContent());
                    jcbdProviderAddressResponseDto.setRemark(addressResponse.getRemark());
                    jcbdProviderAddressResponseDto.setStatus(addressResponse.getStatus());
                    jcbdProviderAddressResponseDtos.add(jcbdProviderAddressResponseDto);
                }
                jcbdBiddingDemandResponseDto.setJcbdProviderAddressResponses(jcbdProviderAddressResponseDtos);
            }
            JcbdProviderConformanceResp providerConformanceResp = new JcbdProviderConformanceResp();
            providerConformanceResp.setJcbdBiddingDemandResponse(biddingDemandResponse);
            List providerConformanceRespList = this.jcbdProviderConformanceRespRepo.findAll((Specification)new BiddingProviderConformanceRespSpec(providerConformanceResp));
            if (!Lang.isEmpty((Object)providerConformanceRespList)) {
                ArrayList<JcbdProviderConformanceRespDto> jcbdProviderConformanceResDtos = new ArrayList<JcbdProviderConformanceRespDto>(providerConformanceRespList.size());
                for (JcbdProviderConformanceResp conformanceResp : providerConformanceRespList) {
                    JcbdProviderConformanceRespDto jcbdProviderConformanceRespDto = new JcbdProviderConformanceRespDto();
                    JcbdBiddingConformance jcbdBiddingConformance = (JcbdBiddingConformance)this.jcbdBiddingConformanceRepo.findOne((Serializable)((Object)conformanceResp.getBiddingConformanceId()));
                    jcbdProviderConformanceRespDto.setConformance(jcbdBiddingConformance.getConformance());
                    jcbdProviderConformanceRespDto.setBiddingConformanceId(jcbdBiddingConformance.getId());
                    jcbdProviderConformanceRespDto.setStatus(conformanceResp.getStatus());
                    jcbdProviderConformanceRespDto.setRemark(conformanceResp.getRemark());
                    jcbdProviderConformanceResDtos.add(jcbdProviderConformanceRespDto);
                }
                jcbdBiddingDemandResponseDto.setJcbdProviderConformanceResps(jcbdProviderConformanceResDtos);
            }
        }
        jcbdBiddingDemandResponseDto.setJcbdBiddingDemand(jcbdBiddingDemandDto);
        log.info("BiddingResponseQueryServiceImpl.queryBiddingDemandResponse\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)jcbdBiddingDemandResponseDto));
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)jcbdBiddingDemandResponseDto);
    }

    @Transactional
    public BaseResponse<BiddingPriceParityDto> queryBiddingPriceParity(String biddingNo) {
        log.info("BiddingResponseQueryServiceImpl.queryBiddingPriceParity-\u8bf7\u6c42\u53c2\u6570biddingNo {}", (Object)biddingNo);
        if (Lang.isEmpty((Object)biddingNo)) {
            return new BaseResponse("\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a!");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty((Object)jcbdBidding)) {
            return new BaseResponse("\u7ade\u4ef7\u6570\u636e\u4e3a\u7a7a!");
        }
        BiddingPriceParityDto biddingPriceParityDto = new BiddingPriceParityDto();
        List jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
        ArrayList<BiddingResponseResultDto> biddingResponseResultList = null;
        if (!Lang.isEmpty((Object)jcbdBdProviders)) {
            biddingResponseResultList = new ArrayList<BiddingResponseResultDto>(jcbdBdProviders.size());
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
                BiddingResponseResultDto biddingResponseResult = new BiddingResponseResultDto();
                biddingResponseResult.setSupllierName(jcbdBdProvider.getProviderName());
                biddingResponseResult.setProviderId(jcbdBdProvider.getProviderId());
                biddingResponseResult.setQuotePriceStatus(SUPPLIER_QUOTEDPRICE_NO);
                if (ProviderConformanceRespStatus.ACCORD.getValue().equals(jcbdBdProvider.getResponseStatus())) {
                    biddingResponseResult.setQuotePriceStatus(SUPPLIER_QUOTEDPRICE_OK);
                }
                biddingResponseResult.setConformanceStatus(ProviderConformanceRespStatus.NOT_ACCORD.getDescription());
                if (ProviderConformanceRespStatus.ACCORD.getValue().equals(jcbdBdProvider.getConformanceCheckStatus())) {
                    biddingResponseResult.setConformanceStatus(ProviderConformanceRespStatus.ACCORD.getDescription());
                }
                biddingResponseResult.setBiddingResult(jcbdBdProvider.getDealStatus());
                biddingResponseResultList.add(biddingResponseResult);
            }
        }
        JcbdBiddingDemand jcbdBiddingDemand = new JcbdBiddingDemand();
        jcbdBiddingDemand.setJcbdBidding(jcbdBidding);
        List jcbdBiddingDemandList = this.jcbdBiddingDemandRepo.findAll((Specification)new BiddingDemandSpecification(jcbdBiddingDemand));
        log.info("BiddingResponseQueryServiceImpl.queryBiddingPriceParity-\u7ade\u4ef7\u9700\u6c42\u5217\u8868\uff1a{}", (Object)jcbdBiddingDemandList);
        DecimalFormat df = new DecimalFormat("#.00");
        BigDecimal totalPrice = BigDecimal.ZERO;
        ArrayList<PriceParityInfoDto> priceParityInfoList = new ArrayList<PriceParityInfoDto>(jcbdBiddingDemandList.size());
        if (!Lang.isEmpty((Object)jcbdBiddingDemandList)) {
            for (JcbdBiddingDemand biddingDemand : jcbdBiddingDemandList) {
                List jcbdBiddingDemandResponseList = this.jcbdBiddingDemandRespRepo.findByJcbdBiddingDemandIdAndIsDelete(biddingDemand.getId(), false);
                if (Lang.isEmpty((Object)jcbdBiddingDemandResponseList)) continue;
                for (JcbdBiddingDemandResponse biddingDemandResponse : jcbdBiddingDemandResponseList) {
                    Long minPurchaseAmount;
                    PriceParityInfoDto priceParityInfo = new PriceParityInfoDto();
                    JcbdBdProvider jcbdBdProvider = (JcbdBdProvider)this.jcbdBdProviderRepo.findOne((Serializable)((Object)biddingDemandResponse.getResponseProviderId()));
                    if (!Lang.isEmpty((Object)jcbdBdProvider)) {
                        priceParityInfo.setSupllierName(jcbdBdProvider.getProviderName());
                        priceParityInfo.setSupplierStatus(jcbdBdProvider.getStatus());
                        priceParityInfo.setProviderId(jcbdBdProvider.getProviderId());
                    }
                    if ((minPurchaseAmount = biddingDemand.getMinPurchaseAmount()) == null) {
                        minPurchaseAmount = Long.parseLong("1");
                    }
                    BigDecimal price = biddingDemandResponse.getPrice();
                    if (!Lang.isEmpty((Object)minPurchaseAmount) && !Lang.isEmpty((Object)price)) {
                        totalPrice = price.multiply(new BigDecimal(df.format(minPurchaseAmount.doubleValue())));
                    }
                    priceParityInfo.setDemandNo(biddingDemand.getDemandCode());
                    priceParityInfo.setLowestPurchaseNumber(minPurchaseAmount);
                    priceParityInfo.setPrice(price);
                    priceParityInfo.setTotalPrice(totalPrice);
                    priceParityInfoList.add(priceParityInfo);
                }
            }
            List priceParityInfosDtos = this.dealPriceParityInfos(priceParityInfoList, biddingResponseResultList);
            biddingPriceParityDto.setBiddingResponseResultDtos(biddingResponseResultList);
            biddingPriceParityDto.setPriceParityInfosDtos(priceParityInfosDtos);
            log.info("BiddingResponseQueryServiceImpl.queryBiddingPriceParity \u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)biddingPriceParityDto));
        }
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f!", (Object)biddingPriceParityDto);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BaseResponse<List<BiddingSupplierDTO>> getAllSupplier(String biddingNo) {
        log.info("BiddingResponseQueryServiceImpl.getAllSupplier-\u8bf7\u6c42\u53c2\u6570biddingNo: {}", (Object)biddingNo);
        if (Lang.isEmpty((Object)biddingNo)) {
            return new BaseResponse("\u8bf7\u6c42\u53c2\u6570\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a!");
        }
        JcbdBidding bidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        JcbdBdProvider jcbdBdProvider = new JcbdBdProvider();
        jcbdBdProvider.setJcbdBidding(bidding);
        List jcbdBdProviders = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(jcbdBdProvider));
        if (Lang.isEmpty((Object)jcbdBdProviders)) {
            return new BaseResponse("BiddingResponseQueryServiceImpl.getAllSupplier-\u67e5\u8be2\u4f9b\u5e94\u5546\u5217\u8868\u4e3a\u7a7a!");
        }
        ArrayList<BiddingSupplierDTO> biddingSupplierDTOS = new ArrayList<BiddingSupplierDTO>();
        for (JcbdBdProvider provider : jcbdBdProviders) {
            BiddingSupplierDTO biddingSupplierDTO = new BiddingSupplierDTO();
            biddingSupplierDTO.setId(provider.getId());
            biddingSupplierDTO.setName(provider.getProviderName());
            List jcbdStoreContactses = this.jcbdStoreContactsRepo.findByJcbdBdProviderIdAndIsDelete(provider.getId(), false);
            if (!Lang.isEmpty((Object)jcbdStoreContactses)) {
                biddingSupplierDTO.setContacts(BeanMapper.mapList((Iterable)jcbdStoreContactses, JcbdStoreContacts.class, BiddingSupplierContactDTO.class));
            }
            biddingSupplierDTOS.add(biddingSupplierDTO);
        }
        log.info("BiddingResponseQueryServiceImpl.getAllSupplier \u67e5\u8be2\u7ed3\u679c\uff1a{}", biddingSupplierDTOS);
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", biddingSupplierDTOS);
    }

    @Transactional
    public Page<DemandResponseQueryDto> findDemandAndResponse(DemanResponseParmDto parms) {
        JcbdBidding jcbidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(parms.getBiddingNo(), false);
        String jcbiddingId = jcbidding.getId();
        String providerId = parms.getProviderId();
        JcbdBdProvider provider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbiddingId, providerId, Boolean.valueOf(false));
        ArrayList<DemandResponseQueryDto> demandResponseQueryDtos = new ArrayList<DemandResponseQueryDto>();
        Page jcbdBiddingDemands = this.jcbdBiddingDemandRepo.findByJcbdBiddingIdAndIsDelete(jcbiddingId, Boolean.valueOf(false), parms.getPageable());
        for (JcbdBiddingDemand jcbdBiddingDemand : jcbdBiddingDemands) {
            DemandResponseQueryDto demandResponseQueryDto = new DemandResponseQueryDto();
            demandResponseQueryDto.setDemandNo(jcbdBiddingDemand.getDemandCode());
            List jcbdBiddingDemandResponses = jcbdBiddingDemand.getJcbdBiddingDemandResponses();
            for (JcbdBiddingDemandResponse demandResponse : jcbdBiddingDemandResponses) {
                if (!provider.getId().equals(demandResponse.getResponseProviderId())) continue;
                demandResponseQueryDto.setSku(demandResponse.getSku());
                demandResponseQueryDto.setGoodsName(demandResponse.getGoodsTitle());
                demandResponseQueryDto.setGoodsBrand(demandResponse.getGoodsBrand());
                demandResponseQueryDto.setGoodsModel(demandResponse.getGoodsModel());
                demandResponseQueryDto.setGoodsParams(demandResponse.getGoodsParams());
                demandResponseQueryDto.setPrice(demandResponse.getPrice());
                demandResponseQueryDto.setUrl(demandResponse.getGoodsLink());
                demandResponseQueryDtos.add(demandResponseQueryDto);
            }
        }
        return new PageImpl(demandResponseQueryDtos, (Pageable)new PageRequest(jcbdBiddingDemands.getNumber(), jcbdBiddingDemands.getSize(), jcbdBiddingDemands.getSort()), jcbdBiddingDemands.getTotalElements());
    }

    @Transactional
    public List<String> findBiddingResponseSkus(String jcbdBiddingNo, String supplierId) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(jcbdBiddingNo, false);
        JcbdBdProvider provider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), supplierId, Boolean.valueOf(false));
        List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        ArrayList<String> skus = new ArrayList<String>();
        jcbdBiddingDemands.forEach(jcbdBiddingDemand -> jcbdBiddingDemand.getJcbdBiddingDemandResponses().forEach(jcbdBiddingDemandResponse -> {
            if (jcbdBiddingDemandResponse.getResponseProviderId().equals(provider.getId()) && !Lang.isEmpty((Object)jcbdBiddingDemandResponse.getSku())) {
                skus.add(jcbdBiddingDemandResponse.getSku());
            }
        }));
        return skus;
    }

    @Transactional(readOnly=true)
    public BaseResponse<Page<BiddingResultDemandQueryDto>> getBiddingResultDemandList(BiddingDemandListQuery biddingDemandListQuery) {
        log.info("\u91c7\u8d2d\u7ecf\u529e\u4eba-\u7ade\u4ef7\u7ed3\u679c\u9875\u9762\u5df2\u6210\u4ea4\u4f9b\u5e94\u5546\u54cd\u5e94\u9700\u6c42\u5217\u8868-\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)biddingDemandListQuery));
        if (Lang.isEmpty((Object)biddingDemandListQuery)) {
            BaseResponse baseResponse = new BaseResponse(false, "\u91c7\u8d2d\u7ecf\u529e\u4eba-\u7ade\u4ef7\u7ed3\u679c\u9875\u9762\u5df2\u6210\u4ea4\u4f9b\u5e94\u5546\u54cd\u5e94\u9700\u6c42\u5217\u8868-\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", null);
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)biddingDemandListQuery.getBiddingCode())) {
            BaseResponse baseResponse = new BaseResponse(false, "\u91c7\u8d2d\u7ecf\u529e\u4eba-\u7ade\u4ef7\u7ed3\u679c\u9875\u9762\u5df2\u6210\u4ea4\u4f9b\u5e94\u5546\u54cd\u5e94\u9700\u6c42\u5217\u8868-\u7ade\u4ef7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", null);
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        if (Lang.isEmpty((Object)biddingDemandListQuery.getPageable())) {
            BaseResponse baseResponse = new BaseResponse(false, "\u91c7\u8d2d\u7ecf\u529e\u4eba-\u7ade\u4ef7\u7ed3\u679c\u9875\u9762\u5df2\u6210\u4ea4\u4f9b\u5e94\u5546\u54cd\u5e94\u9700\u6c42\u5217\u8868-\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", null);
            log.error(baseResponse.getResultMessage());
            return baseResponse;
        }
        try {
            JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingDemandListQuery.getBiddingCode(), false);
            if (Lang.isEmpty((Object)jcbdBidding)) {
                BaseResponse baseResponse = new BaseResponse(false, "\u7ade\u4ef7\u4e0d\u5b58\u5728");
                log.error("\u7ade\u4ef7{}\u4e0d\u5b58\u5728", (Object)biddingDemandListQuery.getBiddingCode());
                return baseResponse;
            }
            JcbdBdProvider provider = new JcbdBdProvider();
            provider.setJcbdBidding(jcbdBidding);
            provider.setStatus(BiddingStatus.SUPPLIER_BIDDING_YES.getValue());
            List providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_SKU_MAKEUP_WAIT.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                provider.setStatus(BiddingStatus.SUPPLIER_SKU_AUDIT_NOT.getValue());
                providers = this.jcbdBdProviderRepo.findAll((Specification)new BiddingProviderSpecification(provider));
            }
            if (Lang.isEmpty((Object)providers)) {
                BaseResponse baseResponse = new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", null);
                return baseResponse;
            }
            provider = (JcbdBdProvider)providers.get(0);
            JcbdBiddingDemand biddingDemand = new JcbdBiddingDemand();
            biddingDemand.setJcbdBidding(jcbdBidding);
            Page biddingDemandPage = this.jcbdBiddingDemandRepo.findAll((Specification)new BiddingDemandSpecification(biddingDemand), biddingDemandListQuery.getPageable());
            List biddingDemands = biddingDemandPage.getContent();
            if (Lang.isEmpty((Object)biddingDemands)) {
                BaseResponse baseResponse = new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", null);
                return baseResponse;
            }
            ArrayList<BiddingResultDemandQueryDto> list = new ArrayList<BiddingResultDemandQueryDto>();
            for (JcbdBiddingDemand demand : biddingDemands) {
                JcbdBiddingDemandResponse jbdr = new JcbdBiddingDemandResponse();
                jbdr.setJcbdBiddingDemand(demand);
                jbdr.setResponseProviderId(provider.getId());
                List jbdrs = this.jcbdBiddingDemandRespRepo.findAll((Specification)new BiddingDemandResponseSpecification(jbdr));
                if (Lang.isEmpty((Object)jbdrs)) continue;
                BiddingResultDemandQueryDto brdqo = (BiddingResultDemandQueryDto)this.mapperFacade.map(jbdrs.get(0), BiddingResultDemandQueryDto.class);
                brdqo.setDemandCode(demand.getDemandCode());
                brdqo.setResponseProviderName(provider.getProviderName());
                brdqo.setGoodsTitle(demand.getGoodsDesription());
                brdqo.setGoodsBrand(demand.getGoodsBrand());
                brdqo.setGoodsModel(demand.getGoodsModel());
                brdqo.setGoodsParams(demand.getSpecification());
                list.add(brdqo);
            }
            PageImpl BiddingResultDemandQueryDtoPage = new PageImpl(list, biddingDemandListQuery.getPageable(), (long)list.size());
            log.info("\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u5217\u8868 DATA : {}", (Object)JSON.toJSONString((Object)BiddingResultDemandQueryDtoPage));
            return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", (Object)BiddingResultDemandQueryDtoPage);
        }
        catch (Exception e) {
            log.error("\u91c7\u8d2d\u7ecf\u529e\u4eba-\u7ade\u4ef7\u7ed3\u679c\u9875\u9762\u5df2\u6210\u4ea4\u4f9b\u5e94\u5546\u54cd\u5e94\u9700\u6c42\u5217\u8868, \u7ade\u4ef7\u7f16\u53f7 {} ", (Object)biddingDemandListQuery.getBiddingCode(), (Object)e);
            return new BaseResponse(false, "\u67e5\u8be2\u5f02\u5e38", null);
        }
    }

    @Transactional
    public JcbdBiddingDemandResponseDto findProviderResponsePrice(String biddingNo, String sku) {
        JcbdBiddingDemandResponse biddingDemandResponse;
        List jcbdBdProviders = this.jcbdBdProviderRepo.findByJcbdBiddingBiddingCodeAndIsDelete(biddingNo, false);
        String providerId = "";
        if (!Lang.isEmpty((Object)jcbdBdProviders)) {
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
                if (!BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue().equals(jcbdBdProvider.getStatus())) continue;
                providerId = jcbdBdProvider.getId();
                break;
            }
        }
        if (!Lang.isEmpty((Object)(biddingDemandResponse = this.jcbdBiddingDemandRespRepo.findByResponseProviderIdAndSku(providerId, sku)))) {
            return (JcbdBiddingDemandResponseDto)this.mapperFacade.map((Object)biddingDemandResponse, JcbdBiddingDemandResponseDto.class);
        }
        return null;
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BaseResponse isAllDemandAreResponse(String jcbdBiddingNo, String responseProviderId) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(jcbdBiddingNo, false);
        JcbdBdProvider jcbdBdProvider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), responseProviderId, Boolean.valueOf(false));
        List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        for (JcbdBiddingDemand jcbdBiddingDemand : jcbdBiddingDemands) {
            JcbdBiddingDemandResponse demandResponse = this.jcbdBiddingDemandRespRepo.findByJcbdBiddingDemandIdAndResponseProviderIdAndIsDelete(jcbdBiddingDemand.getId(), jcbdBdProvider.getId(), Boolean.valueOf(false));
            if (demandResponse != null) continue;
            return new BaseResponse("\u8be5\u9700\u6c42\u672a\u88ab\u5168\u90e8\u54cd\u5e94\uff01");
        }
        return new BaseResponse(true, "\u8be5\u9700\u6c42\u5df2\u7ecf\u5168\u90e8\u54cd\u5e94\uff01");
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public BaseResponse demandResponseIsAllAccord(String jcbdBiddingNo, String responseProviderId) {
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(jcbdBiddingNo, false);
        List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        for (JcbdBiddingDemand jcbdBiddingDemand : jcbdBiddingDemands) {
            List jcbdBiddingDemandResponses = jcbdBiddingDemand.getJcbdBiddingDemandResponses();
            for (JcbdBiddingDemandResponse jcbdBiddingDemandResponse : jcbdBiddingDemandResponses) {
                String isAllAccord;
                if (!jcbdBiddingDemandResponse.getResponseProviderId().equals(responseProviderId) || !"0".equals(isAllAccord = jcbdBiddingDemandResponse.getIsAllAccord())) continue;
                return new BaseResponse("\u5b58\u5728\u4e0d\u6ee1\u8db3\u7684\u9700\u6c42\u54cd\u5e94\uff01");
            }
        }
        return new BaseResponse(true, "\u6240\u6709\u9700\u6c42\u54cd\u5e94\u90fd\u6ee1\u8db3\uff01");
    }

    public List<JcbdBiddingDemandResponseDto> findAll(List<String> demandRspIds) {
        List demandResponses = this.jcbdBiddingDemandRespRepo.findAll((root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get("isDelete"), (Object)false), (Expression)cb.or(demandRspIds.stream().map(id -> cb.equal((Expression)root.get("id"), id)).collect(Collectors.toList()).toArray(new Predicate[0]))));
        return this.mapperFacade.mapAsList((Iterable)demandResponses, JcbdBiddingDemandResponseDto.class);
    }

    private List<PriceParityInfoDto> dealPriceParityInfos(List<PriceParityInfoDto> priceParityInfoList, List<BiddingResponseResultDto> biddingResponseResultList) {
        ArrayList<PriceParityInfoDto> priceParityInfoDtoList = new ArrayList<PriceParityInfoDto>();
        if (Lang.isEmpty(priceParityInfoList)) {
            return priceParityInfoDtoList;
        }
        Map<String, List<PriceParityInfoDto>> priceParityInfoMap = priceParityInfoList.stream().collect(Collectors.groupingBy(PriceParityInfoDto::getSupllierName));
        Set<Map.Entry<String, List<PriceParityInfoDto>>> entries = priceParityInfoMap.entrySet();
        for (Map.Entry<String, List<PriceParityInfoDto>> entry : entries) {
            List<PriceParityInfoDto> parityInfoDtoList = entry.getValue();
            BigDecimal summation = BigDecimal.ZERO;
            for (PriceParityInfoDto parityInfoDto : parityInfoDtoList) {
                summation = summation.add(parityInfoDto.getTotalPrice());
            }
            for (BiddingResponseResultDto responseResultDto : biddingResponseResultList) {
                for (PriceParityInfoDto priceParityInfoDto : parityInfoDtoList) {
                    priceParityInfoDto.setSummation(summation);
                    if (!responseResultDto.getSupllierName().equals(priceParityInfoDto.getSupllierName())) continue;
                    responseResultDto.setQuotePrice(summation);
                }
            }
            priceParityInfoDtoList.addAll(parityInfoDtoList);
        }
        return priceParityInfoDtoList;
    }

    @Transactional
    public BaseResponse findModifySkuFlag(String biddingNo, String supplierId) {
        if (Lang.isEmpty((Object)biddingNo) || Lang.isEmpty((Object)supplierId)) {
            log.error("\u67e5\u8be2\u662f\u5426\u4fee\u6539sku \u53c2\u6570\u4f20\u5165\u9519\u8bef");
            return new BaseResponse("\u53c2\u6570\u4f20\u5165\u9519\u8bef");
        }
        JcbdBidding jcbdBidding = this.jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty((Object)jcbdBidding)) {
            log.error("\u67e5\u8be2\u662f\u5426\u4fee\u6539sku  \u65e0\u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7", (Object)biddingNo);
            return new BaseResponse("\u65e0\u6b64\u7ade\u4ef7");
        }
        JcbdBdProvider provider = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), supplierId, Boolean.valueOf(false));
        if (Lang.isEmpty((Object)provider)) {
            log.error("\u67e5\u8be2\u662f\u5426\u4fee\u6539sku  \u65e0\u4f9b\u5e94\u5546id\u4e3a{}\u7684\u4f9b\u5e94\u5546", (Object)supplierId);
            return new BaseResponse("\u65e0\u6b64\u4f9b\u5e94\u5546");
        }
        List jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        if (Lang.isEmpty((Object)jcbdBiddingDemands)) {
            log.error("\u67e5\u8be2\u662f\u5426\u4fee\u6539sku  \u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7\u4e0b\u65e0\u9700\u6c42", (Object)biddingNo);
            return new BaseResponse("\u8be5\u7ade\u4ef7\u4e0b\u65e0\u9700\u6c42");
        }
        for (JcbdBiddingDemand demand : jcbdBiddingDemands) {
            if (Lang.isEmpty((Object)demand.getJcbdBiddingDemandResponses())) {
                log.error("\u67e5\u8be2\u662f\u5426\u4fee\u6539sku  \u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7\u4e0b\u65e0\u9700\u6c42\u54cd\u5e94", (Object)biddingNo);
                return new BaseResponse("\u8be5\u7ade\u4ef7\u4e0b\u65e0\u9700\u6c42\u54cd\u5e94");
            }
            for (JcbdBiddingDemandResponse response : demand.getJcbdBiddingDemandResponses()) {
                if (!response.getResponseProviderId().equals(provider.getId()) || !Lang.isEmpty((Object)response.getSkuModify()) && !response.getSkuModify().booleanValue()) continue;
                return new BaseResponse(true, "", (Object)true);
            }
        }
        return new BaseResponse(true, "", (Object)false);
    }

    @Transactional(readOnly=true)
    public JcbdBdProviderDto getProviderByBiddingNoAndSupplierId(String biddingId, String supplierId) {
        JcbdBdProvider supplierInfo = this.jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(biddingId, supplierId, Boolean.valueOf(false));
        JcbdBdProviderDto jcbdBdProviderDto = (JcbdBdProviderDto)BeanMapper.map((Object)supplierInfo, JcbdBdProviderDto.class);
        return jcbdBdProviderDto;
    }
}

