/*
 * Decompiled with CFR 0.152.
 */
package bidding.service.service.impl.query;

import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingGroupMember;
import bidding.model.po.JcbdRoleOperation;
import bidding.model.repository.JcbdBiddingGroupMemberRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.model.repository.JcbdRoleOperationRepo;
import bidding.model.specification.BiddingGroupMemberSpecification;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import dto.JcbdRoleOperationDto;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import query.BiddingOperatorQuery;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class BiddingRoleOperationQueryServiceImpl
implements BiddingRoleOperationQueryService {
    private static final Logger log = LoggerFactory.getLogger(BiddingRoleOperationQueryServiceImpl.class);
    @Autowired
    JcbdRoleOperationRepo jcbdRoleOperationRepo;
    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;
    @Autowired
    JcbdBiddingGroupMemberRepo jcbdBiddingGroupMemberRepo;

    public List<JcbdRoleOperationDto> findByRoleCodeAndStatus(String roleCode, String status) {
        List jcbdRoleOperationList = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex(roleCode, status);
        if (!Lang.isEmpty((Object)jcbdRoleOperationList)) {
            return BeanMapper.mapList((Iterable)jcbdRoleOperationList, JcbdRoleOperation.class, JcbdRoleOperationDto.class);
        }
        return null;
    }

    public List<JcbdRoleOperation> getAllStatusByRoles(List<String> roleCodes) {
        List jcbdRoleOperationList = this.jcbdRoleOperationRepo.findByRoleCodeInOrderByShowIndex(roleCodes);
        ArrayList roleOperations = jcbdRoleOperationList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<JcbdRoleOperation>(Comparator.comparing(JcbdRoleOperation::getStatus))), ArrayList::new));
        return roleOperations;
    }

    public List<JcbdRoleOperationDto> findByRoleCodeAndStatusAndModuleOrderByShowIndex(String roleCode, String status, String module) {
        List jcbdRoleOperationList = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusAndModuleAndIsDeleteOrderByShowIndex(roleCode, status, module, Boolean.valueOf(false));
        if (!Lang.isEmpty((Object)jcbdRoleOperationList)) {
            return BeanMapper.mapList((Iterable)jcbdRoleOperationList, JcbdRoleOperation.class, JcbdRoleOperationDto.class);
        }
        return null;
    }

    public List<JcbdRoleOperationDto> getOperatorBiddingOperateByBiddingCode(BiddingOperatorQuery biddingOperatorQuery) {
        JcbdBiddingGroupMember jcbdBiddingGroupMemberQuery = new JcbdBiddingGroupMember();
        jcbdBiddingGroupMemberQuery.setEmail(biddingOperatorQuery.getEmail());
        jcbdBiddingGroupMemberQuery.setGroupMemberId(biddingOperatorQuery.getMemberId());
        JcbdBidding jcbdBidding = new JcbdBidding();
        jcbdBidding.setBiddingCode(biddingOperatorQuery.getBiddingNo());
        jcbdBiddingGroupMemberQuery.setJcbdBidding(jcbdBidding);
        List groupMembers = this.jcbdBiddingGroupMemberRepo.findAll((Specification)new BiddingGroupMemberSpecification(jcbdBiddingGroupMemberQuery));
        ArrayList<JcbdRoleOperationDto> jcbdRoleOperationDtoList = new ArrayList<JcbdRoleOperationDto>();
        if (groupMembers != null && !groupMembers.isEmpty()) {
            JcbdBiddingGroupMember groupMember = (JcbdBiddingGroupMember)groupMembers.get(0);
            if (groupMember != null && groupMember.getJcbdBidding().getOperatorId().equals(biddingOperatorQuery.getMemberId())) {
                List operationDtoForOperator = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex("BIDDING_OPERATOR", groupMember.getStatus());
                List operationDtosForGroupMember = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex("BIDDING_GROUP_MEMBER", groupMember.getStatus());
                if (!Lang.isEmpty((Object)operationDtoForOperator)) {
                    jcbdRoleOperationDtoList.addAll(BeanMapper.mapList((Iterable)operationDtoForOperator, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                }
                if (!Lang.isEmpty((Object)operationDtosForGroupMember)) {
                    jcbdRoleOperationDtoList.addAll(BeanMapper.mapList((Iterable)operationDtosForGroupMember, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                }
            } else {
                List operationDtosForGroupMember = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex("BIDDING_GROUP_MEMBER", groupMember.getStatus());
                if (!Lang.isEmpty((Object)operationDtosForGroupMember)) {
                    jcbdRoleOperationDtoList.addAll(BeanMapper.mapList((Iterable)operationDtosForGroupMember, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
                }
            }
        }
        for (JcbdRoleOperationDto jcbdRoleOperationDto : jcbdRoleOperationDtoList) {
            String url = jcbdRoleOperationDto.getUrl();
            if (url != null && !"".equals(url)) {
                url = url + "?biddingNo=" + biddingOperatorQuery.getBiddingNo();
            }
            jcbdRoleOperationDto.setUrl(url);
        }
        return jcbdRoleOperationDtoList;
    }

    public List<String> getBiddingShowTitle(String status, String module) {
        List jcbdRoleOperations = this.jcbdRoleOperationRepo.findByStatusAndModuleAndIsDelete(status, module, false);
        ArrayList<String> result = new ArrayList<String>();
        jcbdRoleOperations.forEach(jcbdRoleOperation -> result.add(jcbdRoleOperation.getEvent()));
        return result;
    }

    public List<JcbdRoleOperationDto> getSupplierBiddingOperateByBiddingCode(String biddingNo, String status) {
        ArrayList<JcbdRoleOperationDto> jcbdRoleOperationDtoList = new ArrayList<JcbdRoleOperationDto>();
        List operationDtos = this.jcbdRoleOperationRepo.findByRoleCodeAndStatusOrderByShowIndex("BIDDING_SUPPLIER", status);
        if (!Lang.isEmpty((Object)operationDtos)) {
            jcbdRoleOperationDtoList.addAll(BeanMapper.mapList((Iterable)operationDtos, JcbdRoleOperation.class, JcbdRoleOperationDto.class));
        }
        for (JcbdRoleOperationDto jcbdRoleOperationDto : jcbdRoleOperationDtoList) {
            String url = jcbdRoleOperationDto.getUrl();
            if (url != null && !"".equals(url)) {
                url = url + "?biddingNo=" + biddingNo;
            }
            jcbdRoleOperationDto.setUrl(url);
        }
        return jcbdRoleOperationDtoList;
    }
}

