(function( factory ) {
	if ( typeof define === "function" && define.amd ) {
		define( ["jquery", "../jquery.validate"], factory );
	} else if (typeof module === "object" && module.exports) {
		module.exports = factory( require( "jquery" ) );
	} else {
		factory( jQuery );
	}
}(function( $ ) {
	/*
	 * Translated default messages for the jQuery validation plugin.
	 * Locale: ZH (Chinese, 中文 (Zhōngwén), 汉语, 漢語)
	 */
	$.extend( $.validator.messages, {
		required: "请输入{tip-title}",
		remote: "请正确填写该字段",
		email: "请输入正确格式的电子邮件",
		url: "请输入合法的网址",
		date: "请输入合法的日期",
		dateISO: "请输入合法的日期 (ISO).",
		number: "请输入合法的数字",
		digits: "只能输入整数",
		creditcard: "请输入合法的信用卡号",
		equalTo: "请再次输入相同的值",
		accept: "请输入拥有合法后缀名的字符串",
		maxlength: $.validator.format("请输入一个长度最多是 {0} 的字符串"),
		minlength: $.validator.format("请输入一个长度最少是 {0} 的字符串"),
		rangelength: $.validator.format("请输入一个长度介于 {0} 和 {1} 之间的字符串"),
		range: $.validator.format("请输入一个介于 {0} 和 {1} 之间的值"),
		max: $.validator.format("请输入一个最大为 {0} 的值"),
		min: $.validator.format("请输入一个最小为 {0} 的值"),
		isDecimal: $.validator.format("请正确输入在{0}到{1}之间{2}"),
		isIdCardNo: "请核对身份证号码是否输入正确",
		mobilePhone: "请核对手机号码是否输入正确",
		isValidName: "请核对{tip-title}是否输入正确",
		isChineseName:"请核对{tip-title}是否输入正确",
		isLicenseNo: "请正确录入车牌号，未取得车牌请勾选新车未上牌",
		isLicenseNo_nocb: "请正确录入车牌号",
		isCarOwnerName: "请核对是否输入正确",
		combimePhone: "请核对{tip-title}是否输入正确",
		taxPlayerCode: "请正确填写纳税人识别号",
		bankAccount: "请正确填写银行账户"
	} );

}));