var orderManager = {};
orderManager.init = function(){
};
orderManager.init.prototype = {
    // 表格数据
    initManagerTable : function(){
        $('#orderManagerTable').DataTable({
            "sAjaxSource" : "/bidding-web/biddingOperator/getBiddingOrderMangerList",
            "fnServerData" : function(sSource, aoData, fnCallback) {
                var serializeData = function(aoData){
                    var data = {};
                    for(var i = 0 ;i<aoData.length ;i++){
                        var dd = aoData[i];
                        if(dd['value']){
                            data[ dd['name'] ]= dd['value'];
                        }
                    }
                    return $.param(data);
                };
                $.ajax({
                    "type" : 'post',
                    "url" : sSource,
                    //"dataType" : "json",
                    //"dataSrc": "data",
                    "data" :serializeData(aoData),
                    "success" : function(resp) {
                        if (resp.status=="success"){
                            fnCallback(resp.data);
                        }else {
                            showMessage({message: "系统出错，请重新登陆"});
                        }
                    },
                    "error" : function () {
                        showMessage({message: "系统出错，请重新登陆"});
                    }
                });
            },
            "fnDrawCallback" : function(table) {
                //指定跳转页面
                $("#orderManagerTable_paginate").append("<input  class='margin text-center paginput' id='changePage' type='text'> 页  <a class='btn btn-default shiny pagbtn' style='margin-bottom:5px' href='javascript:void(0);' id='dataTable-btn'>跳转</a>");
                var oTable = $("#orderManagerTable").dataTable();
                $('#dataTable-btn').click(function(e) {
                    if($("#changePage").val() && $("#changePage").val() > 0) {
                        var redirectpage = $("#changePage").val() - 1;
                    } else {
                        var redirectpage = 0;
                    }
                    oTable.fnPageChange(redirectpage);
                });
            },
            //向服务器传额外的参数
            "fnServerParams" : function(aoData) {
                var biddingCode = $('#biddingCode').val();
                var orderSTime=$('#orderStartTime').val(); //orderSTime d.对象不能定义为orderStartTime
                var orderETime=$('#orderEndTime').val();
                var status = $("#statusCode").val();
                var orderNo = $('#orderNo').val();
                var confSTime=$('#confStartTime').val();
                var confETime=$('#confEndTime').val();
                aoData.push({
                    "name" : "biddingCode",
                    "value" : biddingCode
                },{
                    "name": "orderSTime",
                    "value": orderSTime
                },{
                    "name": "orderETime",
                    "value": orderETime
                },{
                    "name": "status",
                    "value": status
                },{
                    "name": "orderNo",
                    "value": orderNo
                },{
                    "name": "confSTime",
                    "value": confSTime
                },{
                    "name": "confETime",
                    "value": confETime
                });
            },
            "columns": [
                { "data": "id" },
                { "data": "biddingCode" },
                {"data": "orderNo"},
                {
                    "data": "dateCreated",
                    "render" : function(data) {
                        if(data==null){
                            return "";
                        }else{
                            return dateFtt("yyyy-MM-dd hh:mm:ss", new Date(data));
                        }
                    }
                },
                {"data": "goodsNumber"},
                { "data": "singleAmount" },
                {
                    "data": "confirmOrderTime" ,
                    "render" : function(data) {
                        if(data==null){
                            return "";
                        }else{
                            return dateFtt("yyyy-MM-dd hh:mm:ss", new Date(data));
                        }
                       /* var date = new Date(data);
                        return date.*/getFullYear() + '-' + (date.getMonth() + 1) + '-' + date.getDate()+ ' ' + date.getHours()+ ':' +date.getMinutes()+ ':' +date.getSeconds();
                    }
                },
                { "data" : "statusDescription" },
                {
                    "data" : "operation",
                    "render" : function(data, type, full, meta) {
                        if(data!=null){
                            var operation ="";
                            for(var i=0; i<data.length; i++){
                                var eventDes =data[i].event;
                                if(eventDes!=null){
                                    operation = operation + '<a href="javascript:void(0);"  orderId = "'+ full.id +'" status = "'+ full.status +'" biddingCode = "'+ full.biddingCode +'" orderNo = "'+ full.orderNo +'" onclick="new orderManager.init().'+ data[i].event + '"> '+ data[i].operationName + '</a>'
                                    if(i<data.length-1){
                                        operation = operation + '<span style="color:#ff8a00">|</span>'
                                    }
                                }else{
                                    operation = operation + '<a href="javascript:void(0);"  orderId = "'+ full.id +'" > '+ data[i].operationName + '</a>&nbsp;'
                                }
                            }
                            return operation ;
                        }else{
                            return data;
                        }
                    }
                }
            ],
            //自定义第一列
            "aoColumnDefs":[
              {
                  "sClass":"or",
                  "aTargets":[0],
                  "data":"operations",
                  "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                      return '';
                  }
              }
          ],
            "sDom":'rt<"row"<"col-2"i><"col-8"p><"col-2"l>>',//自定义布局
            "bServerSide" : true, //需要向后端传jqueryDataTablesVo数据,是否启动服务器端数据导入
            "searching":false,
            "paging": true,
            "ordering": false,
            "bPaginate": true,
            "bSort": false, // 是否启动各个字段的排序功能
            "bFilter" : false,// 是否启动过滤、搜索功能
            "aLengthMenu" : [5, 10, 20, 50, 100], //更改显示记录数选项
            "bLengthChange":true,// 每行显示记录数
            "bInfo" : true,// //是否显示页脚信息，DataTables插件左下角显示记录数
            "bWidth" : true,
            //"bProcessing" : true, //DataTables载入数据时，是否显示‘进度’提示
            //"aaSorting" : [[1, "asc"]], //默认的排序方式，第2列，升序排列
            //"bJQueryUI" : true, //是否使用 jQury的UI theme
            "bScrollCollapse" : true,  //是否开启DataTables的高度自适应，当数据条数不够分页数据条数的时候，插件高度是否随数据条数而改变
            "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
            "bAutoWidth":true,  //是否自适应宽度
            "iDisplayLength" : 10, // 每页显示行数
            "bDestroy" : true,
            "bSortCellsTop" : true,
            "oLanguage" : {
                "sProcessing" : "正在获取数据，请稍后...",
                "sLengthMenu" : "显示 _MENU_ 条",
                "sZeroRecords" : "没有检索到数据",
                "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
                "sInfoEmpty" : "记录数为0",
                "sInfoFiltered" : "(全部记录数 _MAX_ 条)",
                "sInfoPostFix" : "",
                "sSearch" : "搜索",
                "sUrl" : "",
                "oPaginate" : {
                    "sFirst" : "首页",
                    "sPrevious" : "前一页",
                    "sNext" : "后一页",
                    "sLast" : "尾页"
                }
             }
            } );
    },

    //查询
    search : function() {
        $("#searchBtn").click(function() {
            if(new orderManager.init().checkTime()){
                new orderManager.init().initManagerTable();
            }
        })
    },
    //所有状态
    getAllStatus :function () {
        $.ajax({
            url: '/bidding-web/biddingOperator/getAllStatus',
            type:"GET",
            success: function (data) {
                var  status = '<li><a code="" href="javascript:void(0)" onclick="new orderManager.init().getValue(this)">全部</a></li>'
                $("#allStatus").append(status);
                for (var i=0;i<data.length;i++) {
                   status = "<li><a code=" + data[i].statusCode + " href=\"javascript:void(0)\" onclick=\"new orderManager.init().getValue(this)\">"+ data[i].statusDescription +"</a></li>"
                    $("#allStatus").append(status);
                }
            },
            error: function () {
                sDefiShowMessage({message:"请求失败"});
            }
        })
    },
    getValue :function (obj) {
        var code = $(obj).attr("code");
        $("#statusCode").val(code);
    },
    //取消订单
    cancelOrder :function (obj) {
        var orderNo = $(obj).attr("orderNo");
        $.ajax({
            url: '/bidding-web/biddingOperator/updateStatusByOrderNo',
            type:"POST",
            data:{
                status:7,
                orderNo:orderNo
            },
            success: function (data) {
                new orderManager.init().initManagerTable();
                sDefiShowMessage({message:"取消订单成功"});
            },
            error: function () {
                sDefiShowMessage({message:"请求失败"});

            }
        })
    },
    //删除订单
    deleteOrder :function (obj) {
        var orderNo = $(obj).attr("orderNo");
        $.ajax({
            url: '/bidding-web/biddingOperator/deleteJcbdMallOrderByOrderNo',
            type:"POST",
            data:{
                orderNo:orderNo
            },
            success: function (data) {
                new orderManager.init().initManagerTable();
                sDefiShowMessage({message:"删除订单成功"});
            },
            error: function () {
                sDefiShowMessage({message:"请求失败"});
            }
        })
    },

    checkTime : function () {
        var orderStartTime = $("#orderStartTime").val();
        var orderEndTime = $("#orderEndTime").val();
        if(orderStartTime && orderEndTime){
            //将字符串转换为日期
            var begin=new Date(orderStartTime.replace(/-/g,"/"));
            var end=new Date(orderEndTime.replace(/-/g,"/"));
            //js判断日期
            if(end < begin ){
                sDefiShowMessage({message:"您选择的时间范围有误"});
                $("#orderStartTime").val("");
                $("#orderEndTime").val("");
                $("#confStartTime").val("");
                $("#confEndTime").val("");
                return false;
            }
        }
        var confStartTime = $("#confStartTime").val();
        var confEndTime = $("#confEndTime").val();
        if(confStartTime && confEndTime){
            //将字符串转换为日期
            var begin=new Date(confStartTime.replace(/-/g,"/"));
            var end=new Date(confEndTime.replace(/-/g,"/"));
            //js判断日期
            if(end < begin ){
                sDefiShowMessage({message:"您选择的时间范围有误"});
                $("#confStartTime").val("");
                $("#confEndTime").val("");
                return false;
            }
        }
        return true;
    },
    detailOrder :function (obj) {
      /*  var oTable = $('#orderManagerTable').dataTable();
        var oSettings = oTable.fnSettings();
        // 获取页码值
        alert(oSettings._iDisplayStart);*/

        var biddingCode = $(obj).attr("biddingCode");
        var orderNo = $(obj).attr("orderNo");
        var status = $(obj).attr("status");
        window.location.href = "/bidding-web/operator/orderDetail?biddingCode=" + biddingCode +"&orderNo=" +orderNo + "&status=" + status ;
    }
}

$(function(){
    var obj = new orderManager.init();
    obj.initManagerTable();
    obj.search();
    obj.getAllStatus();
    obj.checkTime();
})
