$("body").mLoading({
    text: "请稍后...", //加载文字，默认值：加载中...
    icon: "", //加载图标，默认值：一个小型的base64的gif图片
    html: false, //设置加载内容是否是html格式，默认值是false
    content: "", //忽略icon和text的值，直接在加载框中显示此值
    mask: true //是否显示遮罩效果，默认显示
}).mLoading("hide");


var supplierOrderManage = {};
var orderNos;
supplierOrderManage.init = function () {
};
supplierOrderManage.init.prototype = {
    // 表格数据
    initManagerTable: function () {
        $('#supplierOrderManageTable').DataTable({
            "sAjaxSource": "/bidding-web/supplierOperator/getBiddingSupplierOrderMangerList",
            "fnServerData": function (sSource, aoData, fnCallback) {
                var serializeData = function (aoData) {
                    var data = {};
                    for (var i = 0; i < aoData.length; i++) {
                        var dd = aoData[i];
                        if (dd['value']) {
                            data[dd['name']] = dd['value'];
                        }
                    }
                    return $.param(data);
                };
                $("body").mLoading("show");
                $.ajax({
                    "type": 'post',
                    "url": sSource,
                    //"dataType" : "json",
                    //"dataSrc": "data",
                    "data": serializeData(aoData),
                    "success": function (resp) {
                        $("body").mLoading("hide");
                        if (resp.status == "success") {
                            fnCallback(resp.data);
                            if($("#explainAgree2").is(":checked")) {
                                $("#explainAgree2").trigger("click");
                            }
                        } else {
                            showMessage({message: "系统出错，请重新登陆"});
                        }
                    },
                    "error": function () {
                        $("body").mLoading("hide");
                        showMessage({message: "系统出错，请重新登陆"});
                    }
                });
            },
            //向服务器传额外的参数
            "fnServerParams": function (aoData) {
                var biddingCode = $('#biddingCode').val();
                var goodsCode = $('#goodsCode').val();
                var status = $("#statusCode").val();
                var orderSTime = $('#orderStartTime').val();
                var orderETime = $('#orderEndTime').val();
                aoData.push({
                    "name": "biddingCode",
                    "value": biddingCode
                }, {
                    "name": "goodsCode",
                    "value": goodsCode
                }, {
                    "name": "status",
                    "value": status
                }, {
                    "name": "orderSTime",
                    "value": orderSTime
                }, {
                    "name": "orderETime",
                    "value": orderETime
                });
            },
            "columns": [
                {"data": "id"},
                {"data": "biddingCode"},
                {"data": "orderNo"},
                {
                    "data": "dateCreated",
                    "render": function (data) {
                        return dateFtt("yyyy-MM-dd hh:mm:ss", new Date(data));
                    }
                },
                {"data": "address"},
                {
                    "data": "goodsCode",
                    "render": function (data, type, full, meta) {
                        if (data != null) {
                            var goodsCode = "";
                            var skus = data.split(",");
                            for (var i = 0; i < skus.length; i++) {
                                goodsCode += skus[i];
                                if(i + 1 < skus.length) {
                                    goodsCode += "\r\n";
                                }
                            }
                            return goodsCode;
                        } else {
                            return data;
                        }
                    }
                },
                {"data": "goodsNumber"},
                {
                    "data" : "singleAmount",
                    "render" : function (data, type, full, meta) {
                        if(data === undefined || data  === null) {
                            return "";
                        } else {
                            return changeTwoDecimal_f(data);
                        }
                    }
                },
                {"data": "supplierOrderStatusDescription"},
                {
                    "data": "operation",
                    "render": function (data, type, full, meta) {
                        if (data != null) {
                            var option = "";
                            for (var i = 0; i < data.length; i++) {
                                var eventDes = data[i].event;
                                if (eventDes != null) {
                                    option = option + '<a href="javascript:void(0);" biddingCode = "'+ full.biddingCode +'" status = "'+ full.supplierOrderStatus +'" mallOrderNo = "' + full.orderNo + '" mallOrderId = "' + full.id + '"  onclick="new supplierOrderManage.init().' + data[i].event + '"> ' + data[i].operationName + '</a>&nbsp;'
                                } else {
                                    option = option + '<a href="javascript:void(0);" biddingCode = "'+ full.biddingCode +'" status = "'+ full.supplierOrderStatus +'" mallOrderNo = "' + full.orderNo + '" mallOrderId = "' + full.id + '" > ' + data[i].operationName + '</a>&nbsp;'
                                }
                            }
                            return option;
                        } else {
                            return data;
                        }
                    }
                }
            ],
            //自定义第一列
            "aoColumnDefs": [
                {
                    "sClass": "or",
                    "aTargets": [0],
                    "data": "id",
                    "mRender": function (data, type, full, meta) {//id，c表示当前记录行对象
                        var html = '<div class="checkbox c-checkbox input-check">';
                        html = html + '<label> <input type="checkbox" id=' + data + ' name="choice" value=' + full.orderNo + '> ';
                        html = html + '<span class="fa fa-check"></span>';
                        html = html + '</label>';
                        html = html + '</div>';
                        return html;
                    }
                }
            ],
            "fnDrawCallback": function (table) {
                //跳转指定页
                $("#supplierOrderManageTable_paginate").append("<input  class='margin text-center paginput' id='changePage' type='text'> 页  <a class='btn btn-default shiny pagbtn' style='margin-bottom:5px' href='javascript:void(0);' id='dataTable-btn'>跳转</a>");
                var oTable = $("#supplierOrderManageTable").dataTable();
                $('#dataTable-btn').click(function (e) {
                    if ($("#changePage").val() && $("#changePage").val() > 0) {
                        var redirectpage = $("#changePage").val() - 1;
                    } else {
                        var redirectpage = 0;
                    }
                    oTable.fnPageChange(redirectpage);
                });
            },
            "sDom": 'rt<"row"<"col-b2"i><"col-8"p><"col-b3"l>>',//自定义布局
            "bServerSide": true, //需要向后端传jqueryDataTablesVo数据,是否启动服务器端数据导入
            "searching": false,
            "paging": true,
            "ordering": false,
            "bPaginate": true,
            "bSort": false, // 是否启动各个字段的排序功能
            "bFilter": false,// 是否启动过滤、搜索功能
            "aLengthMenu": [5, 10, 20, 50, 100], //更改显示记录数选项
            "bLengthChange": true,// 每行显示记录数
            "bInfo": true,// //是否显示页脚信息，DataTables插件左下角显示记录数
            "bWidth": true,
            //"bProcessing" : true, //DataTables载入数据时，是否显示‘进度’提示
            //"aaSorting" : [[1, "asc"]], //默认的排序方式，第2列，升序排列
            //"bJQueryUI" : true, //是否使用 jQury的UI theme
            "bScrollCollapse": true,  //是否开启DataTables的高度自适应，当数据条数不够分页数据条数的时候，插件高度是否随数据条数而改变
            "sPaginationType": "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
            "bAutoWidth": true,  //是否自适应宽度
            "iDisplayLength": 10, // 每页显示行数
            "bDestroy": true,
            "bSortCellsTop": true,
            "oLanguage": {
                "sProcessing": "正在获取数据，请稍后...",
                "sLengthMenu": "显示 _MENU_ 条",
                "sZeroRecords": "没有检索到数据",
                "sInfo": "从 _START_ 到  _END_ 条记录 总记录数为 _TOTAL_ 条",
                "sInfoEmpty": "记录数为0",
                "sInfoFiltered": "(全部记录数 _MAX_ 条)",
                "sInfoPostFix": "",
                "sSearch": "搜索",
                "sUrl": "",
                "oPaginate": {
                    "sFirst": "首页",
                    "sPrevious": "前一页",
                    "sNext": "后一页",
                    "sLast": "尾页"
                }
            }
        });
    },

    //查询
    search: function () {
        $("#searchBtn").click(function () {
            if (new supplierOrderManage.init().checkTime()) {
                new supplierOrderManage.init().initManagerTable();
            }
        });
    },
    //所有状态
    getAllStatus: function () {
        $.ajax({
            url: '/bidding-web/supplierOperator/getAllSupplierStatus',
            type: "GET",
            success: function (data) {
                var status = '<li><a code="" href="javascript:void(0)" onclick="new supplierOrderManage.init().getValue(this)">全部</a></li>'
                $("#allStatus").append(status);
                for (var i = 0; i < data.length; i++) {
                    status = "<li><a code=" + data[i].statusCode + " href=\"javascript:void(0)\" onclick=\"new supplierOrderManage.init().getValue(this)\">" + data[i].statusDescription + "</a></li>"
                    $("#allStatus").append(status);
                }
                $("#mallOrderStatus").val("全部");
            },
            error: function () {
                sDefiShowMessage({message: "请求失败"});
            }
        })
    },
    getValue: function (obj) {
        var code = $(obj).attr("code");
        $("#statusCode").val(code);
    },
    //删除订单
    cancel: function (obj) {
        $("body").mLoading("show");
        var mallOrderNo = $(obj).attr("mallOrderNo");
        $.ajax({
            url: '/bidding-web/supplierOperator/deleteMallOrder',
            type: "POST",
            data: {
                mallOrderNo : mallOrderNo
            },
            success: function (data) {
                $("body").mLoading("hide");
                if(data.success) {
                    new supplierOrderManage.init().initManagerTable();
                    sDefiShowMessage({message: "删除订单成功"});
                } else {
                    sDefiShowMessage({message: "删除订单失败"});
                }
            },
            error: function () {
                $("body").mLoading("hide");
                sDefiShowMessage({message: "请求失败"});
            }
        });
    },
    excel: function () {
        $("#conditionForm").submit();
    },

    //时间校验
    checkTime: function () {
        var orderStartTime = $("#orderStartTime").val();
        var orderEndTime = $("#orderEndTime").val();
        if (orderStartTime && orderEndTime) {
            //将字符串转换为日期
            var begin = new Date(orderStartTime.replace(/-/g, "/"));
            var end = new Date(orderEndTime.replace(/-/g, "/"));
            //js判断日期
            if (end < begin) {
                sDefiShowMessage({message: "您选择的时间范围有误"});
                $("#orderStartTime").val("");
                $("#orderEndTime").val("");
                return false;
            }
        }
        return true;
    },
    //全选
    checkboxAll: function () {
        var choice = document.getElementsByName("choice");
        var checkAll = document.getElementById("explainAgree2");
        $("#explainAgree2").click(function () {

            if (checkAll.checked == true) {
                for (var i = 0; i < choice.length; i++) {
                    choice[i].checked = true;
                }
            } else {
                for (var i = 0; i < choice.length; i++) {
                    choice[i].checked = false;
                }
            }
        });
    },
    toBeConfirmed: function (element) {
        var mallOrderNos = [];
        if (element !== null && element !== undefined) {
            var mallOrderNo = $(element).attr("mallOrderNo");
            mallOrderNos.push(mallOrderNo);
        } else {
            $("input[name='choice']:checked").each(function () {
                mallOrderNos.push($(this).val());
            });
        }
        orderNos = mallOrderNos;
        if (mallOrderNos.length > 0) {
            var obj = new supplierOrderManage.init();
            var biddingCode = $('#biddingCode').val();
            var getQrCodeUrl = "/bidding-web/biddingProvider/loadQrcode";
            var getAccTokenUrl = "/bidding-web/biddingProvider/getAccToken";
            var getSignResultUrl = "/bidding-web/biddingProvider/getSignResult";
            loadQrCode(getQrCodeUrl,getAccTokenUrl,getSignResultUrl,biddingCode,"confirmOrder",obj.afterConfirm);
            //obj.afterConfirm("test");
        } else {
            sDefiShowMessage({message: "请选择订单"});
        }
    },
    afterConfirm:function (obj) {
        $("body").mLoading("show");//显示loading组件
        $.ajax({
            async: true,
            type: 'POST',
            url: '/bidding-web/supplierOperator/confirmOrder',
            data: {
                mallOrderNos: JSON.stringify(orderNos),
                signValue:obj
            },
            success: function (data) {
                $("body").mLoading("hide");//隐藏loading组件
                var messages = "";
                for (var i = 0; i < data.result.length; i++) {
                    messages += data.result[i];
                    if(i + 1 != data.result.length) {
                        messages += "</br></br>";
                    }
                }
                sDefiShowMessage({message: messages});
                if(data.success) {
                    new supplierOrderManage.init().initManagerTable();
                }
            },
            error: function () {
                $("body").mLoading("hide");//隐藏loading组件
                sDefiShowMessage({message: "请求失败"});
            }
        })
    },
    detailOrder :function (obj) {
        var biddingCode = $(obj).attr("biddingCode");
        var orderNo = $(obj).attr("mallOrderNo");
        var status = $(obj).attr("status");
        window.location.href = "/bidding-web/supplier/supplierOrderDetail?biddingCode=" + biddingCode +"&orderNo=" +orderNo + "&status=" + status ;
    }

}


$(function () {
    var obj = new supplierOrderManage.init();
    obj.initManagerTable();
    obj.search();
    obj.getAllStatus();
    obj.checkTime();
    obj.checkboxAll();

});

function changeTwoDecimal_f(x) {
    var f_x = parseFloat(x);
    if (isNaN(f_x)) {
        return x;
    }
    //f_x = Math.round(f_x * 100) / 100;
    var s_x = f_x.toString();
    var pos_decimal = s_x.indexOf('.');
    if (pos_decimal < 0) {
        pos_decimal = s_x.length;
        s_x += '.';
    }
    while (s_x.length <= pos_decimal + 2) {
        s_x += '0';
    }
    return s_x;
}
