package bidding.web.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import utils.filter.CNTPSSOLoginCheckFilter;

import java.util.List;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@Configuration
@ComponentScan(basePackages = "utils.io")
@ConfigurationProperties(prefix = "security")
public class WebConfig {

//    @Bean
//    public FrontEndLoginCheckFilter frontEndLoginCheckFilter(
//            @Value("${login.excludeUrls}")String excludeUrls,
//            @Value("${login.loginUrl}")String loginUrl,
//            @Value("${login.checkUrls}")String checkUrls,
//            @Value("${login.defaultSuccessUrl}")String defaultSuccessUrl
//    ){
//        FrontEndLoginCheckFilter frontEndLoginCheckFilter =  new FrontEndLoginCheckFilter();
//        frontEndLoginCheckFilter.setExcludeUrls(excludeUrls);
//        frontEndLoginCheckFilter.setLoginUrl(loginUrl);
//        frontEndLoginCheckFilter.setCheckUrls(checkUrls);
//        frontEndLoginCheckFilter.setDefaultSuccessUrl(defaultSuccessUrl);
//
//        return frontEndLoginCheckFilter;
//    }


    List<String> callbackignore;
    @Bean
    public CNTPSSOLoginCheckFilter frontEndLoginCheckFilter(
            @Value("${login.excludeUrls}")String excludeUrls,
            @Value("${login.loginUrl}")String loginUrl,
            @Value("${login.checkUrls}")String checkUrls,
            @Value("${login.defaultSuccessUrl}")String defaultSuccessUrl,
            @Value("${login.sso.authCookiesName}")String authCookiesName,
            @Value("${login.sso.tokenServerCertPath}")String tokenServerCertPath,
            @Value("${login.sso.appKeyStorePath}")String appKeyStorePath,
            @Value("${login.sso.appKeyStoreAlias}")String appKeyStoreAlias,
            @Value("${login.sso.appKeyStoreAliasPwd}")String appKeyStoreAliasPwd,
            @Value("${login.sso.keyStoreType}")String keyStoreType,
            @Value("${login.sso.appid}")String appid,
            @Value("${login.sso.returnUrl}") String returnUrl,
            @Value("${login.sso.serverUrl}") String serverUrl,
            @Value("${login.sso.authMethod:1}") String authMethod,
            @Value("${login.sso.logout.serverUrl}") String logoutServUrl,
            @Value("${login.forbidRoles}")String forbidRoles
    ){
        CNTPSSOLoginCheckFilter frontEndLoginCheckFilter =  new CNTPSSOLoginCheckFilter();
        frontEndLoginCheckFilter.setExcludeUrls(excludeUrls);
        frontEndLoginCheckFilter.setLoginUrl(loginUrl);
        frontEndLoginCheckFilter.setCheckUrls(checkUrls);
        frontEndLoginCheckFilter.setDefaultSuccessUrl(defaultSuccessUrl);
        frontEndLoginCheckFilter.setAppid(appid);
        frontEndLoginCheckFilter.setAppKeyStoreAlias(appKeyStoreAlias);
        frontEndLoginCheckFilter.setAppKeyStoreAliasPwd(appKeyStoreAliasPwd);
        frontEndLoginCheckFilter.setAppKeyStorePath(appKeyStorePath);
        frontEndLoginCheckFilter.setAuthCookiesName(authCookiesName);
        frontEndLoginCheckFilter.setKeyStoreType(keyStoreType);
        frontEndLoginCheckFilter.setTokenServerCertPath(tokenServerCertPath);
        frontEndLoginCheckFilter.setReturnUrl(returnUrl);
        frontEndLoginCheckFilter.setServerUrl(serverUrl);
        frontEndLoginCheckFilter.setAuthMethod(authMethod);
        frontEndLoginCheckFilter.setLogoutServUrl(logoutServUrl);
        frontEndLoginCheckFilter.setIgnoreCallBackPattens(callbackignore);
        frontEndLoginCheckFilter.setForbidRoles(forbidRoles);
        return frontEndLoginCheckFilter;
    }

    public List<String> getCallbackignore() {
        return callbackignore;
    }

    public void setCallbackignore(List<String> callbackignore) {
        this.callbackignore = callbackignore;
    }
}
