package bidding.web.controller;

import bidding.web.service.BiddingAuditorService;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.BiddingAuditIncomeInfoVo;
import bidding.web.vo.BiddingAuditInfoVo;
import bidding.web.vo.BiddingAuditValidateInfoVo;
import bidding.web.vo.QueryStatus;
import com.alibaba.fastjson.JSON;
import definition.BiddingRole;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;
import utils.web.ResponseMapUtils;
import workflow.vo.WorkFlowVo;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;


/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@RestController
@RequestMapping("biddingAuditor")
public class BiddingAuditorController {
    @Autowired
    BiddingAuditorService biddingAuditorService;
    @Autowired
    BiddingOperatorService biddingOperatorService;

    @RequestMapping("/biddingResultAudit")
    public BaseResponse biddingResultAudit(WorkFlowVo workFlowVo) {
        return biddingAuditorService.biddingResultAudit(workFlowVo);
    }

    /**
     * 审核人员-商城竞价管理列表查询
     *
     * @param jqueryDataTablesVo
     * @param request
     * @param biddingAuditInfoVo
     * @return
     */
    @RequestMapping(value = {"/querryBidding"})
    @ResponseBody
    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, HttpServletRequest request, BiddingAuditInfoVo biddingAuditInfoVo) {
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (!Lang.isEmpty(startTime)) {
                biddingAuditInfoVo.setBiddingStartTime(sdf.parse(startTime));
            }
            if (!Lang.isEmpty(endTime)) {
                biddingAuditInfoVo.setBiddingEndTime(sdf.parse(endTime));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        String workId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_AUDITOR_WORK_ID);

        Map resultMap = biddingOperatorService.audirQuerryPageBidding(jqueryDataTablesVo, workId, null, biddingAuditInfoVo);
        if (!Lang.isEmpty(biddingAuditInfoVo.getBiddingStartTime())){
            biddingAuditInfoVo.setStart(DateUtils.toString(biddingAuditInfoVo.getBiddingStartTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        }
        if (!Lang.isEmpty(biddingAuditInfoVo.getBiddingEndTime())){
            biddingAuditInfoVo.setEnd(DateUtils.toString(biddingAuditInfoVo.getBiddingEndTime(), GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        }
        biddingAuditInfoVo.setPageNo((jqueryDataTablesVo.getiDisplayStart()/jqueryDataTablesVo.getiDisplayLength())+1+"");
        request.getSession().setAttribute("auditId",workId);
        request.getSession().setAttribute("auditBiddingTemp",JSON.toJSONString(biddingAuditInfoVo));
        request.getSession().setAttribute("auditBiddingPageTemp",JSON.toJSONString(jqueryDataTablesVo));
        return ResponseMapUtils.success(resultMap);
    }

    /**
     * 获得审核人所选状态
     *
     * @return
     */
    @RequestMapping("/getAuditStatus")
    public List<QueryStatus> getAllStatus() {
        List<QueryStatus> allStatusList = biddingOperatorService.getAuditStatus();
        return allStatusList;
    }

    @RequestMapping("/getAuditInfo")
    public BaseResponse<BiddingAuditValidateInfoVo> getAuditInfo(HttpServletRequest request, BiddingAuditIncomeInfoVo biddingAuditIncomeInfoVo) {
        String workId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_AUDITOR_WORK_ID);
        biddingAuditIncomeInfoVo.setWorkerId(workId);
        BaseResponse<BiddingAuditValidateInfoVo> auditInfo = biddingAuditorService.getAuditInfo(biddingAuditIncomeInfoVo);
        if (auditInfo.isSuccess()) {
            request.getSession().setAttribute(BiddingRole.BIDDING_AUDITOR_WORK_ID, auditInfo.getResult().getWorkerId());
            auditInfo.getResult().setWorkerId(null);
        }
        return auditInfo;
    }
}
