package bidding.web.controller;

import bidding.web.service.BiddingCompanyService;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.JsonModel;
import definition.BiddingRole;
import lombok.AllArgsConstructor;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CorePositionDto;
import member.api.dto.core.CoreUserDto;
import member.api.vo.MemberVo;
import member.model.core.CoreCompany;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.response.BaseResponse;
import utils.GlobalContants;
import workflow.vo.WorkFlowVo;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("company")
public class BiddingCompanyController {

    @Autowired
    BiddingCompanyService biddingCompanyService;
    @RequestMapping("/companyTree")
    public List<JsonModel> companyTree(HttpServletRequest request) {
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID);
        List<JsonModel> companyTree = new ArrayList<>();
        companyTree=biddingCompanyService.companyTree(userId, CorePositionDto.POSITION_JC_CGJBR);
        return companyTree;

    }
}
