package bidding.web.controller;

import bidding.web.service.BiddingGroupService;
import bidding.web.service.BiddingOperatorService;
import bidding.web.vo.*;
import definition.BiddingRole;
import dto.JcbdBiddingOperationLogDto;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@RestController
@RequestMapping("biddingGroup")
public class BiddingGroupController {

    public static final Logger log = org.slf4j.LoggerFactory.getLogger(BiddingGroupController.class);
    public static final String businessCode = "竞价采购";
    @Autowired
    BiddingGroupService biddingGroupService;

    @Autowired
    BiddingOperatorService biddingOperatorService;

    /**
     * 保存符合性审查
     *
     * @param biddingConformityAuditVO
     * @param request
     * @return
     */
    @RequestMapping(value = {"/saveComplianceAudit"}, method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse saveComplianceAudit(@RequestBody BiddingConformityAuditVO biddingConformityAuditVO, HttpServletRequest request) {
        if(biddingOperatorService.biddingIsFinish(biddingConformityAuditVO.getBiddingNo())){
            return new BaseResponse("当前竞价已终止");
        }
        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(biddingConformityAuditVO.getSource())){
            String email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
            if (!StringUtils.isEmpty(email)) {
                biddingConformityAuditVO.setEmail(email);
                BaseResponse baseResponse = biddingGroupService.saveComplianceAudit(biddingConformityAuditVO);
                return baseResponse;
            }
        }else {
            String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
            if (!StringUtils.isEmpty(biddingMemberId)) {
                biddingConformityAuditVO.setAuditorId(biddingMemberId);
                BaseResponse baseResponse = biddingGroupService.saveComplianceAudit(biddingConformityAuditVO);
                return baseResponse;
            }
        }
        /*String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (!StringUtils.isEmpty(biddingMemberId)) {
            biddingConformityAuditVO.setAuditorId(biddingMemberId);
            BaseResponse baseResponse = biddingGroupService.saveComplianceAudit(biddingConformityAuditVO);
            return baseResponse;
        } else {
            String email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
            if (!StringUtils.isEmpty(email)) {
                biddingConformityAuditVO.setEmail(email);
                BaseResponse baseResponse = biddingGroupService.saveComplianceAudit(biddingConformityAuditVO);
                return baseResponse;
            }
        }*/
        return new BaseResponse("获取当前用户信息失败");
    }


    /**
     * 提交符合性审查结果
     * 判断当前小组成员是不是最后一个提交的
     *
     * @param
     * @param request
     * @return
     */
    @RequestMapping(value = {"/submitComplianceAudit"}, method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse submitComplianceAudit(String biddingNo, HttpServletRequest request, String source) {
        if(biddingOperatorService.biddingIsFinish(biddingNo)){
            return new BaseResponse("当前竞价已终止");
        }
        String email = null;
        String auditorId = null;
        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(source)){
            email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
        }else{
            auditorId =(String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        }
        //获取当前登录人id
        if (!StringUtils.isEmpty(auditorId) || !StringUtils.isEmpty(email)) {
            BaseResponse baseResponse = biddingGroupService.submitComplianceAuditResult(biddingNo, auditorId, email);
            //操作记录
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("提交符合性审查");
                jcbdBiddingOperationLogDto.setRemark("");
                if (auditorId != null) {
                    biddingOperatorService.saveOperatorsLog(auditorId, biddingNo, jcbdBiddingOperationLogDto);
                } else if (email != null) {
                    biddingOperatorService.saveOperatorsLog(email, biddingNo, jcbdBiddingOperationLogDto);

                }
            }
            return baseResponse;
        }
        return new BaseResponse("获取当前用户信息失败");
    }

    /**
     * 判断当前人员是不是完成审查
     *
     * @param
     * @param request
     * @return
     */
    @RequestMapping(value = {"/submitComplianceAuditResult"}, method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse submitComplianceAuditResult(String biddingNo, HttpServletRequest request, String source) {
        BaseResponse baseResponse = null;
        String email = null;
        String auditorId =null;
        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(source)){
            email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);

        }else {
            auditorId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        }
        if (!StringUtils.isEmpty(auditorId) || !StringUtils.isEmpty(email)) {
            baseResponse = biddingGroupService.compeleteAudit(biddingNo, auditorId, email);
        }
        return baseResponse;
    }


    /**
     * 审核竞价
     *
     * @param biddingDemandAuditVo
     */
    @RequestMapping(value = {"/auditBidding"}, method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse auditBidding(@RequestBody BiddingDemandAuditVo biddingDemandAuditVo, HttpServletRequest request) {
        if(biddingOperatorService.biddingIsFinish(biddingDemandAuditVo.getBiddingNo())){
            return new BaseResponse("当前竞价已终止");
        }
        String email = null;
        String auditorId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);;
//        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(biddingDemandAuditVo.getSource())){
        if (Lang.isEmpty(auditorId)){
            email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
        }
        biddingDemandAuditVo.setEmail(email);
        biddingDemandAuditVo.setAuditorId(auditorId);

        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        log.info("login memberId{}",memberId);
        MemberDto memberDto = biddingOperatorService.getMember(memberId);
        if(!Lang.isEmpty(email) && !Lang.isEmpty(memberDto) && !Lang.isEmpty(memberDto.getCoreUser())){
            if(!email.equals(memberDto.getCoreUser().getEmail())){
                return new BaseResponse("账号登录异常！ ");
            }
        }

        if (!Lang.isEmpty(email) || !Lang.isEmpty(auditorId)) {
            if (!biddingDemandAuditVo.getBiddingNo().isEmpty()) {

                BaseResponse baseResponse = biddingGroupService.auditBidding(biddingDemandAuditVo);

                //操作记录
                if (baseResponse.isSuccess()) {
                    String pass="1";
                    String noPass="0";
                    JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                    if(pass.equals(biddingDemandAuditVo.getStatus())){
                    jcbdBiddingOperationLogDto.setOperationContent("审核竞价通过");
                    }else if(noPass.equals(biddingDemandAuditVo.getStatus())){
                        jcbdBiddingOperationLogDto.setOperationContent("审核竞价不通过");
                    }
                    if(biddingDemandAuditVo.getAuditMemo().isEmpty()){
                        jcbdBiddingOperationLogDto.setRemark("同意");
                    }else {
                        jcbdBiddingOperationLogDto.setRemark(biddingDemandAuditVo.getAuditMemo());
                    }

                    if (auditorId != null) {
                        biddingOperatorService.saveOperatorsLog(auditorId, biddingDemandAuditVo.getBiddingNo(), jcbdBiddingOperationLogDto);
                    } else if (email != null) {
                        biddingOperatorService.saveOperatorsLog(email, biddingDemandAuditVo.getBiddingNo(), jcbdBiddingOperationLogDto);

                    }
                }
                return baseResponse;
            }
        }
        return new BaseResponse("已审核，请勿重复审核 ");
    }

    /**
     * 投票确认供应商（开启投票）
     *
     * @param changeStateVo
     * @return
     */
    @RequestMapping(value = {"/voteConfirmSupplier"}, method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse voteConfirmSupplier(@RequestBody BiddingChangeStateVo changeStateVo, HttpServletRequest request) {
        if(biddingOperatorService.biddingIsFinish(changeStateVo.getBiddingNo())){
            return new BaseResponse("当前竞价已终止");
        }
        String auditorId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (!Lang.isEmpty(changeStateVo.getBiddingNo()) && !Lang.isEmpty(auditorId)) {
            BaseResponse baseResponse = biddingGroupService.voteConfirmSupplier(changeStateVo,auditorId);
            //操作记录
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("开启投票");
                jcbdBiddingOperationLogDto.setRemark("");
                biddingOperatorService.saveOperatorsLog(auditorId, changeStateVo.getBiddingNo(), jcbdBiddingOperationLogDto);
            }
            return baseResponse;
        }
        return new BaseResponse("竞价编号为空");
    }


    /**
     * 对报价相同的供应商投票
     *
     * @param voteDetailVo
     */
    @RequestMapping(value = {"/vote"}, method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse vote(@RequestBody VoteDetailVo voteDetailVo, HttpServletRequest request) {
        if(biddingOperatorService.biddingIsFinish(voteDetailVo.getBusinessIdentifying())){
            return new BaseResponse("当前竞价已终止");
        }
        BaseResponse baseResponse = null;
        //封装业务码
        voteDetailVo.setBusinessCode(businessCode);
        String auditorEmail = null;
        String auditorId =null;
        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(voteDetailVo.getSource())){
            auditorEmail = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
            //获取当前登录人 是否有权限
            String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
            MemberDto memberDto = biddingOperatorService.getMember(memberId);
            if(!Lang.isEmpty(auditorEmail) && !Lang.isEmpty(memberDto) && !Lang.isEmpty(memberDto.getCoreUser())){
                if(!auditorEmail.equals(memberDto.getCoreUser().getEmail())){
                    return new BaseResponse("投票异常");
                }
            }

        }else {
            auditorId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        }
        if (!StringUtils.isEmpty(auditorId) || !StringUtils.isEmpty(auditorEmail)) {
            voteDetailVo.setVoteMemberId(auditorId);
            baseResponse = biddingGroupService.vote(voteDetailVo, auditorEmail);

            //操作记录
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("投票");
                jcbdBiddingOperationLogDto.setRemark("");
                if (auditorId != null) {
                    biddingOperatorService.saveOperatorsLog(auditorId, voteDetailVo.getBusinessIdentifying(), jcbdBiddingOperationLogDto);
                } else if (auditorEmail != null) {
                    biddingOperatorService.saveOperatorsLog(auditorEmail, voteDetailVo.getBusinessIdentifying(), jcbdBiddingOperationLogDto);
                }
            }
        }
        return baseResponse;
    }

    /**
     * 重新发起符合性审查
     *
     * @param
     * @param resComplianceAuditVo
     * @return
     */
    @RequestMapping(value = {"/restartComplianceAudit"}, method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse restartComplianceAudit(@RequestBody ResComplianceAuditVo resComplianceAuditVo, HttpServletRequest request) {
        if(biddingOperatorService.biddingIsFinish(resComplianceAuditVo.getBiddingNo())){
            return new BaseResponse("当前竞价已终止");
        }
        String auditorId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        BaseResponse baseResponse = null;
        if (!StringUtils.isEmpty(resComplianceAuditVo.getBiddingNo())) {
            baseResponse = biddingGroupService.restartComplianceAudit(resComplianceAuditVo,auditorId);
            //操作记录
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("重新发起符合性审查");
                jcbdBiddingOperationLogDto.setRemark("");
                biddingOperatorService.saveOperatorsLog(auditorId, resComplianceAuditVo.getBiddingNo(), jcbdBiddingOperationLogDto);
            }
        }
        return baseResponse;
    }

}
