package bidding.web.controller;

import bidding.api.vo.BiddingMemberLoginInfoVo;
import com.alibaba.fastjson.JSON;
import definition.BiddingRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.security.AesUtil;

import javax.servlet.http.HttpSession;
import java.util.Base64;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@Controller
@RequestMapping("biddingGroupMember")
public class BiddingLoginController {
    @Value("${bidding.groupMember.login.params}")
    public String groupMemberLoginKey;
    @Value("${bidding.groupMember.loginUrl}")
    private String groupMemberLoginUrl;
    final Logger logger = LoggerFactory.getLogger(getClass());

    @RequestMapping("check")
    public String login(HttpSession session, String params) {
        BiddingMemberLoginInfoVo biddingMemberLoginInfoVo = null;
        try {
            biddingMemberLoginInfoVo = JSON.parseObject(new String(AesUtil.Decrypt(new String(Base64.getDecoder().decode(params)), groupMemberLoginKey)), BiddingMemberLoginInfoVo.class);
//            biddingMemberLoginInfoVo = JSON.pls
// arseObject(params, BiddingMemberLoginInfoVo.class);
            logger.info("biddingMemberLoginInfoVo={}",JSON.toJSONString(biddingMemberLoginInfoVo));
        } catch (Exception e) {
            e.printStackTrace();
        }
        session.setAttribute(BiddingRole.BIDDING_USER_EMAIL, biddingMemberLoginInfoVo.getEmail());
        session.setAttribute(BiddingRole.BIDDING_MEMBER_ROLE, BiddingRole.BIDDING_GROUP_MEMBER);
        return  new StringBuilder("redirect:").append(biddingMemberLoginInfoVo.getRedirectUrl()).append("?biddingNo=").append(biddingMemberLoginInfoVo.getBiddingNo()).append("&source=").append(BiddingRole.BIDDING_GROUP_MEMBER).toString();
    }

    @RequestMapping("getUrl")
    @ResponseBody
    public String getUrl(String biddingNo, String email, String redirectUrl) {
//        String aesKey = "0000000000000000";
//        String loginUrl = "http://127.0.0.1/bidding-web/biddingGroupMember/check";

//        String email = "123456@qq.com";
//        String redirectUrl = "/operator/auditBidding";
//        String biddingNo = "B2018040041";

        BiddingMemberLoginInfoVo biddingMemberLoginInfoVo = new BiddingMemberLoginInfoVo();
        biddingMemberLoginInfoVo.setBiddingNo(biddingNo);
        biddingMemberLoginInfoVo.setEmail(email);
        biddingMemberLoginInfoVo.setRedirectUrl(redirectUrl);
        String paramsJsonStr = JSON.toJSONString(biddingMemberLoginInfoVo);
//        String params = paramsJsonStr;
        try {
            String params = AesUtil.Encrypt(paramsJsonStr, groupMemberLoginKey);
            params = new String(Base64.getEncoder().encode(params.getBytes()));
            String url = groupMemberLoginUrl + "?params=" + params;
            logger.info("url={}", url);
            return url;

        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
