package bidding.web.controller;

import bidding.web.service.BiddingOperatorService;
import bidding.web.service.impl.BiddingOperatorServiceImpl;
import bidding.web.vo.*;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOperateCode;
import definition.BiddingRole;
import definition.BiddingStatus;
import dto.JcbdBiddingDemandResponseDto;
import dto.JcbdBiddingOperationLogDto;
import member.api.QueryInformationApi;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.JsonModel;
import member.api.vo.MemberAddressVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import store.api.dto.modeldto.core.StoreDto;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;
import utils.excel.ReadExcelUtil;
import utils.web.ResponseMapUtils;
import workflow.definition.WorkFlowCode;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@RestController
@RequestMapping("biddingOperator")
public class BiddingOperatorController {

    @Autowired
    BiddingOperatorService biddingOperatorService;
    public static final Logger log = LoggerFactory.getLogger(BiddingOperatorController.class);

    // 是否与收件人地址相同 ，此处取不相同
    private static final String CONSIGNEE_FLAG = "0";

    @MotanReferer
    QueryInformationApi queryInformationApi;

    /**
     * 开启竞价符合性审查（竞价状态更新）
     */
    @RequestMapping(value = {"/startComplianceAudit"}, method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse startComplianceAudit(@RequestBody BiddingChangeStateVo biddingChangeStateVo, HttpServletRequest request) {
        if (biddingOperatorService.biddingIsFinish(biddingChangeStateVo.getBiddingNo())) {
            return new BaseResponse("当前竞价已终止");
        }
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (!Lang.isEmpty(biddingChangeStateVo.getBiddingNo()) && !Lang.isEmpty(biddingMemberId)) {
            BaseResponse baseResponse = biddingOperatorService.startComplianceAudit(biddingChangeStateVo, biddingMemberId);

            //操作记录
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("开启符合性审查");
                jcbdBiddingOperationLogDto.setRemark("");
                biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingChangeStateVo.getBiddingNo(), jcbdBiddingOperationLogDto);
            }
            return baseResponse;
        }
        return new BaseResponse("竞价编号为空");
    }

    /**
     * 重发审查邮件（竞价管理页符合性审查）
     *
     * @param biddingNo
     * @return
     */
    @RequestMapping(value = {"/reSendAuditEmail"}, method = RequestMethod.POST)
    public BaseResponse reSendAuditEmail(String biddingNo, HttpServletRequest request) {
        if (biddingOperatorService.biddingIsFinish(biddingNo)) {
            return new BaseResponse("当前竞价已终止");
        }
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (!Lang.isEmpty(biddingNo) && !Lang.isEmpty(biddingMemberId)) {
            BaseResponse baseResponse = biddingOperatorService.reSendAuditEmail(biddingNo, biddingMemberId);

            //操作记录
            if (baseResponse.isSuccess()) {
                JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                jcbdBiddingOperationLogDto.setOperationContent("重发审查邮件");
                jcbdBiddingOperationLogDto.setRemark("");
                biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingNo, jcbdBiddingOperationLogDto);
            }
            return baseResponse;
        }
        return new BaseResponse("竞价编号获取失败");
    }

    /**
     * 重发审核邮件（竞价审核）
     *
     * @param biddingNo
     * @return
     */
    @RequestMapping(value = {"/reSendBiddingAuditEmail"}, method = RequestMethod.POST)
    public BaseResponse reSendBiddingAuditEmail(String biddingNo, HttpServletRequest request) {
        if (biddingOperatorService.biddingIsFinish(biddingNo)) {
            return new BaseResponse("当前竞价已终止");
        }
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (!Lang.isEmpty(biddingNo)) {
            biddingOperatorService.mailOfGroupMembers(biddingNo, biddingMemberId);
            //操作记录
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("重发审核邮件");
            jcbdBiddingOperationLogDto.setRemark("");
            biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingNo, jcbdBiddingOperationLogDto);
            return new BaseResponse(true, "发送成功");
        }
        return new BaseResponse("竞价编号获取失败");
    }

    /**
     * 竞价列表查询
     *
     * @param jqueryDataTablesVo
     * @param request
     * @param queryBiddingRequestVO
     * @return
     */
    @RequestMapping(value = {"/querryPageBidding"}, method = RequestMethod.POST)
    @ResponseBody
    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, HttpServletRequest request, QueryBiddingRequestVO queryBiddingRequestVO) {
        //获取当前登录人id
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        String biddingEmail = null;
        if (biddingMemberId == null) {
            biddingEmail = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
        }
        //获取当前登录人角色
        List<String> biddingMemberRoles = new ArrayList<>();
        String biddingMemberRole = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ROLE);
        if (Lang.isEmpty(biddingEmail) && Lang.isEmpty(biddingMemberId) && Lang.isEmpty(biddingMemberRole)) {
            return ResponseMapUtils.error("获取用户信息失败");
        }
        if (!Lang.isEmpty(biddingMemberRole)) {
            biddingMemberRoles.add(BiddingRole.BIDDING_OPERATOR);
//            biddingMemberRoles.add(BiddingRole.BIDDING_GROUP_MEMBER);
            biddingMemberRoles.add(biddingMemberRole);
            request.getSession().setAttribute("operateIdentity", biddingMemberId);
        } else {
            biddingMemberRoles.add(BiddingRole.BIDDING_GROUP_MEMBER);
            request.getSession().setAttribute("operateIdentity", biddingEmail);
        }
        Map resultMap = biddingOperatorService.querryPageBidding(jqueryDataTablesVo, biddingMemberId, biddingEmail, biddingMemberRoles, queryBiddingRequestVO);
        queryBiddingRequestVO.setPageNo((jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength()) + 1 + "");
        request.getSession().setAttribute("operateBiddingTemp", JSON.toJSONString(queryBiddingRequestVO));
        request.getSession().setAttribute("operateBiddingPageTemp", JSON.toJSONString(jqueryDataTablesVo));
        return ResponseMapUtils.success(resultMap);
    }

    /**
     * 发布竞价
     *
     * @param biddingIssueRequestVo
     * @return
     */
    @RequestMapping(value = {"/issueBidding"}, method = RequestMethod.POST)
    @ResponseBody
    public Map issueBidding(@RequestBody BiddingIssueRequestVo biddingIssueRequestVo, HttpServletRequest request) {
        if (biddingOperatorService.biddingIsFinish(biddingIssueRequestVo.getBiddingCode())) {
            return ResponseMapUtils.error("当前竞价已终止");
        }
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (Lang.isEmpty(biddingIssueRequestVo) || Lang.isEmpty(biddingIssueRequestVo.getBiddingCode())) {
            return ResponseMapUtils.error("获取不到竞价编号");
        }
        Map returnMap = biddingOperatorService.issueBidding(biddingIssueRequestVo, biddingMemberId);

        //操作记录
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        jcbdBiddingOperationLogDto.setOperationContent("发布竞价");
        jcbdBiddingOperationLogDto.setRemark("");
        biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingIssueRequestVo.getBiddingCode(), jcbdBiddingOperationLogDto);

        return returnMap;
    }

    @RequestMapping(value = {"/getBiddingTime"}, method = RequestMethod.POST)
    @ResponseBody
    public Map getBiddingTime(String biddingCode) {
        JcbdBiddingVo jcbdBiddingVo = biddingOperatorService.getBiddingByBiddingCode(biddingCode);
        Integer a = jcbdBiddingVo.getBiddingPeriod();
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar ca = Calendar.getInstance();
        ca.add(Calendar.DATE, a);// num为增加的天数，可以改变的
        date = ca.getTime();
        String s = DateUtils.toString(date, "yyyy-MM-dd");
        return ResponseMapUtils.success(s);
    }

    /**
     * @author taofeng
     * @date 2018/3/16
     * <p>
     * 基本信息页_获取竞价编号/经办人信息/供应商信息
     */
    @RequestMapping(value = "biddingCodeAndUser", method = RequestMethod.POST)
    public JcbdBiddingVo getBiddingCodeAndUser(HttpServletRequest request, JcbdBiddingVo jcbdBiddingVo) {

        //竞价编号
        String biddingCode = biddingOperatorService.getBiddingCode();
        jcbdBiddingVo.setBiddingCode(biddingCode);

        //经办人
        String biddingUserId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        JcbdBiddingVo biddingMember = biddingOperatorService.getOperator(biddingUserId);

        UserInformationVo memberCompanyInformation = biddingOperatorService.getMemberCompanyInformatio(biddingUserId);
        jcbdBiddingVo.setUsername(biddingMember.getUsername());
        jcbdBiddingVo.setPhone(biddingMember.getPhone());
        jcbdBiddingVo.setEmail(biddingMember.getEmail());
        jcbdBiddingVo.setGroupMemberInfo(new StringBuffer(memberCompanyInformation.getWholeJobName()).append(",").append(biddingMember.getUsername()).append(",").append(biddingMember.getEmail()).toString());

        //供应商信息
        List<JcbdBdProviderVo> jcbdStoreContactsVoList = biddingOperatorService.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
        jcbdBiddingVo.setJcbdBdProviders(jcbdStoreContactsVoList);

        return jcbdBiddingVo;
    }


    /**
     * @author taofeng
     * @date 2018/3/22
     * <p>
     * 查询供应商
     **/
    /*@RequestMapping(value = "getProvider", method = RequestMethod.POST)
    public List<JcbdStoreContactsVo> findProvider(Model model, HttpServletRequest request) {

        //String providerType = (String) request.getSession().getAttribute(StoreDto.STORE_TYPE_SUPLIER);
        List<JcbdStoreContactsVo> jcbdStoreContactsVoList = biddingOperatorService.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);

        return jcbdStoreContactsVoList;
    }*/

    /**
     * @author taofeng
     * @date 2018/3/16
     * <p>
     * 基本信息页_保存
     */
    @RequestMapping(value = "/biddingEdit", method = RequestMethod.POST)
    public Map biddingEdit(HttpServletRequest request, JcbdBiddingVo jcbdBiddingVo, @RequestParam(required = false) String imageVos) {

        //竞价id
        String id = request.getParameter("biddingId");
        jcbdBiddingVo.setId(id);
        //经办人id
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (Lang.isEmpty(memberId) || "".equals(memberId)) {
            return ResponseMapUtils.error("经办人信息获取失败");
        }
        String userId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_ID);
        if (Lang.isEmpty(userId) || "".equals(userId)) {
            return ResponseMapUtils.error("经办人信息获取userId失败");
        }
        JcbdBiddingVo operator = biddingOperatorService.getOperator(memberId);
        jcbdBiddingVo.setOperatorId(memberId);
        jcbdBiddingVo.setUsername(operator.getUsername());
        jcbdBiddingVo.setEmail(operator.getEmail());
        jcbdBiddingVo.setPhone(operator.getPhone());
        //附件
        List<ImageVo> imageVoList = JSON.parseArray(imageVos, ImageVo.class);

        //竞价小组
        String[] biddingGroups = request.getParameterValues("biddingGroup");
        String[] hiddenBiddingGroupMemberIds = request.getParameterValues("hiddenBiddingGroupMemberId");
        String[] hiddenBiddingSpliceStringIds = request.getParameterValues("hiddenBiddingSpliceStringIds");


        Map resultMap = biddingOperatorService.saveOrUpdateBiddingBaseInfo(jcbdBiddingVo, biddingGroups, hiddenBiddingGroupMemberIds, hiddenBiddingSpliceStringIds, imageVoList, userId);
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        if (Lang.isEmpty(id)) {
            jcbdBiddingOperationLogDto.setOperationContent("保存竞价");
            jcbdBiddingOperationLogDto.setRemark("");
        } else {
            jcbdBiddingOperationLogDto.setOperationContent("修改竞价并保存");
            jcbdBiddingOperationLogDto.setRemark("");
        }
        biddingOperatorService.saveOperatorsLog(memberId, jcbdBiddingVo.getBiddingCode(), jcbdBiddingOperationLogDto);
        return resultMap;
    }

    /**
     * @author taofeng
     * @date 2018/4/4
     * <p>
     * 基本信息页_修改
     */
    @RequestMapping(value = "/biddEdit", method = RequestMethod.POST)
    public JcbdBiddingVo bidEdit(HttpServletRequest request, String biddingCode) {

        JcbdBiddingVo biddingVo = biddingOperatorService.getBiddingByBiddingCode(biddingCode);
        if (!Lang.isEmpty(biddingVo)) {
            String biddingUserId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
            JcbdBiddingVo byMemberId = biddingOperatorService.getOperator(biddingUserId);
            biddingVo.setUsername(byMemberId.getUsername());
            biddingVo.setPhone(byMemberId.getPhone());
            biddingVo.setEmail(byMemberId.getEmail());
            List<JcbdBdProviderVo> jcbdStoreContactsVoList = biddingOperatorService.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
            biddingVo.setJcbdBdProviders(jcbdStoreContactsVoList);
            return biddingVo;
        }
        return null;
    }

    /**
     * @author taofeng
     * @date 2018/3/22
     * <p>
     * 获取需求编号
     **/
    @RequestMapping(value = "biddingDemandCode", method = RequestMethod.POST)
    public BiddingDemandVo getBiddingDemandCode(String biddingCode) {

        BiddingDemandVo biddingDemandVo = new BiddingDemandVo();
        String demandCode = biddingOperatorService.getDemandCode(biddingCode);
        biddingDemandVo.setDemandCode(demandCode);

        return biddingDemandVo;
    }


    /**
     * @author taofeng
     * @date 2018/3/16
     * <p>
     * 竞价需求页保存
     */
    @RequestMapping(value = "biddingDemandEdit", method = RequestMethod.POST)
    public String biddingDemandEdit(HttpServletRequest request, BiddingDemandVo biddingDemandVo) {

        String opertorsId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);

        if (Lang.isEmpty(biddingDemandVo.getBiddingId())) {
            return "biddingId_is_null";
        }

        //需求地址及数量
        String[] demandAddress = request.getParameterValues("demandAddress");
        String[] numberNeed = request.getParameterValues("numberNeed");

        //竞价需求符合性列表
        String[] conformances = request.getParameterValues("conformance");

        biddingOperatorService.saveOrUpdateBiddingDemand(biddingDemandVo, demandAddress, numberNeed, conformances);


        return "success";
    }

    /**
     * @author taofeng
     * @date 2018/3/22
     * <p>
     * 竞价提交审核
     **/
    @RequestMapping(value = "/submitBiddingAudit", method = RequestMethod.POST)
    public String saveBiddingToAuditing(HttpServletRequest request, String biddingCode) {
        if (biddingOperatorService.biddingIsFinish(biddingCode)) {
            return "error";
        }
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (Lang.isEmpty(biddingCode)) {
            return "biddingCode_id_null";
        }
        if (Lang.isEmpty(biddingMemberId)) {
            return "biddingMemberId_is_null";
        }
        biddingOperatorService.updateBiddingGroupCheckNo(biddingCode);
        JcbdBiddingVo jcbdBiddingVo = biddingOperatorService.findByBiddingCodeAndIsDelete(biddingCode);
        //验证是否已经添加了竞价需求
        List<BiddingDemandVo> biddingDemandVoList = biddingOperatorService.findByJcbdBiddingCodeAndIsDelete(biddingCode);
        if (Lang.isEmpty(biddingDemandVoList)) {
            return "error";
        }
        BiddingChangeStateVo biddingChangeStateVo = new BiddingChangeStateVo();
        biddingChangeStateVo.setBiddingNo(biddingCode);
        //新建竞价采购
        biddingChangeStateVo.setOpcode(BiddingOperateCode.SUBMIT_BIDDING.getCode());
        //待审核
        if (jcbdBiddingVo.getStatus().equals(BiddingStatus.OM_SUBMIT_WAIT.getValue())) {
            biddingChangeStateVo.setCurrentState(BiddingStatus.OM_SUBMIT_WAIT.getValue());
        } else {
            biddingChangeStateVo.setCurrentState(BiddingStatus.OM_AUDIT_NO.getValue());
        }
        //竞价的ark("");
        biddingOperatorService.changeBiddingState(biddingChangeStateVo);

        //操作记录
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        jcbdBiddingOperationLogDto.setOperationContent("提交审核");
        jcbdBiddingOperationLogDto.setRemark("");
        biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingCode, jcbdBiddingOperationLogDto);

        //邮件发送
        biddingOperatorService.mailOfGroupMembers(biddingCode, biddingMemberId);
        return "success";
    }

    /**
     * @author taofeng
     * @date 2018/3/23
     * <p>
     * 竞价审核基本信息页(基本信息页查看)
     **/
    @RequestMapping(value = "/getBiddingBaseInfo", method = RequestMethod.POST)
    public JcbdBiddingVo auditBidding(String biddingNo, HttpServletRequest request) {

        JcbdBiddingVo jcbdBiddingVo = biddingOperatorService.getBiddingByBiddingCode(biddingNo);
        //重新封装竞价小组成员信息
        List<JcbdBiddingGroupMemberVo> jcbdBiddingGroupMembersNew = new ArrayList<>();
        if (!Lang.isEmpty(jcbdBiddingVo.getJcbdBiddingGroupMembers())) {
            List<JcbdBiddingGroupMemberVo> jcbdBiddingGroupMembers = jcbdBiddingVo.getJcbdBiddingGroupMembers();
            for (JcbdBiddingGroupMemberVo jcbdBiddingGroupMember : jcbdBiddingGroupMembers) {
                String companyName = biddingOperatorService.getOperateInformation(jcbdBiddingGroupMember.getGroupMemberId()).getWholeJobName();
                jcbdBiddingGroupMember.setName(new StringBuffer(companyName).append(jcbdBiddingGroupMember.getName()).toString());
                jcbdBiddingGroupMembersNew.add(jcbdBiddingGroupMember);
            }
            jcbdBiddingVo.setJcbdBiddingGroupMembers(jcbdBiddingGroupMembersNew);
        }
        //经办人
        String operatorId = jcbdBiddingVo.getOperatorId();
        JcbdBiddingVo biddingVo = biddingOperatorService.getOperator(operatorId);
        /*List<JcbdBiddingGroupMemberVo> groupMemberVoList = biddingVo.getJcbdBiddingGroupMembers();
        if (!Lang.isEmpty(groupMemberVoList)) {
            //获取当前登陆人userId
            String userId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_ID);
            Boolean disJcbdBiddingGroupMember = biddingOperatorService.disJcbdBiddingGroup(userId, groupMemberVoList);
            if (!disJcbdBiddingGroupMember) {
                return null;
            }
        }*/

        jcbdBiddingVo.setUsername(biddingVo.getUsername());
        jcbdBiddingVo.setPhone(biddingVo.getPhone());
        jcbdBiddingVo.setEmail(biddingVo.getEmail());

        //供应商信息
        List<JcbdBdProviderVo> jcbdBdProviders = jcbdBiddingVo.getJcbdBdProviders();
        List<JcbdBdProviderVo> jcbdStoreList = biddingOperatorService.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
        for (int i = 0; i < jcbdStoreList.size(); i++) {
            if (jcbdStoreList.get(i).getProviderName().equals(jcbdBdProviders.get(i).getProviderName())) {
                jcbdStoreList.get(i).setResponseStatus(jcbdBdProviders.get(i).getResponseStatus());
            }
        }
        jcbdBiddingVo.setJcbdBdProviders(jcbdStoreList);

        Date timeStartResponse = jcbdBiddingVo.getTimeStartResponse();
        Date timeEndResponse = jcbdBiddingVo.getTimeEndResponse();
        if (!(Lang.isEmpty(timeStartResponse) && Lang.isEmpty(timeEndResponse))) {
            jcbdBiddingVo.setTimeStartResponses(DateUtils.dateToStr(timeStartResponse, GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
            jcbdBiddingVo.setTimeEndResponses(DateUtils.dateToStr(timeEndResponse, GlobalContants.DateFormat.YYYY_MM_DD_HH_MM_SS));
        }

        return jcbdBiddingVo;
    }

    /**
     * 查詢競價需求列表
     *
     * @param jqueryDataTablesVo
     * @param biddingCode
     * @return
     */
    @RequestMapping(value = {"/querryPageBiddingDemad"}, method = RequestMethod.POST)
    @ResponseBody
    public Map querryPageBiddingDemad(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价错误");
        }
        Map resultMap = biddingOperatorService.querryPageBiddingDemad(jqueryDataTablesVo, biddingCode);
        return ResponseMapUtils.success(resultMap);
    }

    /**
     * 供应商竞价响应概要信息查询
     *
     * @param biddingCode
     * @param demandCode
     * @return
     */
    @RequestMapping(value = {"/queryResponseOutline"}, method = RequestMethod.POST)
    @ResponseBody
    public Map queryResponseOutline(String biddingCode, String demandCode) {
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价信息失败");
        }
        if (Lang.isEmpty(demandCode)) {
            return ResponseMapUtils.error("获取需求信息失败");
        }
        Map resultMap = biddingOperatorService.queryResponseOutline(biddingCode, demandCode);
        resultMap.put("demandCode", demandCode);
        return resultMap;
    }

    /**
     * 查询供应商需求响应
     *
     * @param biddingCode
     * @param demandCode
     * @param supplierId
     * @return
     */
    @RequestMapping(value = {"/queryDemandResponse"}, method = RequestMethod.POST)
    public Map queryDemandResponse(String biddingCode, String demandCode, String supplierId) {
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价信息失败");
        }
        if (Lang.isEmpty(demandCode)) {
            return ResponseMapUtils.error("获取需求信息失败");
        }
        if (Lang.isEmpty(supplierId)) {
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingOperatorService.queryDemandResponse(biddingCode, demandCode, supplierId);
        return resultMap;
    }

    /**
     * 提交竞价结果审核
     *
     * @param submitResultVo
     * @param request
     * @return
     */
    @RequestMapping(value = "/submitResultAudit", method = RequestMethod.POST)
    public Map submitResultAudit(@RequestBody SubmitResultVo submitResultVo, HttpServletRequest request) {
        if (biddingOperatorService.biddingIsFinish(submitResultVo.getBiddingCode())) {
            return ResponseMapUtils.error("当前竞价已终止");
        }
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (Lang.isEmpty(submitResultVo.getBiddingCode())) {
            return ResponseMapUtils.error("获取竞价信息失败");
        }
        if (Lang.isEmpty(memberId)) {
            return ResponseMapUtils.error("获取用户信息失败");
        }
        Map resultAudit = biddingOperatorService.submitResultAudit(submitResultVo, memberId);
        //操作记录
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        jcbdBiddingOperationLogDto.setOperationContent("提交竞价结果审核");
        jcbdBiddingOperationLogDto.setRemark("");
        biddingOperatorService.saveOperatorsLog(memberId, submitResultVo.getBiddingCode(), jcbdBiddingOperationLogDto);

        return resultAudit;
    }

    /**
     * @author taofeng
     * @date 2018/3/31
     * <p>
     * 竞价需求_列表
     **/
    @RequestMapping(value = "/findBidDemandPage", method = RequestMethod.POST)
    public Map findBidDemandPage(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        if (Lang.isEmpty(biddingCode)) {
            return null;
        }
        Map resultMap = biddingOperatorService.getBiddingDemandList(jqueryDataTablesVo, biddingCode);
        return ResponseMapUtils.success(resultMap);
    }


    /**
     * @author taofeng
     * @date 2018/3/28
     * <p>
     * 竞价需求_查看及修改
     **/
    @RequestMapping(value = "/getBiddingDemandInfo", method = RequestMethod.POST)
    @ResponseBody
    public BiddingDemandVo findBidDemand(BiddingDemandVo biddingDemandVo) {

        BiddingDemandVo bidDemand = biddingOperatorService.getBiddingDemandInfo(biddingDemandVo.getDemandCode());
        return bidDemand;
    }

    /**
     * @author taofeng
     * @date 2018/3/31
     * <p>
     * 竞价需求_删除
     **/
    @RequestMapping(value = "/deleteBidDemand", method = RequestMethod.POST)
    public BaseResponse deleteBidDemand(BiddingDemandVo biddingDemandVo) {
        BaseResponse baseResponse = null;
        if (!Lang.isEmpty(biddingDemandVo)) {
            baseResponse = biddingOperatorService.deleteBidDemand(biddingDemandVo.getDemandCode());
        }
        return baseResponse;
    }

    /**
     * @author taofeng
     * @date 2018/3/29
     * <p>
     * 开启报价
     **/
    @RequestMapping(value = "/OpenbidPrice", method = RequestMethod.POST)
    public BaseResponse OpenbidPrice(JcbdBiddingVo jcbdBiddingVo, HttpServletRequest request) {
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);

        String biddingCode = jcbdBiddingVo.getBiddingCode();

        if (biddingOperatorService.biddingIsFinish(biddingCode)) {
            return new BaseResponse("当前竞价已终止");
        }

        BaseResponse baseResponse = biddingOperatorService.openPrice(biddingCode);

        //操作记录
        if (baseResponse.isSuccess()) {
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("开启报价");
            jcbdBiddingOperationLogDto.setRemark("");
            biddingOperatorService.saveOperatorsLog(memberId, biddingCode, jcbdBiddingOperationLogDto);
        }
        return baseResponse;
    }

    /**
     * @author taofeng
     * @date 2018/3/29
     * <p>
     * 系统随机选择供应商
     **/
    @RequestMapping(value = "/randomProvider", method = RequestMethod.POST)
    public BaseResponse randomProvider(JcbdBiddingVo jcbdBiddingVo, HttpServletRequest request) {
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);

        String biddingCode = jcbdBiddingVo.getBiddingCode();
        if (biddingOperatorService.biddingIsFinish(biddingCode)) {
            return new BaseResponse("当前竞价已终止");
        }
        BaseResponse baseResponse = biddingOperatorService.randomConfirmSupplier(biddingCode);
        //操作记录
        if (baseResponse.isSuccess()) {
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("系统随机选择供应商");
            jcbdBiddingOperationLogDto.setRemark("");
            biddingOperatorService.saveOperatorsLog(memberId, biddingCode, jcbdBiddingOperationLogDto);
        }
        return baseResponse;
    }


    /**
     * @author taofeng
     * @date 2018/3/30
     * <p>
     * 竞价结果页_列表
     **/
    @RequestMapping(value = "/biddingResult", method = RequestMethod.POST)
    public Map biddingResult(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {

        Map resultMap = biddingOperatorService.getBiddingResultDemandList(jqueryDataTablesVo, biddingCode);
        return resultMap;
    }

    /**
     * @author taofeng
     * @date 2018/4/4
     * <p>
     * 竞价结果页_查看
     */
    @RequestMapping(value = "/queryBiddingDemandResponse", method = RequestMethod.POST)
    public Map queryBiddingDemandResponse(String biddingCode, String demandCode) {

        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价信息失败");
        }
        if (Lang.isEmpty(demandCode)) {
            return ResponseMapUtils.error("获取需求信息失败");
        }
        Map resultMap = biddingOperatorService.queryBiddingDemandResponse(biddingCode, demandCode);
        resultMap.put("demandCode", demandCode);
        return resultMap;

    }


    /**
     * @author taofeng
     * @date 2018/3/31
     * <p>
     * 查询会员默认地址信息
     **/
    @RequestMapping(value = "/defaultAddress", method = RequestMethod.POST)
    public MemberAddressVo defaultAddress(String memberId) {
        MemberAddressVo memberAddressVo = biddingOperatorService.defaultAddress(memberId);
        return memberAddressVo;
    }


    /**
     * @author taofeng
     * @date 2018/3/31
     * <p>
     * 查询会员所有地址信息
     **/
    @RequestMapping(value = "/defaultAddressList", method = RequestMethod.POST)
    public Set<String> defaultAddressList(HttpServletRequest request) {
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        List<MemberAddressVo> memberAddressVos = biddingOperatorService.defaultAddressList(memberId);
        Set<String> addressSet = new HashSet();
        if (!Lang.isEmpty(memberAddressVos)) {
            for (MemberAddressVo memberAddressVo : memberAddressVos) {
                addressSet.add(memberAddressVo.getProvinceName() + " " + memberAddressVo.getCityName());
            }
        } else {
            addressSet.add(null);
        }
        return addressSet;
    }

    /**
     * 审核sku
     *
     * @param biddingAuditVo
     * @param request
     * @return
     */
    @RequestMapping(value = "/auditSku", method = RequestMethod.POST)
    public Map auditSku(BiddingAuditVo biddingAuditVo, HttpServletRequest request) {
        if (biddingOperatorService.biddingIsFinish(biddingAuditVo.getBiddingNo())) {
            return ResponseMapUtils.error("当前竞价已终止");
        }
        //获取当前登录人id
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (Lang.isEmpty(biddingMemberId)) {
            return ResponseMapUtils.error("获取用户信息失败");
        }
        Map resultMap = biddingOperatorService.auditSku(biddingAuditVo, biddingMemberId);

        //操作记录
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        String pass = "1";
        String noPass = "0";
        if (pass.equals(biddingAuditVo.getStatus())) {
            jcbdBiddingOperationLogDto.setOperationContent("商品编码审核通过");
        } else if (noPass.equals(biddingAuditVo.getStatus())) {
            jcbdBiddingOperationLogDto.setOperationContent("商品编码审核不通过");
        }
        jcbdBiddingOperationLogDto.setRemark("");
        biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingAuditVo.getBiddingNo(), jcbdBiddingOperationLogDto);
        return resultMap;
    }

    //======================================执行采购页开始=========================================

    /**
     * 执行采购页临时订单保存
     *
     * @param biddingQueryOperativeBuySaveVo
     * @return
     */
    @RequestMapping(value = "/saveOrderGoodsInfo", method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse saveOrderGoodsInfo(@RequestBody BiddingQueryOperativeBuySaveVo biddingQueryOperativeBuySaveVo) {
        if (biddingOperatorService.biddingIsFinish(biddingQueryOperativeBuySaveVo.getBiddingNo())) {
            return new BaseResponse("当前竞价已终止");
        }
        if (!Lang.isEmpty(biddingQueryOperativeBuySaveVo.getBiddingNo())) {
            BaseResponse baseResponse = biddingOperatorService.saveOrderGoodsInfo(biddingQueryOperativeBuySaveVo);
            return baseResponse;
        }
        return new BaseResponse("竞价编号为空");
    }

    /**
     * 执行采购页临时订单查询
     *
     * @return
     */
    @RequestMapping(value = "/queryOrderInfo")
    @ResponseBody
    public BaseResponse queryOrderInfo(String biddingNo) {
        if (!Lang.isEmpty(biddingNo)) {
            BaseResponse baseResponse = biddingOperatorService.queryTempOrderInfo(biddingNo);
            return baseResponse;
        }
        return new BaseResponse("竞价编号为空");
    }

    /**
     * 执行采购页临时订单修改查询
     *
     * @return
     */
    @RequestMapping(value = "/updateOrderInfo")
    @ResponseBody
    public BaseResponse updateOrderInfo(String temOrderId) {
        if (!Lang.isEmpty(temOrderId)) {
            BaseResponse baseResponse = biddingOperatorService.updateTempOrderInfo(temOrderId);
            return baseResponse;
        }
        return new BaseResponse("临时订单ID为空");
    }

    /**
     * 批量删除临时订单
     *
     * @return
     */
    @RequestMapping(value = "/deleteOrderInfo", method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse deleteOrderInfo(@RequestBody List<String> temOrderId) {
        BaseResponse baseResponse = null;
        if (!Lang.isEmpty(temOrderId)) {
            baseResponse = biddingOperatorService.deleteTempOrderInfo(temOrderId);
            return baseResponse;
        }
        return new BaseResponse("临时订单ID为空");
    }

    /**
     * 可采购商品信息查询
     *
     * @param biddingNo
     * @return
     */
    @RequestMapping(value = "/queryPermitGoodsInfo")
    @ResponseBody
    public BaseResponse queryPermitGoodsInfo(String biddingNo) {
        if (!Lang.isEmpty(biddingNo)) {
            BaseResponse baseResponse = biddingOperatorService.queryPermitGoodsInfo(biddingNo);
            return baseResponse;
        }
        return new BaseResponse("竞价编号为空");
    }

    public final static String VALUE_ADDED_TAX_SPECIAL_INVOICE = "增值税专用发票";
    public final static String VALUE_ADDED_TAX_NOMAL_INVOICE = "增值税普通发票";

    /**
     * Excel批量导入临时订单
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/excel/receiverImport", method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse importExcel(HttpServletRequest req, String biddingNo) {
        if (biddingOperatorService.biddingIsFinish(biddingNo)) {
            return new BaseResponse("当前竞价已终止");
        }
        MultipartHttpServletRequest mReq = (MultipartHttpServletRequest) req;
        MultipartFile file = mReq.getFile("file");
        String fileName = file.getOriginalFilename();
        int startRow = 2;
        if (Lang.isEmpty(fileName)) {
            return new BaseResponse("获取不到文件名");
        }
        List<Object> excelRow;
        Object cell;
        List<ExcelImportDataVo> importDataVoList = new ArrayList<>();
        ExcelImportDataVo importDataVo;
        try {
            InputStream inputStream = file.getInputStream();
            List excelData = ReadExcelUtil.readExcel(inputStream, file.getOriginalFilename());
            if (excelData.size() > 1002) {
                return new BaseResponse("最多可添加1000条数据，无法上传，请返回修改");
            }

            //导入失败的数据数量
            Integer falseDataCount = 0;
            //导入数据总数量
            Integer successDataCount = 0;
            /** 读取数据行 */
            for (int i = startRow; i < excelData.size(); i++) {
                /** 处理分类代码行 */
                excelRow = (List<Object>) excelData.get(i);
                boolean emptyRow = true;
                for (int j = 1; j < 14; j++) {
                    if (!Lang.isEmpty(excelRow.get(j))) {
                        emptyRow = false;
                        break;
                    }
                }
                if (emptyRow) {
                    continue;
                }
                importDataVo = new ExcelImportDataVo();

                if (excelRow.size() > 2) {
                    //======================================校验数据开始==================================
                    //校验商品编号是否存在
                    if (Lang.isEmpty(excelRow.get(1))) {
                        importDataVo.setImportResult("导入失败：商品编号未填写");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    } else {
                        String sku = (String) excelRow.get(1);
                        Boolean notNull = biddingOperatorService.goodIsNull(biddingNo, sku);
                        if (!notNull) {
                            importDataVo.setImportResult("导入失败：商品编号不存在");
                            importDataVoList.add(importDataVo);
                            falseDataCount++;
                            continue;
                        }
                    }
                    //校验商品数量
                    if (Lang.isEmpty(excelRow.get(2))) {
                        importDataVo.setImportResult("导入失败：商品数量未填写");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    }
                    //校验商品收货地址编号
                    if (Lang.isEmpty(excelRow.get(3))) {
                        importDataVo.setImportResult("导入失败：商品收货地址未填写");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    } else {
                        String[] address = new String[5];
                        String[] addressCode = excelRow.get(3).toString().split("_");
                        for (int k = 0; k < addressCode.length; k++) {
                            address[k] = addressCode[k];
                        }
                        String detailAddress = excelRow.get(4).toString();
                        String memberName = excelRow.get(12).toString();
                        String memberTel = excelRow.get(13).toString();
                        Boolean aBoolean = biddingOperatorService.queryAddressExist(address);
                        if (!aBoolean) {
                            importDataVo.setImportResult("导入失败：商品收货地址不存在");
                            importDataVoList.add(importDataVo);
                            falseDataCount++;
                            continue;
                        }
                        //查询此用户地址信息是否已经存在memberAddress表里(不在则保存)
                        MemberAddressDto memberAddressDto = addressInfoHandel(address, detailAddress, memberName, memberTel);
                        if (!Lang.isEmpty(memberAddressDto)) {
                            importDataVo.setMemberAddressCode(memberAddressDto.getId());
                            importDataVo.setMemberName(excelRow.get(12).toString());
                            importDataVo.setMemberTel(excelRow.get(13).toString());
                        } else {
                            return new BaseResponse("批量上传收货地址保存失败");
                        }
                    }
                    //校验商品收货详细地址
                    if (Lang.isEmpty(excelRow.get(4))) {
                        importDataVo.setImportResult("导入失败：商品收货详细地址未填写");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    }
                    //校验纳税人标识号
                    if (Lang.isEmpty(excelRow.get(5))) {
                        importDataVo.setImportResult("导入失败：发票类型未填写");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    } else {
                        //校验发票类型为普通发票时发票抬头是否填写
                        if (VALUE_ADDED_TAX_NOMAL_INVOICE.equals(excelRow.get(5))) {
                            if (Lang.isEmpty(excelRow.get(6))) {
                                importDataVo.setImportResult("导入失败：发票抬头未填写");
                                importDataVoList.add(importDataVo);
                                falseDataCount++;
                                continue;
                            }
                        }
                        //校验发票类型为专用发票时纳税人识别号是否填写
                        if (VALUE_ADDED_TAX_SPECIAL_INVOICE.equals(excelRow.get(5))) {
                            if (Lang.isEmpty(excelRow.get(7))) {
                                importDataVo.setImportResult("导入失败：纳税人识别号未填写");
                                importDataVoList.add(importDataVo);
                                falseDataCount++;
                                continue;
                            } else {
                                //查询纳税人识别号是否存在
                                String identificationCode = excelRow.get(7).toString();
                                Boolean aBoolean = biddingOperatorService.queryIdentificationCode(identificationCode);
                                if (!aBoolean) {
                                    importDataVo.setImportResult("导入失败：纳税人识别号不存在");
                                    importDataVoList.add(importDataVo);
                                    falseDataCount++;
                                    continue;
                                }
                            }
                        }
                    }

                    //校验发票收货地址
                    if (Lang.isEmpty(excelRow.get(8))) {
                        importDataVo.setImportResult("导入失败：商品收货地址未填写");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    } else {
                        String[] address = new String[5];
                        String[] addressCode = excelRow.get(8).toString().split("_");
                        for (int l = 0; l < addressCode.length; l++) {
                            address[l] = addressCode[l];
                        }
                        Boolean aBoolean = biddingOperatorService.queryAddressExist(address);
                        if (!aBoolean) {
                            importDataVo.setImportResult("导入失败：商品收货地址不存在");
                            importDataVoList.add(importDataVo);
                            falseDataCount++;
                            continue;
                        }
                        //查询此用户地址信息是否已经存在memberAddress表里(不在则保存)
//                        addressInfoHandel(req, address, detailAddress);
                        importDataVo.setInvoiceProvinceAddressCode(address[0]);
                        importDataVo.setInvoiceCityAddressCode(address[1]);
                        importDataVo.setInvoiceAddressCode(excelRow.get(8).toString());
                        importDataVo.setInvoiceDetailAddress(excelRow.get(9).toString());
                    }
                    //校验商品收货详细地址
                    if (Lang.isEmpty(excelRow.get(9))) {
                        importDataVo.setImportResult("导入失败：商品收货详细地址未填写");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    }
                    //校验发票收件人姓名
                    if (Lang.isEmpty(excelRow.get(10))) {
                        importDataVo.setImportResult("导入失败：发票收件人为空");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    }
                    //校验发票收件人电话
                    if (Lang.isEmpty(excelRow.get(11))) {
                        importDataVo.setImportResult("导入失败：发票收件人电话为空");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    }

                    //校验发票收件人姓名
                    if (Lang.isEmpty(excelRow.get(12))) {
                        importDataVo.setImportResult("导入失败：收货人为空");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    }
                    //校验发票收件人电话
                    if (Lang.isEmpty(excelRow.get(13))) {
                        importDataVo.setImportResult("导入失败：收货人电话为空");
                        importDataVoList.add(importDataVo);
                        falseDataCount++;
                        continue;
                    }

                    //======================================校验数据结束==================================
                    //将数据写入importDataVo
                    importDataVo.setSku(excelRow.get(1).toString());
                    importDataVo.setNum(Integer.parseInt(excelRow.get(2).toString()));
                    importDataVo.setMemberDetailAddress(excelRow.get(4).toString());
                    importDataVo.setInvoiceType(excelRow.get(5).toString());
                    importDataVo.setInvoiceTitle(excelRow.get(6).toString());
                    importDataVo.setTaxIdentification(excelRow.get(7).toString());
                    importDataVo.setInvoiceMember(excelRow.get(10).toString());
                    importDataVo.setInvoiceMemberTel(excelRow.get(11).toString());

                    importDataVo.setImportResult("导入成功");
                    importDataVoList.add(importDataVo);
                    successDataCount++;
                }
            }
            UploadSaveVo uploadSaveVo = new UploadSaveVo();
            uploadSaveVo.setBiddingNo(biddingNo);
            uploadSaveVo.setImportDataVoList(importDataVoList);

            UploadCountVo uploadCountVo = new UploadCountVo();
            uploadCountVo.setFalseDataCount(falseDataCount);
            uploadCountVo.setSuccessDataCount(successDataCount);

            BaseResponse baseResponse = uploadSave(uploadSaveVo);

            if (baseResponse.isSuccess()) {
                //将打入结果的数据保存在缓存中
                req.getSession().setAttribute(BiddingOperatorService.UPLOAD_RESULT_DATA_SESSION, JSON.toJSONString(importDataVoList));
                return new BaseResponse(true, "文件上传成功", uploadCountVo);
            }

        } catch (Exception e) {
            log.error("文件上传失败{}", e);
            return new BaseResponse("文件导入出错");
        }
        return new BaseResponse("文件上传失败");
    }

    /**
     * 批量导入的地址信息处理
     *
     * @param address
     * @param detailAddress
     */
    public MemberAddressDto addressInfoHandel(String[] address, String detailAddress, String memberName, String memberTel) {
        //查询此用户地址信息是否已经存在memberAddress表里(不在则保存)
        MemberAddressDto memberAddress = biddingOperatorService.findMemberAddress(address, detailAddress, memberName, memberTel);
        if (Lang.isEmpty(memberAddress)) {
            //填写的地址不存在则将地址数据保存在memberAddress表中
            MemberAddressDto saveStatues = biddingOperatorService.saveExcelImportData(address, detailAddress, memberName, memberTel);
            return saveStatues;
        }
        return memberAddress;
    }

    /**
     * 文件上传成功后保存
     *
     * @param uploadSaveVo
     * @return
     */

    public BaseResponse uploadSave(UploadSaveVo uploadSaveVo) {
        if (biddingOperatorService.biddingIsFinish(uploadSaveVo.getBiddingNo())) {
            return new BaseResponse("当前竞价已终止");
        }
        BiddingQueryOperativeBuySaveVo biddingQueryOperativeBuySaveVo = new BiddingQueryOperativeBuySaveVo();
        try {
            if (!Lang.isEmpty(uploadSaveVo)) {
                List<ExcelImportDataVo> importDataVoList = uploadSaveVo.getImportDataVoList();
                if (!Lang.isEmpty(importDataVoList)) {
                    for (ExcelImportDataVo excelImportData : importDataVoList) {
                        if (BiddingOperatorServiceImpl.IMPORT_SUCCESS.equals(excelImportData.getImportResult())) {
                            long time1 = System.currentTimeMillis();
                            biddingQueryOperativeBuySaveVo.setBiddingNo(uploadSaveVo.getBiddingNo());
                            List<JcbdTempGoodsVo> jcbdTempGoodsVoList = new ArrayList<>();
                            JcbdTempGoodsVo jcbdTempGoodsVo = new JcbdTempGoodsVo();
                            // 根据sku查询供应商响应价格
                            JcbdBiddingDemandResponseDto demandResponseDto = biddingOperatorService.findGoodsPriceBySku(uploadSaveVo.getBiddingNo(), excelImportData.getSku());
                            long time2 = System.currentTimeMillis();
                            log.info("根据sku查询供应商响应价格{}", time2 - time1);
                            if (!Lang.isEmpty(demandResponseDto)) {
                                jcbdTempGoodsVo.setPrice(demandResponseDto.getPrice());
                                jcbdTempGoodsVo.setDemandId(demandResponseDto.getJcbdBiddingDemand().getId());
                            }
                            // 根据sku查询goodsId
                            String goodsId = biddingOperatorService.findGoodsIdBySku(excelImportData.getSku());
                            long time3 = System.currentTimeMillis();
                            log.info("根据sku查询goodsId{}", time3 - time2);
                            jcbdTempGoodsVo.setGoodsId(goodsId);
                            // 根据sku查询productfashionId
                            String productFashionId = biddingOperatorService.findProductFashionId(excelImportData.getSku());
                            long time4 = System.currentTimeMillis();
                            log.info("根据sku查询productfashionId{}", time4 - time3);
                            jcbdTempGoodsVo.setProductFashionId(productFashionId);
                            jcbdTempGoodsVo.setSku(excelImportData.getSku());
                            jcbdTempGoodsVo.setNum(excelImportData.getNum());
                            jcbdTempGoodsVoList.add(jcbdTempGoodsVo);
                            biddingQueryOperativeBuySaveVo.setJcbdTempGoodses(jcbdTempGoodsVoList);

                            biddingQueryOperativeBuySaveVo.setMemberAddressId(excelImportData.getMemberAddressCode());
                            if (VALUE_ADDED_TAX_NOMAL_INVOICE.equals(excelImportData.getInvoiceType())) {
                                biddingQueryOperativeBuySaveVo.setInvoiceType(GlobalContants.InvoiceCode.INVOICE_TYPE_PLAIN);
                            } else {
                                biddingQueryOperativeBuySaveVo.setInvoiceType(GlobalContants.InvoiceCode.INVOICE_TYPE_SPECIAL);
                            }

                            biddingQueryOperativeBuySaveVo.setInvoiceTitle(excelImportData.getInvoiceTitle());
                            biddingQueryOperativeBuySaveVo.setTaxIdentification(excelImportData.getTaxIdentification());

                            biddingQueryOperativeBuySaveVo.setConsigneeProvinceCode(excelImportData.getInvoiceProvinceAddressCode());
                            biddingQueryOperativeBuySaveVo.setConsigneeCityCode(excelImportData.getInvoiceCityAddressCode());
                            biddingQueryOperativeBuySaveVo.setAddressDetail(excelImportData.getInvoiceDetailAddress());
                            biddingQueryOperativeBuySaveVo.setConsigneeFlag(CONSIGNEE_FLAG);
                            biddingQueryOperativeBuySaveVo.setConsigneeName(excelImportData.getInvoiceMember());
                            biddingQueryOperativeBuySaveVo.setConsigneePhone(excelImportData.getInvoiceMemberTel());

                            biddingOperatorService.saveOrderGoodsInfo(biddingQueryOperativeBuySaveVo);
                            long time5 = System.currentTimeMillis();
                            log.info("模板保存{}", time5 - time4);
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error("临时订单保存失败{}", e);
            return new BaseResponse("临时订单保存失败");
        }
        return new BaseResponse(true, "临时订单数据保存成功");
    }

    /**
     * 获取运费
     *
     * @return
     */
    @RequestMapping(value = "/getOrderFee")
    @ResponseBody
    public BaseResponse getOrderFee(@RequestBody TempPurchaseVo tempPurchaseVo, HttpServletRequest request) {
        BaseResponse baseResponse = null;
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (!Lang.isEmpty(memberId)) {
            baseResponse = biddingOperatorService.getOrderFee(tempPurchaseVo, memberId);
            return baseResponse;
        }
        return new BaseResponse("当前用户Id为空");
    }

    /**
     * 校验商品总计数量与历史下单数量相加是否超过此需求的最高采购数量
     *
     * @param biddingCode
     * @return
     */
    @RequestMapping(value = "/checkGoodNums")
    @ResponseBody
    public BaseResponse checkGoodNums(String biddingCode) {
        BaseResponse baseResponse = biddingOperatorService.checkGoodNums(biddingCode);
        return baseResponse;
    }
    @Autowired
    RedisTemplate redisTemplate;
    /**
     * 执行采购下单
     *
     * @param tempPurchaseVo
     * @param request
     * @return
     */
    @RequestMapping(value = "/submitTemOrder", method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse submitTemOrder(@RequestBody TempPurchaseVo tempPurchaseVo, HttpServletRequest request) {
        BaseResponse baseResponse = null;
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        // 比较当前竞价是否在该经办人名下
        Boolean compareResult = biddingOperatorService.compareCurrentMemberId(memberId, tempPurchaseVo.getBiddingCode());
        String lockFlag  = memberId+tempPurchaseVo.getRequestId();
//        log.info("lockFlag：{}",lockFlag);
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(lockFlag);
            if(boundValueOperations.setIfAbsent(true)) {
                boundValueOperations.expire(1,TimeUnit.DAYS);
                try {
                    if (compareResult) {
                        baseResponse = biddingOperatorService.commitJcbdOrderData(tempPurchaseVo, memberId);
                        //操作记录
                        if (baseResponse.isSuccess()) {
                            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
                            jcbdBiddingOperationLogDto.setOperationContent("执行采购");
                            jcbdBiddingOperationLogDto.setRemark("");
                            long start = System.currentTimeMillis();
                            biddingOperatorService.saveOperatorsLog(memberId, tempPurchaseVo.getBiddingCode(), jcbdBiddingOperationLogDto);
                            log.info("保存日志耗时：{}ms", System.currentTimeMillis() - start);
                        }
                        baseResponse.setResult(null);
                        return baseResponse;
                    }else{
                        return new BaseResponse("当前登录用户状态有误");
                    }
                } catch (Exception e) {
                    log.error("[memberId:{}]下单失败....", memberId, e);
                    return new BaseResponse(false, "下单失败，请联系管理员");
                }
            }else {
                log.error("订单重复提交,tempPurchaseVo={}",JSON.toJSONString(tempPurchaseVo));
                return new BaseResponse(false,"订单重复提交");
            }

    }

    /**
     * 查询发票机构
     *
     * @param companyId
     * @param companyLevel
     * @return
     */
    @RequestMapping(value = {"/companyInfo", "/companyInfo.json"})
    @ResponseBody
    public Map getCompanyInvoiceInfo(String companyId, String companyLevel) {
        if (Lang.isEmpty(companyId)) {
            return null;
        }
        //所选中的机构等级不能大于本级机构  否则给予错误提示
        Map map = new HashMap();
        CoreCompanyDto coreCompany = biddingOperatorService.getCoreCompanyInfoById(companyId);
        map.put("company", coreCompany);
        return map;
    }

    /**
     * 限额校验
     *
     * @return
     */
    @RequestMapping(value = "/checkLimit")
    @ResponseBody
    public BaseResponse checkLimit(String biddingCode) {
        if (Lang.isEmpty(biddingCode)) {
            return new BaseResponse(false, "竞价编号为空");
        }
        return biddingOperatorService.checkLimit(biddingCode);
    }

    //======================================执行采购页结束=========================================

    /**
     * @author taofeng
     * @date 2018/4/4
     * 操作记录
     */
    @RequestMapping(value = "findbiddingLog", method = RequestMethod.POST)
    public Map findbiddingLog(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("当前竞价状态无操作记录");
        }
        Map resultMap = biddingOperatorService.findbiddingLog(jqueryDataTablesVo, biddingCode);

        return ResponseMapUtils.success(resultMap);
    }

    /**
     * 采购经办人 竞价终止
     *
     * @param biddingNo
     * @return
     */
    @RequestMapping(value = "/finishBidding", method = RequestMethod.POST)
    public Map finishBidding(String biddingNo, String remark, HttpServletRequest request) {
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        if (Lang.isEmpty(biddingNo)) {
            return ResponseMapUtils.error("获取竞价编号失败");
        }
        if (Lang.isEmpty(biddingMemberId)) {
            return ResponseMapUtils.error("获取用户信息失败");
        }
        //操作记录
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        jcbdBiddingOperationLogDto.setOperationContent("竞价终止");
        jcbdBiddingOperationLogDto.setRemark(remark);
        biddingOperatorService.saveOperatorsLog(biddingMemberId, biddingNo, jcbdBiddingOperationLogDto);
        return biddingOperatorService.finishBidding(biddingNo, remark, biddingMemberId);
    }

    /**
     * 查询的投票详情
     *
     * @param biddingNo
     * @return
     */
    @RequestMapping(value = "/voteDetailsQuery", method = RequestMethod.GET)
    public Map voteDetailsQuery(String biddingNo, Map map) {
        if (!Lang.isEmpty(biddingNo)) {
            List<VoteQueryResultVo> voteQueryResultVos = biddingOperatorService.voteDetailsQuery(biddingNo);
            map.put("voteQueryResultVos", voteQueryResultVos);
        }
        return ResponseMapUtils.success(map);
    }

    @RequestMapping("getVoteStatus")
    public BaseResponse<Boolean> getVoteStatus(String biddingNo, HttpServletRequest request, String source) {
        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(source)) {
            String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
        }
        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        return biddingOperatorService.getVoteStatus(biddingNo, memberId);
    }

    /**
     * @author taofeng
     * @date 2018/4/21
     * <p>
     * 竞价_删除
     */
    @RequestMapping(value = "/deleteBidding", method = RequestMethod.POST)
    public Map deleteBidding(String biddingNo) {

        if (Lang.isEmpty(biddingNo)) {
            return ResponseMapUtils.error("获取竞价编号失败");
        }

        return biddingOperatorService.deleteBidding(biddingNo);
    }

    @RequestMapping("getBiddingResultTiaoXianCompany")
    public TiaoXianCompanyVo getBiddingResultTiaoXianCompany(HttpServletRequest request, String biddingNo) {
        String userId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_ID);
        return biddingOperatorService.getBiddingResultTiaoXian(userId, biddingNo);
    }

    @RequestMapping("getBiddingOrderiaoXianCompany")
    public TiaoXianCompanyVo getBiddingOrderiaoXianCompany(HttpServletRequest request, BigDecimal totalMoney) {
        String userId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_ID);
        TianXianRequestVo tianXianRequestVo = new TianXianRequestVo();
        tianXianRequestVo.setUserId(userId);
        tianXianRequestVo.setUseCode(WorkFlowCode.BIDDING_ORDER_WORKFLOW_CODE.getCode());
        tianXianRequestVo.setTotalMoney(totalMoney);
        return biddingOperatorService.getBiddingOrderTiaoXian(tianXianRequestVo);
    }

    /**
     * 准备数据供前端左边区域显示组织结构
     * 2018.6.7 added by Li JiLong
     *
     * @param request
     * @return
     */
    @RequestMapping(value = {"companyJsTree"})
    @ResponseBody
    public List<JsonModel> jstree(HttpServletRequest request) {

        List<JsonModel> list = biddingOperatorService.jsTree();

        return list;
    }

    /**
     * 准备数据供前端左边区域显示组织结构
     * 2018.6.13 added by Aaron Li
     *
     * @param request
     * @return
     */
    @RequestMapping(value = {"compJsTree"})
    @ResponseBody
    public List<JsonModel> compJsTree(HttpServletRequest request) {

        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID);
        List<JsonModel> list = new ArrayList<>();
        try {
            //采购经办人
            list = biddingOperatorService.compJsTree(userId, "R_JC_BUYERDEAL");
        } catch (Exception e) {
            log.error("竞价小组成员选择获取用户组织结构树数据出错:", e);
            e.printStackTrace();
        }

        return list;
    }

    /**
     * 根据输入的查询条件 查询竞价小组成员信息列表
     *
     * @param selectedCompanyOrDepartmentId
     * @param nameLike
     * @param emailLike
     * @param pageable
     * @param request                       请求
     * @param jqueryDataTablesVo
     * @return
     */
    @RequestMapping(value = {"getBiddingMember.do"})
    @ResponseBody
    public Map getBiddingMember(String selectedCompanyOrDepartmentName, String selectedCompanyOrDepartmentId, String nameLike, String emailLike, Pageable pageable, HttpServletRequest request, JqueryDataTablesVo jqueryDataTablesVo) {

        Map returnMap = new HashMap(16);

        try {

            String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID);

            String nameLikeU8 = null;
            if (!Lang.isEmpty(nameLike)) {
                nameLikeU8 = URLDecoder.decode(nameLike, "UTF-8");
            }

            returnMap = biddingOperatorService.getTechAuditorListBySearchCondition(jqueryDataTablesVo, selectedCompanyOrDepartmentName, selectedCompanyOrDepartmentId, nameLikeU8, emailLike, false, userId, GlobalContants.ROLE_CODE_JC_JJXZ, pageable);

        } catch (Exception e) {
            log.error("查询符合条件的竞价小组成员列表数据出错:", e);
            e.printStackTrace();
        }

        return ResponseMapUtils.success(returnMap);

    }

}

