package bidding.web.controller;
import api.query.BiddingMallOrderQueryApi;
import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingOrderManagerService;
import bidding.web.vo.*;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingRole;
import dto.BiddingOrderInfoDto;
import dto.JcbdMallOrderDto;
import dto.JcbdRoleOperationDto;
import member.api.QueryOrderApi;
import member.api.dto.shop.MemberInVoiceDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import outsideapi.vo.OrderShippingPackageVo;
import query.BiddingOrderManagerListQuery;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.web.ResponseMapUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @author luoxianwei
* @date 2018/4/14
*/
@RestController
@RequestMapping("biddingOperator")
public class BiddingOrderManagerController {

    @Autowired
    BiddingOrderManagerService biddingOrderManagerService;

    /**
     * 分页获取订单管理列表
     * @param biddingOrderManagerListQuery
     * @return
     */
    @RequestMapping(value = "/getBiddingOrderMangerList",method = RequestMethod.POST)
    public Map getBiddingOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingOrderManagerListQuery biddingOrderManagerListQuery, HttpServletRequest request,Pageable pageable){
        String orderSTime = request.getParameter("orderSTime");
        String orderETime = request.getParameter("orderETime");
        String confSTime = request.getParameter("confSTime");
        String confETime = request.getParameter("confETime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if(!Lang.isEmpty(orderSTime)){
                biddingOrderManagerListQuery.setOrderStartTime(sdf.parse(orderSTime));
             }
            if(!Lang.isEmpty(orderETime)){
                biddingOrderManagerListQuery.setOrderEndTime(sdf.parse(orderETime));
            }
            if(!Lang.isEmpty(confSTime)){
                biddingOrderManagerListQuery.setConfStartTime(sdf.parse(confSTime));
            }
             if(!Lang.isEmpty(confETime)){
                biddingOrderManagerListQuery.setConfEndTime(sdf.parse(confETime));
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
            if(Lang.isEmpty(biddingOrderManagerListQuery.getStatus())){
                 biddingOrderManagerListQuery.setStatus(null);
            }
         String memeberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        biddingOrderManagerListQuery.setMemeberId(memeberId);
        Map resultMap = biddingOrderManagerService.getBiddingOrderMangerList(jqueryDataTablesVo, biddingOrderManagerListQuery,pageable);
        return ResponseMapUtils.success(resultMap);
    }

    /**
     * 所有状态
     * @return
     */
    @RequestMapping(value = "/getAllStatus",method = RequestMethod.GET)
    public List<QueryStatus> getAllStatus(){
        List<QueryStatus> allStatusList = biddingOrderManagerService.getAllStatus();
        return allStatusList;
    }

    /**
     * 取消订单
     * @param status
     * @param orderNo
     * @return
     */
    @RequestMapping(value = "/updateStatusByOrderNo",method = RequestMethod.POST)
    public JcbdMallOrderVo updateStatusByOrderNo( String status, String orderNo){
        JcbdMallOrderVo jcbdMallOrderVo = biddingOrderManagerService.updateStatusByOrderNo(status, orderNo);
        return jcbdMallOrderVo;
    }

    /**
     * 订单管理订单删除
     * @param status
     * @param orderNo
     * @return
     */
    @RequestMapping(value = "/deleteJcbdMallOrderByOrderNo",method = RequestMethod.POST)
    public JcbdMallOrderVo deleteJcbdMallOrderByOrderNo( String status, String orderNo){
        JcbdMallOrderVo jcbdMallOrderVo =  biddingOrderManagerService.deleteJcbdMallOrderByOrderNo(orderNo);
        return jcbdMallOrderVo;
    }

    /**
     * 订单信息

     * @return
     */
    @RequestMapping(value = "/getBiddingOrderInfoVo",method = RequestMethod.POST)
    public String getBiddingOrderInfoVo(String orderNo, String biddingCode,String status, HttpServletRequest request){
        Map map = new HashMap(16);
        HttpSession session = request.getSession();
        Object memberId = session.getAttribute(GlobalContants.SESSION_MEMBER_ID);
        Map<String, Object> params = new HashMap<>(16);
        params.put("orderNo", orderNo);
        params.put("memberId", memberId);
        Map<String, Object> orderMap = queryOrderApi.queryOrderDetail(params);

        if (!Lang.isEmpty(orderMap)) {
            OrderMainDto orderMain = (OrderMainDto) orderMap.get("orderMain");
            if(!Lang.isEmpty(orderMain)){
                List<OrderItemDto> orderItems = orderMain.getOrderItems();
                List<List<OrderItemDto>> items = new ArrayList<>();  //订单商品
                List<OrderItemDto> orderItemDtos = new ArrayList<>();
                for (OrderItemDto orderItem : orderItems) {
                    OrderItemDto orderItemDto = BeanMapper.map(orderItem, OrderItemDto.class);
                    orderItemDtos.add(orderItemDto);
                }
                items.add(orderItemDtos);
                orderMap.put("items",items);

                List<String> orderNos = new ArrayList<>();   //子订单号
                String orderNo1 = orderMain.getOrderNo();
                orderNos.add(orderNo1);
                orderMap.put("orderNos",orderNos);
            }
            map.putAll(orderMap);
        }

        //订单类型，供应商名称
        BiddingOrderInfoDto orderInfoDto = biddingOrderManagerService.getOrderInfoByOrderNo(orderNo);
        map.put("orderInfoDto",orderInfoDto);

        biddingOrderManagerService.getFlowSteps(orderInfoDto.getReviewNo(), map);
        List<ImageVo> uploadFiles = biddingOrderManagerService.getOrderUploadFiles(orderNo);
        OrderAuditInfoVo businessWorkFlowInfo = biddingOrderManagerService.getBusinessWorkFlowInfo(orderNo, null);
        if(!Lang.isEmpty(businessWorkFlowInfo)){
            map.put("businessWorkFlowInfo",businessWorkFlowInfo);
        }

        if (!uploadFiles.isEmpty()) {
            map.put("uploadFiles", uploadFiles);
        }
        map.put("invoiceTypeMap", MemberInVoiceDto.INVOICETYPEMAP);
        String orderStatus = request.getParameter("status");
        map.put("status", orderStatus);
        Map<String,Object> orderTrackResp = (Map<String, Object>) map.get("orderTrackResp");
        List<OrderTrackRespVo> orderTrackRespVoList = new ArrayList<>();
        OrderTrackRespVo orderTrackRespVo = null;
        if(!Lang.isEmpty(orderTrackResp)){
            for (String key : orderTrackResp.keySet()) {
                orderTrackRespVo =  new OrderTrackRespVo();
                orderTrackRespVo.setKey(key);
                OrderShippingPackageVo orderShippingTrackVo = (OrderShippingPackageVo) orderTrackResp.get(key);
                orderTrackRespVo.setOrderShippingTrackVo(BeanMapper.map(orderShippingTrackVo,OrderShippingPackageVo.class));
                orderTrackRespVoList.add(orderTrackRespVo);
            }
        }
        map.put("orderTrackRespVo",orderTrackRespVoList);


        //竞价信息
        //经办人
        String biddingUserId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        JcbdBiddingVo biddingVo = biddingOperatorService.getOperator(biddingUserId);
        BiddingInformationVo biddingInformationVo = BeanMapper.map(biddingVo, BiddingInformationVo.class);
        //竞价编号
        biddingInformationVo.setBiddingCode(biddingCode);
        map.put("biddingInformationVo",biddingInformationVo);

        //根据状态获取操作信息
        List<JcbdRoleOperationDto> jcbdRoleOperationDtos =biddingOrderManagerService.getOpertionByStatus(status);
        map.put("jcbdRoleOperationDtos",jcbdRoleOperationDtos);
        String orderInfoJsonString = JSON.toJSONString(map);
        return  orderInfoJsonString;
    }


    @Autowired
    BiddingOperatorService biddingOperatorService;

    @MotanReferer
    QueryOrderApi queryOrderApi;


}

