package bidding.web.controller;

import bidding.web.service.BiddingOrderResultService;
import bidding.web.vo.BiddingOrderResultInfoVo;
import dto.BiddingOrderResultDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import query.BiddingOrderResultListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.web.ResponseMapUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
* @author luoxianwei
* @date 2018/4/14
*/
@RestController
@RequestMapping("biddingOperator")
public class BiddingOrderResultController {

    @Autowired
    BiddingOrderResultService biddingOrderService;

    /**
     * 获得执行采购结果数据
     * @param biddingCode
     * @return
     */
    @RequestMapping(value = "/getOrderResultInfo",method = RequestMethod.GET)
    public BiddingOrderResultInfoVo getOrderResultInfo(@RequestParam("biddingNo") String biddingCode){
        return biddingOrderService.getPurchaseResult(biddingCode);
    }

    /**
     * 分页获取采购结果列表
     * @param biddingNo
     * @return
     */
    @RequestMapping(value = "/getBiddingOrderResultList",method = RequestMethod.POST)
    public Map getBiddingOrderResultList(JqueryDataTablesVo jqueryDataTablesVo, @RequestParam("biddingNo") String biddingNo, Pageable pageable){
        BiddingOrderResultListQuery biddingOrderResultListQuery = new BiddingOrderResultListQuery();
        biddingOrderResultListQuery.setBiddingCode(biddingNo);
        Map resultMap = biddingOrderService.getBiddingOrderResultList(jqueryDataTablesVo, biddingOrderResultListQuery, pageable);
        return ResponseMapUtils.success(resultMap);
    }

}

