package bidding.web.controller;

import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingProviderService;
import bidding.web.vo.*;
import com.alibaba.fastjson.JSON;
import definition.BiddingRole;
import definition.BiddingStatus;
import dto.JcbdBdProviderDto;
import dto.JcbdBiddingOperationLogDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.GlobalContants;
import utils.Lang;
import utils.web.ResponseMapUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@RestController
@RequestMapping("biddingProvider")
public class BiddingProviderController {

    @Autowired
    BiddingProviderService biddingProviderService;

    @Autowired
    BiddingOperatorService biddingOperatorService;



    /**
     * 竞价列表查询
     * @param jqueryDataTablesVo
     * @param request
     * @param queryBiddingRequestVO
     * @return
     */
    @RequestMapping(value = {"/querryPageBidding"}, method = RequestMethod.POST)
    @ResponseBody
    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, HttpServletRequest request, QueryBiddingRequestVO queryBiddingRequestVO) {
        //获取当前登录人id
        String biddingMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        //获取当前登录人角色
        String biddingMemberRole = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ROLE);
        List<String> biddingMemberRoles = new ArrayList<>();
        biddingMemberRoles.add(biddingMemberRole);

        if (Lang.isEmpty(biddingMemberId)||Lang.isEmpty(biddingMemberRoles)){
            return ResponseMapUtils.error("获取用户信息失败");
        }
        Map resultMap =  biddingProviderService.querryPageBidding(jqueryDataTablesVo, biddingMemberId, biddingMemberRoles, queryBiddingRequestVO);
        queryBiddingRequestVO.setPageNo((jqueryDataTablesVo.getiDisplayStart()/jqueryDataTablesVo.getiDisplayLength())+1+"");
        request.getSession().setAttribute("supplierId",biddingMemberId);
        request.getSession().setAttribute("supplierBiddingTemp",JSON.toJSONString(queryBiddingRequestVO));
        request.getSession().setAttribute("supplierBiddingPageTemp",JSON.toJSONString(jqueryDataTablesVo));
        return ResponseMapUtils.success(resultMap);
    }

    /**
     * 供应商查询竞价需求列表
     * @param jqueryDataTablesVo
     * @param biddingCode
     * @param request
     * @return
     */
    @RequestMapping(value = {"/querryPageBiddingDemad"}, method = RequestMethod.POST)
    @ResponseBody
    public Map querryPageBiddingDemad(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, HttpServletRequest request) {
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
//        String supplierId = "8ce42ec1-8c83-4f22-80c6-e31cdc0dab14";
        if (Lang.isEmpty(supplierId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingProviderService.querryPageBiddingDemand(jqueryDataTablesVo,biddingCode, supplierId);
        return resultMap;
    }

    /**
     * 保存竞价需求响应
     * @param biddingDemandResponseVo
     * @param request
     * @return
     */
    @RequestMapping(value = {"/saveBiddingDemadResp"}, method = RequestMethod.POST)
    @ResponseBody
    public Map saveBiddingDemadResp(@RequestBody BiddingDemandResponseVo biddingDemandResponseVo, HttpServletRequest request) {
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        if (Lang.isEmpty(biddingDemandResponseVo)){
            return ResponseMapUtils.error("传入数据为空");
        }
        if (Lang.isEmpty(supplierId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingProviderService.saveBiddingDemadResp(biddingDemandResponseVo,supplierId);

        return resultMap;
    }

    /**
     * 提交竞价需求响应
     * @param supplierBiddingResponseVo
     * @param request
     * @return
     */
    @RequestMapping(value = {"/submitResp"}, method = RequestMethod.POST)
    @ResponseBody
    public Map submitResp(@RequestBody SupplierBiddingResponseVo supplierBiddingResponseVo, HttpServletRequest request){
        String signValue = (String) request.getSession().getAttribute(GlobalContants.SESSION_TPCLOUD_SIGN_VALUE);
        if (Lang.isEmpty(signValue)){
            return ResponseMapUtils.error("非法请求");
        }
        if (!signValue.equals(supplierBiddingResponseVo.getSignValue())){
            return ResponseMapUtils.error("非法请求");
        }
        // 清除缓存
        request.getSession().setAttribute(GlobalContants.SESSION_TPCLOUD_SIGN_VALUE,"");
        if (biddingOperatorService.biddingIsFinish(supplierBiddingResponseVo.getJcbdBiddingNo())){
            return ResponseMapUtils.error("当前竞价已终止");
        }
        String userId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_ID);
        if (Lang.isEmpty(userId)){
            return ResponseMapUtils.error("获取用户信息失败");
        }
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        String loginId = (String) request.getSession().getAttribute(GlobalContants.SESSION_D_VENDER_LXR_ID);
        if (Lang.isEmpty(supplierId)||Lang.isEmpty(loginId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }

        JcbdBiddingVo biddingByBiddingCode = biddingOperatorService.getBiddingByBiddingCode(supplierBiddingResponseVo.getJcbdBiddingNo());
        JcbdBdProviderDto providerInfo = null;
        if(!Lang.isEmpty(biddingByBiddingCode)){
            providerInfo = biddingProviderService.getProviderByBiddingNoAndSupplierId(biddingByBiddingCode.getId(), supplierId);
        }
        //操作记录
        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
        if(BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue().equals(providerInfo.getStatus())){
            jcbdBiddingOperationLogDto.setOperationContent("竞价响应");
            jcbdBiddingOperationLogDto.setRemark("");
        }else if(BiddingStatus.SUPPLIER_RESPONSE_YES.getValue().equals(providerInfo.getStatus())||BiddingStatus.SUPPLIER_RESPONSE_YES_GIVEUP.getValue().equals(providerInfo.getStatus())||BiddingStatus.SUPPLIER_RESPONSE_GIVEUP.getValue().equals(providerInfo.getStatus())){
            jcbdBiddingOperationLogDto.setOperationContent("修改响应");
            jcbdBiddingOperationLogDto.setRemark("");
        }

        Map resultMap = biddingProviderService.submitResp(supplierBiddingResponseVo,userId, supplierId);
        String status = (String) resultMap.get("status");
        if(GlobalContants.ResponseStatus.SUCCESS.equals(status)){
            biddingOperatorService.saveOperatorsLog(loginId, supplierBiddingResponseVo.getJcbdBiddingNo(), jcbdBiddingOperationLogDto);
        }
        return resultMap;

    }


    /**
     * 判断所有需求是否已经全部响应
     * @param biddingCode
     * @param request
     * @return
     */
    @RequestMapping(value = {"/checkIsAllRespond"}, method = RequestMethod.POST)
    @ResponseBody
    public Map checkIsAllRespond(String biddingCode, HttpServletRequest request){
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价失败");
        }
        if (Lang.isEmpty(supplierId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingProviderService.checkIsAllRespond(biddingCode,supplierId);
        return resultMap;
    }

    /**
     * 判断所有响应是否都符合
     * @param biddingCode
     * @param request
     * @return
     */
    @RequestMapping(value = {"/checkDemadIsAllAccord"}, method = RequestMethod.POST)
    @ResponseBody
    public Map checkDemadIsAllAccord(String biddingCode, HttpServletRequest request){
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价失败");
        }
        if (Lang.isEmpty(supplierId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingProviderService.checkDemadIsAllAccord(biddingCode,supplierId);
        return resultMap;
    }

    /**
     * 确认竞价结果
     * @param biddingCode
     * @param signValue 签名值 (太平云盾验证)
     * @return
     */
    @RequestMapping(value = "/sureResult" , method = RequestMethod.POST)
    public Map sureResult(String biddingCode,String signValue,HttpServletRequest request){
        String exitSignValue = (String) request.getSession().getAttribute(GlobalContants.SESSION_TPCLOUD_SIGN_VALUE);
        if (Lang.isEmpty(exitSignValue)){
            return ResponseMapUtils.error("非法请求");
        }
        if (!exitSignValue.equals(signValue)){
            return ResponseMapUtils.error("非法请求");
        }
        // 清除缓存
        request.getSession().setAttribute(GlobalContants.SESSION_TPCLOUD_SIGN_VALUE,"");
        if (biddingOperatorService.biddingIsFinish(biddingCode)){
            return ResponseMapUtils.error("当前竞价已终止");
        }
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        String loginId = (String) request.getSession().getAttribute(GlobalContants.SESSION_D_VENDER_LXR_ID);
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价失败");
        }
        if (Lang.isEmpty(supplierId)||Lang.isEmpty(loginId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingProviderService.sureResult(biddingCode,signValue, supplierId);
        String status = (String) resultMap.get("status");
        if(GlobalContants.ResponseStatus.SUCCESS.equals(status)) {
            //操作记录
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("确认竞价结果");
            jcbdBiddingOperationLogDto.setRemark("");
            biddingOperatorService.saveOperatorsLog(loginId, biddingCode, jcbdBiddingOperationLogDto);
        }
        return resultMap;
    }


    /**
     * 响应sku列表查询
     * @param jqueryDataTablesVo
     * @param biddingCode
     * @param request
     * @return
     */
    @RequestMapping(value = "/querryPageSku", method = RequestMethod.POST)
    public Map querryPageSku(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, HttpServletRequest request){
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        if (Lang.isEmpty(supplierId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价失败");
        }
        Map resultMap = biddingProviderService.querryPageSku(jqueryDataTablesVo, biddingCode,supplierId);
        return resultMap;
    }

    /**
     * 更新sku
     * @param updateSkuVo
     * @param request
     * @return
     */
    @RequestMapping(value = "/updateSku" ,method = RequestMethod.POST)
    public Map updateSku(UpdateSkuVo updateSkuVo, HttpServletRequest request){
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        String loginId = (String) request.getSession().getAttribute(GlobalContants.SESSION_D_VENDER_LXR_ID);
        if (Lang.isEmpty(supplierId)||Lang.isEmpty(loginId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        if (Lang.isEmpty(updateSkuVo.getBiddingNo())) {
            return ResponseMapUtils.error("获取竞价失败");
        }
        if (Lang.isEmpty(updateSkuVo.getDemandNo())) {
            return ResponseMapUtils.error("获取响应需求失败");
        }
        Map resultMap = biddingProviderService.updateSku(updateSkuVo, supplierId,loginId);

//        //操作记录
//        JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
//        jcbdBiddingOperationLogDto.setOperationContent("需求"+updateSkuVo.getDemandNo()+"更新商品编码");
//        jcbdBiddingOperationLogDto.setRemark("");
//        biddingOperatorService.saveOperatorsLog(supplierId, updateSkuVo.getBiddingNo(), jcbdBiddingOperationLogDto);

        return resultMap;
    }

    /**
     * 提交sku审核
     * @param biddingCode
     * @param request
     * @return
     */
    @RequestMapping(value = "/submitSkuAudit", method = RequestMethod.POST)
    public Map submitSkuAudit(String biddingCode, HttpServletRequest request){
        if (biddingOperatorService.biddingIsFinish(biddingCode)){
            return ResponseMapUtils.error("当前竞价已终止");
        }
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        String loginId = (String) request.getSession().getAttribute(GlobalContants.SESSION_D_VENDER_LXR_ID);
        if (Lang.isEmpty(supplierId)||Lang.isEmpty(loginId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价失败");
        }
        Map resultMap = biddingProviderService.submitSkuAudit(biddingCode, supplierId);
        String status = (String) resultMap.get("status");
        if(GlobalContants.ResponseStatus.SUCCESS.equals(status)) {
            //操作记录
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("提交商品编码审核");
            jcbdBiddingOperationLogDto.setRemark("");
            biddingOperatorService.saveOperatorsLog(loginId, biddingCode, jcbdBiddingOperationLogDto);
        }
        return resultMap;
    }

    /**
     * 查询sku链接
     * @param sku
     * @param request
     * @return
     */
    @RequestMapping(value = "/findUrlBySku", method = RequestMethod.POST)
    public Map findUrlBySku(String sku, HttpServletRequest request){
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        if (Lang.isEmpty(supplierId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        if (Lang.isEmpty(sku)) {
            return ResponseMapUtils.error("获取sku失败");
        }
        Map resultMap = biddingProviderService.findUrlBySku(sku, supplierId);
        return resultMap;
    }

    /**
     * 获取响应信息
     * @param biddingNo
     * @param demandCode
     * @param request
     * @return
     */
    @RequestMapping(value = "/getBiddingDemadDetail", method = RequestMethod.POST)
    public BiddingDemandResponseVo getBiddingDemadDetail(String biddingNo, String demandCode, HttpServletRequest request){
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        return biddingProviderService.getBiddingDemadDetail(supplierId, demandCode, biddingNo);
    }

    /**
     * 获取竞价基本信息
     * @param biddingNo
     * @return
     */
    @RequestMapping(value = "/getBiddingDetail", method = RequestMethod.POST)
    public BiddingBaseInfoVo getBiddingDemadDetail(String biddingNo){
        return biddingProviderService.getBiddingDetail(biddingNo);
    }

    /**
     * 是否有修改sku
     * @param biddingCode
     * @param request
     * @return
     */
    @RequestMapping(value = "/checkModifySku", method = RequestMethod.POST)
    public Map checkModifySku(String biddingCode, HttpServletRequest request){
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        if (Lang.isEmpty(supplierId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingProviderService.checkModifySku(biddingCode, supplierId);
        return resultMap;
    }

    /**
     * 放弃响应
     * @param biddingNo
     * @param request
     * @return
     */
    @RequestMapping(value = "/responseGiveUp", method = RequestMethod.POST)
    public Map responseGiveUp(String biddingNo, HttpServletRequest request){
        if (biddingOperatorService.biddingIsFinish(biddingNo)){
            return ResponseMapUtils.error("当前竞价已终止");
        }
        String supplierId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_SUPPLIER_ID);
        String loginId = (String) request.getSession().getAttribute(GlobalContants.SESSION_D_VENDER_LXR_ID);
        if (Lang.isEmpty(supplierId)||Lang.isEmpty(loginId)){
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingProviderService.responseGiveUp(biddingNo, supplierId);
        String status = (String) resultMap.get("status");
        if(GlobalContants.ResponseStatus.SUCCESS.equals(status)) {
            //操作记录
            JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto = new JcbdBiddingOperationLogDto();
            jcbdBiddingOperationLogDto.setOperationContent("放弃响应");
            jcbdBiddingOperationLogDto.setRemark("");
            biddingOperatorService.saveOperatorsLog(loginId, biddingNo, jcbdBiddingOperationLogDto);
        }
        return resultMap;
    }

    /**
     * 拉取验证二维码
     * @param request
     * @param businessCode 竞价编号
     * @param operateType 操作类型
     * @return
     */
    @RequestMapping(value = "/loadQrcode",method = RequestMethod.POST)
    public Map loadQrcode(HttpServletRequest request,String businessCode,String operateType){
        // TODO  account 测试账号
        //String account = "17600123400";
        String account = (String) request.getSession().getAttribute(GlobalContants.SESSION_D_VENDER_ORGANIZATION_CODE);
        Map resultMap = biddingProviderService.loadQrcode(account,businessCode,operateType);
        return resultMap;
    }

    /**
     * 获取扫码凭证
     * @param eventId 事件id
     * @return
     */
    @RequestMapping(value = "/getAccToken",method = RequestMethod.POST)
    public Map getAccToken(String eventId){
        return biddingProviderService.getAccToken(eventId);
    }

    /**
     * 获取扫码结果
     * @param accToken 凭证
     * @return
     */
    @RequestMapping("/getSignResult")
    public Map getSignResult(HttpServletRequest request,String accToken){
        Map signResultMap = biddingProviderService.getSignResult(accToken);
        request.getSession(true).setAttribute(GlobalContants.SESSION_TPCLOUD_SIGN_VALUE,signResultMap.get(GlobalContants.ResponseString.DATA));
        return signResultMap;
    }
}
