package bidding.web.controller;

import bidding.web.service.BiddingOperatorService;
import bidding.web.service.BiddingQueryService;
import bidding.web.vo.BiddingConformityQueryVo;
import bidding.web.vo.BiddingPriceParityVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.PriceParityInfoVo;
import definition.BiddingRole;
import definition.BiddingStatus;
import dto.BiddingPriceParityDto;
import dto.JcbdBiddingDto;
import dto.PriceParityInfoDto;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.data.BeanMapper;
import utils.web.ResponseMapUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@RestController
@RequestMapping("biddingQuery")
public class BiddingQueryController {

    @Autowired
    BiddingQueryService biddingQueryService;

    @Autowired
    BiddingOperatorService biddingOperatorService;

    public static final Logger log = org.slf4j.LoggerFactory.getLogger(BiddingQueryController.class);

    /**
     * 查询竞价需求
     */
    @RequestMapping("queryBiddingDemand")
    public void queryBiddingDemand(String biddingNo){

    }

    @RequestMapping("biddingQueryList")
    public List<JcbdBiddingDto> findAllJcbdBidding(){
        List<JcbdBiddingDto> jcbdBiddingDtoList = biddingQueryService.findAllJcbdBidding();
        return jcbdBiddingDtoList;
    }

    /**
     * 查询竞价比价信息
     */
    @RequestMapping("queryBiddingPriceParity")
    @ResponseBody
    public BiddingPriceParityVo queryBiddingPriceParity(String biddingNo){
//        biddingNo="B201804100949400098";
        BiddingPriceParityVo biddingPriceParityVo=null;
        BiddingPriceParityDto biddingPriceParityDto=null;
        if(!Lang.isEmpty(biddingNo)){
            BaseResponse<BiddingPriceParityDto> biddingPriceParityDtoBaseResponse = biddingQueryService.queryBiddingPriceParity(biddingNo);
            biddingPriceParityDto =biddingPriceParityDtoBaseResponse.getResult();
            biddingPriceParityVo = BeanMapper.map(biddingPriceParityDto, BiddingPriceParityVo.class);
        }
        return biddingPriceParityVo;
    }


    /**
     * 查询投票页信息（对于报价相同的供应商投票）
     */
    @RequestMapping("querySupplierResponse")
    @ResponseBody
    public BiddingPriceParityVo querySupplierResponse(String biddingNo){
        BiddingPriceParityVo supplierDemandResponse=new BiddingPriceParityVo();
        List<PriceParityInfoVo> priceParityInfosVos = new ArrayList<>();
        if(!StringUtils.isEmpty(biddingNo)){
            BaseResponse<BiddingPriceParityDto> biddingPriceParityDtoBaseResponse = biddingQueryService.queryBiddingPriceParity(biddingNo);
            List<PriceParityInfoDto> priceParityInfosDtos = biddingPriceParityDtoBaseResponse.getResult().getPriceParityInfosDtos();
            for (PriceParityInfoDto priceParityInfoDto:priceParityInfosDtos){
                if(priceParityInfoDto.getSupplierStatus().equals(BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue())){
                    PriceParityInfoVo priceParityInfoVo = BeanMapper.map(priceParityInfoDto, PriceParityInfoVo.class);
                    priceParityInfosVos.add(priceParityInfoVo);
                }
            }
//            supplierDemandResponse = BeanMapper.map(biddingPriceParityDtoBaseResponse.getResult(), BiddingPriceParityVo.class);
        }
        supplierDemandResponse.setPriceParityInfosDtos(priceParityInfosVos);
        return supplierDemandResponse;
    }


    /**
     * 查詢符合性审查页需求列表
     * @param biddingNo
     * @param request
     * @return
     */
    @RequestMapping("/querryBiddingDemandList")
    @ResponseBody
    public Map querryPageBiddingDemad(String biddingNo , HttpServletRequest request ,JqueryDataTablesVo jqueryDataTablesVo, String source) {
        BiddingConformityQueryVo biddingConformityQueryVo  = new BiddingConformityQueryVo();
            String sessionMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
            String sessionEmail = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
            String email = null;
            String memberId =null;
            if (BiddingRole.BIDDING_GROUP_MEMBER.equals(source)){
                email = sessionEmail;
        }else {
            memberId = sessionMemberId;
        }
        Map resultMap = new HashMap<>();
        if(!Lang.isEmpty(memberId) || !Lang.isEmpty(email)){
            biddingConformityQueryVo.setMemberId(memberId);
            biddingConformityQueryVo.setBiddingCode(biddingNo);
            biddingConformityQueryVo.setEmail(email);
            resultMap = biddingQueryService.querryPageBiddingDemad(biddingConformityQueryVo,jqueryDataTablesVo);
        }

        return ResponseMapUtils.success(resultMap);
    }

    /**
     * 供应商竞价响应概要信息查询
     *
     * @param biddingCode
     * @param demandCode
     * @return
     */
    @RequestMapping(value = {"/queryResponseOutline"}, method = RequestMethod.POST)
    @ResponseBody
    public Map queryResponseOutline(String biddingCode, String demandCode,HttpServletRequest request, String source) {
        String sessionMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        String sessionEmail = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
        String email = null;
        String memberId =null;
        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(source)){
            email = sessionEmail;
        }else {
            memberId = sessionMemberId;
        }
//        String email = null;
//        String memberId =null;
//        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(source)){
//            email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
//        }else {
//            memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
//        }
        BiddingConformityQueryVo biddingConformityQueryVo  = new BiddingConformityQueryVo();
        biddingConformityQueryVo.setBiddingCode(biddingCode);
        biddingConformityQueryVo.setDemandCode(demandCode);
//        String memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
//        String email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
        biddingConformityQueryVo.setMemberId(memberId);
        biddingConformityQueryVo.setEmail(email);
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价信息失败");
        }
        if (Lang.isEmpty(demandCode)) {
            return ResponseMapUtils.error("获取需求信息失败");
        }
        Map resultMap = biddingQueryService.queryResponseOutline(biddingConformityQueryVo);
        resultMap.put("demandCode", demandCode);
        return resultMap;
    }

    /**
     * 查询供应商需求响应
     *
     * @param biddingCode
     * @param demandCode
     * @param supplierId
     * @return
     */
    @RequestMapping(value = {"/queryDemandResponse"}, method = RequestMethod.POST)
    public Map queryDemandResponse(String biddingCode, String demandCode, String supplierId,HttpServletRequest request, String source) {
        String sessionMemberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
        String sessionEmail = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
        String email = null;
        String memberId =null;
        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(source)){
            email = sessionEmail;
        }else {
            memberId = sessionMemberId;
        }
//        String email = null;
//        String memberId =null;
//        if (BiddingRole.BIDDING_GROUP_MEMBER.equals(source)){
//            email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
//        }else {
//            memberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
//        }
        BiddingConformityQueryVo biddingConformityQueryVo  = new BiddingConformityQueryVo();
        biddingConformityQueryVo.setBiddingCode(biddingCode);
        biddingConformityQueryVo.setDemandCode(demandCode);
        biddingConformityQueryVo.setProviderId(supplierId);
//        String memeberId = (String) request.getSession().getAttribute(BiddingRole.BIDDING_MEMBER_ID);
//        String email = (String) request.getSession().getAttribute(BiddingRole.BIDDING_USER_EMAIL);
        if(!Lang.isEmpty(memberId) || !Lang.isEmpty(email)){
            biddingConformityQueryVo.setMemberId(memberId);
            biddingConformityQueryVo.setEmail(email);
        }
        if (Lang.isEmpty(biddingCode)) {
            return ResponseMapUtils.error("获取竞价信息失败");
        }
        if (Lang.isEmpty(demandCode)) {
            return ResponseMapUtils.error("获取需求信息失败");
        }
        if (Lang.isEmpty(supplierId)) {
            return ResponseMapUtils.error("获取供应商信息失败");
        }
        Map resultMap = biddingQueryService.queryDemandResponse(biddingConformityQueryVo);
        return resultMap;
    }

    /**
     * 审核员查詢符合性审查页需求列表
     * @param biddingNo
     * @param request
     * @return
     */
    @RequestMapping("/auditorQuerryBiddingDemandList")
    @ResponseBody
    public Map auditorQuerryBiddingDemandList(String biddingNo , HttpServletRequest request ,JqueryDataTablesVo jqueryDataTablesVo, String source) {
        BiddingConformityQueryVo biddingConformityQueryVo  = new BiddingConformityQueryVo();
        JcbdBiddingVo biddingVo = biddingOperatorService.getBiddingByBiddingCode(biddingNo);
        String memberId =biddingVo.getOperatorId();
        Map resultMap = new HashMap<>();
        if(!Lang.isEmpty(memberId)){
            biddingConformityQueryVo.setMemberId(memberId);
            biddingConformityQueryVo.setBiddingCode(biddingNo);
            resultMap = biddingQueryService.querryPageBiddingDemad(biddingConformityQueryVo,jqueryDataTablesVo);
        }
        return ResponseMapUtils.success(resultMap);
    }
 }
